/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.atomcoord;

import jp.advancesoft.chase.atomcoord.Atom;
import jp.advancesoft.chase.atomcoord.AtomEditor;
import jp.advancesoft.chase.atomcoord.AtomEditorCheckBox;
import jp.advancesoft.chase.atomcoord.AtomEditorComboBox;
import jp.advancesoft.chase.atomcoord.AtomEditorEditors;
import jp.advancesoft.chase.atomcoord.AtomEditorTextField;
import jp.advancesoft.chase.common.TaggedString;
import jp.advancesoft.chase.common.Utils;
import jp.advancesoft.chase.inputinterface.inputinterfacetable.InputInterfaceTableColumns;

class AtomEditors {
    AtomEditors() {
    }

    static AtomEditorEditors getInstance(InputInterfaceTableColumns column, Atom atom, AtomEditor parent) {
        String editor = column.getCellEditor();
        String ini = "";
        ini = AtomEditors.initValue(column, atom);
        boolean bini = Utils.getBool(ini);
        if (editor.equals(InputInterfaceTableColumns.CHECK_BOX)) {
            return new AtomEditorCheckBox(column.getName(), bini, parent);
        }
        if (editor.equals(InputInterfaceTableColumns.COMBO_BOX)) {
            return new AtomEditorComboBox(column.getName(), ini, column.getChoices(), parent);
        }
        if (editor.equals(InputInterfaceTableColumns.TEXT_FIELD)) {
            return new AtomEditorTextField(column.getName(), ini, parent);
        }
        return null;
    }

    static void setValue(AtomEditorEditors editor, String name, Atom atom) {
        String ini = "";
        ini = AtomEditors.getValueFrom(name, atom);
        editor.setValue(ini);
    }

    private static String initValue(InputInterfaceTableColumns column, Atom atom) {
        if (atom == null) {
            return column.getDefaultValue();
        }
        return AtomEditors.getValueFrom(column.getName(), atom);
    }

    private static String getValueFrom(String name, Atom atom) {
        String element = "element";
        String rx = "rx";
        String ry = "ry";
        String rz = "rz";
        TaggedString[] au = atom.getAuxil();
        String ret = "";
        if (name.equals(element)) {
            ret = atom.getElementName();
        } else if (name.equals(rx)) {
            ret = atom.getPos()[0];
        } else if (name.equals(ry)) {
            ret = atom.getPos()[1];
        } else if (name.equals(rz)) {
            ret = atom.getPos()[2];
        } else if (au != null) {
            for (int i = 0; i < au.length; ++i) {
                if (!au[i].getTag().equals(name)) continue;
                ret = au[i].getValue();
                break;
            }
        }
        return ret;
    }
}

