/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.atomcoord;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JTextField;
import jp.advancesoft.chase.atomcoord.AtomEditor;
import jp.advancesoft.chase.atomcoord.AtomEditorEditors;
import jp.advancesoft.chase.common.ConstParameters;

class AtomEditorTextField
extends JTextField
implements AtomEditorEditors {
    private String name;
    private AtomEditor parent;
    private DecimalFormat formater = ConstParameters.formater;
    private ActionListener[] listeners;

    AtomEditorTextField(String name, String init, AtomEditor parent) {
        super(init);
        this.setColumns(6);
        this.name = name;
        this.parent = parent;
        this.addListener();
    }

    public void removeListeners() {
        this.listeners = this.getActionListeners();
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.removeActionListener(this.listeners[i]);
        }
    }

    public void restoreListeners() {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.addActionListener(this.listeners[i]);
        }
    }

    private void addListener() {
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AtomEditorTextField.this.parent.doIt();
            }
        });
    }

    public String getValue() {
        return this.getText();
    }

    public String getIdentifiers() {
        return this.name;
    }

    public void setValue(String value) {
        String formatted = value;
        try {
            formatted = this.formater.format(Double.parseDouble(value));
        }
        catch (NumberFormatException nfe) {
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        this.setText(formatted);
    }
}

