/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer.scenegraphelements.bond;

import javax.media.j3d.Appearance;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import jp.advancesoft.chase.acviewer.scenegraphelements.DynamicallyEditableBG;
import jp.advancesoft.chase.acviewer.scenegraphelements.bond.CylinderCreatorTG;
import jp.advancesoft.chase.settings.GlobalProperties;
import jp.advancesoft.chase.settings.PropertiesManager;

public class BondObject
extends DynamicallyEditableBG {
    private double[] nearestNeighbor;
    private float[] bondColor;
    private int numNodes = 30;
    private double bondWidth = 0.1;
    private CylinderCreatorTG cylindercreate;
    private int index = 0;
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(1);

    public BondObject(double[] nearestNeighbor) {
        this.nearestNeighbor = nearestNeighbor;
    }

    public int getType() {
        return 1;
    }

    public void create() {
        Appearance app = new Appearance();
        Material material = new Material();
        material.setDiffuseColor(new Color3f(this.bondColor));
        material.setShininess(120.0f);
        app.setMaterial(material);
        Point3d Cyl1 = new Point3d(this.nearestNeighbor[0], this.nearestNeighbor[1], this.nearestNeighbor[2]);
        Point3d Cyl2 = new Point3d(this.nearestNeighbor[3], this.nearestNeighbor[4], this.nearestNeighbor[5]);
        this.cylindercreate = new CylinderCreatorTG(Cyl1, Cyl2, this.bondWidth, app, this.numNodes);
        this.addChild((Node)this.cylindercreate);
    }

    public BondObject getCopy() {
        double[] nn = new double[this.nearestNeighbor.length];
        for (int i = 0; i < this.nearestNeighbor.length; ++i) {
            nn[i] = this.nearestNeighbor[i];
        }
        BondObject copy = new BondObject(nn);
        Appearance app = new Appearance();
        Material material = new Material();
        material.setDiffuseColor(new Color3f(this.bondColor));
        material.setShininess(120.0f);
        app.setMaterial(material);
        float transparency = 0.6f;
        try {
            transparency = Float.parseFloat(this.gp.getProperty("transparency_of_temporary_atom"));
        }
        catch (Exception exc) {
            // empty catch block
        }
        TransparencyAttributes ta = new TransparencyAttributes(2, 0.0f);
        ta.setTransparency(transparency);
        app.setTransparencyAttributes(ta);
        Point3d Cyl1 = new Point3d(this.nearestNeighbor[0], this.nearestNeighbor[1], this.nearestNeighbor[2]);
        Point3d Cyl2 = new Point3d(this.nearestNeighbor[3], this.nearestNeighbor[4], this.nearestNeighbor[5]);
        this.transformBuffer = new CylinderCreatorTG(Cyl1, Cyl2, this.bondWidth, app, this.numNodes);
        copy.addChild((Node)this.transformBuffer);
        copy.setIndex(this.index);
        return copy;
    }

    protected boolean intermediateStateNecessary() {
        return this.buffer != null && this.transformBuffer != null;
    }

    public void recreate(double[] nearestNeighbor) {
        if (this.cylindercreate == null) {
            return;
        }
        Point3d Cyl1 = new Point3d(nearestNeighbor[0], nearestNeighbor[1], nearestNeighbor[2]);
        Point3d Cyl2 = new Point3d(nearestNeighbor[3], nearestNeighbor[4], nearestNeighbor[5]);
        this.cylindercreate.recreate(Cyl1, Cyl2);
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setBondColor(float[] bondColor) {
        this.bondColor = bondColor;
    }

    public void setNumNodes(int numNodes) {
        this.numNodes = numNodes;
    }

    public void setBondWidth(double bondWidth) {
        this.bondWidth = bondWidth;
    }

    public void createBuffer() {
        this.buffer = this.getCopy();
    }

    public void nullifyBuffer() {
        this.buffer = null;
        this.transformBuffer = null;
    }
}

