/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer.scenegraphelements;

import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.media.j3d.Behavior;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import jp.advancesoft.chase.acviewer.ACVDataManager;
import jp.advancesoft.chase.acviewer.ConfigData;
import jp.advancesoft.chase.acviewer.ConfigDataManager;
import jp.advancesoft.chase.acviewer.MainPanel;
import jp.advancesoft.chase.acviewer.ScaleShiftXYZ;
import jp.advancesoft.chase.acviewer.measure.Measurable;
import jp.advancesoft.chase.acviewer.measure.Measure;
import jp.advancesoft.chase.acviewer.measure.MeasureBranchGroup;
import jp.advancesoft.chase.acviewer.mouselistener.MyMouseRotate;
import jp.advancesoft.chase.acviewer.mouselistener.MyMouseTranslate;
import jp.advancesoft.chase.acviewer.scenegraphelements.AtomObject;
import jp.advancesoft.chase.acviewer.scenegraphelements.AtomPicker;
import jp.advancesoft.chase.acviewer.scenegraphelements.DynamicallyEditable;
import jp.advancesoft.chase.acviewer.scenegraphelements.SceneGraphElement;
import jp.advancesoft.chase.acviewer.scenegraphelements.SceneGraphElementBG;
import jp.advancesoft.chase.acviewer.scenegraphelements.SceneGraphElementCreator;
import jp.advancesoft.chase.acviewer.scenegraphelements.Selectable;
import jp.advancesoft.chase.acviewer.scenegraphelements.bond.BondCalculator;
import jp.advancesoft.chase.acviewer.scenegraphelements.bond.BondInfo;
import jp.advancesoft.chase.acviewer.scenegraphelements.bond.BondObject;
import jp.advancesoft.chase.common.TaggedString;
import org.apache.log4j.Logger;

public class TGAtom
extends TransformGroup
implements Selectable,
Measurable,
ConfigData {
    private static Logger logger = Logger.getLogger((String)TGAtom.class.getName());
    private SceneGraphElementCreator creator;
    private MainPanel mp;
    private double lenmax;
    private double[] jusin;
    private Measure measure;
    private boolean measureAtWork = false;
    private Stack selectedAtoms = new Stack();
    private ConfigDataManager mCD;
    private ACVDataManager mACVD;
    private double[][] Dpos;
    private double[][] Dforce;
    private int NumAt;
    private double[][] cellvec;
    private BondCalculator clcbnd;
    private BondInfo[] bondInfo;
    private boolean rescaleOnUpdate = true;
    private Vector bondVector = new Vector();
    private Transform3D buffer = new Transform3D();

    public TGAtom() {
        this.setCapability(18);
        this.setCapability(17);
        this.setCapability(1);
        this.setCapability(14);
        this.setCapability(12);
        this.setCapability(13);
    }

    public void setParentFrame(MainPanel mp) {
        this.mp = mp;
    }

    public MainPanel getParentFrame() {
        return this.mp;
    }

    public void setPicker(AtomPicker picker) {
        picker.setParent(this);
        BranchGroup bg = new BranchGroup();
        bg.addChild((Node)picker);
        this.addChild((Node)bg);
    }

    public void registerMeasure(Measure measure) {
        if (this.measure != null && measure != null && this.measure.getClass().getName().equals(measure.getClass().getName())) {
            this.endMeasure();
        }
        this.measure = measure;
        this.startMeasure();
    }

    public void toggleMeasure() {
        if (this.measureAtWork && this.measure != null) {
            this.endMeasure();
        } else {
            this.startMeasure();
        }
    }

    public void startMeasure() {
        this.deselectAll();
        this.measureAtWork = true;
        logger.debug((Object)"start measure");
    }

    public void endMeasure() {
        this.deselectAll();
        this.measureAtWork = false;
        this.measure = null;
        logger.debug((Object)"end measure");
    }

    public void selected(AtomObject obj) {
        BranchGroup root = this.mp.getRootBranch();
        Enumeration enu = root.getAllChildren();
        while (enu.hasMoreElements()) {
            Object object = enu.nextElement();
            if (!(object instanceof MouseTranslate)) continue;
            ((Behavior)object).setEnable(false);
        }
        this.selectedAtoms.push(obj);
        this.doBond();
        if (this.measure == null || this.measure.getNumberOfNecessaryAtoms() < 0) {
            return;
        }
        if (this.measureAtWork && this.selectedAtoms.size() >= this.measure.getNumberOfNecessaryAtoms()) {
            this.measure.measure(this.selectedAtoms);
            this.measure.draw();
            this.deselectAll();
        }
    }

    private void doBond() {
        int i;
        int[] satoms = this.getSelectedAtomsIndex();
        if (satoms == null || satoms.length == 0) {
            return;
        }
        BondObject[] bonds = this.getBondObjects();
        if (bonds == null) {
            return;
        }
        for (i = 0; i < bonds.length; ++i) {
            bonds[i].nullifyBuffer();
        }
        for (i = 0; i < satoms.length - 1; ++i) {
            for (int j = i + 1; j < satoms.length; ++j) {
                int bind = this.clcbnd.getBondIndex(satoms[i], satoms[j]);
                logger.debug((Object)("index of bond for atom " + satoms[i] + " and " + satoms[j] + ": " + bind));
                if (bind < 0) continue;
                for (int k = 0; k < bonds.length; ++k) {
                    if (bonds[k].getBuffer() != null || bonds[k].getIndex() != bind) continue;
                    logger.debug((Object)"creating buffer...");
                    bonds[k].createBuffer();
                }
            }
        }
    }

    public void removeMeasureObjects() {
        Enumeration enumeration = this.getAllChildren();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (!(obj instanceof MeasureBranchGroup)) continue;
            ((MeasureBranchGroup)((Object)obj)).detach();
        }
    }

    public void addShape(BranchGroup shape) {
        this.addChild((Node)shape);
    }

    public SceneGraphElementCreator getCreator() {
        return this.creator;
    }

    public void deselected(AtomObject obj) {
        if (this.selectedAtoms.remove(obj)) {
            logger.debug((Object)("removed atom " + obj.getID() + " from 'selected' list"));
        }
        this.doBond();
        if (this.selectedAtoms.empty()) {
            BranchGroup root = this.mp.getRootBranch();
            Enumeration enu = root.getAllChildren();
            while (enu.hasMoreElements()) {
                Object object = enu.nextElement();
                if (!(object instanceof MyMouseTranslate)) continue;
                ((MyMouseTranslate)((Object)object)).clear();
                ((Behavior)object).setEnable(true);
            }
        }
    }

    public void deselectAll() {
        AtomObject[] selected = this.getSelectedAtoms();
        if (selected == null) {
            return;
        }
        logger.debug((Object)"removing all atoms.");
        int n = selected.length;
        for (int i = 0; i < n; ++i) {
            selected[i].unSelect();
        }
        BranchGroup root = this.mp.getRootBranch();
        Enumeration enu = root.getAllChildren();
        this.selectedAtoms = new Stack();
        while (enu.hasMoreElements()) {
            Object object = enu.nextElement();
            if (!(object instanceof MyMouseTranslate)) continue;
            ((MyMouseTranslate)((Object)object)).clear();
            ((Behavior)object).setEnable(true);
        }
    }

    public void setRotationEnabled(boolean enable) {
        BranchGroup root = this.mp.getRootBranch();
        Enumeration enu = root.getAllChildren();
        while (enu.hasMoreElements()) {
            Object object = enu.nextElement();
            if (!(object instanceof MyMouseRotate)) continue;
            ((MyMouseRotate)((Object)object)).init();
            ((Behavior)object).setEnable(enable);
        }
    }

    private void setLenMax(double lenmax) {
        this.lenmax = lenmax;
    }

    public double getLenMax() {
        return this.lenmax;
    }

    private void setCOM(double[] jusin) {
        this.jusin = jusin;
    }

    public double[] getCOM() {
        return this.jusin;
    }

    public void setSceneGraphElementCreator(SceneGraphElementCreator creator) {
        this.creator = creator;
        this.mCD = creator.getConfigData();
        this.mACVD = creator.getACVData();
        this.mCD.register(this);
    }

    public ConfigDataManager getConfigData() {
        return this.creator.getConfigData();
    }

    public ACVDataManager getACVData() {
        return this.creator.getACVData();
    }

    public void create() {
        this.prepare();
        this.addAtoms();
        this.addBond();
        this.addCell();
    }

    public void restoreSelection(int last, int[] selectedBuffer) {
        logger.debug((Object)"restoreing selection...");
        logger.debug((Object)("numat now: " + this.mCD.getNumAt() + ", previous numat: " + last));
        if (selectedBuffer == null || selectedBuffer.length == 0) {
            return;
        }
        logger.debug((Object)("size of 'selected' buffer: " + selectedBuffer.length));
        if (this.mCD.getNumAt() == last) {
            AtomObject[] atoms = this.getAtomObjects();
            if (atoms == null || selectedBuffer == null) {
                return;
            }
            for (int i = 0; i < atoms.length; ++i) {
                for (int j = 0; j < selectedBuffer.length; ++j) {
                    if (Integer.parseInt(atoms[i].getID()) - 1 != selectedBuffer[j]) continue;
                    atoms[i].setSelected();
                }
            }
        }
    }

    private void prepare() {
        this.prepare(true);
    }

    private void prepare(boolean rescaleOnUpdate) {
        int i;
        this.NumAt = this.mCD.getNumAt();
        double[][] DposOrig = this.mCD.getPos();
        this.Dpos = new double[this.NumAt][3];
        for (i = 0; i < this.NumAt; ++i) {
            logger.debug((Object)("DposOrig: " + DposOrig[i][0] + " " + DposOrig[i][1] + " " + DposOrig[i][2]));
            for (int j = 0; j < 3; ++j) {
                this.Dpos[i][j] = DposOrig[i][j];
            }
        }
        if (rescaleOnUpdate) {
            double[][] cellvec_tmp;
            ScaleShiftXYZ ssxyz = new ScaleShiftXYZ(this.mACVD, this.mCD);
            this.cellvec = new double[3][3];
            if (this.mACVD.getDrawCell() && (cellvec_tmp = this.mCD.getCell()) != null) {
                for (int i2 = 0; i2 < 3; ++i2) {
                    for (int j = 0; j < 3; ++j) {
                        this.cellvec[i2][j] = cellvec_tmp[i2][j];
                    }
                }
                try {
                    ssxyz.SSVecs(this.Dpos, this.NumAt, this.cellvec);
                }
                catch (Exception exception) {
                    logger.warn((Object)"failed shifting & scaling of cellvector");
                }
            } else {
                ssxyz.SSVecs(this.Dpos, this.NumAt);
            }
            this.setLenMax(ssxyz.getLenMax());
            this.setCOM(ssxyz.getCOM());
        } else {
            for (i = 0; i < this.NumAt; ++i) {
                double x = this.Dpos[i][0];
                double y = this.Dpos[i][1];
                double z = this.Dpos[i][2];
                double lenmax = this.mCD.getLenMax();
                double[] COM = this.mCD.getCOM();
                x -= COM[0];
                y -= COM[1];
                z -= COM[2];
                this.Dpos[i][0] = x /= lenmax;
                this.Dpos[i][1] = y /= lenmax;
                this.Dpos[i][2] = z /= lenmax;
                this.setLenMax(this.mCD.getLenMax());
                this.setCOM(this.mCD.getCOM());
            }
        }
        this.Dforce = this.mCD.getForce();
    }

    private void addAtoms() {
        String[] elements = this.mCD.getElements();
        TaggedString[][] auxils = this.mCD.getAuxils();
        for (int i = 0; i < this.NumAt; ++i) {
            int atomicNumber = 1;
            if (elements[i] == null || elements[i].length() == 0) continue;
            for (int j = 0; j < this.mACVD.getNumEl(); ++j) {
                if (!elements[i].equals(this.mACVD.getElement()[j])) continue;
                atomicNumber = j;
            }
            int mobile = 0;
            int weight = 1;
            try {
                for (int au = 0; au < auxils[0].length; ++au) {
                    TaggedString ts = auxils[i][au];
                    if (ts.getTag().trim().equalsIgnoreCase("mobile")) {
                        try {
                            mobile = Integer.parseInt(ts.getValue());
                        }
                        catch (NumberFormatException nfe) {}
                        continue;
                    }
                    if (!ts.getTag().trim().equalsIgnoreCase("weight")) continue;
                    try {
                        weight = Integer.parseInt(ts.getValue());
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
            }
            catch (NullPointerException npe) {
                mobile = 0;
                weight = 1;
            }
            logger.debug((Object)("elements, pos, label, mobile: " + elements[i] + " " + this.Dpos[i][0] + " " + this.Dpos[i][1] + " " + this.Dpos[i][2] + " " + " " + mobile));
            String ID = new Integer(i + 1).toString();
            SceneGraphElement at = this.creator.getSceneGraphElement(ID, atomicNumber, this.Dpos[i], this.Dforce[i], mobile, weight);
            at.register(this.mCD, this.mACVD, this);
            this.mCD.register(at);
            this.addChild((Node)at);
        }
    }

    private void addBond() {
        this.clcbnd = new BondCalculator(this.mACVD, this.mCD);
        this.clcbnd.calculateBond(this.Dpos);
        this.bondInfo = this.clcbnd.getBondInfo();
        int NumBond = this.clcbnd.getNumBond();
        int NumBondMax = this.clcbnd.getNumBondMax();
        for (int i = 0; i < NumBondMax; ++i) {
            if (!this.bondInfo[i].isValid()) continue;
            double[] NearestNeighbor_ = this.bondInfo[i].getCoordinates();
            SceneGraphElementBG bond = this.creator.getSceneGraphElement(NearestNeighbor_);
            ((BondObject)bond).setIndex(i);
            this.addChild((Node)bond);
            this.bondVector.addElement(new Integer(i));
        }
    }

    private void addCell() {
        double[] cellOrigin = this.mCD.getCellOriginVector();
        if (this.mACVD.getDrawCell() && this.mCD.getValidCell()) {
            this.addChild((Node)this.creator.getSceneGraphElement(cellOrigin, this.cellvec));
        }
    }

    public int getSelectedAtomCount() {
        int ret = 0;
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!(this.getChild(i) instanceof AtomObject) || !((AtomObject)this.getChild(i)).isSelected()) continue;
            ++ret;
        }
        return ret;
    }

    public int[] getSelectedAtomsIndex() {
        int i;
        Vector<String> vret = new Vector<String>();
        for (i = 0; i < this.numChildren(); ++i) {
            if (!(this.getChild(i) instanceof AtomObject) || !((AtomObject)this.getChild(i)).isSelected()) continue;
            vret.addElement(((AtomObject)this.getChild(i)).getID());
        }
        if (vret.size() == 0) {
            return null;
        }
        int[] ret = new int[vret.size()];
        for (i = 0; i < vret.size(); ++i) {
            ret[i] = Integer.parseInt((String)vret.elementAt(i)) - 1;
        }
        return ret;
    }

    public void setRescaleOnUpdate(boolean rescaleOnUpdate) {
        this.rescaleOnUpdate = rescaleOnUpdate;
    }

    public boolean getRescaleOnUpdate() {
        return this.rescaleOnUpdate;
    }

    public void configDataUpdate(boolean rescaleOnUpdate) {
        if (this.mp.doRedraw()) {
            return;
        }
        this.prepare(rescaleOnUpdate);
        this.updateBond();
    }

    public void configDataUpdate() {
        if (this.mp.doRedraw()) {
            return;
        }
        this.prepare();
        this.updateBond();
    }

    public int getLastNumAt() {
        int last = this.mCD.getNumAt();
        logger.debug((Object)("stored selection; numat now: " + last));
        return last;
    }

    private void updateBond() {
        this.clcbnd.calculateBond(this.Dpos);
        this.bondInfo = this.clcbnd.getBondInfo();
        int NumBondMax = this.clcbnd.getNumBondMax();
        for (int i = 0; i < NumBondMax; ++i) {
            if (!this.bondInfo[i].isValid() || this.alreadyDrawn(i)) continue;
            double[] NearestNeighbor_ = this.bondInfo[i].getCoordinates();
            SceneGraphElementBG bond = this.creator.getSceneGraphElement(NearestNeighbor_);
            ((BondObject)bond).setIndex(i);
            this.addChild((Node)bond);
            this.bondVector.addElement(new Integer(i));
        }
        BondObject[] bonds = this.getBondObjects();
        if (bonds == null) {
            return;
        }
        for (int i = 0; i < bonds.length; ++i) {
            this.recreateBond(bonds[i]);
        }
    }

    private boolean alreadyDrawn(int i) {
        int ind = this.bondVector.indexOf(new Integer(i));
        return ind >= 0;
    }

    private void recreateBond(BondObject bond) {
        logger.debug((Object)("recreating bond no. " + bond.getIndex()));
        int ind = bond.getIndex();
        double[] NearestNeighbor_ = this.bondInfo[ind].getCoordinates();
        if (this.bondInfo[ind].isValid()) {
            bond.recreate(NearestNeighbor_);
        } else {
            bond.detach();
            this.bondVector.remove(new Integer(ind));
        }
    }

    public boolean needsUpdate() {
        return true;
    }

    public DynamicallyEditable[] getDynamicallyEditableElements() {
        Vector<Node> retvec = new Vector<Node>();
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!(this.getChild(i) instanceof DynamicallyEditable)) continue;
            retvec.addElement(this.getChild(i));
        }
        if (retvec.size() == 0) {
            return null;
        }
        Object[] rets = new DynamicallyEditable[retvec.size()];
        retvec.copyInto(rets);
        return rets;
    }

    private BondObject[] getBondObjects() {
        Vector<Node> retvec = new Vector<Node>();
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!(this.getChild(i) instanceof BondObject)) continue;
            retvec.addElement(this.getChild(i));
        }
        if (retvec.size() == 0) {
            return null;
        }
        Object[] rets = new BondObject[retvec.size()];
        retvec.copyInto(rets);
        return rets;
    }

    public AtomObject[] getAtomObjects() {
        Vector<Node> retvec = new Vector<Node>();
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!(this.getChild(i) instanceof AtomObject)) continue;
            retvec.addElement(this.getChild(i));
        }
        if (retvec.size() == 0) {
            return null;
        }
        Object[] rets = new AtomObject[retvec.size()];
        retvec.copyInto(rets);
        return rets;
    }

    public AtomObject[] getSelectedAtoms() {
        AtomObject[] all = this.getAtomObjects();
        if (all == null) {
            return null;
        }
        Vector<AtomObject> retvec = new Vector<AtomObject>();
        for (int i = 0; i < all.length; ++i) {
            if (!all[i].isSelected()) continue;
            retvec.addElement(all[i]);
        }
        if (retvec.size() == 0) {
            return null;
        }
        Object[] rets = new AtomObject[retvec.size()];
        retvec.copyInto(rets);
        return rets;
    }
}

