/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import jp.advancesoft.chase.acviewer.MainPanel;
import jp.advancesoft.chase.settings.GlobalProperties;
import jp.advancesoft.chase.settings.PropertiesManager;

public class ACVDataManager {
    public static final int DARKER = 0;
    public static final int BRIGHTER = 1;
    private double bondfactor;
    private float bgr;
    private float bgg;
    private float bgb;
    private int NumEl;
    private double[] covrad;
    private float[] rad;
    private String[] element;
    private String[] mass;
    private Vector elementNew = new Vector();
    private Vector radNew = new Vector();
    private Vector covradNew = new Vector();
    private Vector colorNew = new Vector();
    private float[][] color;
    private int numnodes;
    private int numnodesbond;
    private float[] bondcolor;
    private double bondwidth;
    private float[] bgcolor;
    private float scale;
    private float scaleatom;
    private boolean drawcell;
    private float cellwidth;
    private int numnodescell;
    private float cellr;
    private float cellg;
    private float cellb;
    private float[] cellcolor;
    private boolean gettext;
    private boolean legend;
    private boolean axis;
    private String[] label;
    private boolean bmobile;
    private int labelOffset;
    private GlobalProperties propManager = PropertiesManager.getGlobalProperties(1);
    private PrintWriter fout;
    private String elementInfo;
    private int mobilityDisplayMode;
    private Font font;
    private MainPanel mp;

    public ACVDataManager() {
        this.setBondFactor(1.06);
        this.setBgColor(0.6f, 0.6f, 0.6f);
        this.setBondColor(0.0f, 0.2f, 0.2f);
        this.setBondWidth(0.01);
        this.setScale(1.0f);
        this.setNumNodesAtom(10);
        this.setNumNodesBond(10);
        this.setScaleAtom(1.0f);
        this.setCellWidth(0.005f);
        this.setNumNodesCell(10);
        this.setCellColor(1.0f, 1.0f, 1.0f);
        this.setDrawCell(false);
        this.setText(false);
        this.setMobile(false);
        this.setLabelOffset(3);
        this.setMobilityDisplayMode(0);
        this.setFont(new Font("Helvetica", 0, 18));
        this.readACVPrefs();
    }

    public void setDefaults() {
        this.setBondFactor(1.06);
        this.setBgColor(0.6f, 0.6f, 0.6f);
        this.setScale(1.0f);
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = new Font("Helvetica", 0, 18);
        }
        return this.font;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScaleAtom(float scaleatom) {
        this.scaleatom = scaleatom;
    }

    public float getScaleAtom() {
        return this.scaleatom;
    }

    public void setBgColor(float bgr, float bgg, float bgb) {
        this.bgr = bgr;
        this.bgg = bgg;
        this.bgb = bgb;
        this.bgcolor = new float[3];
        this.bgcolor[0] = this.bgr;
        this.bgcolor[1] = this.bgg;
        this.bgcolor[2] = this.bgb;
    }

    public float[] getBgColor() {
        return this.bgcolor;
    }

    public void setBondFactor(double bondfactor) {
        this.bondfactor = bondfactor;
    }

    public double getBondFactor() {
        return this.bondfactor;
    }

    public void setNumEl(int NumEl) {
        this.NumEl = NumEl;
    }

    public int getNumEl() {
        int ret = this.element.length + this.elementNew.size();
        return ret;
    }

    public void setElement(String[] element) {
        this.element = element;
    }

    public String[] getElement() {
        int i;
        String[] ret = new String[this.element.length + this.elementNew.size()];
        for (i = 0; i < this.element.length; ++i) {
            ret[i] = this.element[i];
        }
        for (i = 0; i < this.elementNew.size(); ++i) {
            ret[i + this.element.length] = (String)this.elementNew.get(i);
        }
        return ret;
    }

    public void setCovRad(double[] covrad) {
        this.covrad = covrad;
    }

    public double[] getCovRad() {
        int i;
        double[] ret = new double[this.covrad.length + this.covradNew.size()];
        for (i = 0; i < this.covrad.length; ++i) {
            ret[i] = this.covrad[i];
        }
        for (i = 0; i < this.covradNew.size(); ++i) {
            ret[i + this.covrad.length] = (Double)this.covradNew.get(i);
        }
        return ret;
    }

    public void setRad(float[] rad) {
        this.rad = rad;
    }

    public float[] getRad() {
        int i;
        float[] ret = new float[this.rad.length + this.radNew.size()];
        for (i = 0; i < this.rad.length; ++i) {
            ret[i] = this.rad[i];
        }
        for (i = 0; i < this.radNew.size(); ++i) {
            ret[i + this.rad.length] = ((Float)this.radNew.get(i)).floatValue();
        }
        return ret;
    }

    public void setColor(float[][] color) {
        this.color = color;
    }

    public float[][] getColor() {
        int j;
        int i;
        float[][] ret = new float[this.color.length + this.colorNew.size()][3];
        for (i = 0; i < this.color.length; ++i) {
            for (j = 0; j < 3; ++j) {
                ret[i][j] = this.color[i][j];
            }
        }
        for (i = 0; i < this.colorNew.size(); ++i) {
            for (j = 0; j < 3; ++j) {
                ret[i + this.color.length][j] = ((float[])this.colorNew.get(i))[j];
            }
        }
        return ret;
    }

    public void setNumNodesAtom(int numnodes) {
        this.numnodes = numnodes;
    }

    public int getNumNodesAtom() {
        return this.numnodes;
    }

    public void setNumNodesBond(int numnodesbond) {
        this.numnodesbond = numnodesbond;
    }

    public int getNumNodesBond() {
        return this.numnodesbond;
    }

    public void setBondColor(float bndcolorr, float bndcolorb, float bndcolorg) {
        this.bondcolor = new float[3];
        this.bondcolor[0] = bndcolorr;
        this.bondcolor[1] = bndcolorb;
        this.bondcolor[2] = bndcolorg;
    }

    public float[] getBondColor() {
        return this.bondcolor;
    }

    public void setBondWidth(double bondwidth) {
        this.bondwidth = bondwidth;
    }

    public double getBondWidth() {
        return this.bondwidth;
    }

    public void setDrawCell(boolean drawcell) {
        this.drawcell = drawcell;
    }

    public boolean getDrawCell() {
        return this.drawcell;
    }

    public void setNumNodesCell(int numnodescell) {
        this.numnodescell = numnodescell;
    }

    public int getNumNodesCell() {
        return this.numnodescell;
    }

    public void setCellWidth(float cellwidth) {
        this.cellwidth = cellwidth;
    }

    public float getCellWidth() {
        return this.cellwidth;
    }

    public void setCellColor(float cellr, float cellg, float cellb) {
        this.cellcolor = new float[3];
        this.cellcolor[0] = cellr;
        this.cellcolor[1] = cellg;
        this.cellcolor[2] = cellb;
    }

    public float[] getCellColor() {
        return this.cellcolor;
    }

    public void setText(boolean gettext) {
        this.gettext = gettext;
    }

    public boolean getText() {
        return this.gettext;
    }

    public void setLabel(String[] label) {
        this.label = label;
    }

    public String[] getLabel() {
        return this.label;
    }

    public void setLegend(boolean legend) {
        this.legend = legend;
    }

    public boolean getLegend() {
        return this.legend;
    }

    public void setAxis(boolean axis) {
        this.axis = axis;
    }

    public boolean getAxis() {
        return this.axis;
    }

    public void setMobile(boolean bmobile) {
        this.bmobile = bmobile;
    }

    public boolean getMobile() {
        return this.bmobile;
    }

    public void setMobilityDisplayMode(int mobilityDisplayMode) {
        this.mobilityDisplayMode = mobilityDisplayMode;
    }

    public int getMobilityDisplayMode() {
        return this.mobilityDisplayMode;
    }

    public void setLabelOffset(int labelOffset) {
        this.labelOffset = labelOffset;
    }

    public int getLabelOffset() {
        return this.labelOffset;
    }

    public void setElementInfoFile(String elementInfo) {
        this.elementInfo = elementInfo;
        this.NumEl = this.getNumElementInfo();
        this.setNumEl(this.NumEl);
        this.element = new String[this.NumEl];
        this.covrad = new double[this.NumEl];
        this.rad = new float[this.NumEl];
        this.color = new float[this.NumEl][3];
        this.mass = new String[this.NumEl];
        this.readElementInfo();
        this.setElement(this.element);
        this.setCovRad(this.covrad);
        this.setRad(this.rad);
        this.setColor(this.color);
    }

    private void readACVPrefs() {
        this.setBondFactor(Double.parseDouble(this.propManager.getProperty("bondfactor").trim()));
        this.setBgColor(Float.parseFloat(this.propManager.getProperty("bgcolor_r").trim()), Float.parseFloat(this.propManager.getProperty("bgcolor_g").trim()), Float.parseFloat(this.propManager.getProperty("bgcolor_b").trim()));
        this.setBondColor(Float.parseFloat(this.propManager.getProperty("bondcolor_r").trim()), Float.parseFloat(this.propManager.getProperty("bondcolor_g").trim()), Float.parseFloat(this.propManager.getProperty("bondcolor_b").trim()));
        this.setBondWidth(Double.parseDouble(this.propManager.getProperty("bondwidth").trim()));
        this.setScale(Float.parseFloat(this.propManager.getProperty("scale").trim()));
        this.setNumNodesAtom(Integer.parseInt(this.propManager.getProperty("numnodesatom").trim()));
        this.setNumNodesBond(Integer.parseInt(this.propManager.getProperty("numnodesbond").trim()));
        this.setScaleAtom(Float.parseFloat(this.propManager.getProperty("scaleatom").trim()));
        this.setDrawCell(Boolean.valueOf(this.propManager.getProperty("drawcell").trim()));
        this.setCellWidth(Float.parseFloat(this.propManager.getProperty("cellwidth").trim()));
        this.setCellColor(Float.parseFloat(this.propManager.getProperty("cellcolor_r").trim()), Float.parseFloat(this.propManager.getProperty("cellcolor_g").trim()), Float.parseFloat(this.propManager.getProperty("cellcolor_b").trim()));
        this.setNumNodesCell(Integer.parseInt(this.propManager.getProperty("numnodescell").trim()));
        this.setText(Boolean.valueOf(this.propManager.getProperty("setlabel").trim()));
        this.setLegend(Boolean.valueOf(this.propManager.getProperty("setlegend").trim()));
        this.setAxis(Boolean.valueOf(this.propManager.getProperty("setaxis").trim()));
        this.setMobile(Boolean.valueOf(this.propManager.getProperty("showmobility").trim()));
        this.setLabelOffset(Integer.parseInt(this.propManager.getProperty("labeloffset").trim()));
        this.setMobilityDisplayMode(Integer.parseInt(this.propManager.getProperty("mobilitydisplaymode").trim()));
        this.setFont(new Font(this.propManager.getProperty("font_name"), Integer.parseInt(this.propManager.getProperty("font_style")), Integer.parseInt(this.propManager.getProperty("font_size"))));
    }

    private int getNumElementInfo() {
        int i = 0;
        try {
            String str;
            FileReader reader = new FileReader(this.elementInfo);
            BufferedReader br = new BufferedReader(reader);
            while ((str = br.readLine()) != null) {
                if (str.startsWith("#")) continue;
                ++i;
            }
            reader.close();
        }
        catch (Exception e) {
            System.out.println("failed to read elementinfo,");
            System.out.println(e);
            return -1;
        }
        return i++;
    }

    private void readElementInfo() {
        int i = 0;
        String str = new String();
        try {
            FileReader reader = new FileReader(this.elementInfo);
            BufferedReader br = new BufferedReader(reader);
            while ((str = br.readLine()) != null) {
                if ((str = str.trim()).startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(str);
                this.element[i] = st.nextToken();
                this.rad[i] = Float.parseFloat(st.nextToken());
                this.covrad[i] = Double.parseDouble(st.nextToken());
                this.color[i][0] = Float.parseFloat(st.nextToken());
                this.color[i][1] = Float.parseFloat(st.nextToken());
                this.color[i][2] = Float.parseFloat(st.nextToken());
                this.mass[i] = st.nextToken();
                ++i;
            }
            reader.close();
        }
        catch (Exception e) {
            System.out.println("failed to read elementinfo,");
            System.out.println(e);
        }
    }

    public void addElementInfo(String nameNew, float radiusNew, double covalentradiusNew, float[] elementcolorNew) {
        this.elementNew.addElement(nameNew);
        this.radNew.addElement(new Float(radiusNew));
        this.covradNew.addElement(new Double(covalentradiusNew));
        this.colorNew.addElement(elementcolorNew);
    }

    public void writeACVData() {
        this.writeACVPrefs();
        this.writeElemInfo();
    }

    private void writeACVPrefs() {
        this.propManager.setProperty("bgcolor_r", Float.toString(this.getBgColor()[0]));
        this.propManager.setProperty("bgcolor_g", Float.toString(this.getBgColor()[1]));
        this.propManager.setProperty("bgcolor_b", Float.toString(this.getBgColor()[2]));
        this.propManager.setProperty("bondfactor", Double.toString(this.getBondFactor()));
        this.propManager.setProperty("bondwidth", Double.toString(this.getBondWidth()));
        this.propManager.setProperty("scale", Float.toString(this.getScale()));
        this.propManager.setProperty("scaleatom", Float.toString(this.getScaleAtom()));
        this.propManager.setProperty("numnodesatom", Integer.toString(this.getNumNodesAtom()));
        this.propManager.setProperty("numnodesbond", Integer.toString(this.getNumNodesBond()));
        this.propManager.setProperty("numnodescell", Integer.toString(this.getNumNodesCell()));
        this.propManager.setProperty("drawcell", Boolean.toString(this.getDrawCell()));
        this.propManager.setProperty("cellwidth", Float.toString(this.getCellWidth()));
        this.propManager.setProperty("cellcolor_r", Float.toString(this.getCellColor()[0]));
        this.propManager.setProperty("cellcolor_g", Float.toString(this.getCellColor()[1]));
        this.propManager.setProperty("cellcolor_b", Float.toString(this.getCellColor()[2]));
        this.propManager.setProperty("setlabel", Boolean.toString(this.getText()));
        this.propManager.setProperty("setaxis", Boolean.toString(this.getAxis()));
        this.propManager.setProperty("setlegend", Boolean.toString(this.getLegend()));
        this.propManager.setProperty("showmobility", Boolean.toString(this.getMobile()));
        this.propManager.setProperty("bondcolor_r", Float.toString(this.getBondColor()[0]));
        this.propManager.setProperty("bondcolor_g", Float.toString(this.getBondColor()[1]));
        this.propManager.setProperty("bondcolor_b", Float.toString(this.getBondColor()[2]));
        this.propManager.setProperty("labeloffset", Integer.toString(this.getLabelOffset()));
        this.propManager.setProperty("mobilitydisplaymode", Integer.toString(this.getMobilityDisplayMode()));
        this.font = this.getFont();
        this.propManager.setProperty("font_name", this.font.getName());
        this.propManager.setProperty("font_style", String.valueOf(this.font.getStyle()));
        this.propManager.setProperty("font_syze", String.valueOf(this.font.getSize()));
        this.propManager.storeProperty();
    }

    private void writeElemInfo() {
        try {
            this.fout = new PrintWriter(new BufferedWriter(new FileWriter(this.elementInfo)));
            this.fout.println("#element(symbol)    radius(A)   covalent_radius (A)    color(rgb) mass");
            for (int i = 0; i < this.getElement().length; ++i) {
                this.fout.println(this.getElement()[i] + "                  " + this.getRad()[i] + "                  " + this.getCovRad()[i] + "            " + this.getColor()[i][0] + " " + this.getColor()[i][1] + " " + this.getColor()[i][2] + "   " + this.mass[i]);
            }
            this.fout.close();
        }
        catch (Exception e) {
            System.out.println("failed write to elementinfo");
        }
    }

    protected void setParent(MainPanel mp) {
        this.mp = mp;
    }

    public MainPanel getParent() {
        return this.mp;
    }
}

