/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Common.BaseWindow;
import AbinitMp.Common.GaussianInputFile;
import AbinitMp.Common.PdbFile;
import AbinitMp.Tool.ExampleFileFilter;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.GaussianInputFilePanel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class GaussianInputFileWindow
extends BaseWindow {
    private JFileChooser openFileChooser;
    private JFileChooser saveFileChooser;
    private GaussianInputFilePanel gifFilePanel;

    public GaussianInputFileWindow() {
        super(MyResourceBundle.getResourceString("GaussianInputFileWindow.Title"));
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter("gjf", "Gaussian input file");
        this.openFileChooser = new JFileChooser(".");
        FileFilter fileFilter = this.openFileChooser.getFileFilter();
        this.openFileChooser.addChoosableFileFilter(exampleFileFilter);
        this.openFileChooser.setFileFilter(fileFilter);
        this.openFileChooser.setPreferredSize(new Dimension(500, 500));
        this.saveFileChooser = new JFileChooser(".");
        fileFilter = this.saveFileChooser.getFileFilter();
        this.saveFileChooser.addChoosableFileFilter(exampleFileFilter);
        this.saveFileChooser.setFileFilter(fileFilter);
        this.saveFileChooser.setPreferredSize(new Dimension(500, 500));
        Container container = this.getContentPane();
        container.remove(this.messagePanel);
        this.getJMenuBar().add(this.addMenuItem("GaussianInputFileWindow.fileMenuTitle", "GaussianInputFileWindow.fileMenu", (Action)new fileListener()));
        this.gifFilePanel = new GaussianInputFilePanel();
        this.mainPanel.add(this.gifFilePanel);
        this.pack();
    }

    private void openFile(String string) {
        try {
            GaussianInputFile gaussianInputFile = new GaussianInputFile(string);
            this.gifFilePanel.setParameter(gaussianInputFile);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Gaussian Input File load error (" + string + ").\n" + exception.getMessage(), "Error message", 0);
        }
    }

    private void saveFile(String string) {
        GaussianInputFile gaussianInputFile = new GaussianInputFile();
        this.gifFilePanel.setParameterToFile(gaussianInputFile);
        try {
            gaussianInputFile.saveFile(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Gaussian Input File save error (" + string + ").\n" + exception.getMessage(), "Error message", 0);
        }
    }

    public void setMolecule(PdbFile pdbFile) {
        this.gifFilePanel.setMolecule(pdbFile);
    }

    public static void main(String[] stringArray) {
        GaussianInputFileWindow gaussianInputFileWindow = new GaussianInputFileWindow();
        gaussianInputFileWindow.setVisible(true);
    }

    class fileListener
    extends AbstractAction {
        fileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("GaussianInputFileWindow.fileMenu");
            char c = string.charAt(0);
            if (GaussianInputFileWindow.this.getNemonic(stringArray[0]) == c) {
                if (GaussianInputFileWindow.this.openFileChooser.showOpenDialog(null) == 0) {
                    String string2 = GaussianInputFileWindow.this.openFileChooser.getSelectedFile().getPath();
                    GaussianInputFileWindow.this.openFile(string2);
                }
            } else if (GaussianInputFileWindow.this.getNemonic(stringArray[1]) == c) {
                if (GaussianInputFileWindow.this.saveFileChooser.showSaveDialog(null) == 0) {
                    String string3 = GaussianInputFileWindow.this.saveFileChooser.getSelectedFile().getPath();
                    int n = string3.lastIndexOf(".");
                    if (n == -1) {
                        string3 = string3 + ".gif";
                    }
                    GaussianInputFileWindow.this.saveFile(string3);
                }
            } else if (GaussianInputFileWindow.this.getNemonic(stringArray[2]) == c) {
                GaussianInputFileWindow.this.setVisible(false);
            }
        }
    }
}

