/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Structure;

import AbinitMp.AbinitMpFile.TrajectoryFile;
import AbinitMp.Common.AtomData;
import AbinitMp.Structure.MolecularStructure;
import AbinitMp.Structure.SimplePicking;
import AbinitMp.Structure.SimplePickingCallback;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.DisplayPreference;
import AbinitMp.Viewer.FileItem;
import AbinitMp.Viewer.Text3DData;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.geometry.Text2D;
import com.sun.j3d.utils.picking.PickTool;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DepthComponent;
import javax.media.j3d.DepthComponentFloat;
import javax.media.j3d.DepthComponentInt;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.Raster;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4d;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class SceneViewer
extends Canvas3D {
    private SimpleUniverse universe;
    private BranchGroup branchGroup;
    private TransformGroup transformGroup;
    private TransformGroup centerTG;
    private TransformGroup rotateTG;
    private BranchGroup sectionControl;
    private float scale;
    private AbinitMpViewer abinitMpViewer;
    private SimplePicking picker;
    private Color3f bgColor;
    private Background bg;
    private int distanceFlag = 0;
    private AtomData firstAtomData;
    private Switch axisRootNode;
    private TransformGroup axisTrans;
    private TransformGroup axisRotateTG;
    private BranchGroup pickedGroup;
    private Switch moNode;
    private Switch isoNode;
    MouseRotate myMouseRotate;
    MouseTranslate myMouseTranslate;
    MouseZoom myMouseZoom;
    MouseRotate axisMouseRotate;
    private int axisWhich;
    private BranchGroup textBranchGroup;
    private Switch textSwitch;
    private int rotate = 0;
    private RotationInterpolator rotatorX;
    private RotationInterpolator rotatorY;
    private RotationInterpolator rotatorZ;
    private RotationInterpolator rotatorAxisX;
    private RotationInterpolator rotatorAxisY;
    private RotationInterpolator rotatorAxisZ;
    private Alpha rotationAlpha;
    private Raster readRaster;
    private String imagefileDirectory;
    private String imagefilePrefix;
    private Hashtable boundaryTgTable1 = new Hashtable();
    private Hashtable boundaryTgTable2 = new Hashtable();

    public TransformGroup getScene() {
        return this.transformGroup;
    }

    public BranchGroup getRoot() {
        return this.branchGroup;
    }

    public void addNode(Node node) {
        this.branchGroup.detach();
        this.rotateTG.addChild(node);
        this.universe.addBranchGraph(this.branchGroup);
        String string = (String)node.getUserData();
        if (string != null && string.equals("Isosurface")) {
            this.isoNode = (Switch)node;
        }
        if (string != null && string.equals("MolecularStructure")) {
            this.moNode = (Switch)node;
        }
    }

    public void detach() {
        this.branchGroup.detach();
    }

    public void addBranchGraph() {
        this.universe.addBranchGraph(this.branchGroup);
    }

    public void setSceneGraph(Switch switch_) {
        this.branchGroup.detach();
        for (int i = 0; i < this.rotateTG.numChildren(); ++i) {
            if (!(this.rotateTG.getChild(i) instanceof Shape3D) && !(this.rotateTG.getChild(i) instanceof TransformGroup) && !(this.rotateTG.getChild(i) instanceof Switch)) continue;
            this.rotateTG.removeChild(i);
            --i;
        }
        this.rotateTG.addChild((Node)switch_);
        String string = (String)switch_.getUserData();
        if (string != null && string.equals("Isosurface")) {
            this.isoNode = switch_;
        }
        if (string != null && string.equals("MolecularStructure")) {
            this.moNode = switch_;
        }
        Transform3D transform3D = new Transform3D();
        this.transformGroup.getTransform(transform3D);
        transform3D.setScale((double)this.scale);
        this.transformGroup.setTransform(transform3D);
        this.universe.addBranchGraph(this.branchGroup);
    }

    public void setSceneGraph(TransformGroup transformGroup) {
        this.branchGroup.detach();
        for (int i = 0; i < this.rotateTG.numChildren(); ++i) {
            if (!(this.rotateTG.getChild(i) instanceof Shape3D) && !(this.rotateTG.getChild(i) instanceof TransformGroup) && !(this.rotateTG.getChild(i) instanceof BranchGroup) && !(this.rotateTG.getChild(i) instanceof Switch)) continue;
            this.rotateTG.removeChild(i);
            --i;
        }
        this.rotateTG.addChild((Node)transformGroup);
        this.universe.addBranchGraph(this.branchGroup);
    }

    public void replaceMoNode(Switch switch_) {
        long l = System.currentTimeMillis();
        Switch switch_2 = null;
        this.branchGroup.detach();
        for (int i = 0; i < this.rotateTG.numChildren(); ++i) {
            String string;
            if (!(this.rotateTG.getChild(i) instanceof Switch) || (string = (String)(switch_2 = (Switch)this.rotateTG.getChild(i)).getUserData()) == null || !string.equals("MolecularStructure")) continue;
            this.rotateTG.removeChild(i);
            this.rotateTG.insertChild((Node)switch_, i);
            break;
        }
        this.moNode = switch_;
        this.universe.addBranchGraph(this.branchGroup);
    }

    public void replaceIsoNode(Switch switch_) {
        Switch switch_2 = null;
        this.branchGroup.detach();
        for (int i = 0; i < this.rotateTG.numChildren(); ++i) {
            String string;
            if (!(this.rotateTG.getChild(i) instanceof Switch) || (string = (String)(switch_2 = (Switch)this.rotateTG.getChild(i)).getUserData()) == null || !string.equals("Isosurface")) continue;
            this.rotateTG.removeChild(i);
            this.rotateTG.insertChild((Node)switch_, i);
            break;
        }
        this.isoNode = switch_;
        this.universe.addBranchGraph(this.branchGroup);
    }

    public Switch getIsoNode() {
        return this.isoNode;
    }

    public Switch getMoNode() {
        return this.moNode;
    }

    public SceneViewer(AbinitMpViewer abinitMpViewer, GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        if (DisplayPreference.stereo) {
            this.setStereoEnable(true);
        }
        this.abinitMpViewer = abinitMpViewer;
        this.scale = 0.5f;
        this.branchGroup = new BranchGroup();
        this.branchGroup.setCapability(12);
        this.branchGroup.setCapability(13);
        this.branchGroup.setCapability(17);
        this.branchGroup.setCapability(14);
        this.universe = new SimpleUniverse((Canvas3D)this);
        this.transformGroup = new TransformGroup();
        this.transformGroup.setCapability(18);
        this.transformGroup.setCapability(17);
        this.transformGroup.setCapability(14);
        this.transformGroup.setCapability(13);
        this.branchGroup.addChild((Node)this.transformGroup);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        this.bgColor = new Color3f(DisplayPreference.backgroundColor);
        this.bg = new Background(this.bgColor);
        this.bg.setApplicationBounds((Bounds)boundingSphere);
        this.bg.setCapability(17);
        this.transformGroup.addChild((Node)this.bg);
        this.textBranchGroup = new BranchGroup();
        this.textBranchGroup.setCapability(12);
        this.textBranchGroup.setCapability(13);
        this.textBranchGroup.setCapability(17);
        this.textBranchGroup.setCapability(14);
        this.branchGroup.addChild((Node)this.textBranchGroup);
        this.centerTG = new TransformGroup();
        this.centerTG.setCapability(18);
        this.centerTG.setCapability(17);
        this.transformGroup.addChild((Node)this.centerTG);
        this.rotateTG = new TransformGroup();
        this.rotateTG.setCapability(18);
        this.rotateTG.setCapability(17);
        this.rotateTG.setCapability(14);
        this.rotateTG.setCapability(13);
        this.rotateTG.setCapability(12);
        this.centerTG.addChild((Node)this.rotateTG);
        this.sectionControl = new BranchGroup();
        this.sectionControl.setCapability(17);
        this.sectionControl.setCapability(14);
        this.sectionControl.setCapability(13);
        this.rotateTG.addChild((Node)this.sectionControl);
        this.axisRootNode = this.createAxisNode(this.universe);
        this.createRotaors();
        this.setViewPoint("front");
        this.myMouseRotate = new MouseRotate();
        this.myMouseRotate.setTransformGroup(this.transformGroup);
        this.myMouseRotate.setSchedulingBounds((Bounds)boundingSphere);
        this.branchGroup.addChild((Node)this.myMouseRotate);
        this.myMouseTranslate = new MouseTranslate();
        this.myMouseTranslate.setTransformGroup(this.transformGroup);
        this.myMouseTranslate.setSchedulingBounds((Bounds)boundingSphere);
        this.branchGroup.addChild((Node)this.myMouseTranslate);
        this.myMouseZoom = new MouseZoom();
        this.myMouseZoom.setTransformGroup(this.transformGroup);
        this.myMouseZoom.setSchedulingBounds((Bounds)boundingSphere);
        this.branchGroup.addChild((Node)this.myMouseZoom);
        this.picker = new SimplePicking(this.branchGroup, this, (Bounds)boundingSphere);
        this.picker.setupCallback(new PickingCallback());
        this.branchGroup.addChild((Node)this.picker);
        AmbientLight ambientLight = new AmbientLight();
        ambientLight.setInfluencingBounds((Bounds)boundingSphere);
        this.branchGroup.addChild((Node)ambientLight);
        Color3f color3f = new Color3f(0.8f, 0.8f, 0.8f);
        Vector3f vector3f = new Vector3f(-1.0f, -1.0f, -1.0f);
        DirectionalLight directionalLight = new DirectionalLight(color3f, vector3f);
        directionalLight.setInfluencingBounds((Bounds)boundingSphere);
        this.branchGroup.addChild((Node)directionalLight);
        color3f = new Color3f(0.2f, 0.2f, 0.2f);
        vector3f = new Vector3f(1.0f, 0.0f, -1.0f);
        directionalLight = new DirectionalLight(color3f, vector3f);
        directionalLight.setInfluencingBounds((Bounds)boundingSphere);
        this.branchGroup.addChild((Node)directionalLight);
        this.universe.getViewingPlatform().setNominalViewingTransform();
        View view = this.universe.getViewer().getView();
        view.setBackClipDistance(10.0);
        view.setFrontClipDistance((double)0.01f);
        if (DisplayPreference.glassless) {
            view.setFieldOfView(1.5707963267948966);
        }
        this.pickedGroup = new BranchGroup();
        this.pickedGroup.setCapability(17);
        this.pickedGroup.setCapability(13);
        this.rotateTG.addChild((Node)this.pickedGroup);
        this.universe.addBranchGraph(this.branchGroup);
    }

    public void setViewPoint(String string) {
        Transform3D transform3D = new Transform3D();
        Quat4d quat4d = null;
        double d = 0.5 / Math.tan(0.39269908169872414);
        Point3d point3d = null;
        Point3d point3d2 = new Point3d();
        Vector3d vector3d = null;
        if (this.rotate != 0) {
            this.rotatorX.setEnable(false);
            this.rotatorY.setEnable(false);
            this.rotatorZ.setEnable(false);
            this.rotatorAxisX.setEnable(false);
            this.rotatorAxisY.setEnable(false);
            this.rotatorAxisZ.setEnable(false);
        }
        if (string.equals("front")) {
            point3d = new Point3d(0.0, 0.0, d);
            vector3d = new Vector3d(0.0, 1.0, 0.0);
            this.rotate = 0;
            quat4d = new Quat4d(0.0, 0.0, 0.0, 1.0);
        } else if (string.equals("back")) {
            point3d = new Point3d(0.0, 0.0, -1.0 * d);
            vector3d = new Vector3d(0.0, 1.0, 0.0);
            this.rotate = 0;
            quat4d = new Quat4d(0.0, 2.0, 0.0, 1.0);
        } else if (string.equals("right")) {
            point3d = new Point3d(d, 0.0, 0.0);
            vector3d = new Vector3d(0.0, 1.0, 0.0);
            this.rotate = 0;
            quat4d = new Quat4d(0.0, -1.0, 0.0, 1.0);
        } else if (string.equals("left")) {
            point3d = new Point3d(-1.0 * d, 0.0, 0.0);
            vector3d = new Vector3d(0.0, 1.0, 0.0);
            this.rotate = 0;
            quat4d = new Quat4d(0.0, 1.0, 0.0, 1.0);
        } else if (string.equals("top")) {
            point3d = new Point3d(0.0, d, 0.0);
            vector3d = new Vector3d(0.0, 0.0, -1.0);
            this.rotate = 0;
            quat4d = new Quat4d(1.0, 0.0, 0.0, 1.0);
        } else if (string.equals("bottom")) {
            point3d = new Point3d(0.0, -1.0 * d, 0.0);
            vector3d = new Vector3d(0.0, 0.0, 1.0);
            this.rotate = 0;
            quat4d = new Quat4d(-1.0, 0.0, 0.0, 1.0);
        } else {
            if (string.equals("rotate_x") || string.equals("rotate_y") || string.equals("rotate_z")) {
                Transform3D transform3D2 = new Transform3D();
                this.centerTG.getTransform(transform3D2);
                Vector3f vector3f = new Vector3f();
                transform3D2.get(vector3f);
                vector3f.scale(-1.0f);
                if (string.equals("rotate_x")) {
                    if (this.rotate == 1) {
                        this.rotate = 0;
                        return;
                    }
                    transform3D2.rotZ(-1.5707963267948966);
                    transform3D2.setTranslation(vector3f);
                    if (DisplayPreference.glassless) {
                        this.rotatorX.setAxisOfRotation(transform3D2);
                    } else {
                        this.rotatorX.setTransformAxis(transform3D2);
                    }
                    this.rotatorX.setEnable(true);
                    this.rotatorAxisX.setEnable(true);
                    this.rotate = 1;
                } else if (string.equals("rotate_y")) {
                    if (this.rotate == 2) {
                        this.rotate = 0;
                        return;
                    }
                    transform3D2.setTranslation(vector3f);
                    if (DisplayPreference.glassless) {
                        this.rotatorY.setAxisOfRotation(transform3D2);
                    } else {
                        this.rotatorY.setTransformAxis(transform3D2);
                    }
                    this.rotatorY.setEnable(true);
                    this.rotatorAxisY.setEnable(true);
                    this.rotate = 2;
                } else if (string.equals("rotate_z")) {
                    if (this.rotate == 3) {
                        this.rotate = 0;
                        return;
                    }
                    transform3D2.rotX(-1.5707963267948966);
                    transform3D2.setTranslation(vector3f);
                    if (DisplayPreference.glassless) {
                        this.rotatorZ.setAxisOfRotation(transform3D2);
                    } else {
                        this.rotatorZ.setTransformAxis(transform3D2);
                    }
                    this.rotatorZ.setEnable(true);
                    this.rotatorAxisZ.setEnable(true);
                    this.rotate = 3;
                }
                return;
            }
            point3d = new Point3d(0.0, 0.0, d);
            vector3d = new Vector3d(0.0, 1.0, 0.0);
        }
        transform3D.lookAt(point3d, point3d2, vector3d);
        transform3D.setScale((double)this.scale);
        this.transformGroup.setTransform(transform3D);
        this.rotateTG.setTransform(new Transform3D());
        this.axisRotateTG.setTransform(new Transform3D());
        Transform3D transform3D3 = new Transform3D();
        this.axisTrans.getTransform(transform3D3);
        transform3D3.setRotation(quat4d);
        this.axisTrans.setTransform(transform3D3);
    }

    public void createRotaors() {
        BoundingSphere boundingSphere = new BoundingSphere();
        Transform3D transform3D = new Transform3D();
        Transform3D transform3D2 = new Transform3D();
        Transform3D transform3D3 = new Transform3D();
        int n = DisplayPreference.ROTATION_SPEED;
        this.rotationAlpha = new Alpha(-1, 1, 4000L, 1000L, (long)n, 0L, 0L, 0L, 0L, 0L);
        this.rotatorX = new RotationInterpolator(this.rotationAlpha, this.rotateTG, transform3D, 0.0f, (float)Math.PI * 2);
        this.rotatorX.setSchedulingBounds((Bounds)boundingSphere);
        this.rotateTG.addChild((Node)this.rotatorX);
        this.rotatorY = new RotationInterpolator(this.rotationAlpha, this.rotateTG, transform3D2, 0.0f, (float)Math.PI * 2);
        this.rotatorY.setSchedulingBounds((Bounds)boundingSphere);
        this.rotateTG.addChild((Node)this.rotatorY);
        this.rotatorZ = new RotationInterpolator(this.rotationAlpha, this.rotateTG, transform3D3, 0.0f, (float)Math.PI * 2);
        this.rotatorZ.setSchedulingBounds((Bounds)boundingSphere);
        this.rotateTG.addChild((Node)this.rotatorZ);
        transform3D.rotZ(-1.5707963267948966);
        transform3D3.rotX(-1.5707963267948966);
        this.rotatorAxisX = new RotationInterpolator(this.rotationAlpha, this.axisRotateTG, transform3D, 0.0f, (float)Math.PI * 2);
        this.rotatorAxisX.setSchedulingBounds((Bounds)boundingSphere);
        this.axisRotateTG.addChild((Node)this.rotatorAxisX);
        this.rotatorAxisY = new RotationInterpolator(this.rotationAlpha, this.axisRotateTG, transform3D2, 0.0f, (float)Math.PI * 2);
        this.rotatorAxisY.setSchedulingBounds((Bounds)boundingSphere);
        this.axisRotateTG.addChild((Node)this.rotatorAxisY);
        this.rotatorAxisZ = new RotationInterpolator(this.rotationAlpha, this.axisRotateTG, transform3D3, 0.0f, (float)Math.PI * 2);
        this.rotatorAxisZ.setSchedulingBounds((Bounds)boundingSphere);
        this.axisRotateTG.addChild((Node)this.rotatorAxisZ);
        this.rotatorX.setEnable(false);
        this.rotatorY.setEnable(false);
        this.rotatorZ.setEnable(false);
        this.rotatorAxisX.setEnable(false);
        this.rotatorAxisY.setEnable(false);
        this.rotatorAxisZ.setEnable(false);
    }

    public void setRotationSpeed() {
        this.rotationAlpha.setIncreasingAlphaDuration((long)DisplayPreference.ROTATION_SPEED);
    }

    public void setScale(float f) {
        this.scale = f;
    }

    public SimpleUniverse getUniverse() {
        return this.universe;
    }

    public Color getBackground() {
        return this.bgColor.get();
    }

    public void setBackgroundColor(Color color) {
        this.bgColor = new Color3f(color);
        this.bg.setColor(this.bgColor);
    }

    private Switch createAxisNode(SimpleUniverse simpleUniverse) {
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3d(-1.55, -1.2, -2.0));
        transform3D.setScale(3.0);
        if (DisplayPreference.glassless) {
            transform3D.setTranslation(new Vector3d(-3.0, -2.5, -1.0));
            transform3D.setScale(4.0);
        }
        this.axisTrans = new TransformGroup(transform3D);
        this.axisRotateTG = new TransformGroup();
        this.axisRotateTG.setCapability(18);
        this.axisRotateTG.setCapability(17);
        this.axisTrans.addChild((Node)this.axisRotateTG);
        this.branchGroup.addChild((Node)this.axisTrans);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(), 100.0);
        this.axisMouseRotate = new MouseRotate();
        this.axisMouseRotate.setTransformGroup(this.axisTrans);
        this.axisMouseRotate.setSchedulingBounds((Bounds)boundingSphere);
        this.axisTrans.addChild((Node)this.axisMouseRotate);
        this.axisTrans.setCapability(18);
        this.axisTrans.setCapability(17);
        Switch switch_ = new Switch(-2);
        switch_.setCapability(14);
        switch_.setCapability(13);
        switch_.setCapability(18);
        switch_.setCapability(17);
        this.axisRotateTG.addChild((Node)switch_);
        Color3f color3f = new Color3f(Color.red);
        Color3f color3f2 = new Color3f(Color.blue);
        Color3f color3f3 = new Color3f(Color.green);
        LineArray lineArray = new LineArray(6, 5);
        lineArray.setCoordinate(0, new Point3f(0.0f, 0.0f, 0.0f));
        lineArray.setCoordinate(1, new Point3f(0.05f, 0.0f, 0.0f));
        lineArray.setCoordinate(2, new Point3f(0.0f, 0.0f, 0.0f));
        lineArray.setCoordinate(3, new Point3f(0.0f, 0.05f, 0.0f));
        lineArray.setCoordinate(4, new Point3f(0.0f, 0.0f, 0.0f));
        lineArray.setCoordinate(5, new Point3f(0.0f, 0.0f, 0.05f));
        lineArray.setColor(0, color3f);
        lineArray.setColor(1, color3f);
        lineArray.setColor(2, color3f2);
        lineArray.setColor(3, color3f2);
        lineArray.setColor(4, color3f3);
        lineArray.setColor(5, color3f3);
        LineAttributes lineAttributes = new LineAttributes(2.0f, 0, true);
        Appearance appearance = new Appearance();
        appearance.setLineAttributes(lineAttributes);
        Shape3D shape3D = new Shape3D((Geometry)lineArray, appearance);
        shape3D.setPickable(false);
        switch_.addChild((Node)shape3D);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotZ(-1.5707963267948966);
        transform3D2.setTranslation(new Vector3d(0.04, 0.0, 0.0));
        TransformGroup transformGroup = new TransformGroup(transform3D2);
        Appearance appearance2 = new Appearance();
        appearance2.setMaterial(new Material(color3f, color3f, color3f, color3f, 100.0f));
        Cone cone = new Cone(0.005f, 0.02f);
        cone.setAppearance(appearance2);
        cone.setPickable(false);
        transformGroup.addChild((Node)cone);
        switch_.addChild((Node)transformGroup);
        Transform3D transform3D3 = new Transform3D();
        transform3D3.setTranslation(new Vector3d(0.0, 0.04, 0.0));
        TransformGroup transformGroup2 = new TransformGroup(transform3D3);
        Appearance appearance3 = new Appearance();
        appearance3.setMaterial(new Material(color3f2, color3f2, color3f2, color3f2, 100.0f));
        Cone cone2 = new Cone(0.005f, 0.02f);
        cone2.setAppearance(appearance3);
        cone2.setPickable(false);
        transformGroup2.addChild((Node)cone2);
        switch_.addChild((Node)transformGroup2);
        Transform3D transform3D4 = new Transform3D();
        transform3D4.rotX(1.5707963267948966);
        transform3D4.setTranslation(new Vector3d(0.0, 0.0, 0.04));
        TransformGroup transformGroup3 = new TransformGroup(transform3D4);
        Appearance appearance4 = new Appearance();
        appearance4.setMaterial(new Material(color3f3, color3f3, color3f3, color3f3, 100.0f));
        Cone cone3 = new Cone(0.005f, 0.02f);
        cone3.setAppearance(appearance4);
        cone3.setPickable(false);
        transformGroup3.addChild((Node)cone3);
        switch_.addChild((Node)transformGroup3);
        float f = 0.02f;
        Font3D font3D = new Font3D(new Font("Century Gothic", 0, 1), new FontExtrusion());
        Point3f point3f = new Point3f(3.0f, -0.4f, 0.0f);
        Transform3D transform3D5 = new Transform3D();
        transform3D5.setScale((double)f);
        TransformGroup transformGroup4 = new TransformGroup(transform3D5);
        Text3D text3D = new Text3D(font3D, "x", point3f);
        OrientedShape3D orientedShape3D = new OrientedShape3D((Geometry)text3D, appearance2, 1, point3f);
        orientedShape3D.setPickable(false);
        transformGroup4.addChild((Node)orientedShape3D);
        switch_.addChild((Node)transformGroup4);
        Point3f point3f2 = new Point3f(0.0f, 3.0f, 0.0f);
        Transform3D transform3D6 = new Transform3D();
        transform3D6.setScale((double)f);
        TransformGroup transformGroup5 = new TransformGroup(transform3D6);
        Text3D text3D2 = new Text3D(font3D, "y", point3f2);
        OrientedShape3D orientedShape3D2 = new OrientedShape3D((Geometry)text3D2, appearance3, 1, point3f2);
        orientedShape3D2.setPickable(false);
        transformGroup5.addChild((Node)orientedShape3D2);
        switch_.addChild((Node)transformGroup5);
        Point3f point3f3 = new Point3f(0.0f, -0.4f, 3.0f);
        Transform3D transform3D7 = new Transform3D();
        transform3D7.setScale((double)f);
        TransformGroup transformGroup6 = new TransformGroup(transform3D7);
        Text3D text3D3 = new Text3D(font3D, "z", point3f3);
        OrientedShape3D orientedShape3D3 = new OrientedShape3D((Geometry)text3D3, appearance4, 1, point3f3);
        orientedShape3D3.setPickable(false);
        transformGroup6.addChild((Node)orientedShape3D3);
        switch_.addChild((Node)transformGroup6);
        return switch_;
    }

    public void setAxisEnable(boolean bl) {
        if (bl) {
            this.axisRootNode.setWhichChild(-2);
        } else {
            this.axisRootNode.setWhichChild(-1);
        }
    }

    public void saveImage(String string, String string2) throws IOException {
        GraphicsContext3D graphicsContext3D = this.getGraphicsContext3D();
        int n = this.getWidth();
        int n2 = this.getHeight();
        Raster raster = new Raster(new Point3f(0.0f, 0.0f, 0.0f), 1, 0, 0, n, n2, new ImageComponent2D(1, n, n2), null);
        graphicsContext3D.readRaster(raster);
        BufferedImage bufferedImage = raster.getImage().getImage();
        File file = new File(string);
        ImageIO.write((RenderedImage)bufferedImage, string2, file);
    }

    public void saveImage(String string) throws IOException {
        int n = this.getWidth();
        int n2 = this.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        ImageComponent2D imageComponent2D = new ImageComponent2D(1, bufferedImage);
        DepthComponentFloat depthComponentFloat = new DepthComponentFloat(n, n2);
        Raster raster = new Raster(new Point3f(0.0f, 0.0f, 0.0f), 1, 0, 0, n, n2, imageComponent2D, (DepthComponent)depthComponentFloat);
        GraphicsContext3D graphicsContext3D = this.getGraphicsContext3D();
        graphicsContext3D.flush(true);
        graphicsContext3D.readRaster(raster);
        ImageComponent2D imageComponent2D2 = raster.getImage();
        BufferedImage bufferedImage2 = imageComponent2D2.getImage();
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
        jPEGImageEncoder.encode(bufferedImage2);
        fileOutputStream.close();
    }

    public void startSaveImagefiles(String string, String string2) {
        this.imagefileDirectory = string;
        this.imagefilePrefix = string2;
        int n = this.getWidth();
        int n2 = this.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        ImageComponent2D imageComponent2D = new ImageComponent2D(1, bufferedImage);
        DepthComponentInt depthComponentInt = new DepthComponentInt(n, n2);
        this.readRaster = new Raster(new Point3f(0.0f, 0.0f, 0.0f), 1, 0, 0, n, n2, imageComponent2D, (DepthComponent)depthComponentInt);
    }

    public void saveAnimationImage(int n) throws IOException {
        GraphicsContext3D graphicsContext3D = this.getGraphicsContext3D();
        graphicsContext3D.flush(true);
        graphicsContext3D.readRaster(this.readRaster);
        ImageComponent2D imageComponent2D = this.readRaster.getImage();
        BufferedImage bufferedImage = imageComponent2D.getImage();
        String string = n < 10 ? "00" + n : (n < 100 ? "0" + n : Integer.toString(n));
        File file = new File(this.imagefileDirectory + "/" + this.imagefilePrefix + string + ".jpg");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
        jPEGImageEncoder.encode(bufferedImage);
        fileOutputStream.close();
    }

    public void setCenter(float f, float f2, float f3) {
        Transform3D transform3D = new Transform3D();
        Vector3f vector3f = new Vector3f(this.abinitMpViewer.coordInfo.xcenter - f, this.abinitMpViewer.coordInfo.ycenter - f2, this.abinitMpViewer.coordInfo.zcenter - f3);
        transform3D.setTranslation(vector3f);
        this.centerTG.setTransform(transform3D);
    }

    public void resetCenter() {
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3f(0.0f, 0.0f, 0.0f));
        this.rotateTG.setTransform(new Transform3D());
        this.centerTG.setTransform(transform3D);
    }

    public void setRotationTranslation(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        Transform3D transform3D = new Transform3D();
        this.transformGroup.getTransform(transform3D);
        Transform3D transform3D2 = new Transform3D();
        this.axisTrans.getTransform(transform3D2);
        Transform3D transform3D3 = new Transform3D();
        transform3D3.setRotation(new AxisAngle4f(f, f2, f3, (float)((double)(f4 / 180.0f) * Math.PI)));
        transform3D.mul(transform3D3);
        transform3D2.mul(transform3D3);
        transform3D3 = new Transform3D();
        transform3D3.set(new Vector3f(f5, f6, f7));
        transform3D.mul(transform3D3);
        transform3D.setScale((double)f8 * transform3D.getScale());
        this.transformGroup.setTransform(transform3D);
        this.rotateTG.setTransform(new Transform3D());
        this.axisRotateTG.setTransform(new Transform3D());
        this.axisTrans.setTransform(transform3D2);
    }

    public void setViewPosition(Matrix4f matrix4f) {
        Transform3D transform3D = new Transform3D();
        transform3D.set(matrix4f);
        this.transformGroup.setTransform(transform3D);
        Quat4f quat4f = new Quat4f();
        Vector3f vector3f = new Vector3f();
        transform3D.get(quat4f, vector3f);
        transform3D = new Transform3D();
        this.axisTrans.getTransform(transform3D);
        transform3D.setRotation(quat4f);
        this.axisTrans.setTransform(transform3D);
    }

    public Matrix4f getViewPosition() {
        Transform3D transform3D = new Transform3D();
        this.transformGroup.getTransform(transform3D);
        Matrix4f matrix4f = new Matrix4f();
        transform3D.get(matrix4f);
        return matrix4f;
    }

    public BranchGroup getPickedGroup() {
        return this.pickedGroup;
    }

    public TransformGroup getRotateTG() {
        return this.rotateTG;
    }

    public void addSectionRootNode(FileItem fileItem, Node node) {
        if (fileItem.sectionFileRootNode == null) {
            fileItem.sectionFileRootNode = new BranchGroup();
            fileItem.sectionFileRootNode.setCapability(17);
            fileItem.sectionFileRootNode.setCapability(14);
            fileItem.sectionFileRootNode.setCapability(13);
            fileItem.sectionFileRootNode.setCapability(12);
        }
        fileItem.sectionFileRootNode.detach();
        fileItem.sectionFileRootNode.addChild(node);
        this.sectionControl.addChild((Node)fileItem.sectionFileRootNode);
        this.connectSectionControl();
    }

    public void connectSectionControl() {
        if (DisplayPreference.glassless) {
            int n;
            for (n = 0; n < this.rotateTG.numChildren() && !this.rotateTG.getChild(n).equals(this.sectionControl); ++n) {
            }
            if (n == this.rotateTG.numChildren()) {
                this.rotateTG.addChild((Node)this.sectionControl);
            }
        } else if (this.rotateTG.indexOfChild((Node)this.sectionControl) == -1) {
            this.rotateTG.addChild((Node)this.sectionControl);
        }
    }

    public void deleteSectionNode(FileItem fileItem, int n) {
        fileItem.sectionFileRootNode.detach();
        fileItem.sectionFileRootNode.removeChild(n);
        System.out.println(n);
        this.sectionControl.addChild((Node)fileItem.sectionFileRootNode);
    }

    public void deleteSectionFileRootNode(BranchGroup branchGroup) {
        this.sectionControl.detach();
        branchGroup.removeAllChildren();
        this.sectionControl.removeChild((Node)branchGroup);
        this.rotateTG.addChild((Node)this.sectionControl);
    }

    public void detachSectionControl() {
        this.sectionControl.detach();
    }

    public void addSectionControl() {
        this.rotateTG.addChild((Node)this.sectionControl);
    }

    public void addSectionFileRootNode(BranchGroup branchGroup) {
        this.sectionControl.addChild((Node)branchGroup);
    }

    public void setProjection(int n) {
        if (n == 0) {
            this.universe.getViewer().getView().setProjectionPolicy(1);
        } else {
            this.universe.getViewer().getView().setProjectionPolicy(0);
        }
    }

    public void createFragmentBoundaryNode(AtomData atomData, AtomData atomData2) {
        float f = atomData.coordX;
        float f2 = atomData.coordY;
        float f3 = atomData.coordZ;
        float f4 = atomData2.coordX;
        float f5 = atomData2.coordY;
        float f6 = atomData2.coordZ;
        float f7 = f4 - f;
        float f8 = f5 - f2;
        float f9 = f6 - f3;
        TransformGroup transformGroup = MolecularStructure.createBondTfg(f7 / 2.0f + f - f7 / 20.0f, f8 / 2.0f + f2 - f8 / 20.0f, f9 / 2.0f + f3 - f9 / 20.0f, f7 / 2.0f + f + f7 / 20.0f, f8 / 2.0f + f2 + f8 / 20.0f, f9 / 2.0f + f3 + f9 / 20.0f);
        Material material = new Material();
        material.setDiffuseColor(new Color3f(Color.gray));
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        Sphere sphere = new Sphere(1.0f, 97, 16, appearance);
        sphere.setUserData((Object)atomData);
        transformGroup.setCapability(1);
        transformGroup.setCapability(12);
        transformGroup.setCapability(13);
        transformGroup.addChild((Node)sphere);
        this.addNode((Node)transformGroup);
        this.boundaryTgTable1.put(atomData, transformGroup);
        transformGroup = MolecularStructure.createBondTfg(f7 / 2.0f + f, f8 / 2.0f + f2, f9 / 2.0f + f3, f4, f5, f6);
        sphere = new Sphere(0.2f, 97, 16, appearance);
        sphere.setUserData((Object)atomData);
        transformGroup.setCapability(1);
        transformGroup.setCapability(12);
        transformGroup.setCapability(13);
        transformGroup.addChild((Node)sphere);
        this.addNode((Node)transformGroup);
        this.boundaryTgTable2.put(atomData, transformGroup);
    }

    public void removeFragmentBoundaryNode(AtomData atomData) {
        this.branchGroup.detach();
        this.rotateTG.removeChild((Node)((TransformGroup)this.boundaryTgTable1.get(atomData)));
        this.rotateTG.removeChild((Node)((TransformGroup)this.boundaryTgTable2.get(atomData)));
        this.universe.addBranchGraph(this.branchGroup);
    }

    public void highlightBounbaryNode(AtomData atomData) {
        Sphere sphere;
        TransformGroup transformGroup;
        Material material = new Material();
        material.setDiffuseColor(new Color3f(Color.gray));
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        Enumeration enumeration = this.boundaryTgTable1.elements();
        while (enumeration.hasMoreElements()) {
            transformGroup = (TransformGroup)enumeration.nextElement();
            sphere = (Sphere)transformGroup.getChild(0);
            sphere.setAppearance(appearance);
        }
        enumeration = this.boundaryTgTable2.elements();
        while (enumeration.hasMoreElements()) {
            transformGroup = (TransformGroup)enumeration.nextElement();
            sphere = (Sphere)transformGroup.getChild(0);
            sphere.setAppearance(appearance);
        }
        transformGroup = (TransformGroup)this.boundaryTgTable1.get(atomData);
        sphere = (Sphere)transformGroup.getChild(0);
        material = new Material();
        material.setDiffuseColor(new Color3f(Color.yellow));
        appearance = new Appearance();
        appearance.setMaterial(material);
        sphere.setAppearance(appearance);
        transformGroup = (TransformGroup)this.boundaryTgTable2.get(atomData);
        sphere = (Sphere)transformGroup.getChild(0);
        sphere.setAppearance(appearance);
    }

    public void setMouseRotateEnable(boolean bl) {
        this.myMouseRotate.setEnable(bl);
        this.myMouseTranslate.setEnable(bl);
        this.myMouseZoom.setEnable(bl);
        this.axisMouseRotate.setEnable(bl);
    }

    public void add3DText(Text3DData text3DData) {
        Transform3D transform3D = new Transform3D();
        Vector3d vector3d = SimplePicking.calcText3Dposition((float)((double)text3DData.x / 100.0), (float)((double)text3DData.y / 100.0));
        transform3D.setTranslation(vector3d);
        transform3D.setScale((double)0.005f);
        TransformGroup transformGroup = new TransformGroup(transform3D);
        Text2D text2D = new Text2D(text3DData.text, new Color3f(text3DData.color), text3DData.font, text3DData.size, text3DData.style);
        text2D.setUserData((Object)transformGroup);
        PickTool.setCapabilities((Node)text2D, (int)4100);
        transformGroup.setCapability(18);
        transformGroup.setCapability(17);
        transformGroup.setCapability(1);
        transformGroup.addChild((Node)text2D);
        this.textBranchGroup.detach();
        this.textBranchGroup.addChild((Node)transformGroup);
        this.branchGroup.addChild((Node)this.textBranchGroup);
        text3DData.transformGroup = transformGroup;
    }

    public void delete3DText(Text3DData text3DData) {
        this.textBranchGroup.detach();
        this.textBranchGroup.removeChild((Node)text3DData.transformGroup);
        this.branchGroup.addChild((Node)this.textBranchGroup);
    }

    public void modify3DText(Text3DData text3DData) {
        this.delete3DText(text3DData);
        this.add3DText(text3DData);
    }

    public void setNewTextPosition(float f, float f2, TransformGroup transformGroup) {
        this.abinitMpViewer.setNewTextPosition(f, f2, transformGroup);
    }

    public void createTrajectoryText(TrajectoryFile trajectoryFile) {
        if (trajectoryFile.stepLabel != null && (trajectoryFile.type == 1 || trajectoryFile.type == 3)) {
            this.textBranchGroup.detach();
            this.textBranchGroup.removeChild((Node)this.textSwitch);
            this.textSwitch = new Switch(0);
            this.textSwitch.setCapability(14);
            this.textSwitch.setCapability(18);
            this.textSwitch.setCapability(17);
            this.textSwitch.setCapability(12);
            Text3DData text3DData = this.abinitMpViewer.getTrajectoryTex3DtData();
            Transform3D transform3D = new Transform3D();
            Vector3d vector3d = SimplePicking.calcText3Dposition((float)((double)text3DData.x / 100.0), (float)((double)text3DData.y / 100.0));
            transform3D.setTranslation(vector3d);
            transform3D.setScale((double)0.005f);
            for (int i = 0; i < trajectoryFile.stepNum; ++i) {
                TransformGroup transformGroup = new TransformGroup(transform3D);
                Text2D text2D = new Text2D(trajectoryFile.stepLabel[i], new Color3f(text3DData.color), text3DData.font, text3DData.size, text3DData.style);
                text2D.setUserData((Object)transformGroup);
                text2D.setPickable(false);
                transformGroup.addChild((Node)text2D);
                this.textSwitch.addChild((Node)transformGroup);
            }
            this.textBranchGroup.addChild((Node)this.textSwitch);
            this.branchGroup.addChild((Node)this.textBranchGroup);
        }
    }

    public void setTrajectoryText(int n) {
        if (this.textSwitch != null) {
            this.textSwitch.setWhichChild(n);
        }
    }

    public void removeTrajectoryText() {
        this.textBranchGroup.detach();
        this.textBranchGroup.removeChild((Node)this.textSwitch);
    }

    class PickingCallback
    implements SimplePickingCallback {
        PickingCallback() {
        }

        public void picked(int n, Node node, boolean bl, boolean bl2) {
            SceneViewer.this.abinitMpViewer.pickNode(node, bl, bl2, 1);
        }

        public void clearHightSelection() {
            SceneViewer.this.abinitMpViewer.clearHighlightSelection(true);
        }

        public void clear() {
            SceneViewer.this.abinitMpViewer.clearNodeTable();
        }

        public void popupAttributeWindow(Node node, boolean bl, boolean bl2) {
            SceneViewer.this.abinitMpViewer.pickNode(node, bl, bl2, 3);
            SceneViewer.this.abinitMpViewer.popupAttributeWindow(node);
        }
    }
}

