/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Structure;

import AbinitMp.AbinitMpFile.CheckPointFile;
import AbinitMp.AbinitMpFile.GridFile;
import AbinitMp.AbinitMpFile.TrajectoryFile;
import AbinitMp.Common.AtomData;
import AbinitMp.Common.ChainData;
import AbinitMp.Common.GaussianCubeFile;
import AbinitMp.Common.MDLFile;
import AbinitMp.Common.MOL2File;
import AbinitMp.Common.PdbFile;
import AbinitMp.Common.ResidueData;
import AbinitMp.Common.XyzFile;
import AbinitMp.Viewer.DisplayPreference;
import AbinitMp.Viewer.FileItem;
import java.io.PrintStream;
import java.util.Vector;

public class CoordInfo {
    public float xmin = 100000.0f;
    public float xmax = -100000.0f;
    public float xcenter = 0.0f;
    public float xlength;
    public float ymin = 100000.0f;
    public float ymax = -100000.0f;
    public float ycenter = 0.0f;
    public float ylength;
    public float zmin = 100000.0f;
    public float zmax = -100000.0f;
    public float zcenter = 0.0f;
    public float zlength;
    public float scale = 1.0f;

    public void setMinMax(float f, float f2, float f3) {
        this.xmin = Math.min(f, this.xmin);
        this.ymin = Math.min(f2, this.ymin);
        this.zmin = Math.min(f3, this.zmin);
        this.xmax = Math.max(f, this.xmax);
        this.ymax = Math.max(f2, this.ymax);
        this.zmax = Math.max(f3, this.zmax);
    }

    public void setMinMax(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            FileItem fileItem = (FileItem)vector.get(i);
            fileItem.coordInfo = new CoordInfo();
            PdbFile pdbFile = null;
            if (fileItem.type == 4 || fileItem.type == 5 || fileItem.type == 6 || fileItem.type == 7 || fileItem.type == 11 || fileItem.type == 13) {
                if (fileItem.type == 4) {
                    pdbFile = (PdbFile)fileItem.file;
                } else if (fileItem.type == 5) {
                    pdbFile = ((CheckPointFile)fileItem.file).pdbFile;
                } else if (fileItem.type == 6) {
                    pdbFile = ((MOL2File)fileItem.file).pdbFile;
                } else if (fileItem.type == 7) {
                    pdbFile = ((MDLFile)fileItem.file).pdbFile;
                } else if (fileItem.type == 11) {
                    pdbFile = ((XyzFile)fileItem.file).pdbFile;
                } else if (fileItem.type == 13) {
                    object = (TrajectoryFile)fileItem.file;
                    pdbFile = ((TrajectoryFile)object).getPdbFile();
                }
                object = pdbFile.chains;
                for (int j = 0; j < ((Vector)object).size(); ++j) {
                    AtomData atomData;
                    int n;
                    ResidueData residueData;
                    int n2;
                    ChainData chainData = (ChainData)((Vector)object).get(j);
                    Vector vector2 = chainData.atomTable;
                    Vector vector3 = chainData.hemTable;
                    Vector vector4 = chainData.residueTable;
                    Vector vector5 = chainData.hemResidueTable;
                    for (n2 = 0; n2 < vector4.size(); ++n2) {
                        residueData = (ResidueData)vector4.get(n2);
                        for (n = residueData.startNo; n <= residueData.endNo; ++n) {
                            atomData = (AtomData)vector2.get(n);
                            fileItem.coordInfo.setMinMax(atomData.x, atomData.y, atomData.z);
                        }
                    }
                    for (n2 = 0; n2 < vector5.size(); ++n2) {
                        residueData = (ResidueData)vector5.get(n2);
                        for (n = residueData.startNo; n <= residueData.endNo; ++n) {
                            atomData = (AtomData)vector3.get(n);
                            fileItem.coordInfo.setMinMax(atomData.x, atomData.y, atomData.z);
                        }
                    }
                    this.xmin = Math.min(fileItem.coordInfo.xmin, this.xmin);
                    this.ymin = Math.min(fileItem.coordInfo.ymin, this.ymin);
                    this.zmin = Math.min(fileItem.coordInfo.zmin, this.zmin);
                    this.xmax = Math.max(fileItem.coordInfo.xmax, this.xmax);
                    this.ymax = Math.max(fileItem.coordInfo.ymax, this.ymax);
                    this.zmax = Math.max(fileItem.coordInfo.zmax, this.zmax);
                }
                fileItem.coordInfo.setScale();
                continue;
            }
            if (fileItem.type == 8 || fileItem.type == 9 || fileItem.type == 10) {
                object = (GaussianCubeFile)fileItem.file;
                fileItem.coordInfo.xmin = ((GaussianCubeFile)object).xmin;
                fileItem.coordInfo.ymin = ((GaussianCubeFile)object).ymin;
                fileItem.coordInfo.zmin = ((GaussianCubeFile)object).zmin;
                fileItem.coordInfo.xmax = ((GaussianCubeFile)object).xmax;
                fileItem.coordInfo.ymax = ((GaussianCubeFile)object).ymax;
                fileItem.coordInfo.zmax = ((GaussianCubeFile)object).zmax;
                fileItem.coordInfo.setScale();
            } else {
                object = (GridFile)fileItem.file;
                fileItem.coordInfo.xmin = ((GridFile)object).x[0];
                fileItem.coordInfo.ymin = ((GridFile)object).y[0];
                fileItem.coordInfo.zmin = ((GridFile)object).z[0];
                fileItem.coordInfo.xmax = ((GridFile)object).x[((GridFile)object).nx - 1];
                fileItem.coordInfo.ymax = ((GridFile)object).y[((GridFile)object).nx * ((GridFile)object).ny - 1];
                fileItem.coordInfo.zmax = ((GridFile)object).z[((GridFile)object).nx * ((GridFile)object).ny * ((GridFile)object).nz - 1];
                fileItem.coordInfo.setScale();
            }
            this.xmin = Math.min(fileItem.coordInfo.xmin, this.xmin);
            this.ymin = Math.min(fileItem.coordInfo.ymin, this.ymin);
            this.zmin = Math.min(fileItem.coordInfo.zmin, this.zmin);
            this.xmax = Math.max(fileItem.coordInfo.xmax, this.xmax);
            this.ymax = Math.max(fileItem.coordInfo.ymax, this.ymax);
            this.zmax = Math.max(fileItem.coordInfo.zmax, this.zmax);
        }
        this.setScale();
    }

    public void setMinMax(FileItem fileItem) {
        PdbFile pdbFile = null;
        if (fileItem.type == 4 || fileItem.type == 5 || fileItem.type == 6 || fileItem.type == 7 || fileItem.type == 11 || fileItem.type == 13) {
            Object object;
            if (fileItem.type == 4) {
                pdbFile = (PdbFile)fileItem.file;
            } else if (fileItem.type == 5) {
                pdbFile = ((CheckPointFile)fileItem.file).pdbFile;
            } else if (fileItem.type == 6) {
                pdbFile = ((MOL2File)fileItem.file).pdbFile;
            } else if (fileItem.type == 7) {
                pdbFile = ((MDLFile)fileItem.file).pdbFile;
            } else if (fileItem.type == 11) {
                pdbFile = ((XyzFile)fileItem.file).pdbFile;
            } else if (fileItem.type == 13) {
                object = (TrajectoryFile)fileItem.file;
                pdbFile = ((TrajectoryFile)object).getPdbFile();
            }
            object = pdbFile.chains;
            fileItem.coordInfo = new CoordInfo();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                AtomData atomData;
                int n;
                ResidueData residueData;
                int n2;
                ChainData chainData = (ChainData)((Vector)object).get(i);
                Vector vector = chainData.atomTable;
                Vector vector2 = chainData.hemTable;
                Vector vector3 = chainData.residueTable;
                Vector vector4 = chainData.hemResidueTable;
                for (n2 = 0; n2 < vector3.size(); ++n2) {
                    residueData = (ResidueData)vector3.get(n2);
                    for (n = residueData.startNo; n <= residueData.endNo; ++n) {
                        atomData = (AtomData)vector.get(n);
                        fileItem.coordInfo.setMinMax(atomData.x, atomData.y, atomData.z);
                    }
                }
                for (n2 = 0; n2 < vector4.size(); ++n2) {
                    residueData = (ResidueData)vector4.get(n2);
                    for (n = residueData.startNo; n <= residueData.endNo; ++n) {
                        atomData = (AtomData)vector2.get(n);
                        fileItem.coordInfo.setMinMax(atomData.x, atomData.y, atomData.z);
                    }
                }
                fileItem.coordInfo.setScale();
            }
        } else if (fileItem.type == 8 || fileItem.type == 9 || fileItem.type == 10) {
            GaussianCubeFile gaussianCubeFile = (GaussianCubeFile)fileItem.file;
            fileItem.coordInfo = new CoordInfo();
            fileItem.coordInfo.xmin = gaussianCubeFile.xmin;
            fileItem.coordInfo.ymin = gaussianCubeFile.ymin;
            fileItem.coordInfo.zmin = gaussianCubeFile.zmin;
            fileItem.coordInfo.xmax = gaussianCubeFile.xmax;
            fileItem.coordInfo.ymax = gaussianCubeFile.ymax;
            fileItem.coordInfo.zmax = gaussianCubeFile.zmax;
            fileItem.coordInfo.setScale();
        }
    }

    public void setScale() {
        float f = Math.max(Math.max(this.xmax - this.xmin, this.ymax - this.ymin), this.zmax - this.zmin);
        this.scale = 1.5f / f;
        if (DisplayPreference.glassless) {
            this.scale = 4.0f / f;
        }
        this.xlength = this.xmax - this.xmin;
        this.ylength = this.ymax - this.ymin;
        this.zlength = this.zmax - this.zmin;
        this.xcenter = this.xlength / 2.0f + this.xmin;
        this.ycenter = this.ylength / 2.0f + this.ymin;
        this.zcenter = this.zlength / 2.0f + this.zmin;
    }

    public void setCenter(float f, float f2, float f3) {
        this.xcenter = f;
        this.ycenter = f2;
        this.zcenter = f3;
    }

    public void debugPrint(PrintStream printStream) {
        printStream.println("*** CoordInfo ***");
        printStream.println("xmin " + this.xmin + " xmax " + this.xmax + " xcenter " + this.xcenter);
        printStream.println("ymin " + this.ymin + " ymax " + this.ymax + " ycenter " + this.ycenter);
        printStream.println("zmin " + this.zmin + " zmax " + this.zmax + " zcenter " + this.zcenter);
        printStream.println("scale " + this.scale);
    }
}

