/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Display;

import AbinitMp.Tool.MathFunc;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class CellTool {
    private static final int[][] sideApexTable = new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 0}, {4, 5}, {5, 6}, {6, 7}, {7, 4}, {0, 4}, {1, 5}, {2, 6}, {3, 7}};
    private static final int[][] planeSideTable = new int[][]{{0, 1, 2, 3}, {4, 5, 6, 7}, {0, 8, 4, 9}, {1, 10, 5, 9}, {2, 11, 6, 10}, {3, 11, 7, 8}};
    private static final int[][] sidePlaneTable = new int[][]{{0, 2}, {0, 3}, {0, 4}, {0, 5}, {1, 2}, {1, 3}, {1, 4}, {1, 5}, {2, 5}, {2, 3}, {3, 4}, {4, 5}};

    public static Point3f[] getCellApexCoordinate(int n, int n2, int n3, float[] fArray, float[] fArray2, float[] fArray3) {
        if (n >= fArray.length || n2 >= fArray2.length || n3 >= fArray3.length || n < 0 || n2 < 0 || n3 < 0) {
            System.out.println("out of range. getCellApexCoordinate");
            return null;
        }
        Point3f[] point3fArray = new Point3f[]{new Point3f(fArray[n], fArray2[n2], fArray3[n3]), new Point3f(fArray[n + 1], fArray2[n2], fArray3[n3]), new Point3f(fArray[n + 1], fArray2[n2 + 1], fArray3[n3]), new Point3f(fArray[n], fArray2[n2 + 1], fArray3[n3]), new Point3f(fArray[n], fArray2[n2], fArray3[n3 + 1]), new Point3f(fArray[n + 1], fArray2[n2], fArray3[n3 + 1]), new Point3f(fArray[n + 1], fArray2[n2 + 1], fArray3[n3 + 1]), new Point3f(fArray[n], fArray2[n2 + 1], fArray3[n3 + 1])};
        return point3fArray;
    }

    public static Point3f[] getCellApexCoordinate(int n, int n2, int n3, float[] fArray, float[] fArray2, float[] fArray3, int n4, int n5, int n6) {
        if (n >= n4 || n2 >= n5 || n3 >= n6 || n < 0 || n2 < 0 || n3 < 0) {
            System.out.println("out of range. getCellApexCoordinate");
            return null;
        }
        int n7 = n4 * n5;
        Point3f[] point3fArray = new Point3f[]{new Point3f(fArray[n + n4 * n2 + n7 * n3], fArray2[n + n4 * n2 + n7 * n3], fArray3[n + n4 * n2 + n7 * n3]), new Point3f(fArray[n + 1 + n4 * n2 + n7 * n3], fArray2[n + 1 + n4 * n2 + n7 * n3], fArray3[n + 1 + n4 * n2 + n7 * n3]), new Point3f(fArray[n + 1 + n4 * (n2 + 1) + n7 * n3], fArray2[n + 1 + n4 * (n2 + 1) + n7 * n3], fArray3[n + 1 + n4 * (n2 + 1) + n7 * n3]), new Point3f(fArray[n + n4 * (n2 + 1) + n7 * n3], fArray2[n + n4 * (n2 + 1) + n7 * n3], fArray3[n + n4 * (n2 + 1) + n7 * n3]), new Point3f(fArray[n + n4 * n2 + n7 * (n3 + 1)], fArray2[n + n4 * n2 + n7 * (n3 + 1)], fArray3[n + n4 * n2 + n7 * (n3 + 1)]), new Point3f(fArray[n + 1 + n4 * n2 + n7 * (n3 + 1)], fArray2[n + 1 + n4 * n2 + n7 * (n3 + 1)], fArray3[n + 1 + n4 * n2 + n7 * (n3 + 1)]), new Point3f(fArray[n + 1 + n4 * (n2 + 1) + n7 * (n3 + 1)], fArray2[n + 1 + n4 * (n2 + 1) + n7 * (n3 + 1)], fArray3[n + 1 + n4 * (n2 + 1) + n7 * (n3 + 1)]), new Point3f(fArray[n + n4 * (n2 + 1) + n7 * (n3 + 1)], fArray2[n + n4 * (n2 + 1) + n7 * (n3 + 1)], fArray3[n + n4 * (n2 + 1) + n7 * (n3 + 1)])};
        return point3fArray;
    }

    public static boolean isCross(Point3f[] point3fArray, Vector3f vector3f, Point3f point3f) {
        float f;
        float f2 = point3fArray[0].distance(point3fArray[6]);
        if (f2 < (f = point3fArray[2].distance(point3fArray[4]))) {
            f2 = f;
        }
        if (f2 < (f = point3fArray[3].distance(point3fArray[5]))) {
            f2 = f;
        }
        if (f2 < (f = point3fArray[1].distance(point3fArray[7]))) {
            f2 = f;
        }
        f2 /= 2.0f;
        float f3 = 0.0f;
        for (int i = 0; i < 8; ++i) {
            f3 += point3fArray[i].x;
        }
        f3 /= 8.0f;
        float f4 = 0.0f;
        for (int i = 0; i < 8; ++i) {
            f4 += point3fArray[i].y;
        }
        f4 /= 8.0f;
        float f5 = 0.0f;
        for (int i = 0; i < 8; ++i) {
            f5 += point3fArray[i].z;
        }
        Vector3f vector3f2 = new Vector3f(f3 - point3f.x, f4 - point3f.y, (f5 /= 8.0f) - point3f.z);
        float f6 = Math.abs(vector3f2.dot(vector3f));
        return f6 < f2;
    }

    public static float distanceFromPointToPlane(Point3f point3f, Vector3f vector3f, Point3f point3f2) {
        Vector3f vector3f2 = new Vector3f(point3f.x - point3f2.x, point3f.y - point3f2.y, point3f.z - point3f2.z);
        float f = vector3f2.dot(vector3f);
        return f;
    }

    public static float distanceFromPointToLine(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        float f = (-vector3f2.dot(vector3f) + vector3f3.dot(vector3f)) / (vector3f.length() * vector3f.length());
        Vector3f vector3f4 = new Vector3f(vector3f);
        vector3f4.scale(f);
        Point3f point3f = new Point3f((Tuple3f)vector3f4);
        point3f.add((Tuple3f)vector3f2);
        return point3f.distance(new Point3f((Tuple3f)vector3f3));
    }

    public static int crossPoint(Point3f[] point3fArray, Vector3f vector3f, Point3f point3f, int n, int n2, int n3, Vector vector, Vector vector2, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, float[] fArray6, int n4, int n5, int n6, float[] fArray7, int n7, int n8) {
        int n9 = 0;
        int n10 = -1;
        int n11 = -1;
        block0: for (int i = 0; n10 != i && i < 6; ++i) {
            for (int j = 0; j < 4; ++j) {
                int n12 = planeSideTable[i][j];
                if (n12 == n11) continue;
                Point3f point3f2 = point3fArray[sideApexTable[n12][0]];
                Point3f point3f3 = point3fArray[sideApexTable[n12][1]];
                float f = CellTool.distanceFromPointToPlane(point3f2, vector3f, point3f);
                float f2 = CellTool.distanceFromPointToPlane(point3f3, vector3f, point3f);
                if (f == 0.0f && f2 == 0.0f) {
                    while (f == 0.0f && f2 == 0.0f) {
                        point3f.x += point3f.x / 100000.0f;
                        point3f.y += point3f.y / 1000000.0f;
                        point3f.z += point3f.z / 1.0E7f;
                        f = CellTool.distanceFromPointToPlane(point3f2, vector3f, point3f);
                        f2 = CellTool.distanceFromPointToPlane(point3f3, vector3f, point3f);
                        if (f != 0.0f || f2 != 0.0f) continue;
                        System.out.println(f + " " + f2);
                    }
                }
                if (!(f < 0.0f && f2 > 0.0f) && (!(f > 0.0f) || !(f2 < 0.0f))) continue;
                f = Math.abs(f);
                f2 = Math.abs(f2);
                Point3f point3f4 = new Point3f();
                Point3f point3f5 = new Point3f(point3f3);
                point3f5.sub((Tuple3f)point3f2);
                point3f4.scaleAdd(f / (f + f2), (Tuple3f)point3f5, (Tuple3f)point3f2);
                vector.add(point3f4);
                ++n9;
                float f3 = CellTool.getValue(n, n2, n3, sideApexTable[n12][0], sideApexTable[n12][1], f, f2, fArray7, n7, n4, n5, n6);
                vector2.add(new Float(f3));
                if (n10 == -1) {
                    n10 = i;
                }
                n11 = n12;
                if (sidePlaneTable[n12][0] == i) {
                    i = sidePlaneTable[n12][1] - 1;
                    continue block0;
                }
                i = sidePlaneTable[n12][0] - 1;
                continue block0;
            }
        }
        return n9;
    }

    private static float getValue(int n, int n2, int n3, int n4, int n5, float f, float f2, float[] fArray, int n6, int n7, int n8, int n9) {
        float f3;
        int n10 = n;
        int n11 = n2;
        int n12 = n3;
        int n13 = n;
        int n14 = n2;
        int n15 = n3;
        if (n4 == 1 || n4 == 2 || n4 == 5 || n4 == 6) {
            ++n10;
        }
        if (n4 == 2 || n4 == 3 || n4 == 6 || n4 == 7) {
            ++n11;
        }
        if (n4 >= 4) {
            ++n12;
        }
        if (n5 == 1 || n5 == 2 || n5 == 5 || n5 == 6) {
            ++n13;
        }
        if (n5 == 2 || n5 == 3 || n5 == 6 || n5 == 7) {
            ++n14;
        }
        if (n5 >= 4) {
            ++n15;
        }
        float f4 = fArray[n10 + n11 * n7 + n12 * n7 * n8];
        float f5 = fArray[n13 + n14 * n7 + n15 * n7 * n8];
        if (n6 == 0) {
            if (f4 == 0.0f || f5 == 0.0f) {
                f3 = 0.0f;
            } else if (f4 < 0.0f && 0.0f < f5 || f5 < 0.0f && 0.0f < f4) {
                float f6 = f4;
                float f7 = f5;
                f3 = f6 + (f7 - f6) * f / (f + f2);
            } else if (f4 < 0.0f) {
                float f8 = MathFunc.log10(-f4);
                float f9 = MathFunc.log10(-f5);
                f3 = -((float)Math.pow(10.0, f8 + (f9 - f8) * f / (f + f2)));
            } else {
                float f10 = MathFunc.log10(f4);
                float f11 = MathFunc.log10(f5);
                f3 = (float)Math.pow(10.0, f10 + (f11 - f10) * f / (f + f2));
            }
        } else {
            float f12 = f4;
            float f13 = f5;
            f3 = f12 + (f13 - f12) * f / (f + f2);
        }
        return f3;
    }

    private static float getInterpolateValue(int n, int n2, int n3, Point3f point3f, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int n4, int n5, int n6, int n7) {
        float[] fArray5 = new float[8];
        float[] fArray6 = new float[8];
        float f = fArray2[n];
        float f2 = fArray2[n + 1];
        float f3 = fArray3[n2];
        float f4 = fArray3[n2 + 1];
        float f5 = fArray4[n3];
        float f6 = fArray4[n3 + 1];
        fArray5[0] = (point3f.x - f) * (point3f.y - f3) * (point3f.z - f5);
        fArray5[1] = (f2 - point3f.x) * (point3f.y - f3) * (point3f.z - f5);
        fArray5[2] = (f2 - point3f.x) * (f4 - point3f.y) * (point3f.z - f5);
        fArray5[3] = (point3f.x - f) * (f4 - point3f.y) * (point3f.z - f5);
        fArray5[4] = (f2 - point3f.x) * (point3f.y - f3) * (f6 - point3f.z);
        fArray5[5] = (point3f.x - f) * (point3f.y - f3) * (f6 - point3f.z);
        fArray5[6] = (point3f.x - f) * (f4 - point3f.y) * (f6 - point3f.z);
        fArray5[7] = (f2 - point3f.x) * (f4 - point3f.y) * (f6 - point3f.z);
        int n8 = n4 * n5;
        fArray6[0] = fArray[n + n2 * n4 + n3 * n8];
        fArray6[1] = fArray[n + 1 + n2 * n4 + n3 * n8];
        fArray6[2] = fArray[n + 1 + (n2 + 1) * n4 + n3 * n8];
        fArray6[3] = fArray[n + (n2 + 1) * n4 + n3 * n8];
        fArray6[4] = fArray[n + 1 + n2 * n4 + (n3 + 1) * n8];
        fArray6[5] = fArray[n + n2 * n4 + (n3 + 1) * n8];
        fArray6[6] = fArray[n + (n2 + 1) * n4 + (n3 + 1) * n8];
        fArray6[7] = fArray[n + 1 + (n2 + 1) * n4 + (n3 + 1) * n8];
        float f7 = 0.0f;
        float f8 = 0.0f;
        if (n7 == 0) {
            int n9 = 0;
            int n10 = 1;
            for (int i = 0; i < 8; ++i) {
                if (fArray6[i] < 0.0f) {
                    n10 = -1;
                    fArray6[i] = -fArray6[i];
                } else {
                    n10 = 1;
                }
                if (fArray6[i] != 0.0f) {
                    f8 += MathFunc.log10(fArray6[i]) * fArray5[7 - i];
                } else {
                    ++n9;
                }
                f7 += fArray5[i];
            }
            f8 = n9 >= 1 ? 0.0f : (float)Math.pow(10.0, f8 / f7) * (float)n10;
        } else {
            for (int i = 0; i < 8; ++i) {
                f8 += fArray6[i] * fArray5[7 - i];
                f7 += fArray5[i];
            }
            f8 /= f7;
        }
        return f8;
    }
}

