/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.textviewer;

import java.awt.Container;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;
import org.apache.log4j.Logger;

public class TextViewer
extends InternalFrameChase
implements HyperlinkListener {
    private static Logger logger = Logger.getLogger((String)TextViewer.class.getName());
    private Container container = this.getContentPane();
    private String helpPath;
    private JEditorPane pane;
    private JButton backButton;

    public TextViewer(String helpPath) {
        super("help", true, true, true, true);
        this.helpPath = helpPath;
        this.setSize(800, 600);
        this.createTextViewer();
    }

    private void createTextViewer() {
        this.pane = new JEditorPane();
        this.pane.setContentType("text/html; charset=Shift_JIS");
        this.pane.setEditable(false);
        this.pane.addHyperlinkListener(this);
        try {
            URL foo = TextViewer.class.getClass().getResource("/jp/advancesoft/chase/textviewer/foo.htm");
            this.pane.setPage(foo);
            logger.info((Object)this.pane.getContentType());
            JScrollPane scr = new JScrollPane(this.pane);
            scr.setVerticalScrollBarPolicy(22);
            scr.setPreferredSize(new Dimension(800, 600));
            this.container.add(scr);
        }
        catch (IOException ioe) {
            logger.warn((Object)("failed to load help file: " + this.helpPath));
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        String url = e.getURL().toString();
        try {
            this.pane.setPage(url);
        }
        catch (IOException ioe) {
            logger.warn((Object)("failed to load from: " + url));
        }
    }
}

