/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.test.materialeditor;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Light;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;

public class MaterialEditor
extends JFrame
implements ActionListener,
ChangeListener,
AdjustmentListener {
    private static final int RENDER_CANVAS_SIZE = 200;
    private static final int RENDER_CANVAS_BG_GRID_NUM = 8;
    private static final int ID_AMBIENT = 0;
    private static final int ID_DIFFUSE = 1;
    private static final int ID_SPECULAR = 2;
    private static final int ID_EMISSION = 3;
    private static final int ID_SHINIESS = 4;
    private static final int ID_TRANSPARENCY = 5;
    private JLabel[] paramNameLabels = new JLabel[6];
    private JButton[] paramButtons = new JButton[4];
    private JScrollBar[] paramScrollBars = new JScrollBar[2];
    private JColorChooser colorChooser;
    private JButton outputButton;
    private Color[] paramColors = new Color[]{new Color(87, 61, 54), new Color(161, 50, 47), new Color(59, 60, 21), new Color(20, 17, 15)};
    private int selectedParamID = 0;
    String[] labelNames = new String[]{"Ambient(\u74b0\u5883\u5149)", "Diffuse(\u62e1\u6563\u5149)", "Specular(\u93e1\u9762\u5149)", "Emission(\u653e\u5c04\u5149)", "Shiniess(\u8f1d\u5ea6)", "Transparency(\u900f\u660e\u5ea6)"};
    private Appearance m_appearance;

    private Canvas3D createCanvas() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas = new Canvas3D(config);
        canvas.setSize(200, 200);
        SimpleUniverse universe = new SimpleUniverse(canvas);
        universe.getViewingPlatform().setNominalViewingTransform();
        universe.addBranchGraph(this.createBranchGraph());
        return canvas;
    }

    private BranchGroup createBranchGraph() {
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.addChild((Node)this.createDirectionalLight());
        branchGroup.addChild((Node)this.createAmbientLight());
        branchGroup.addChild((Node)this.createBackgroundImage());
        branchGroup.addChild((Node)this.createSphere());
        branchGroup.compile();
        return branchGroup;
    }

    private Light createDirectionalLight() {
        DirectionalLight light = new DirectionalLight(true, new Color3f(1.0f, 1.0f, 1.0f), new Vector3f(-1.0f, -1.0f, -1.0f));
        light.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(), 10.0));
        return light;
    }

    private Light createAmbientLight() {
        AmbientLight light = new AmbientLight();
        light.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(), 10.0));
        return light;
    }

    private Background createBackgroundImage() {
        BufferedImage bufferedImage = new BufferedImage(200, 200, 5);
        Graphics2D g = bufferedImage.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, 200, 200);
        g.setColor(Color.black);
        int gridSize = 25;
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 8; ++x) {
                if ((x + y) % 2 != 0) continue;
                g.fillRect(x * gridSize, y * gridSize, gridSize, gridSize);
            }
        }
        Background background = new Background(new ImageComponent2D(1, bufferedImage));
        background.setApplicationBounds((Bounds)new BoundingSphere(new Point3d(), 10.0));
        return background;
    }

    private Sphere createSphere() {
        Material material = new Material();
        material.setCapability(0);
        material.setCapability(1);
        material.setLightingEnable(true);
        TransparencyAttributes tansparency = new TransparencyAttributes(2, 0.0f);
        tansparency.setCapability(2);
        tansparency.setCapability(3);
        this.m_appearance = new Appearance();
        this.m_appearance.setCapability(0);
        this.m_appearance.setCapability(1);
        this.m_appearance.setCapability(10);
        this.m_appearance.setCapability(11);
        this.m_appearance.setMaterial(material);
        this.m_appearance.setTransparencyAttributes(tansparency);
        Sphere sphere = new Sphere(0.7f, 1, 128, this.m_appearance);
        sphere.getShape().setCapability(15);
        sphere.getShape().setCapability(14);
        return sphere;
    }

    private void setSelectedParamID(int id) {
        this.paramNameLabels[this.selectedParamID].setBorder(null);
        this.selectedParamID = id;
        this.paramNameLabels[this.selectedParamID].setBorder(BorderFactory.createLineBorder(Color.blue));
        this.colorChooser.setBorder(BorderFactory.createTitledBorder(this.labelNames[this.selectedParamID]));
        this.colorChooser.setColor(this.paramColors[this.selectedParamID]);
    }

    private JPanel createParamEditPanel() {
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(300, 200));
        panel.setLayout(new GridLayout(6, 2, 10, 5));
        for (int i = 0; i < 6; ++i) {
            this.paramNameLabels[i] = new JLabel(this.labelNames[i], 4);
            panel.add(this.paramNameLabels[i]);
            if (i < 4) {
                this.paramButtons[i] = new JButton();
                panel.add(this.paramButtons[i]);
                this.paramButtons[i].addActionListener(this);
                continue;
            }
            int barIndex = i - 4;
            this.paramScrollBars[barIndex] = new JScrollBar(0, 0, 1, 0, 100);
            this.paramScrollBars[barIndex].addAdjustmentListener(this);
            panel.add(this.paramScrollBars[barIndex]);
        }
        return panel;
    }

    private void buildUI() {
        JPanel panelNorth = new JPanel();
        panelNorth.setLayout(new FlowLayout());
        panelNorth.add((Component)this.createCanvas());
        panelNorth.add(this.createParamEditPanel());
        JPanel panelCenter = new JPanel();
        this.colorChooser = new JColorChooser();
        this.colorChooser.getSelectionModel().addChangeListener(this);
        panelCenter.add(this.colorChooser);
        JPanel panelSouth = new JPanel();
        this.outputButton = new JButton("\u30b3\u30fc\u30c9\u51fa\u529b");
        panelSouth.add(this.outputButton);
        this.outputButton.addActionListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panelNorth, "North");
        this.getContentPane().add((Component)panelCenter, "Center");
        this.getContentPane().add((Component)panelSouth, "South");
    }

    public void stateChanged(ChangeEvent e) {
        this.setMaterialParam(this.selectedParamID, this.colorChooser.getColor());
    }

    private void setMaterialParam(int paramID, Color c) {
        this.paramColors[paramID] = c;
        this.paramButtons[paramID].setBackground(c);
        Material material = this.m_appearance.getMaterial();
        switch (paramID) {
            case 0: {
                material.setAmbientColor(new Color3f(c));
                break;
            }
            case 1: {
                material.setDiffuseColor(new Color3f(c));
                break;
            }
            case 2: {
                material.setSpecularColor(new Color3f(c));
                break;
            }
            case 3: {
                material.setEmissiveColor(new Color3f(c));
            }
        }
    }

    private void setMaterialParam(int paramID, float value) {
        switch (paramID) {
            case 4: {
                this.m_appearance.getMaterial().setShininess(value);
                break;
            }
            case 5: {
                this.m_appearance.getTransparencyAttributes().setTransparency(value);
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getAdjustable().equals(this.paramScrollBars[0])) {
            this.setMaterialParam(4, (float)this.paramScrollBars[0].getValue() * 1.28f);
        } else {
            this.setMaterialParam(5, (float)this.paramScrollBars[1].getValue() / 100.0f);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.outputButton)) {
            this.outputCode();
        } else {
            for (int i = 0; i < 4; ++i) {
                if (!e.getSource().equals(this.paramButtons[i])) continue;
                this.setSelectedParamID(i);
                break;
            }
        }
    }

    private void outputCode() {
        Material material = this.m_appearance.getMaterial();
        Color3f color = new Color3f();
        JFrame frame = new JFrame("Code");
        frame.setBounds(100, 100, 500, 250);
        JTextArea textArea = new JTextArea();
        textArea.setLineWrap(true);
        DecimalFormat form = new DecimalFormat("0.0000");
        textArea.append("Material material = new Material();\n");
        material.getAmbientColor(color);
        textArea.append("material.setAmbientColor(" + form.format(color.x) + "f, " + form.format(color.y) + "f, " + form.format(color.z) + "f);\n");
        material.getDiffuseColor(color);
        textArea.append("material.setDiffuseColor(" + form.format(color.x) + "f, " + form.format(color.y) + "f, " + form.format(color.z) + "f);\n");
        material.getSpecularColor(color);
        textArea.append("material.setSpecularColor(" + form.format(color.x) + "f, " + form.format(color.y) + "f, " + form.format(color.z) + "f);\n");
        material.getEmissiveColor(color);
        textArea.append("material.setEmissiveColor(" + form.format(color.x) + "f, " + form.format(color.y) + "f, " + form.format(color.z) + "f);\n");
        float shininess = material.getShininess();
        textArea.append("material.setShininess(" + form.format(shininess) + "f);\n");
        textArea.append("TransparencyAttributes tansparency = new TransparencyAttributes(TransparencyAttributes.BLENDED, " + form.format(this.m_appearance.getTransparencyAttributes().getTransparency()) + "f);\n");
        textArea.append("Appearance appearance = new Appearance();\n");
        textArea.append("appearance.setMaterial(material);\n");
        textArea.append("appearance.setTransparencyAttributes(tansparency);\n");
        frame.add(textArea);
        frame.setVisible(true);
    }

    public MaterialEditor() {
        super("MaterialEditor");
        this.buildUI();
        this.setSelectedParamID(0);
        for (int i = 0; i < 4; ++i) {
            this.setMaterialParam(i, this.paramColors[i]);
        }
        this.paramScrollBars[0].setValue(30);
        this.paramScrollBars[1].setValue(3);
        this.setMaterialParam(4, 38.4f);
        this.setMaterialParam(5, 0.03f);
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        MaterialEditor materialEditor = new MaterialEditor();
        materialEditor.setDefaultCloseOperation(3);
        materialEditor.setBounds(10, 10, 600, 650);
        materialEditor.setVisible(true);
    }
}

