/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.util.Vector;
import jp.advancesoft.chase.ssh.filechooser.RemoteFile;
import jp.advancesoft.chase.ssh.sftp.MyProgressMonitor;
import jp.advancesoft.chase.ssh.sftp.SftpEvent;
import jp.advancesoft.chase.ssh.sftp.SftpListener;
import org.apache.log4j.Logger;

class Upload
implements Runnable {
    private static Logger logger = Logger.getLogger((String)Upload.class.getName());
    private RemoteFile[] files;
    private RemoteFile dir;
    private ChannelSftp c;
    private Vector listeners;
    private boolean recursive = true;

    protected Upload(RemoteFile[] files, RemoteFile dir, ChannelSftp c, Vector listeners) {
        this.files = files;
        this.dir = dir;
        this.c = c;
        this.listeners = listeners;
    }

    protected Upload(RemoteFile[] files, RemoteFile dir, ChannelSftp c, Vector listeners, boolean recursive) {
        this.files = files;
        this.dir = dir;
        this.c = c;
        this.listeners = listeners;
        this.recursive = recursive;
    }

    public void run() {
        this.upload(this.files, this.dir);
    }

    private void upload(RemoteFile[] files, RemoteFile dir) {
        int i;
        if (files != null && dir != null) {
            for (i = 0; i < files.length; ++i) {
                String upfile = files[i].getAbsolutePath();
                if (files[i].isDirectory()) {
                    if (files[i].getName().trim().equals(".") || files[i].getName().trim().equals("..")) continue;
                    RemoteFile newDir = new RemoteFile(dir.getAbsolutePath(), files[i].getName(), this.c);
                    newDir.mkdir();
                    this.upload((RemoteFile[])files[i].listFiles(), newDir);
                    continue;
                }
                String toDir = dir.getAbsolutePath();
                try {
                    int mode = 0;
                    logger.info((Object)("uploading file: " + upfile + " to " + dir.getAbsolutePath()));
                    MyProgressMonitor monitor = new MyProgressMonitor();
                    this.c.put(upfile, toDir, (SftpProgressMonitor)monitor, mode);
                    logger.info((Object)"... done");
                    continue;
                }
                catch (SftpException e) {
                    logger.error((Object)("failed to upload: " + upfile));
                }
            }
        }
        if (this.listeners != null) {
            for (i = 0; i < this.listeners.size(); ++i) {
                ((SftpListener)this.listeners.elementAt(i)).uploadFinished(new SftpEvent(this));
            }
        }
    }
}

