/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh.remotehostexecuter;

import java.io.File;
import java.util.List;
import java.util.Vector;
import jp.advancesoft.chase.common.TaggedString;
import jp.advancesoft.chase.ssh.remotehostexecuter.ChaseFileProperty;
import jp.advancesoft.chase.ssh.remotehostexecuter.RegExpFile;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Element;

public class ChaseFile {
    private Logger logger = Logger.getLogger((String)ChaseFile.class.getName());
    public static final int INOUT = 5;
    public static final int OUT = 4;
    public static final int IN = 3;
    public static final int ALL = 7;
    public static final int NEWEST_ONLY = 6;
    private File file;
    private String ident;
    private int mode = 5;
    private boolean hasregexp = false;
    private int regexpedfile = 7;
    private String basedir;
    private ChaseFileProperty[] properties;

    public ChaseFile(File file, String basedir, String ident, int mode) {
        this.file = file;
        this.ident = ident;
        this.mode = mode;
        this.basedir = basedir;
        this.createCFPs();
    }

    public ChaseFile(File file, String basedir, String ident, int mode, boolean hasregexp, int regexpedfile) {
        this.file = file;
        this.ident = ident;
        this.mode = mode;
        this.hasregexp = hasregexp;
        this.regexpedfile = regexpedfile;
        this.basedir = basedir;
        this.logger.debug((Object)("file: " + file.getPath() + " basedir: " + basedir + " ident: " + ident));
        this.createCFPs();
    }

    public ChaseFileProperty[] getChaseFileProperties() {
        return this.properties;
    }

    public String getIdentifier() {
        return this.ident;
    }

    public File getFile() {
        return this.file;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean hasRegExp() {
        return this.hasregexp;
    }

    public int getTransferSchemeForRegexpedFile() {
        return this.regexpedfile;
    }

    public String getBaseDir() {
        return this.basedir;
    }

    public void setIdentifier(String ident) {
        this.ident = ident;
    }

    public void setBaseDir(String basedir) {
        this.basedir = basedir;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setHasRegExp(boolean hasregexp) {
        this.hasregexp = hasregexp;
    }

    public ChaseFileProperty getChaseFileProperty(String key) {
        for (int i = 0; i < this.properties.length; ++i) {
            String comp = this.properties[i].getProp().getTag();
            if (!comp.equals(key)) continue;
            return this.properties[i];
        }
        return null;
    }

    public static ChaseFile createChaseFile(Element element) throws NullPointerException {
        String locdir;
        ChaseFile cfile = null;
        Vector propvec = new Vector();
        List lattrs = element.getAttributes();
        Attribute[] attrs = new Attribute[lattrs.size()];
        for (int i = 0; i < lattrs.size(); ++i) {
            attrs[i] = (Attribute)lattrs.get(i);
        }
        List lelem = element.getChildren();
        Element[] elems = new Element[lelem.size()];
        for (int i = 0; i < lelem.size(); ++i) {
            elems[i] = (Element)lelem.get(i);
        }
        String ident = element.getAttribute("identifier").getValue();
        String fname = element.getChild("filename").getTextTrim();
        String intent = element.getAttribute("intent").getValue();
        int iintent = 3;
        if (intent.equals("IN")) {
            iintent = 3;
        } else if (intent.equals("OUT")) {
            iintent = 4;
        } else if (intent.equals("INOUT")) {
            iintent = 5;
        }
        String transfer = element.getChild("transfer").getTextTrim();
        int itransfer = 7;
        if (transfer.equals("ALL")) {
            itransfer = 7;
        } else if (transfer.equals("NEWEST_ONLY")) {
            itransfer = 6;
        }
        boolean hasreg = new Boolean(element.getAttribute("hasregexp").getValue());
        String basedir = locdir = element.getChild("localdir").getTextTrim();
        if (!basedir.endsWith(System.getProperty("file.separator"))) {
            basedir = basedir + System.getProperty("file.separator");
        }
        cfile = new ChaseFile(new File(basedir + fname), basedir, ident, iintent, hasreg, itransfer);
        boolean upl = new Boolean(element.getChild("upload").getTextTrim());
        boolean dow = new Boolean(element.getChild("download").getTextTrim());
        ChaseFileProperty[] props = cfile.getChaseFileProperties();
        for (int i = 0; i < props.length; ++i) {
            if (props[i].getProp().getTag().equals("upload")) {
                props[i].getProp().setValue(Boolean.toString(upl));
                continue;
            }
            if (!props[i].getProp().getTag().equals("download")) continue;
            props[i].getProp().setValue(Boolean.toString(dow));
        }
        return cfile;
    }

    private void createCFPs() {
        Vector<ChaseFileProperty> tmpvec = new Vector<ChaseFileProperty>();
        ChaseFileProperty ident = new ChaseFileProperty(new TaggedString("identifier", this.getIdentifier()), 1, false);
        ChaseFileProperty fname = new ChaseFileProperty(new TaggedString("filename", new RegExpFile(this.file.getAbsolutePath(), this.basedir, this.hasregexp).getName()), 0, false);
        tmpvec.addElement(ident);
        tmpvec.addElement(fname);
        String smode = "";
        if (this.mode == 3) {
            smode = "IN";
        } else if (this.mode == 4) {
            smode = "OUT";
        } else if (this.mode == 5) {
            smode = "INOUT";
        }
        tmpvec.addElement(new ChaseFileProperty(new TaggedString("intent", smode), 1, false));
        String exi = "TRUE";
        if (!this.file.exists()) {
            exi = "FALSE";
        }
        tmpvec.addElement(new ChaseFileProperty(new TaggedString("exists", exi), 0, false));
        TaggedString locdir = new TaggedString("localdir", this.basedir);
        tmpvec.addElement(new ChaseFileProperty(locdir, 0, false, true, false, 0));
        tmpvec.addElement(new ChaseFileProperty(new TaggedString("hasregexp", Boolean.toString(this.hasregexp)), 1, true, false));
        String transferscheme = this.getTransferSchemeForRegexpedFile() == 6 ? "NEWEST_ONLY" : "ALL";
        tmpvec.addElement(new ChaseFileProperty(new TaggedString("transfer", transferscheme), 0, false, true, true, 3, new String[]{"ALL", "NEWEST_ONLY"}));
        boolean upl = false;
        boolean downl = false;
        if (this.mode == 3 && exi.equals("TRUE")) {
            upl = true;
            downl = false;
        } else if (this.mode == 5 && exi.equals("TRUE")) {
            upl = true;
            downl = true;
        } else if (this.mode == 4) {
            upl = false;
            downl = true;
        } else if (this.mode == 5 && !exi.equals("TRUE")) {
            upl = false;
            downl = true;
        }
        TaggedString upload = new TaggedString("upload", Boolean.toString(upl));
        TaggedString download = new TaggedString("download", Boolean.toString(downl));
        tmpvec.addElement(new ChaseFileProperty(upload, 0, true, true, true));
        tmpvec.addElement(new ChaseFileProperty(download, 0, true, true, true));
        this.properties = new ChaseFileProperty[tmpvec.size()];
        for (int i = 0; i < tmpvec.size(); ++i) {
            ChaseFileProperty prop = (ChaseFileProperty)tmpvec.elementAt(i);
            this.logger.debug((Object)prop);
            this.properties[i] = prop;
        }
    }
}

