/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh.hosts;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.Vector;
import jp.advancesoft.chase.common.ConstParameters;
import jp.advancesoft.chase.common.TaggedString;
import jp.advancesoft.chase.inputinterface.DataManager;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.inputinterface.InputInterfaceBlock;
import jp.advancesoft.chase.inputinterface.InputInterfacePrimitiveEntry;
import jp.advancesoft.chase.ssh.hosts.HostInfo;
import jp.advancesoft.chase.ssh.hosts.PasswordManager;
import org.apache.log4j.Logger;

public class HostList
extends LinkedList {
    private static Logger logger = Logger.getLogger((String)HostList.class.getName());
    private static HostList list;
    private final String FS = ConstParameters.FS;
    private String hostsFile = System.getProperty("user.home") + this.FS + ".chase" + this.FS + "hosts";
    private InputInterface inputInterface;
    private PasswordManager pass;

    public static HostList getHostList() {
        if (list == null) {
            list = new HostList();
        }
        return list;
    }

    private HostList() {
        if (!new File(this.hostsFile).exists()) {
            this.createHostsFile();
        }
        DataManager dm = new DataManager(this.hostsFile, true);
        dm.setWSisDelimiter(false);
        dm.parse();
        this.inputInterface = dm.getInputInterface();
        this.inputInterface.selectRoot();
        String[] hosts = this.inputInterface.getTags();
        try {
            this.pass = new PasswordManager();
        }
        catch (Exception exc) {
            logger.error((Object)exc);
            logger.warn((Object)"can't manage password ...");
        }
        boolean foundLocalhost = false;
        if (hosts != null && hosts.length > 0) {
            for (int j = 0; j < hosts.length; ++j) {
                this.inputInterface.selectBlock(hosts[j], null);
                InputInterfacePrimitiveEntry[] entries = this.inputInterface.getAllPrimitiveEntries();
                String name = hosts[j];
                HostInfo inf = new HostInfo(name);
                foundLocalhost = name.trim().equals("localhost");
                if (entries != null && entries.length > 0) {
                    for (int i = 0; i < entries.length; ++i) {
                        String tmp = entries[i].getName();
                        String val = entries[i].getValue();
                        inf.setProperty(tmp, val);
                    }
                }
                if (name.trim().equals("localhost")) {
                    this.addFirst(inf);
                } else {
                    this.addLast(inf);
                }
                this.inputInterface.selectRoot();
            }
            try {
                this.readPasswordFile();
            }
            catch (IOException ioe) {
                logger.debug((Object)"couldn't read password files");
            }
        }
    }

    private void createHostsFile() {
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(this.hostsFile)));
            writer.println("localhost{");
            writer.println("    address=127.0.0.1");
            writer.println("    username=" + System.getProperty("user.name"));
            writer.println("    bindir=" + System.getProperty("chase.home") + System.getProperty("file.separator") + "bin");
            writer.println("    basedir=" + System.getProperty("user.home"));
            writer.println("}");
            writer.close();
        }
        catch (IOException ioe) {
            logger.warn((Object)"failed to create 'hosts' file");
        }
    }

    public HostInfo getHostInfo(int i) {
        HostInfo info;
        try {
            info = (HostInfo)this.get(i);
        }
        catch (Exception e) {
            logger.warn((Object)("failed to get HostInfo at: " + i));
            return null;
        }
        return info;
    }

    protected void debug() {
        for (int i = 0; i < this.size(); ++i) {
            logger.debug((Object)("for HostInfo " + i));
            this.getHostInfo(i).debug();
        }
    }

    protected void save() {
        int nhosts = this.size();
        this.inputInterface.selectRoot();
        for (int i = 0; i < nhosts; ++i) {
            InputInterfacePrimitiveEntry entry;
            String val;
            String tag;
            int j;
            HostInfo info = this.getHostInfo(i);
            TaggedString[] props = info.getHostProperties();
            String name = info.getName();
            boolean savepass = false;
            if (name == null || name.trim().length() == 0) continue;
            if (this.inputInterface.selectBlock(name, null)) {
                for (j = 0; j < props.length; ++j) {
                    tag = props[j].getTag();
                    if (tag == null || tag.trim().length() == 0 || tag.trim().equals("password")) continue;
                    val = props[j].getValue();
                    entry = this.inputInterface.getPrimitiveEntry(tag);
                    if (entry.getName().trim().length() != 0) {
                        entry.setValue(val);
                    } else {
                        entry = new InputInterfacePrimitiveEntry(tag.trim(), val.trim(), "");
                        this.inputInterface.replaceEntry(entry);
                    }
                    logger.debug((Object)("entry: " + tag + " val: " + val));
                }
            } else {
                this.inputInterface.addBlock(new InputInterfaceBlock(name), true);
                for (j = 0; j < props.length; ++j) {
                    tag = props[j].getTag();
                    if (tag == null || tag.trim().length() == 0 || tag.trim().equals("password")) continue;
                    val = props[j].getValue();
                    entry = new InputInterfacePrimitiveEntry(tag.trim(), val.trim(), "");
                    logger.debug((Object)("entry: " + tag + " val: " + val));
                    this.inputInterface.replaceEntry(entry);
                }
            }
            this.inputInterface.selectRoot();
        }
        this.inputInterface.saveTo(new File(this.hostsFile));
        Vector<TaggedString> passVector = new Vector<TaggedString>();
        Vector<String> rempassVector = new Vector<String>();
        for (int i = 0; i < nhosts; ++i) {
            String name;
            HostInfo info = this.getHostInfo(i);
            String ssavepass = info.getProperty("savepass");
            boolean savepass = false;
            if (ssavepass != null && ssavepass.equalsIgnoreCase("true")) {
                savepass = true;
            }
            if (savepass) {
                name = info.getName();
                String passString = info.getPasswordString();
                passVector.addElement(new TaggedString(name, passString));
                continue;
            }
            name = info.getName();
            rempassVector.addElement(name);
        }
        if (passVector.size() >= 1) {
            try {
                this.writePasswordFile(passVector);
            }
            catch (IOException ioe) {
                logger.error((Object)"failed to save encrypted passwords to disk");
            }
        }
        if (rempassVector.size() >= 1) {
            String passwordDir = System.getProperty("user.home") + this.FS + ".chase" + this.FS + "passwords";
            for (int ii = 0; ii < rempassVector.size(); ++ii) {
                new File(passwordDir + this.FS + (String)rempassVector.elementAt(ii)).delete();
            }
        }
    }

    protected void writePasswordFile(Vector passVector) throws IOException {
        try {
            this.pass = new PasswordManager();
        }
        catch (Exception exc) {
            logger.error((Object)"failed to create password manager");
            return;
        }
        String passwordDir = System.getProperty("user.home") + this.FS + ".chase" + this.FS + "passwords";
        new File(passwordDir).mkdir();
        for (int i = 0; i < passVector.size(); ++i) {
            TaggedString data = (TaggedString)passVector.get(i);
            String name = data.getTag().trim();
            String passwd = data.getValue().trim();
            byte[] passb = null;
            try {
                passb = this.pass.getEncryptedPassword(passwd);
            }
            catch (Exception exc) {
                logger.error((Object)"failed to encrypt password");
                continue;
            }
            if (passb == null) continue;
            BufferedOutputStream bostream = new BufferedOutputStream(new FileOutputStream(passwordDir + this.FS + name));
            bostream.write(passb, 0, passb.length);
            bostream.flush();
        }
    }

    protected void readPasswordFile() throws IOException {
        File passwdDir = new File(System.getProperty("user.home") + this.FS + ".chase" + this.FS + "passwords");
        if (!passwdDir.exists()) {
            return;
        }
        File[] passwdFiles = passwdDir.listFiles();
        try {
            this.pass = new PasswordManager();
        }
        catch (Exception exc) {
            logger.error((Object)exc);
            logger.warn((Object)"can't manage password ...");
            return;
        }
        for (int i = 0; i < passwdFiles.length; ++i) {
            String name = passwdFiles[i].getName();
            BufferedInputStream bistream = new BufferedInputStream(new FileInputStream(passwdDir.getAbsolutePath() + this.FS + name));
            byte[] pas = new byte[bistream.available()];
            bistream.read(pas);
            String planepass = "";
            try {
                planepass = this.pass.getPlanePassword(pas);
                logger.debug((Object)("plain password: " + planepass));
            }
            catch (Exception exc) {
                logger.debug((Object)"couldn't get plain password...");
                continue;
            }
            for (int j = 0; j < this.size(); ++j) {
                HostInfo info = this.getHostInfo(j);
                if (!info.getName().trim().equals(name)) continue;
                info.setPasswordString(planepass);
                info.setSavePassword(true);
            }
        }
    }
}

