/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh.hosts;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import jp.advancesoft.chase.ssh.SshClient;
import jp.advancesoft.chase.ssh.hosts.HostInfo;
import jp.advancesoft.chase.ssh.hosts.HostSelectorList;
import org.apache.log4j.Logger;

public class HostConnector
extends JPanel
implements ActionListener {
    private static Logger logger = Logger.getLogger((String)HostConnector.class.getName());
    private SshClient client;
    private HostSelectorList list;

    public HostConnector(SshClient client) {
        this.client = client;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        JScrollPane scrollpane = new JScrollPane();
        this.list = new HostSelectorList();
        this.list.setSelectedIndex(0);
        scrollpane.getViewport().setView(this.list);
        scrollpane.setBorder(new TitledBorder("list of hosts"));
        this.add(scrollpane);
        JButton connect = new JButton("connect");
        connect.addActionListener(this);
        this.add(connect);
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JButton) {
            HostInfo host = this.list.getSelectedHost();
            if (host == null) {
                logger.error((Object)"select host!");
            } else {
                this.client.connect(host);
            }
        }
    }
}

