/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.project;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import jp.advancesoft.chase.common.ChaseFileChooser;
import jp.advancesoft.chase.common.ChoicePanel;
import jp.advancesoft.chase.common.InputPanel;
import jp.advancesoft.chase.common.MyMessageBox;
import jp.advancesoft.chase.mainpanel.Chase;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;
import jp.advancesoft.chase.settings.PropertyManager;

public class NewProject
extends InternalFrameChase {
    private final String ONE = "1";
    private Container cont;
    private Chase parent;
    private JPanel pexe_cont;
    private JPanel pparallel;
    private JTextField tfprojdir;
    private ChoicePanel projtype;
    private InputPanel np;
    private InputPanel nk;
    private InputPanel ne;
    private JButton bcreateproj;
    private JButton btnclose;
    private JButton btnproj;
    private String projdir;
    private String[] s_projtype = new String[]{"PHASE"};
    private PrintWriter fout;
    private MyMessageBox mbox;
    private int NumPseudPot = 0;
    private PropertyManager pmproj;
    private boolean b_fnd;

    public NewProject(Chase frame) {
        super("new project", true, true, true, true);
        this.setDefaultCloseOperation(1);
        this.parent = frame;
        this.mbox = new MyMessageBox();
        this.cont = this.getContentPane();
        this.cont.setLayout(new FlowLayout(0));
        this.cont.add(Box.createVerticalGlue());
        this.projtype = new ChoicePanel("project type", this.s_projtype);
        this.projtype.m_choice.setPreferredSize(new Dimension(100, 25));
        this.cont.add(this.projtype);
        JPanel pproj = new JPanel();
        pproj.setLayout(new BoxLayout(pproj, 0));
        this.tfprojdir = new JTextField(20);
        pproj.add(this.tfprojdir);
        this.btnproj = new JButton("Select");
        pproj.add(this.btnproj);
        pproj.setSize(400, 20);
        pproj.setBorder(new TitledBorder("project directory"));
        this.cont.add(pproj);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBackground(Color.gray.brighter());
        JPanel pclose = new JPanel();
        pclose.setLayout(new BoxLayout(pclose, 0));
        this.bcreateproj = new JButton("create new project");
        pclose.add(this.bcreateproj);
        this.btnclose = new JButton("Close");
        pclose.add(this.btnclose);
        this.cont.add(pclose);
        this.cont.add(Box.createVerticalStrut(5));
        this.setBackground(Color.gray.brighter());
        this.setResizable(true);
        this.setLocation(200, 100);
        this.setSize(450, 130);
        this.setVisible(false);
        this.btnproj.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChaseFileChooser fdlg = new ChaseFileChooser();
                fdlg.setDialogType(2);
                fdlg.setDialogTitle("Open");
                fdlg.setCurrentDirectory(new File("."));
                fdlg.setFileSelectionMode(1);
                if (fdlg.showDialog(NewProject.this.cont, "open") != 0) {
                    return;
                }
                NewProject.this.projdir = fdlg.getSelectedFile().getAbsolutePath();
                NewProject.this.tfprojdir.setText(NewProject.this.projdir);
                NewProject.this.projdir = NewProject.this.get_projdir(false);
            }
        });
        this.bcreateproj.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewProject.this.createNewProject();
            }
        });
        this.btnclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewProject.this.setVisible(false);
            }
        });
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                NewProject.this.setVisible(false);
            }
        });
    }

    public void display() {
        this.setVisible(true);
    }

    public String get_projdir(boolean warn) {
        String str = this.tfprojdir.getText();
        if (str.trim().length() == 0 && warn) {
            this.mbox.setText("Input project directory.");
            return str;
        }
        if (!str.endsWith("\\") && !str.endsWith("/")) {
            str = str + System.getProperty("file.separator");
        }
        return str;
    }

    public void setProjdir(String proj) {
        this.projdir = proj;
        this.tfprojdir.setText(this.projdir);
    }

    public int createNewProject() {
        this.projdir = this.get_projdir(true);
        if (this.projdir.trim().length() == 0) {
            return -1;
        }
        String modulestr = new String();
        modulestr = this.projtype.getChoice();
        this.createInitialFiles(modulestr);
        this.parent.getMenuBarChase().open_project(this.projdir);
        this.setVisible(false);
        this.dispose();
        return 0;
    }

    private void createInitialFiles(String modulestr_) {
        String modulestr = modulestr_;
        if (!this.projdir.endsWith(System.getProperty("file.separator"))) {
            this.projdir = this.projdir + System.getProperty("file.separator");
        }
        if (modulestr.equalsIgnoreCase("PHASE")) {
            this.createInitialFilesForPhase();
        } else {
            System.out.println("failed creation of initial files for " + modulestr);
        }
    }

    private void createInitialFilesForPhase() {
        this.pmproj = new PropertyManager(2);
        this.pmproj.setProjDir(this.projdir);
        this.pmproj.setProperty("module", "PHASE");
        this.pmproj.setProperty("np", "1");
        this.pmproj.setProperty("nk", "1");
        this.pmproj.setProperty("ne", "1");
        this.pmproj.storeProperty();
        String fname = this.projdir + "file_names.data";
        File file = new File(fname);
        if (!file.exists()) {
            try {
                PrintWriter fout = new PrintWriter(new BufferedWriter(new FileWriter(fname)));
                fout.println("&fnames");
                fout.println(" F_INP = '" + this.projdir + "nfinp.data" + "'");
                fout.println(" F_KPOINT = '" + this.projdir + "kpoint.data" + "'");
                fout.println(" F_DYNM = '" + this.projdir + "nfdynm.data" + "'");
                fout.println(" F_ENF = '" + this.projdir + "nfene.data" + "'");
                fout.println(" F_CHR = '" + this.projdir + "nfchr.cube" + "'");
                fout.println(" F_DOS = '" + this.projdir + "dos.data" + "'");
                fout.println(" F_ENERG = '" + this.projdir + "nfenergy.data" + "'");
                fout.println(" F_ZAJ = '" + this.projdir + "nfzaj.data" + "'");
                fout.println(" F_CHGT = '" + this.projdir + "nfchgt.data" + "'");
                fout.println(" F_CNTN = '" + this.projdir + "continue.data" + "'");
                fout.println(" F_CNTN_BIN = '" + this.projdir + "continue_bin.data" + "'");
                fout.println("&end");
                fout.close();
            }
            catch (Exception e) {
                System.out.println("write to " + fname + " failed.");
            }
        }
    }
}

