/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.primitiveguis.tableforinputinterface;

import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.inputinterface.InputInterfaceEntry;
import jp.advancesoft.chase.inputinterface.InputInterfaceEntryChangeEvent;
import jp.advancesoft.chase.inputinterface.InputInterfacePrimitiveEntry;
import jp.advancesoft.chase.primitiveguis.tableforinputinterface.TableModelForInputInterface;
import org.apache.log4j.Logger;

public class TableModelForNonTabularData
extends TableModelForInputInterface {
    private static Logger logger = Logger.getLogger((String)TableModelForNonTabularData.class.getName());
    private Vector entryVector = new Vector();
    private int rowStart = 1;
    private boolean rowOriented = false;
    private int[] map;

    public TableModelForNonTabularData(String[] inputSpecifications, InputInterface inputInterface, int[] mapSpecCol, EventListener el) {
        super(inputSpecifications, inputInterface, mapSpecCol, el);
        super.init();
    }

    public TableModelForNonTabularData(String[] inputSpecifications, InputInterface inputInterface, int[] mapSpecCol, EventListener el, int columnIndex) {
        super(inputSpecifications, inputInterface, mapSpecCol, el, columnIndex);
        super.init();
    }

    public boolean isRowOriented() {
        return this.rowOriented;
    }

    public void inputInterfaceInitializing() {
        TableModelListener[] listeners = this.getTableModelListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.removeTableModelListener(listeners[i]);
        }
        int row = this.getRowCount();
        int col = this.getColumnCount();
        int colStart = 1;
        for (int i = 0; i < row; ++i) {
            for (int j = colStart; j < col; ++j) {
                this.setValueAt("", i, j);
            }
        }
        this.restoreListeners(listeners);
    }

    protected void createTableColumns() {
        if (this.columns == null) {
            return;
        }
        logger.debug((Object)"creating table columns...");
        Object[] colNames = null;
        if (this.spec.isRowOriented()) {
            this.rowOriented = true;
            colNames = this.spec.getColumnNamesForNonTabularData();
            this.setColumnIdentifiers(colNames);
            this.setRowCount(this.columns.length);
            for (int i = 0; i < this.columns.length; ++i) {
                logger.debug((Object)("set name : " + this.columns[i].getName()));
                this.setValueAt(this.columns[i].getName(), i, 0);
            }
        } else {
            this.rowOriented = false;
            for (int i = 0; i < this.columns.length; ++i) {
                this.addColumn(this.columns[i].getName());
            }
            int nrw = this.spec.getNumRows();
            if (nrw > 0) {
                this.setRowCount(nrw);
            }
            String[] foo = this.inputSpecifications[0].split("\\.");
            String tag = foo[foo.length - 1];
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.setValueAt(tag, i, 0);
            }
        }
    }

    protected void extractInputFile() {
        this.entryVector = new Vector();
        this.map = new int[this.columns.length];
        int count = 0;
        logger.debug((Object)("extraction input. " + this.inputSpecifications[0]));
        for (int i = 0; i < this.columns.length; ++i) {
            String fullName = this.inputSpecifications[0] + "." + this.columns[i].getName().trim();
            logger.debug((Object)("fullname: " + fullName));
            if (this.columns[i].ignoreOnSave()) continue;
            InputInterfacePrimitiveEntry entry = this.input.getInputInterfacePrimitiveEntry(fullName);
            this.map[i] = count++;
            this.entryVector.addElement(entry);
        }
        this.setInputToModel();
    }

    protected void setInputToModel() {
        this.input.setUpdateUndoStack(false);
        this.updateInputInterface = false;
        int icol = this.getColumnCount();
        int irow = this.getRowCount();
        int idata = icol + this.rowStart;
        int idata2 = irow;
        if (this.rowOriented) {
            idata = irow;
            idata2 = icol + this.rowStart;
        }
        for (int i = 0; i < this.entryVector.size(); ++i) {
            if (i >= idata) continue;
            InputInterfacePrimitiveEntry entry = (InputInterfacePrimitiveEntry)this.entryVector.get(i);
            String value = entry.getValue();
            String[] values = value.trim().split("\\s+");
            for (int j = 0; j < values.length; ++j) {
                if (j >= idata2) continue;
                if (this.rowOriented) {
                    int tmp = j + this.rowStart;
                    logger.debug((Object)("rowOriented; set value " + values[j] + " at: " + i + " " + tmp));
                    this.setValueAt(values[j], i, tmp);
                    continue;
                }
                logger.debug((Object)("set value " + values[j] + " at: " + j + " " + i));
                this.setValueAt(values[j], j, i + this.rowStart);
            }
        }
        this.input.setUpdateUndoStack(true);
        this.updateInputInterface = true;
    }

    public void execute(EventObject e) {
        if (!this.updateInputInterface) {
            return;
        }
        TableModelListener[] listeners = this.getTableModelListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.removeTableModelListener(listeners[i]);
        }
        TableModelEvent tmde = (TableModelEvent)e;
        int first = 0;
        int last = 0;
        int chcol = 0;
        if (tmde == null) {
            this.restoreListeners(listeners);
            return;
        }
        first = tmde.getFirstRow();
        last = tmde.getLastRow();
        chcol = tmde.getColumn();
        logger.debug((Object)("first row that changed: " + tmde.getFirstRow()));
        logger.debug((Object)("last row that changed: " + tmde.getLastRow()));
        logger.debug((Object)("type: " + tmde.getType()));
        if (first < 0 || last < 0 || first >= this.getRowCount() || last >= this.getRowCount()) {
            this.restoreListeners(listeners);
            return;
        }
        logger.debug((Object)"updating table data ...");
        int icol = this.getColumnCount();
        int irow = this.getRowCount();
        int rowStart = 1;
        String[] columnName = new String[icol];
        for (int i = 0; i < icol; ++i) {
            columnName[i] = this.getColumnName(i);
        }
        int change = -1;
        int targ = -1;
        if (this.rowOriented) {
            change = first;
            targ = first;
        } else {
            change = chcol;
            targ = chcol;
        }
        if (change < 0 || targ < 0) {
            this.restoreListeners(listeners);
            return;
        }
        Vector<InputInterfacePrimitiveEntry> entries = new Vector<InputInterfacePrimitiveEntry>();
        InputInterfacePrimitiveEntry pentry = this.input.getInputInterfacePrimitiveEntry(this.inputSpecifications[0] + "." + this.columns[targ].getName());
        logger.debug((Object)("targ: " + targ + "changing entry: " + this.inputSpecifications[0] + "." + this.columns[targ].getName()));
        pentry.saveState();
        String accumData = "";
        String name = "";
        if (this.rowOriented) {
            for (int j = rowStart; j < icol; ++j) {
                accumData = accumData + (String)this.getValueAt(change, j) + " ";
            }
            name = ((String)this.getValueAt(change, 0)).trim();
        } else {
            for (int j = 0; j < irow; ++j) {
                accumData = accumData + (String)this.getValueAt(j, change);
            }
            name = columnName[change].trim();
        }
        pentry.setName(name);
        pentry.setValue(accumData);
        pentry.setUnit("");
        this.input.replaceEntry(pentry, this);
        entries.addElement(pentry);
        this.restoreListeners(listeners);
    }

    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent e) {
        logger.debug((Object)("at inputInterfaceEntryChaged: tag: " + e.getTag()));
        if (e == null || e.getTag() == null) {
            logger.debug((Object)"something is wrong... InputInterfaceEntryChangeEvent not properly initialized.");
            return;
        }
        if (e.getSource() == this) {
            logger.debug((Object)"source == this");
            return;
        }
        InputInterfaceEntry entry = e.getEntry();
        if (entry.getEntryType() != 0) {
            logger.debug((Object)"not primitive entry");
            return;
        }
        int target = -1;
        String tag = e.getTag().trim() + "." + e.getEntry().getName();
        String targetTag = "";
        for (int i = 0; i < this.columns.length; ++i) {
            if (!tag.equalsIgnoreCase(this.inputSpecifications[0] + "." + this.columns[i].getName())) continue;
            target = i;
        }
        if (target < 0) {
            logger.debug((Object)"not target");
            return;
        }
        logger.debug((Object)("tag: " + tag));
        logger.debug((Object)("e.getSource(): " + e.getSource()));
        logger.debug((Object)("this: " + this));
        InputInterfacePrimitiveEntry pentry = this.input.getInputInterfacePrimitiveEntry(tag);
        this.entryVector.set(this.map[target], pentry);
        this.setInputToModel();
    }
}

