/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.util.EventListener;
import java.util.Vector;
import jp.advancesoft.chase.atomcoord.Atom;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import jp.advancesoft.chase.common.TaggedString;
import jp.advancesoft.chase.phase.TableForInputInterface;
import jp.advancesoft.chase.phase.TableModelForInputInterface;
import org.apache.log4j.Logger;

public class TableModelForAtomPanel
extends TableModelForInputInterface {
    private static Logger logger = Logger.getLogger((String)TableModelForAtomPanel.class.getName());
    private AtomCoords coords;
    private boolean doPost = true;

    public TableModelForAtomPanel(TableForInputInterface table, Object[] columnNames, int rowCount, EventListener el, AtomCoords coords) {
        super(table, columnNames, rowCount, el);
        this.coords = coords;
    }

    public TableModelForAtomPanel(TableForInputInterface table, Object[] columnNames, int rowCount, AtomCoords coords) {
        super(columnNames, rowCount);
        this.coords = coords;
    }

    public void post(String[] columnNames, Vector data) {
        logger.debug((Object)"entering post process ...");
        logger.debug((Object)("size of data: " + data.size()));
        this.coords.getAtomList().clear();
        for (int i = 0; i < data.size(); ++i) {
            Atom atom;
            String element;
            String[] row = (String[])data.get(i);
            String[] xyz = new String[3];
            if (row.length >= 4) {
                element = row[0];
                for (int j = 0; j < 3; ++j) {
                    xyz[j] = row[j + 1];
                }
            } else {
                logger.warn((Object)"invalid atom coordinates!");
                return;
            }
            int numAuxil = row.length - 4;
            if (numAuxil > 0) {
                TaggedString[] ts = new TaggedString[numAuxil];
                for (int j = 0; j < numAuxil; ++j) {
                    ts[j] = new TaggedString(columnNames[j + 4], row[j + 4]);
                }
                atom = new Atom(element, xyz, ts);
            } else {
                atom = new Atom(element, xyz);
            }
            this.coords.getAtomList().addAtom(atom);
        }
    }

    protected AtomCoords getAtomCoords() {
        return this.coords;
    }
}

