/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.awt.Container;
import java.awt.Dimension;
import java.util.EventListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.phase.ChoicePanelPhase;
import jp.advancesoft.chase.phase.CloseButton;
import jp.advancesoft.chase.phase.PhaseInputChildrenPanel;
import jp.advancesoft.chase.phase.TableForInputInterface;
import jp.advancesoft.chase.phase.TableModelForInputInterface;
import org.apache.log4j.Logger;

class SymmetryDetails
extends PhaseInputChildrenPanel {
    private static Logger logger = Logger.getLogger((String)SymmetryDetails.class.getName());

    public SymmetryDetails(InputInterface inputInterface) {
        super("symmetry details", true, true, true, true, inputInterface, new Dimension(550, 350));
    }

    void createGUI() {
        Container cont = this.getContentPane();
        cont.setLayout(new BoxLayout(cont, 1));
        cont.add(this.createSymmetryPanel());
        cont.add(new CloseButton(this));
        this.setResizable(true);
    }

    private JPanel createSymmetryPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JPanel p_cryst = new JPanel();
        p_cryst.setLayout(new BoxLayout(p_cryst, 0));
        Object[] colname_tspace = new String[]{"rotation", "tx", "ty", "tz"};
        String[] crystalspec = new String[]{"structure.symmetry.crystal_structure"};
        String[] crystals = new String[]{this.NO_SELECTION, "diamond", "hexagonal", "fcc", "bcc", "hcp", "simple_cubic"};
        ChoicePanelPhase crystal = new ChoicePanelPhase(crystalspec, this.inputInterface, "crystal structure", crystals, this);
        String[] invsymspec = new String[]{"structure.symmetry.sw_inversion"};
        String[] on_off_forc = new String[]{"off", "on"};
        ChoicePanelPhase invsym = new ChoicePanelPhase(invsymspec, this.inputInterface, "inversion duplication", on_off_forc, this);
        p_cryst.add(crystal);
        p_cryst.add(invsym);
        p.add(p_cryst);
        JPanel p_tspace = new JPanel();
        p_tspace.setLayout(new BoxLayout(p_tspace, 1));
        p_tspace.setBorder(new TitledBorder("tspace"));
        JPanel p_tspace_misc = new JPanel();
        p_tspace_misc.setLayout(new BoxLayout(p_tspace_misc, 0));
        String[] latticesymmspec = new String[]{"structure.symmetry.tspace.lattice_system"};
        String[] latticesymmchoi = new String[]{this.NO_SELECTION, "trigonal", "hexagonal", "primitive", "facecentered", "bodycentered", "basecentered"};
        ChoicePanelPhase latticesymm = new ChoicePanelPhase(latticesymmspec, this.inputInterface, "lattice system", latticesymmchoi, this);
        String[] genspec = new String[]{"structure.symmetry.tspace.num_generators"};
        String[] NUM_GEN = new String[]{this.NO_SELECTION, "1", "2", "3"};
        ChoicePanelPhase gen = new ChoicePanelPhase(genspec, this.inputInterface, "number of generators", NUM_GEN, this);
        p_tspace_misc.add(latticesymm);
        p_tspace_misc.add(gen);
        p_tspace.add(p_tspace_misc);
        p_tspace.add(Box.createVerticalGlue());
        String[] gentablespec = new String[]{"structure.symmetry.tspace.generators.table"};
        JPanel p_tspace_table = new JPanel();
        p_tspace_table.setBorder(new TitledBorder("generators"));
        String[] afgentablespec = new String[]{"structure.symmetry.tspace.afgenerator.table"};
        JPanel p_tspace_table_af = new JPanel();
        p_tspace_table_af.setBorder(new TitledBorder("af_generator"));
        TableForInputInterface tbl_tspace = new TableForInputInterface(gentablespec, this.inputInterface);
        tbl_tspace.setColumnSelectionAllowed(true);
        tbl_tspace.setRowSelectionAllowed(true);
        TableForInputInterface tbl_af = new TableForInputInterface(afgentablespec, this.inputInterface);
        tbl_af.setColumnSelectionAllowed(true);
        tbl_af.setRowSelectionAllowed(true);
        TableModelForInputInterface tblmod_tspace = new TableModelForInputInterface(tbl_tspace, colname_tspace, 3, (EventListener)this);
        tbl_tspace.setModel(tblmod_tspace);
        TableModelForInputInterface tblmod_af = new TableModelForInputInterface(tbl_af, colname_tspace, 1, (EventListener)this);
        tbl_af.setModel(tblmod_af);
        JScrollPane scrPane = new JScrollPane();
        scrPane.getViewport().setView(tbl_tspace);
        scrPane.setPreferredSize(new Dimension(500, 70));
        p_tspace_table.add(scrPane);
        JScrollPane scrPane_af = new JScrollPane();
        scrPane_af.getViewport().setView(tbl_af);
        scrPane_af.setPreferredSize(new Dimension(500, 40));
        p_tspace_table_af.add(scrPane_af);
        p_tspace.add(p_tspace_table);
        p_tspace.add(p_tspace_table_af);
        int[] intarray = new int[]{0};
        latticesymm.registerDisabableGUI(intarray, gen);
        latticesymm.registerDisabableGUI(intarray, tbl_tspace);
        latticesymm.registerDisabableGUI(intarray, tbl_af);
        p.add(p_tspace);
        return p;
    }

    public void delete() {
    }

    public void add() {
    }

    public void save() {
    }
}

