/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jp.advancesoft.chase.common.Command;
import jp.advancesoft.chase.inputinterface.DataManager;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;
import jp.advancesoft.chase.phase.AccuracyPanel;
import jp.advancesoft.chase.phase.ButtonFrameInterface;
import jp.advancesoft.chase.phase.CloseButton;
import jp.advancesoft.chase.phase.ControlPanel;
import jp.advancesoft.chase.phase.PostProcessPanel;
import jp.advancesoft.chase.phase.PrintLevelPanel;
import jp.advancesoft.chase.phase.SaveButton;
import jp.advancesoft.chase.phase.SaveCloseButton;
import jp.advancesoft.chase.phase.SolverPanel;
import jp.advancesoft.chase.phase.StructurePanel;
import jp.advancesoft.chase.phase.projectinfo.PhaseInfo;
import org.apache.log4j.Logger;

public class PhaseInputFrame
extends InternalFrameChase
implements ActionListener,
ButtonFrameInterface {
    private static Logger logger = Logger.getLogger((String)PhaseInputFrame.class.getName());
    protected static String NO_SELECTION = "------------";
    private String[] on_off = new String[]{NO_SELECTION, "on", "off"};
    private String[] on_off_FORCE_SELECTION = new String[]{"on", "off"};
    private String infileName;
    private int x = 750;
    private int y = 680;
    private InputInterface inputInterface;
    private JTabbedPane tab;
    private PhaseInfo info;

    public PhaseInputFrame(PhaseInfo info, Dimension size) {
        super("PHASE Input", true, true, true, true, size);
        this.info = info;
        Container cont = this.getContentPane();
        cont.setLayout(new BoxLayout(cont, 1));
        this.tab = new JTabbedPane();
        this.tab.setPreferredSize(new Dimension(this.x - 50, this.y - 100));
        DataManager dm = new DataManager(info.getInputFilePath());
        dm.parse();
        this.inputInterface = dm.getInputInterface();
        String[] pps = info.getPPFiles();
        for (int i = 0; i < pps.length; ++i) {
            logger.debug((Object)("pp-files: " + pps[i]));
        }
        this.tab.addTab("Control", new ControlPanel(this.inputInterface));
        this.tab.addTab("Structure", new StructurePanel(this.inputInterface));
        this.tab.addTab("Accuracy", new AccuracyPanel(this.inputInterface));
        this.tab.addTab("Solver", new SolverPanel(this.inputInterface));
        this.tab.addTab("Post process", new PostProcessPanel(this.inputInterface));
        this.tab.addTab("Print level", new PrintLevelPanel(this.inputInterface));
        cont.add(this.tab);
        cont.add(Box.createVerticalStrut(5));
        JPanel pclose = new JPanel();
        pclose.setLayout(new BoxLayout(pclose, 0));
        pclose.add(new SaveButton(this));
        pclose.add(new SaveCloseButton(this));
        pclose.add(new CloseButton(this));
        cont.add(pclose);
        cont.add(Box.createVerticalStrut(5));
        this.setResizable(true);
        this.setVisible(false);
    }

    public JTabbedPane getTab() {
        return this.tab;
    }

    public void actionPerformed(ActionEvent e) {
        Command command = (Command)e.getSource();
        command.execute(e);
    }

    public void save() {
        if (this.inputInterface != null) {
            this.inputInterface.saveTo(new File("./foo.txt"));
        }
    }

    public void close() {
        this.dispose();
    }

    public void saveClose() {
        this.save();
        this.close();
    }
}

