/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import jp.advancesoft.chase.common.RegExpedString;
import jp.advancesoft.chase.projectbrowser.fileinfo.DefaultFileInfo;
import jp.advancesoft.chase.projectbrowser.fileinfo.FileInfo;
import jp.advancesoft.chase.projectbrowser.fileinfo.FileInfoParser;
import org.apache.log4j.Logger;

public class PhaseFileInfoParser
extends FileInfoParser {
    private Logger logger = Logger.getLogger((String)PhaseFileInfoParser.class.getName());

    public PhaseFileInfoParser(File filefile, File defaultParent, DefaultFileInfo fileinfo) {
        super(filefile, defaultParent, fileinfo);
        this.init();
    }

    public String getFileInfoName() {
        return "phase";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        FileInfo[] infos = this.fileinfo.getFileInfos();
        this.logger.debug((Object)"saving file info ...");
        for (int i = 0; i < infos.length; ++i) {
            this.logger.debug((Object)infos[i]);
        }
        File file = new File(this.defaultParent.getAbsolutePath() + System.getProperty("file.separator") + "file_names.data");
        PrintWriter fout = null;
        try {
            fout = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            fout.println("&fnames");
            for (int i = 0; i < infos.length; ++i) {
                if (infos[i].getFileNameEditLevel() == 1) continue;
                RegExpedString ident = infos[i].getIdentifier();
                String path = ".";
                File parent = infos[i].getPath();
                if (parent.isAbsolute()) {
                    path = parent.getPath();
                }
                if (!ident.getValue().startsWith("F_POT(")) {
                    String filename = path + System.getProperty("file.separator") + infos[i].getName();
                    fout.println(ident.getValue() + " = '" + filename + "'");
                    continue;
                }
                File[] paths = infos[i].getPaths();
                String[] names = infos[i].getNames();
                if (names == null || paths == null) continue;
                for (int j = 0; j < names.length; ++j) {
                    if (names[j].trim().length() == 0) continue;
                    String filename = paths[j].getPath() + System.getProperty("file.separator") + names[j];
                    String pot = "F_POT(" + String.valueOf(j + 1) + ") = '" + filename + "'";
                    fout.println(pot);
                }
            }
            fout.println("&end");
        }
        catch (Exception exc) {
            exc.printStackTrace();
            System.out.println("failed write to: " + file);
        }
        finally {
            fout.close();
        }
    }

    public void init() {
        Vector vector = new Vector();
        Object ret = null;
        try {
            String entry;
            BufferedReader br = new BufferedReader(new FileReader(this.filefile));
            while ((entry = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(entry, "=");
                if (st.countTokens() < 2) continue;
                String ident = st.nextToken().trim();
                String value = st.nextToken().replace('\'', ' ').trim();
                File file = new File(value);
                this.updateFileInfo(ident, file);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("failed read from: " + this.filefile));
        }
    }

    public void debug() {
        this.fileinfo.debug();
    }

    private void updateFileInfo(String ident, File file) {
        if (this.fileinfo == null) {
            return;
        }
        this.logger.debug((Object)("updating file info for : " + ident + " " + file.getPath()));
        FileInfo[] infos = this.fileinfo.getFileInfos();
        if (infos == null) {
            return;
        }
        String value = file.getName();
        for (int i = 0; i < infos.length; ++i) {
            RegExpedString id = infos[i].getIdentifier();
            if (!id.equals(ident)) continue;
            infos[i].setName(value);
            infos[i].setPath(file.getParentFile());
        }
    }
}

