/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretListener;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.inputinterface.InputInterfacePrimitiveEntry;
import jp.advancesoft.chase.phase.ComboBoxPhase;
import jp.advancesoft.chase.phase.PhaseInputPanelInterface;
import jp.advancesoft.chase.phase.TextFieldPhase;
import org.apache.log4j.Logger;

public class InputPanelPhase
extends JPanel
implements PhaseInputPanelInterface {
    private static Logger logger = Logger.getLogger((String)InputPanelPhase.class.getName());
    private InputInterfacePrimitiveEntry entry;
    private InputInterface inputinterface;
    private String[] inputSpecifications;
    private String[] fullName;
    private TextFieldPhase textfield;
    private ComboBoxPhase combobox;
    private String title;
    private int unit;
    private int columns;
    public static final int NONE = 0;
    public static final int LONGTIME = 1;
    public static final int TIME = 2;
    public static final int LENGTH = 3;
    public static final int ENERGY = 4;
    public static final int FORCE = 5;
    private String[] choices;
    private String[] units_longtime = new String[]{"day", "hour", "min", "sec"};
    private String[] units_time = new String[]{"au_time", "ns", "fs"};
    private String[] units_length = new String[]{"Bohr", "Angstrom", "nm"};
    private String[] units_energy = new String[]{"Hartree", "Rydberg", "eV"};
    private String[] units_force = new String[]{"Hartree/Bohr", "eV/Angstrom"};

    public InputPanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title, int unit, int columns, EventListener parent) {
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        this.title = title;
        this.unit = unit;
        this.columns = columns;
        this.extractInputFile();
        this.createGUI();
        this.addListeners(parent);
    }

    public InputPanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title, int unit, int columns) {
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        this.title = title;
        this.unit = unit;
        this.columns = columns;
        this.extractInputFile();
        this.createGUI();
    }

    public void addListeners(EventListener listener) {
        if (this.combobox != null) {
            this.combobox.addActionListener((ActionListener)listener);
        }
        this.textfield.addCaretListener((CaretListener)listener);
    }

    public void setEnabled(boolean enabled) {
        if (this.combobox != null) {
            this.combobox.setEnabled(enabled);
        }
        this.textfield.setEditable(enabled);
    }

    private void extractInputFile() {
        for (int is = 0; is < this.inputSpecifications.length; ++is) {
            String inp = this.inputSpecifications[is];
            logger.debug((Object)("inp: " + inp));
            this.fullName = inp.split("\\.");
            this.inputinterface.selectRoot();
            logger.debug((Object)("length of fullName: " + this.fullName.length));
            for (int i = 0; i < this.fullName.length - 1; ++i) {
                String ident = this.fullName[i];
                if (this.inputinterface.selectBlock(ident)) continue;
                logger.debug((Object)("couldn't select block: " + ident));
            }
            this.entry = this.inputinterface.getPrimitiveEntry(this.fullName[this.fullName.length - 1]);
            if (this.entry.getName().trim().length() == 0 && is != this.inputSpecifications.length - 1) continue;
            logger.debug((Object)("got entry: " + this.entry.getName() + " value: " + this.entry.getValue() + " unit: " + this.entry.getUnit()));
            String st = this.inputSpecifications[0];
            this.fullName = st.split("\\.");
            this.entry.setName(this.fullName[this.fullName.length - 1].trim());
            this.inputinterface.selectRoot();
            break;
        }
    }

    private void createGUI() {
        int pwidth = this.unit == 0 ? this.columns : this.columns + 80;
        if (this.unit == 1) {
            this.choices = this.units_longtime;
        } else if (this.unit == 2) {
            this.choices = this.units_time;
        } else if (this.unit == 3) {
            this.choices = this.units_length;
        } else if (this.unit == 4) {
            this.choices = this.units_energy;
        } else if (this.unit == 5) {
            this.choices = this.units_force;
        }
        this.createTextField();
        super.add(this.textfield);
        if (this.unit != 0) {
            this.createComboBox();
            this.combobox.setSize(60, 20);
            this.add(this.combobox);
        }
        super.setLayout(new BoxLayout(this, 0));
        super.setSize(pwidth, 20);
        if (this.title != null) {
            super.setBorder(new TitledBorder(this.title));
        }
    }

    private void createTextField() {
        this.textfield = new TextFieldPhase(this.columns, this.inputSpecifications, this.inputinterface);
        this.textfield.setText(this.entry.getValue());
    }

    private void createComboBox() {
        this.combobox = new ComboBoxPhase(this.choices, this.inputSpecifications, this.inputinterface);
        String unit = this.entry.getUnit();
        for (int i = 0; i < this.choices.length; ++i) {
            if (!this.choices[i].equalsIgnoreCase(unit)) continue;
            this.combobox.setSelectedIndex(i);
        }
    }

    public String getValue() {
        return this.textfield.getText();
    }

    public String getUnit() {
        return (String)this.combobox.getSelectedItem();
    }

    public TextFieldPhase getTextField() {
        return this.textfield;
    }
}

