/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.mainpanel;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jp.advancesoft.chase.common.ChaseFileChooser;
import jp.advancesoft.chase.common.ExternalProgramExecuter;
import jp.advancesoft.chase.common.MyMessageBox;
import jp.advancesoft.chase.common.Utils;
import jp.advancesoft.chase.logger.JTextAreaAppender;
import jp.advancesoft.chase.mainpanel.ChaseFrame;
import jp.advancesoft.chase.mainpanel.ChaseMenu;
import jp.advancesoft.chase.mainpanel.ChaseSplitPane;
import jp.advancesoft.chase.mainpanel.Desktop;
import jp.advancesoft.chase.mainpanel.FrameChase;
import jp.advancesoft.chase.mainpanel.LogoBooter;
import jp.advancesoft.chase.mainpanel.LookandFeel;
import jp.advancesoft.chase.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import jp.advancesoft.chase.settings.GlobalProperties;
import jp.advancesoft.chase.settings.PropertiesManager;
import jp.advancesoft.chase.settings.PropertyManager;
import org.apache.log4j.Logger;

public class Chase
extends FrameChase {
    private static Logger logger = Logger.getLogger((String)Chase.class.getName());
    private final String FS = System.getProperty("file.separator");
    private boolean b_ctrl_PRESSED = false;
    private MyMessageBox mbox;
    private Container cont;
    public JDesktopPane desktop;
    private int fontsize = 12;
    private String fonttype = "SansSerif";
    private int fontstyle = 0;
    private PropertyManager propProj;
    private boolean chaseiniExists = true;
    private ChaseMenu chaseMenu;
    private ProjectDirBrowser dirBrowser;
    private Vector components = new Vector();

    public Chase(boolean splash) {
        super("CHASE-3PT:", new Dimension(1024, 768));
        GlobalProperties props = PropertiesManager.getGlobalProperties(0);
        LogoBooter lb = null;
        if (splash) {
            lb = new LogoBooter(this);
        }
        this.mbox = new MyMessageBox();
        this.cont = this.getContentPane();
        if (!this.checkInstallation()) {
            this.mbox.setText("failed installation ... exiting program");
            System.exit(0);
        }
        this.setInitialLookandFeel();
        this.desktop = Desktop.getDesktop();
        JScrollPane scrpanedesk = new JScrollPane(this.desktop);
        scrpanedesk.setPreferredSize(new Dimension(this.desktop.getWidth(), this.desktop.getHeight()));
        ((Desktop)this.desktop).setScrollPane(scrpanedesk);
        String unit_increment = props.getProperty("desktop_scrollbar_increment");
        int unitincre = 30;
        try {
            unitincre = Integer.parseInt(unit_increment);
        }
        catch (NumberFormatException nfe) {
            unitincre = 30;
        }
        int hunit = unitincre;
        int vunit = unitincre;
        scrpanedesk.getHorizontalScrollBar().setUnitIncrement(hunit);
        scrpanedesk.getVerticalScrollBar().setUnitIncrement(vunit);
        scrpanedesk.getViewport().setScrollMode(0);
        JTextArea textarea = JTextAreaAppender.getTextArea();
        textarea.setLineWrap(true);
        textarea.setWrapStyleWord(true);
        JScrollPane scrpane = new JScrollPane(textarea);
        scrpane.setVerticalScrollBarPolicy(22);
        scrpane.setPreferredSize(new Dimension(250, 250));
        JPanel logview = new JPanel();
        logview.setLayout(new BoxLayout(logview, 0));
        JButton clearLogButton = new JButton("clear log");
        JButton logsaveButton = new JButton("save log");
        logview.add(scrpane);
        JPanel logbuttons = new JPanel();
        logbuttons.setLayout(new BoxLayout(logbuttons, 1));
        logbuttons.add(clearLogButton);
        logbuttons.add(logsaveButton);
        logview.add(logbuttons);
        JScrollPane scrDir = new JScrollPane();
        JPanel panel = new JPanel();
        this.dirBrowser = new ProjectDirBrowser("projects");
        scrDir.getViewport().setView(this.dirBrowser);
        ChaseSplitPane splitpaneDir = new ChaseSplitPane("dirselector", 1, (Component)this);
        this.components.addElement(splitpaneDir);
        splitpaneDir.setOneTouchExpandable(true);
        splitpaneDir.setLeftComponent(this.dirBrowser);
        splitpaneDir.setRightComponent(scrpanedesk);
        splitpaneDir.init();
        this.cont.add(splitpaneDir);
        ChaseSplitPane splitpane = new ChaseSplitPane("logviewer", 0, (Component)this);
        splitpane.setTopComponent(splitpaneDir);
        splitpane.setBottomComponent(logview);
        splitpane.setContinuousLayout(true);
        splitpane.setOneTouchExpandable(true);
        splitpane.init();
        this.cont.add(splitpane);
        this.components.addElement(splitpane);
        logsaveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Chase.this.exportLog();
            }
        });
        clearLogButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Chase.this.clearLog();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Chase.this.exiting();
                Chase.this.dispose();
                System.exit(0);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Chase.this.requestFocusInWindow();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                String str_tgl = new String();
                if (e.getKeyCode() == 113) {
                    str_tgl = "f";
                    Chase.this.toggleInternalPanel(str_tgl);
                } else if (e.getKeyCode() == 114) {
                    str_tgl = "b";
                    Chase.this.toggleInternalPanel(str_tgl);
                }
                if (e.getKeyCode() == 17) {
                    Chase.this.b_ctrl_PRESSED = true;
                }
                Chase.this.addKeyListener(new KeyAdapter(){

                    public void keyPressed(KeyEvent e2) {
                        if (Chase.this.b_ctrl_PRESSED) {
                            if (e2.getKeyCode() == 81) {
                                Chase.this.dispose();
                                Runtime.getRuntime().gc();
                                System.exit(1);
                                Chase.this.b_ctrl_PRESSED = false;
                            }
                        }
                        if (Chase.this.b_ctrl_PRESSED) {
                            if (e2.getKeyCode() == 87) {
                                Chase.this.desktop.getSelectedFrame().setVisible(false);
                                JInternalFrame[] frames = Chase.this.desktop.getAllFrames();
                                JInternalFrame gsf = Chase.this.desktop.getSelectedFrame();
                                for (int i = 0; i < frames.length; ++i) {
                                    if (!frames[i].isVisible()) continue;
                                    try {
                                        frames[i].setSelected(true);
                                        continue;
                                    }
                                    catch (Exception e) {
                                        Chase.this.mbox.setText("error: " + e);
                                    }
                                }
                                Chase.this.requestFocusInWindow();
                                Chase.this.b_ctrl_PRESSED = false;
                            }
                        }
                    }
                });
                Chase.this.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent e3) {
                        if (e3.getKeyCode() == 17) {
                            Chase.this.b_ctrl_PRESSED = false;
                        }
                    }
                });
            }
        });
        this.chaseMenu = new ChaseMenu(this);
        this.setJMenuBar(this.chaseMenu);
        logger.info((Object)"Welcome to CHASE-3PT!");
        logger.info((Object)"Copyright (C) AdvanceSoft Corporation.");
        lb.stop();
    }

    public ChaseMenu getMenuBarChase() {
        return this.chaseMenu;
    }

    public void display(boolean disp) {
        this.setVisible(disp);
        if (!this.chaseiniExists) {
            Object[] selection = new Object[]{"yes", "no, I'll do it later"};
            int ret = JOptionPane.showInternalOptionDialog(Desktop.getDesktop(), "this seems to be your first time boot ... set preferences now?", "message", 0, 1, null, selection, selection[0]);
            if (ret == 0) {
                Utils.bootPropertyPanel();
            }
        }
    }

    public void exiting() {
        this.dirBrowser.saveMyProjects();
        for (int i = 0; i < this.components.size(); ++i) {
            ((ChaseFrame)this.components.elementAt(i)).saveState();
        }
    }

    public static int getScreenHeight() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = ge.getDefaultScreenDevice();
        DisplayMode mode = device.getDisplayMode();
        return mode.getHeight();
    }

    public static int getScreenWidth() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = ge.getDefaultScreenDevice();
        DisplayMode mode = device.getDisplayMode();
        return mode.getWidth();
    }

    public void setUI(String str) {
        try {
            UIManager.setLookAndFeel(str);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exc) {
            logger.error((Object)("Error loading L&F: " + str));
            exc.printStackTrace();
        }
    }

    ProjectDirBrowser getProjectDirBrowser() {
        return this.dirBrowser;
    }

    private void toggleInternalPanel(String str_tgl_) {
        JInternalFrame[] frames = this.desktop.getAllFrames();
        JInternalFrame gsf = this.desktop.getSelectedFrame();
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i] != gsf) continue;
            if (i == frames.length - 1) {
                try {
                    frames[0].setSelected(true);
                }
                catch (Exception e) {
                    this.mbox.setText("error: " + e);
                }
                continue;
            }
            try {
                frames[i + 1].setSelected(true);
                continue;
            }
            catch (Exception e) {
                this.mbox.setText("error: " + e);
            }
        }
        this.requestFocusInWindow();
    }

    private boolean checkInstallation() {
        boolean ret = true;
        this.chaseiniExists = true;
        String chaseini = System.getProperty("user.home") + this.FS + ".chase";
        String chaseInstDir = System.getProperty("chase.home") + this.FS + "install" + this.FS + "install_files";
        File file = new File(chaseini);
        if (!file.exists()) {
            this.chaseiniExists = false;
            if (!file.mkdir()) {
                this.mbox.setText("failed to create " + chaseini + " ... exiting program");
            }
        } else if (!file.isDirectory()) {
            this.mbox.setText(chaseini + " must be a directory ... exiting program");
            System.exit(0);
        }
        PropertyManager propini = new PropertyManager(5);
        Enumeration<?> filenames = propini.getProp().propertyNames();
        while (filenames.hasMoreElements()) {
            String ident = (String)filenames.nextElement();
            String value = propini.getProperty(ident);
            File checkFile = new File(chaseini + this.FS + value);
            if (checkFile.exists()) continue;
            try {
                ExternalProgramExecuter.copy(chaseInstDir + this.FS + value, chaseini + this.FS + value);
                System.out.println("copied " + chaseInstDir + this.FS + value + " to " + chaseini + this.FS + value);
            }
            catch (Exception exc) {
                System.out.println("failed to copy " + chaseInstDir + this.FS + value);
                return false;
            }
        }
        return ret;
    }

    private void clearLog() {
        JTextArea textArea = JTextAreaAppender.getTextArea();
        textArea.setText("");
    }

    private void exportLog() {
        JTextArea textArea = JTextAreaAppender.getTextArea();
        ChaseFileChooser filechooser = new ChaseFileChooser("log");
        filechooser.setFileSelectionMode(0);
        if (filechooser.showDialog(this, "open") != 0) {
            return;
        }
        String selectedFile = filechooser.getSelectedFile().getAbsolutePath();
        logger.info((Object)("exported log file to " + selectedFile));
        try {
            FileWriter writer = new FileWriter(new File(selectedFile));
            writer.write(textArea.getText());
            writer.flush();
            writer.close();
        }
        catch (IOException ioe) {
            logger.error((Object)("failed to export log to file : " + selectedFile));
        }
    }

    protected void setInitialLookandFeel() {
        GlobalProperties props = PropertiesManager.getGlobalProperties(0);
        String lf = props.getProperty("look_and_feel");
        if (lf != null && lf.length() != 0) {
            boolean failed_skin_load = false;
            if (lf.equals(LookandFeel.landf_skin)) {
                String skin = props.getProperty("look_and_feel_skin");
                String defaultSkin = "defaultthemepack.zip";
                if (skin != null && skin.trim().length() != 0) {
                    try {
                        SkinLookAndFeel.setSkin((Skin)SkinLookAndFeel.loadThemePack((String)(System.getProperty("chase.home") + this.FS + "lib" + this.FS + "skinlf" + this.FS + skin)));
                    }
                    catch (Exception ee) {
                        failed_skin_load = true;
                        logger.error((Object)("failed to load: " + skin));
                    }
                } else {
                    try {
                        SkinLookAndFeel.setSkin((Skin)SkinLookAndFeel.loadThemePack((String)(System.getProperty("chase.home") + this.FS + "lib" + this.FS + "skinlf" + this.FS + defaultSkin)));
                    }
                    catch (Exception ex) {
                        failed_skin_load = true;
                        logger.error((Object)("failed to load: " + defaultSkin));
                    }
                }
            }
            boolean sup = false;
            for (int i = 0; i < LookandFeel.supported_lf.length; ++i) {
                if (!LookandFeel.supported_lf[i].equals(lf)) continue;
                this.setUI(lf);
                sup = true;
                break;
            }
            if (!sup) {
                logger.error((Object)("unsupported look and feel: " + lf));
                logger.error((Object)("using default: " + LookandFeel.landf_metal));
                this.setUI(LookandFeel.landf_metal);
            } else if (failed_skin_load) {
                logger.error((Object)"unsupported skin.");
                this.setUI(LookandFeel.landf_metal);
            }
        } else {
            this.setUI(LookandFeel.landf_metal);
        }
    }
}

