/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.inputinterface;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.advancesoft.chase.common.Utils;
import jp.advancesoft.chase.inputinterface.EntryTokenizer;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.inputinterface.InputInterfaceBlock;
import jp.advancesoft.chase.inputinterface.InputInterfaceDefaults;
import jp.advancesoft.chase.inputinterface.InputInterfacePrimitiveEntry;
import jp.advancesoft.chase.inputinterface.InputInterfaceUnits;
import jp.advancesoft.chase.inputinterface.inputinterfacetable.InputInterfaceTable;
import jp.advancesoft.chase.inputinterface.inputinterfacetable.InputInterfaceTableSpecManager;
import org.apache.log4j.Logger;

public class DataManager {
    private InputInterface input;
    private InputInterfaceBlock rootBlock;
    private String fileName;
    public static String RBRACE = "\\}";
    public static String ENTRY = "[\\w[*][(][)][=][+][-][.][,][\\s][\\\\][:][/][\"]]+[^#]";
    public static String LBRACE = "[\\w[\\\\][-][.][\\s]]+\\{";
    public static String LBRACE_NO_IDENT = "\\{";
    public static String SPACE = "\\s";
    public static String[] COMMENT = new String[]{"[!]", "/{2,}"};
    public static String BIKKURIHASH = "!#";
    public static String HASH = "#";
    public static String AST = "*";
    public static String blockStart = "blockStart";
    public static String blockEnd = "blockEnd";
    public static String entry = "entry";
    public static String comment = "comment";
    public static String tableStart = "tableStart";
    public static String tableEntry = "tableEntry";
    public static String tableEnd = "tableEnd";
    public static String TAG = "tag";
    public static String DEFAULT = "default";
    public static String UNITS = "units";
    public static String[] CELL_VECTORS = new String[]{"a_vector", "b_vector", "c_vector"};
    private boolean inTable = false;
    private int numCols;
    private String[] tableIdentifiers;
    private Vector tableData = new Vector();
    private EntryTokenizer tokenizer = new EntryTokenizer();
    private Logger logger;
    private boolean caseSensitive = false;
    private InputInterfaceTableSpecManager manager;
    private String fullName = "";

    public DataManager() {
        this.input = new InputInterface();
        this.rootBlock = new InputInterfaceBlock();
        this.rootBlock.setName("filename comes here");
        this.logger = Logger.getLogger(this.getClass());
    }

    public DataManager(String fileName) {
        this.fileName = fileName;
        this.input = new InputInterface();
        this.rootBlock = new InputInterfaceBlock();
        this.rootBlock.setName("filename comes here");
        this.logger = Logger.getLogger(this.getClass());
    }

    public DataManager(String fileName, URL url) {
        this.fileName = fileName;
        this.input = new InputInterface();
        this.manager = new InputInterfaceTableSpecManager(url, this.input);
        this.rootBlock = new InputInterfaceBlock();
        this.rootBlock.setName("filename comes here");
        this.logger = Logger.getLogger(this.getClass());
    }

    public DataManager(String fileName, boolean caseSensitive) {
        this.fileName = fileName;
        this.caseSensitive = caseSensitive;
        this.input = new InputInterface();
        this.rootBlock = new InputInterfaceBlock();
        this.rootBlock.setName("filename comes here");
        this.logger = Logger.getLogger(this.getClass());
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setWSisDelimiter(boolean wid) {
        this.tokenizer.setWSisDelimiter(wid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() {
        if (this.manager != null && this.input.getInputInterfaceTableSpecManager() == null) {
            this.input.setInputInterfaceTableSpecManager(this.manager);
        }
        this.input.setFile(this.fileName);
        this.input.initialize();
        this.rootBlock = this.input.getRootList();
        this.input.setUpdateUndoStack(false);
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(this.fileName));
            while ((line = br.readLine()) != null) {
                Vector tokens = this.tokenize(line);
                for (int i = 0; i < tokens.size(); ++i) {
                    String[] token = (String[])tokens.get(i);
                    String tokenKind = token[1];
                    this.logger.debug((Object)("token: " + token[0]));
                    this.logger.debug((Object)("tokenKind: " + token[1]));
                    if (tokenKind.equals(comment)) continue;
                    if (tokenKind.equals(blockStart)) {
                        this.startBlock(token[0]);
                        continue;
                    }
                    if (tokenKind.equals(blockEnd)) {
                        if (this.inTable) {
                            this.registerTableData();
                            this.inTable = false;
                        }
                        this.endBlock();
                        continue;
                    }
                    this.registerEntry(token[0], token[1]);
                }
            }
        }
        catch (Exception exc) {
            this.logger.error((Object)("failed to parse: " + this.fileName));
            exc.printStackTrace();
            this.input.clearUndoRedo();
            this.input.setUpdateUndoStack(true);
            return;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ioe) {
                this.logger.error((Object)("failed to close file: " + this.fileName));
            }
        }
        this.logger.debug((Object)"calling InputInterface.replaceAst()");
        this.input.replaceAst();
        this.input.clearUndoRedo();
        this.input.intialized();
        this.input.setUpdateUndoStack(true);
    }

    public InputInterface getInputInterface() {
        return this.input;
    }

    private void startBlock(String token) {
        this.logger.debug((Object)("starting block: " + token));
        String blockName = token.replaceAll(LBRACE_NO_IDENT, "").trim();
        this.fullName = this.fullName.trim().length() == 0 ? blockName : this.fullName + "." + blockName;
        InputInterfaceBlock block = new InputInterfaceBlock(blockName, new String(this.fullName));
        this.input.addBlock(block);
    }

    private void endBlock() {
        int ind = this.fullName.lastIndexOf(".");
        if (ind < 0) {
            ind = 0;
        }
        this.fullName = this.fullName.substring(0, ind);
        this.input.selectParentBlock();
    }

    private void registerTableData() {
        InputInterfaceTable tableEntry = new InputInterfaceTable(this.input.getCurrentBlock().getName(), this.tableIdentifiers, this.tableData);
        this.input.replaceEntry(tableEntry, null, false);
        this.logger.debug((Object)"registered table data");
        this.logger.debug((Object)("name of table: " + this.input.getCurrentBlock().getName()));
    }

    private void registerEntry(String token, String tokenKind) {
        this.tokenizer.setTokens(token, tokenKind);
        Vector results = this.tokenizer.getResults();
        for (int i = 0; i < results.size(); ++i) {
            String[] res = (String[])results.get(i);
            if (tokenKind.equals(tableStart)) {
                this.tableIdentifiers = res;
                continue;
            }
            if (tokenKind.equals(tableEntry)) {
                this.tableData.addElement(res);
                continue;
            }
            if (tokenKind.equals(entry)) {
                InputInterfacePrimitiveEntry entry = new InputInterfacePrimitiveEntry(Utils.stripDQ(res[0]), Utils.stripDQ(res[1]), Utils.stripDQ(res[2]));
                entry.setFullName(this.input.getCurrentBlock().getFullName() + "." + Utils.stripDQ(res[0]));
                this.input.replaceEntry(entry, null, false);
                continue;
            }
            if (tokenKind.equals(DEFAULT)) {
                InputInterfaceDefaults defs = new InputInterfaceDefaults(this.input.getCurrentBlock().getName(), res);
                defs.setFullName(this.input.getCurrentBlock().getFullName());
                this.input.replaceEntry(defs, null, false);
                continue;
            }
            if (!tokenKind.equals(UNITS)) continue;
            InputInterfaceUnits units = new InputInterfaceUnits(this.input.getCurrentBlock().getName(), res);
            units.setFullName(this.input.getCurrentBlock().getFullName());
            this.input.replaceEntry(units, null, false);
        }
    }

    private Vector tokenize(String line) {
        String[] token;
        Vector<String[]> tokens = new Vector<String[]>();
        line = !this.caseSensitive ? line.toLowerCase().trim() : line.trim();
        String line_new = line.replaceAll(BIKKURIHASH, HASH);
        if (!line_new.equals(line)) {
            this.logger.debug((Object)"replaced !# to #");
            line = line_new;
        }
        for (int j = 0; j < COMMENT.length; ++j) {
            String[] comments = line.split(COMMENT[j]);
            for (int i = 1; i < comments.length; ++i) {
                String[] token2 = new String[]{comments[i], comment};
                tokens.addElement(token2);
                this.logger.debug((Object)("found comment: " + token2[0]));
            }
            if (comments.length < 1) {
                return tokens;
            }
            line = comments[0];
        }
        Pattern pattern = Pattern.compile(LBRACE);
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            String[] token3 = new String[]{matcher.group(), blockStart};
            tokens.addElement(token3);
            this.logger.debug((Object)("found lbrace: " + token3[0]));
        }
        if (line.indexOf(HASH) >= 0) {
            String[] token4 = this.parseLinesWithHash(line);
            tokens.addElement(token4);
            return tokens;
        }
        pattern = Pattern.compile(ENTRY);
        matcher = pattern.matcher(line);
        String entryName = new String();
        String notify = new String();
        if (this.inTable) {
            entryName = tableEntry;
            notify = "found table entry: ";
        } else {
            entryName = entry;
            notify = "found primitive entry: ";
        }
        while (matcher.find()) {
            token = new String[2];
            String matchString = matcher.group();
            if (matchString.trim().endsWith("{")) continue;
            token[0] = matchString.replaceAll("}", "");
            token[1] = entryName;
            tokens.addElement(token);
            this.logger.debug((Object)(notify + matchString));
        }
        pattern = Pattern.compile(RBRACE);
        matcher = pattern.matcher(line);
        while (matcher.find()) {
            token = new String[]{matcher.group(), blockEnd};
            tokens.addElement(token);
            this.logger.debug((Object)("found rbrace: " + token[0]));
        }
        return tokens;
    }

    private String[] parseLinesWithHash(String line) {
        String[] token = new String[2];
        int hashStart = line.indexOf(HASH);
        String parseString = line.substring(hashStart + 1, line.length());
        if (parseString.startsWith(TAG)) {
            token[0] = line;
            token[1] = tableStart;
            this.inTable = true;
            this.tableData = new Vector();
        } else if (parseString.startsWith(DEFAULT)) {
            token[0] = line;
            token[1] = DEFAULT;
        } else if (parseString.startsWith(UNITS)) {
            token[0] = line;
            token[1] = UNITS;
        } else {
            token[0] = line;
            token[1] = comment;
        }
        return token;
    }

    public static void main(String[] args) {
        DataManager datamanager = null;
        if (args.length != 0) {
            datamanager = new DataManager(args[0]);
            datamanager.parse();
        } else {
            System.err.println("must specify file name!");
            System.exit(0);
        }
        InputInterface input = datamanager.getInputInterface();
        input.scanList();
        if (args.length >= 2) {
            input.saveTo(new File(args[1]));
        }
    }
}

