/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.graph.dataset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jp.advancesoft.chase.graph.GraphPanel;
import jp.advancesoft.chase.graph.dataset.DataSet;
import jp.advancesoft.chase.graph.dataset.DataSetCollection;
import jp.advancesoft.chase.graph.dataset.DataSetElement;
import jp.advancesoft.chase.graph.dataset.PlotProperties;
import jp.advancesoft.chase.graph.dataset.PlotPropertiesEditor;
import jp.advancesoft.chase.graph.dataset.SubPlotProperties;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;
import org.apache.log4j.Logger;

public class DataSetManipulator
extends InternalFrameChase {
    private Logger logger = Logger.getLogger((String)DataSetManipulator.class.getName());
    private DataSet[] dset;
    private PlotSelectionPanel plot;
    private DataSetManipulator manipulator;
    private PlotProperties props;
    private DataSetBrowser browserX;
    private DataSetBrowser browserY;

    public DataSetManipulator(DataSet[] dset) {
        super("data sets", true, true, true, true, new Dimension(500, 500));
        this.dset = dset;
        this.manipulator = this;
        this.init();
    }

    private void init() {
        this.props = new PlotProperties();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.browserX = new DataSetBrowser("domain", this.dset, 1);
        this.browserY = new DataSetBrowser("range", this.dset);
        JSplitPane splitpane = new JSplitPane(1, this.browserX, this.browserY);
        splitpane.setDividerLocation(0.5);
        splitpane.setResizeWeight(0.5);
        panel.add((Component)splitpane, "North");
        this.plot = new PlotSelectionPanel("plot");
        panel.add((Component)this.plot, "Center");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.fill = 2;
        constraints.weighty = 0.0;
        constraints.weightx = 1.0;
        JPanel btnpanel = new JPanel();
        btnpanel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        JButton btnplot = new JButton("plot");
        btnpanel.add((Component)btnplot, gc);
        JButton btnpref = new JButton("preferences");
        gc.gridx = 1;
        btnpanel.add((Component)btnpref, gc);
        JButton btnclose = new JButton("close");
        gc.gridx = 2;
        btnpanel.add((Component)btnpref, gc);
        gc.gridx = 3;
        gc.fill = 0;
        btnpanel.add((Component)btnclose, gc);
        panel.add((Component)btnpanel, "South");
        this.add(panel);
        btnplot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataSetManipulator.this.doPlot();
            }
        });
        btnclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataSetManipulator.this.dispose();
            }
        });
    }

    private void doPlot() {
        Vector plotprops = new Vector();
        AxisSelectionPanel[] axisx = this.plot.getAxisX();
        AxisSelectionPanel[] axisy = this.plot.getAxisY();
        if (axisx == null || axisx.length == 0) {
            this.logger.error((Object)"no data.");
            return;
        }
        for (int i = 0; i < axisx.length; ++i) {
            int k;
            int j;
            DataSetElement[][] dxa = axisx[i].getDataSetElements();
            String[] axisxnames = axisx[i].getNames();
            DataSetElement[][] dy = axisy[i].getDataSetElements();
            String[] axisynames = axisy[i].getNames();
            if (dxa == null || dy == null || dxa.length == 0 || dy.length == 0 || dxa[0].length == 0 || dy[0].length == 0) {
                this.logger.error((Object)("no data for plot " + i));
                return;
            }
            DataSetElement dx = dxa[0][0];
            String axisxname = axisxnames[0];
            this.props.setTitle(dx.getParent().getName());
            DataSetCollection coll = new DataSetCollection(this.plot.getPlotTitle(i));
            coll.initData();
            int count = axisynames.length;
            if (count > axisxnames.length) {
                for (j = 0; j < count; ++j) {
                    coll.setRangeAxisName(j, axisynames[j]);
                    coll.setDomainAxisName(j, axisxname);
                    coll.setDomain(j, dx);
                    for (k = 0; k < dy[j].length; ++k) {
                        coll.addRange(j, dy[j][k]);
                    }
                }
            } else {
                for (j = 0; j < axisxnames.length; ++j) {
                    coll.setRangeAxisName(j, axisynames[0]);
                    coll.setDomainAxisName(j, axisxnames[j]);
                    coll.setDomain(j, dxa[j][0]);
                    for (k = 0; k < dy[0].length; ++k) {
                        coll.addRange(j, dy[0][k]);
                    }
                }
            }
            SubPlotProperties spp = this.props.getSubPlotPropertiesAt(i);
            spp.setDataSetCollection(coll);
            if (axisy[i].getAxisCount() >= 2) {
                spp.setMultipleAxisType(SubPlotProperties.MULTIPLE_AXIS_Y);
                continue;
            }
            if (axisx[i].getAxisCount() < 2) continue;
            spp.setMultipleAxisType(SubPlotProperties.MULTIPLE_AXIS_X);
        }
        GraphPanel gpanel = new GraphPanel("graph", this.props);
        gpanel.display();
    }

    void changeAxisState(AxisSelectionPanel p, int numaxis) {
        boolean enable = false;
        if (numaxis <= 1) {
            enable = true;
        }
        if (p == this.browserX.getAxisPanel()) {
            this.browserY.getAxisPanel().enableAxisManipulation(enable);
        } else if (p == this.browserY.getAxisPanel()) {
            this.browserX.getAxisPanel().enableAxisManipulation(enable);
        }
    }

    class AxisSelectionPanel
    extends JPanel {
        private Logger logger = Logger.getLogger((String)AxisSelectionPanel.class.getName());
        public static final String AXIS_TYPE_DOMAIN = "domain";
        public static final String AXIS_TYPE_RANGE = "range";
        private String axisType;
        private JComboBox selector;
        private int selectionType = 0;
        private JList listofaxis;
        private DefaultListModel listModel;
        private JTextField newaxisTextField;
        private JPanel plistOfData = new JPanel();
        private Vector listOfData = new Vector();
        private String ID = "";
        private JButton button;
        private JButton buttonrem;

        public AxisSelectionPanel(String axisType, String ID) {
            this.axisType = axisType;
            this.ID = ID;
            this.selectionType = axisType.equals(AXIS_TYPE_RANGE) ? 2 : 0;
            this.init();
        }

        void enableAxisManipulation(boolean enable) {
            this.button.setEnabled(enable);
            this.buttonrem.setEnabled(enable);
            this.newaxisTextField.setEnabled(enable);
        }

        String getID() {
            return this.ID;
        }

        JList getList() {
            return this.listofaxis;
        }

        int getAxisCount() {
            return this.selector.getItemCount();
        }

        private void init() {
            this.setLayout(new BoxLayout(this, 1));
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.fill = 2;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            this.selector = new JComboBox<String>(new String[]{this.axisType + "-axis"});
            this.plistOfData = new JPanel();
            this.plistOfData.setBorder(new TitledBorder("list of data"));
            this.plistOfData.setLayout(new BoxLayout(this.plistOfData, 0));
            ListOfData list = new ListOfData(this.selectionType);
            this.listOfData.addElement(list);
            this.listModel = new DefaultListModel();
            constraints.gridy = 1;
            this.plistOfData.add(list);
            this.add((Component)this.plistOfData, constraints);
            constraints.gridy = 2;
            JPanel newaxispanel = new JPanel();
            newaxispanel.setLayout(new BoxLayout(newaxispanel, 0));
            newaxispanel.setBorder(new TitledBorder("manipulate axis"));
            this.button = new JButton("create");
            this.buttonrem = new JButton("remove");
            this.newaxisTextField = new JTextField(10);
            newaxispanel.add(this.selector);
            newaxispanel.add(this.newaxisTextField);
            newaxispanel.add(this.button);
            newaxispanel.add(this.buttonrem);
            this.add((Component)newaxispanel, constraints);
            this.selector.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AxisSelectionPanel.this.selectList();
                }
            });
            this.button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AxisSelectionPanel.this.createNewAxis();
                }
            });
            this.buttonrem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AxisSelectionPanel.this.removeSelectedAxis();
                }
            });
        }

        public DataSetElement[][] getDataSetElements() {
            Vector<DataSetElement[]> retVec = new Vector<DataSetElement[]>();
            for (int i = 0; i < this.selector.getItemCount(); ++i) {
                DataSetElement[] dse = ((ListOfData)this.listOfData.get(i)).getData();
                retVec.addElement(dse);
            }
            if (retVec.size() == 0) {
                return null;
            }
            DataSetElement[][] ret = new DataSetElement[retVec.size()][];
            retVec.copyInto((Object[])ret);
            return ret;
        }

        public String[] getNames() {
            String[] ret = new String[this.selector.getItemCount()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.selector.getItemAt(i).toString();
            }
            return ret;
        }

        public void addData(DataSetElement data) {
            ListOfData list = this.getSelectedList();
            list.addNewData(data);
        }

        public void removeSelectedData() {
            ListOfData list = this.getSelectedList();
            list.removeSelectedData();
        }

        public DataSetElement[] getData() {
            ListOfData list = this.getSelectedList();
            return list.getData();
        }

        private ListOfData getSelectedList() {
            int indx = this.selector.getSelectedIndex();
            if (indx >= this.listOfData.size() || indx < 0) {
                this.logger.error((Object)"something is wrong!");
                return null;
            }
            return (ListOfData)this.listOfData.get(indx);
        }

        private void selectList() {
            int indx = this.selector.getSelectedIndex();
            if (indx < 0 || indx > this.listOfData.size()) {
                return;
            }
            if (indx >= this.listOfData.size() - 1) {
                ListOfData listofdata = new ListOfData(this.selectionType);
                this.listOfData.addElement(listofdata);
            }
            ListOfData list = (ListOfData)this.listOfData.get(indx);
            this.plistOfData.removeAll();
            this.plistOfData.setBorder(new TitledBorder("list of data"));
            this.plistOfData.setLayout(new BoxLayout(this.plistOfData, 0));
            this.plistOfData.add(list);
        }

        private void createNewAxis() {
            String newAxisName = this.newaxisTextField.getText();
            for (int i = 0; i < this.selector.getItemCount(); ++i) {
                if (!this.selector.getItemAt(i).toString().equals(newAxisName)) continue;
                this.logger.warn((Object)"duplicate axis name.");
            }
            if (newAxisName == null || newAxisName.trim().length() == 0) {
                newAxisName = this.selector.getItemAt(0).toString() + String.valueOf(this.selector.getItemCount());
            }
            this.selector.addItem(newAxisName);
            this.selector.setSelectedItem(newAxisName);
            DataSetManipulator.this.manipulator.changeAxisState(this, this.selector.getItemCount());
        }

        private void removeSelectedAxis() {
            if (this.selector.getItemCount() == 1) {
                this.logger.warn((Object)"you need at least one axis.");
                return;
            }
            Object sele = this.selector.getSelectedItem();
            this.selector.removeItem(sele);
            DataSetManipulator.this.manipulator.changeAxisState(this, this.selector.getItemCount());
        }

        class ListOfData
        extends JScrollPane {
            private Logger logger = Logger.getLogger((String)ListOfData.class.getName());
            private JList listofdata;
            private DefaultListModel listModel;
            private int selectionType;
            private Vector dataVector = new Vector();

            protected ListOfData(int selectionType) {
                this.setPreferredSize(new Dimension(400, 150));
                this.selectionType = selectionType;
                this.init();
            }

            private void init() {
                this.listModel = new DefaultListModel();
                this.listofdata = new JList(this.listModel);
                this.viewport.add(this.listofdata);
            }

            void addNewData(DataSetElement data) {
                if (this.selectionType == 0) {
                    this.logger.debug((Object)"SINGLE_SELECTION");
                    this.listModel.removeAllElements();
                } else {
                    this.logger.debug((Object)"MULTIPLE_SELECTION");
                }
                String listString = "data set: " + data.getParent().getName() + " element: " + data.toString();
                for (int i = 0; i < this.listModel.size(); ++i) {
                    String comp = this.listModel.get(i).toString();
                    if (!comp.equals(listString)) continue;
                    this.logger.warn((Object)"duplicate data");
                    return;
                }
                this.listModel.addElement("data set: " + data.getParent().getName() + " element: " + data);
                this.dataVector.addElement(data);
                this.listofdata.revalidate();
            }

            void removeSelectedData() {
                int i;
                Object[] sele = this.listofdata.getSelectedValues();
                int[] indeces = this.listofdata.getSelectedIndices();
                if (sele == null) {
                    return;
                }
                for (i = sele.length - 1; i >= 0; --i) {
                    this.listModel.removeElement(sele[i]);
                }
                for (i = indeces.length - 1; i >= 0; --i) {
                    this.dataVector.removeElementAt(indeces[i]);
                }
                this.listofdata.revalidate();
            }

            DataSetElement[] getData() {
                int size = this.listModel.getSize();
                if (size <= 0) {
                    return null;
                }
                DataSetElement[] ele = new DataSetElement[size];
                for (int i = 0; i < size; ++i) {
                    ele[i] = (DataSetElement)this.dataVector.get(i);
                }
                return ele;
            }
        }
    }

    class DataSetBrowser
    extends JPanel {
        private Logger logger = Logger.getLogger((String)DataSetBrowser.class.getName());
        private int treeSelectionMode = 4;
        private String title;
        private DataSet[] dset;
        private DataSetTree tree;
        private AxisSelectionPanel axis;
        private DataSetBrowser browser;
        private String axis_type;

        public DataSetBrowser(String title, DataSet[] dset) {
            this.title = title;
            this.dset = dset;
            this.init();
        }

        public DataSetBrowser(String title, DataSet[] dset, int selectionMode) {
            this.title = title;
            this.dset = dset;
            this.treeSelectionMode = selectionMode;
            this.init();
        }

        public DataSetElement[][] getDataSetElements() {
            return this.axis.getDataSetElements();
        }

        public String[] getNames() {
            return this.axis.getNames();
        }

        private void init() {
            this.setLayout(new BoxLayout(this, 1));
            this.tree = new DataSetTree(this.title, this.dset, this.treeSelectionMode);
            ImageIcon iconreg = new ImageIcon(this.getClass().getResource("/org/javalobby/icons/20x20/Down.gif"));
            JButton btndown = new JButton(iconreg);
            ImageIcon icondel = new ImageIcon(this.getClass().getResource("/org/javalobby/icons/20x20/Delete.gif"));
            JButton btndele = new JButton(icondel);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            panel.add(btndown);
            panel.add(btndele);
            this.add(this.tree);
            this.add(panel);
            btndown.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DataSetElement[] data = DataSetBrowser.this.tree.getSelectedDataSetElement();
                    if (data == null || data.length == 0) {
                        return;
                    }
                    for (int i = 0; i < data.length; ++i) {
                        DataSetBrowser.this.axis.addData(data[i]);
                    }
                }
            });
            btndele.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DataSetBrowser.this.axis.removeSelectedData();
                }
            });
        }

        AxisSelectionPanel getAxisPanel() {
            return this.axis;
        }

        void setAxisPanel(AxisSelectionPanel ax) {
            int n = this.getComponentCount();
            for (int i = n - 1; i >= 0; --i) {
                Component comp = this.getComponent(i);
                if (!(comp instanceof AxisSelectionPanel)) continue;
                this.remove(comp);
            }
            this.axis = ax;
            this.add(ax);
            this.revalidate();
        }
    }

    class DataSetTree
    extends JPanel {
        private Logger logger = Logger.getLogger((String)DataSetTree.class.getName());
        private DataSet[] dset;
        private JTree tree;
        private DefaultTreeModel treeModel;
        private int selectionMode = 4;

        public DataSetTree(String title, DataSet[] dset) {
            this.dset = dset;
            this.setBorder(new TitledBorder(title));
            this.init();
            this.createGUI();
        }

        public DataSetTree(String title, DataSet[] dset, int selectionMode) {
            this.dset = dset;
            this.selectionMode = selectionMode;
            this.setBorder(new TitledBorder(title));
            this.init();
            this.createGUI();
        }

        private void init() {
            if (this.dset == null || this.dset.length == 0) {
                return;
            }
            DataSetBrowserNode rootNode = new DataSetBrowserNode("data set");
            this.treeModel = new DefaultTreeModel(rootNode);
            for (int i = 0; i < this.dset.length; ++i) {
                DataSetBrowserNode dsetNode = new DataSetBrowserNode(this.dset[i]);
                rootNode.add(dsetNode);
                DataSetElement[] dsetElement = this.dset[i].getData();
                if (dsetElement == null || dsetElement.length == 0) continue;
                for (int j = 0; j < dsetElement.length; ++j) {
                    DataSetBrowserNode dsetENode = new DataSetBrowserNode(dsetElement[j]);
                    dsetNode.add(dsetENode);
                }
            }
            this.tree = new JTree(this.treeModel);
            this.tree.setCellRenderer(new DataSetBrowserRenderer());
            this.tree.getSelectionModel().setSelectionMode(this.selectionMode);
        }

        private void createGUI() {
            this.setLayout(new BoxLayout(this, 1));
            JScrollPane scr = new JScrollPane();
            scr.setPreferredSize(new Dimension(400, 150));
            scr.setSize(scr.getPreferredSize());
            scr.getViewport().setView(this.tree);
            this.add(scr);
        }

        public JTree getTree() {
            return this.tree;
        }

        public DataSetElement[] getSelectedDataSetElement() {
            Object[] ret = null;
            TreePath[] path = this.tree.getSelectionPaths();
            if (path == null || path.length == 0) {
                this.logger.warn((Object)"no selection.");
                return null;
            }
            Vector<DataSetElement> dsetVector = new Vector<DataSetElement>();
            for (int i = 0; i < path.length; ++i) {
                DataSetElement dse;
                DataSetBrowserNode node = (DataSetBrowserNode)path[i].getLastPathComponent();
                if (!node.isLeaf() || (dse = node.getDataSetElement()) == null) continue;
                dsetVector.addElement(dse);
            }
            if (dsetVector.size() == 0) {
                this.logger.warn((Object)"no data selected.");
                return null;
            }
            ret = new DataSetElement[dsetVector.size()];
            dsetVector.copyInto(ret);
            return ret;
        }

        class DataSetBrowserRenderer
        extends DefaultTreeCellRenderer {
            DataSetBrowserRenderer() {
            }

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                return super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
            }
        }

        class DataSetBrowserNode
        extends DefaultMutableTreeNode {
            DataSetBrowserNode() {
            }

            DataSetBrowserNode(Object obj) {
                super(obj);
            }

            DataSetBrowserNode(Object obj, boolean allowChild) {
                super(obj, allowChild);
            }

            DataSetElement getDataSetElement() {
                if (this.userObject instanceof DataSetElement) {
                    return (DataSetElement)this.userObject;
                }
                return null;
            }
        }
    }

    class PlotSelectionPanel
    extends JPanel {
        private Logger logger = Logger.getLogger((String)PlotSelectionPanel.class.getName());
        private JComboBox plotSelector;
        private JTextField tfnewplot;
        private Vector plotProperties = new Vector();
        private Vector axisxCache = new Vector();
        private Vector axisyCache = new Vector();

        public PlotSelectionPanel(String title) {
            JPanel pplot = new JPanel();
            pplot.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            String axis_type = "range";
            pplot.setBorder(new TitledBorder("manipulate plot"));
            pplot.setLayout(new BoxLayout(pplot, 0));
            this.plotSelector = new JComboBox<String>(new String[]{title});
            SubPlotProperties spp = new SubPlotProperties();
            DataSetManipulator.this.props.addSubPlotProperties(spp);
            this.tfnewplot = new JTextField(10);
            JButton btnnewplot = new JButton("create plot");
            JButton btnremplot = new JButton("remove plot");
            JButton btneditConfig = new JButton("edit configuration");
            pplot.add((Component)this.plotSelector, gc);
            pplot.add((Component)this.tfnewplot, gc);
            pplot.add((Component)btnnewplot, gc);
            pplot.add(btnremplot);
            pplot.add((Component)btneditConfig, gc);
            this.add(pplot);
            btnnewplot.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlotSelectionPanel.this.newPlot();
                }
            });
            btnremplot.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlotSelectionPanel.this.removePlot();
                }
            });
            this.plotSelector.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlotSelectionPanel.this.plotSelected();
                }
            });
            btneditConfig.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlotPropertiesEditor editor = new PlotPropertiesEditor(PlotSelectionPanel.this.plotSelector.getSelectedItem().toString(), DataSetManipulator.this.props, PlotSelectionPanel.this.plotSelector.getSelectedIndex());
                }
            });
            this.plotSelector.setSelectedIndex(0);
        }

        private void newPlot() {
            String newplotName = this.tfnewplot.getText();
            for (int i = 0; i < this.plotSelector.getItemCount(); ++i) {
                if (!this.plotSelector.getItemAt(i).toString().equals(newplotName)) continue;
                this.logger.warn((Object)"duplicate plot name.");
            }
            if (newplotName == null || newplotName.trim().length() == 0) {
                newplotName = this.plotSelector.getItemAt(0).toString() + String.valueOf(this.plotSelector.getItemCount());
            }
            this.plotSelector.addItem(newplotName);
            this.plotSelector.setSelectedItem(newplotName);
            SubPlotProperties spp = new SubPlotProperties();
            DataSetManipulator.this.props.addSubPlotProperties(spp);
        }

        private void removePlot() {
            if (this.plotSelector.getItemCount() == 1) {
                this.logger.warn((Object)"you need at least one plot.");
                return;
            }
            int remind = this.plotSelector.getSelectedIndex();
            SubPlotProperties spp = DataSetManipulator.this.props.getSubPlotPropertiesAt(remind);
            DataSetManipulator.this.props.removeSubPlotProperty(spp);
            Object ox = this.axisxCache.get(remind);
            this.axisxCache.remove(ox);
            Object oy = this.axisyCache.get(remind);
            this.axisyCache.remove(oy);
            Object o = this.plotSelector.getSelectedItem();
            this.plotSelector.removeItem(o);
        }

        private void plotSelected() {
            String ID = this.plotSelector.getSelectedItem().toString();
            AxisSelectionPanel axisx = null;
            AxisSelectionPanel axisy = null;
            for (int i = 0; i < this.axisxCache.size(); ++i) {
                if (!((AxisSelectionPanel)this.axisxCache.get(i)).getID().equals(ID)) continue;
                axisx = (AxisSelectionPanel)this.axisxCache.get(i);
                axisy = (AxisSelectionPanel)this.axisyCache.get(i);
                break;
            }
            if (axisx == null) {
                axisx = new AxisSelectionPanel("domain", ID);
                axisy = new AxisSelectionPanel("range", ID);
                this.axisxCache.addElement(axisx);
                this.axisyCache.addElement(axisy);
            }
            DataSetManipulator.this.browserX.setAxisPanel(axisx);
            DataSetManipulator.this.browserY.setAxisPanel(axisy);
            DataSetManipulator.this.manipulator.revalidate();
        }

        AxisSelectionPanel[] getAxisX() {
            return this.getArrayFrom(this.axisxCache);
        }

        AxisSelectionPanel[] getAxisY() {
            return this.getArrayFrom(this.axisyCache);
        }

        String getPlotTitle(int i) {
            return this.plotSelector.getItemAt(i).toString();
        }

        private AxisSelectionPanel[] getArrayFrom(Vector vec) {
            if (vec == null || vec.size() == 0) {
                return null;
            }
            Object[] p = new AxisSelectionPanel[vec.size()];
            vec.copyInto(p);
            return p;
        }
    }
}

