/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.common;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import jp.advancesoft.chase.common.MyMessageBox;
import jp.advancesoft.chase.common.MyThread;
import jp.advancesoft.chase.common.Utils;
import jp.advancesoft.chase.settings.GlobalProperties;
import jp.advancesoft.chase.settings.PropertiesManager;

public class LocalScriptExecuter {
    public static final int PHASE = 0;
    public static final int EKCAL = 1;
    public static final int CIAO = 2;
    public static final int ABCAP = 3;
    private final String LS = System.getProperty("line.separator");
    private final String FS = System.getProperty("file.separator");
    private final String submitSh = "submit.sh";
    private final String submitBat = "submit.bat";
    private final String whiteSpace = " ";
    private int scriptType = -1;
    private int np;
    private int ne;
    private int nk;
    private String projDir;
    private MyMessageBox mbox = new MyMessageBox();
    private boolean isWindows = false;

    public LocalScriptExecuter() {
        this.isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public LocalScriptExecuter(int scriptType) {
        this.scriptType = scriptType;
        this.isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public LocalScriptExecuter(int scriptType, boolean isWindows) {
        this.scriptType = scriptType;
        this.isWindows = isWindows;
    }

    public void setScriptType(int scriptType) {
        this.scriptType = scriptType;
    }

    public void setMPIParams(int np) {
        this.np = np;
    }

    public void setMPIParamsPhase(int ne, int nk) {
        this.ne = ne;
        this.nk = nk;
    }

    public void setProjDir(String projDir) {
        this.projDir = projDir;
        if (!projDir.trim().endsWith(System.getProperty("file.separator"))) {
            projDir = projDir + System.getProperty("file.separator");
        }
    }

    public boolean execute() throws Exception {
        return this.executeScript();
    }

    private boolean executeScript() throws Exception {
        GlobalProperties prop = PropertiesManager.getGlobalProperties(0);
        boolean bret = true;
        String exePath = new String();
        if (this.scriptType == 0) {
            exePath = System.getProperty("chase.home") + this.FS + prop.getProperty("phasedir") + this.FS + "phase";
        } else if (this.scriptType == 1) {
            exePath = System.getProperty("chase.home") + this.FS + prop.getProperty("ekcaldir") + this.FS + "ekcal";
        }
        if (this.isWindows) {
            exePath = exePath + ".exe";
        }
        String check = " ... check Preferences -> program paths";
        if (exePath == null) {
            this.mbox.setText("could not find executable file " + check);
            return false;
        }
        if (!new File(exePath).exists()) {
            this.mbox.setText("could not find " + exePath + check);
            return false;
        }
        exePath = Utils.getPathDQ(exePath);
        String mpirunPath = "";
        String nee = "";
        String nke = "";
        String npe = "";
        if (Boolean.valueOf(prop.getProperty("mpienable")).booleanValue() && !this.isWindows) {
            mpirunPath = prop.getProperty("mpirunpath");
            if (mpirunPath == null) {
                this.mbox.setText("could not find mpirun " + check);
                return false;
            }
            if (!new File(mpirunPath).exists()) {
                this.mbox.setText("could not find mpirun " + check);
                return false;
            }
            mpirunPath = Utils.getPathDQ(mpirunPath);
            nee = "ne=" + this.ne;
            nke = "nk=" + this.nk;
            npe = "-np " + this.np;
        }
        String exeString = "";
        String submit = new String();
        if (!this.projDir.endsWith(this.FS)) {
            this.projDir = this.projDir + this.FS;
        }
        if (this.isWindows) {
            submit = this.projDir + "submit.bat";
        } else {
            submit = this.projDir + "submit.sh";
            exeString = "#!/bin/sh" + this.LS;
        }
        exeString = exeString + "cd " + Utils.getPathDQ(this.projDir) + this.LS;
        if (this.isWindows) {
            exeString = exeString + "cmd.exe /c " + exePath + " ";
            exeString = exeString + "> Log &";
        } else if (this.scriptType == 0) {
            exeString = exeString + mpirunPath + " " + npe + " ";
            exeString = exeString + exePath + " " + nee + " " + nke + " ";
            exeString = exeString + ">& errLog &" + this.LS;
        } else if (this.scriptType == 1) {
            exeString = exeString + mpirunPath + " " + exePath + ">& errLog &" + this.LS;
        }
        FileWriter fwriter = new FileWriter(submit);
        BufferedWriter bwriter = new BufferedWriter(fwriter);
        bwriter.write(exeString, 0, exeString.length());
        bwriter.flush();
        fwriter.close();
        if (!this.isWindows) {
            Process process = Runtime.getRuntime().exec("chmod 744 " + submit);
            process.waitFor();
        }
        MyThread thread = new MyThread(Utils.getPathDQ(submit));
        return bret;
    }
}

