/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.atomcoord;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import jp.advancesoft.chase.atomcoord.Atom;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import jp.advancesoft.chase.atomcoord.Cell;
import jp.advancesoft.chase.common.TaggedString;
import org.apache.log4j.Logger;

public class Nfdynm2AtomCoords {
    private static Logger logger = Logger.getLogger((String)Nfdynm2AtomCoords.class.getName());
    public static final int OFF = 0;
    public static final int ON = 1;
    private String fileName;
    private final String HASH = "#";
    private final String SPACE = "[\\s]+";
    private String[] avec = new String[3];
    private String[] bvec = new String[3];
    private String[] cvec = new String[3];
    private int NTyp = 1;
    private int NAtom = 1;
    private int NAtomNow = 0;
    private Vector atomSpecies = new Vector();
    private Vector speciesName = new Vector();
    private AtomCoords coords;
    private Cell cell;
    private int cellCount = 0;
    private Vector frames = new Vector();
    private int periodic = 0;
    private int natm0 = 0;

    public Nfdynm2AtomCoords(String fileName) {
        this.fileName = fileName;
        this.coords = new AtomCoords();
        this.coords.isCart(true);
        this.coords.setUnit(1);
        logger.debug((Object)("num frames: " + this.frames.size()));
    }

    public Nfdynm2AtomCoords(String fileName, int periodic) {
        this.fileName = fileName;
        this.coords = new AtomCoords();
        this.coords.isCart(true);
        this.coords.setUnit(1);
        this.periodic = periodic;
        logger.debug((Object)("num frames: " + this.frames.size()));
    }

    private void parse() {
        this.frames = new Vector();
        FileReader freader = null;
        try {
            int line = 0;
            freader = new FileReader(this.fileName);
            BufferedReader breader = new BufferedReader(freader);
            String str = new String();
            while ((str = breader.readLine()) != null) {
                ++line;
                if (this.parseString(str)) continue;
                logger.warn((Object)("failed parse at line: " + line));
            }
            freader.close();
        }
        catch (IOException e) {
            logger.warn((Object)("failed read from file " + this.fileName));
        }
    }

    private boolean parseString(String str) {
        if (str.trim().startsWith("#")) {
            return this.parseHeader(str.trim());
        }
        if (str.trim().startsWith("cps")) {
            return true;
        }
        return this.parseData(str.trim());
    }

    private boolean parseHeader(String str) {
        char[] cha = str.toCharArray();
        String data = new String();
        for (int i = 1; i < cha.length; ++i) {
            data = data + String.valueOf(cha[i]);
        }
        if ((data = data.trim()).startsWith("a_vector") || data.startsWith("b_vector") || data.startsWith("c_vector")) {
            int i;
            String[] vec = data.split("=");
            if (vec.length <= 1) {
                logger.warn((Object)"invalid cell data");
                return false;
            }
            String vector = vec[1].trim();
            String[] vals = vector.split("[\\s]+");
            if (vals.length <= 2) {
                logger.warn((Object)"invalid cell data");
                return false;
            }
            for (i = 0; i < 3; ++i) {
                vals[i] = vals[i].trim();
            }
            logger.debug((Object)("got cell vector: " + vals[0] + " " + vals[1] + " " + vals[2]));
            try {
                for (i = 0; i < 3; ++i) {
                    Double.parseDouble(vals[i]);
                }
            }
            catch (NumberFormatException nfe) {
                logger.warn((Object)"cell vector is not a number");
                return false;
            }
            if (data.startsWith("a_vector")) {
                for (i = 0; i < 3; ++i) {
                    this.avec[i] = vals[i];
                    ++this.cellCount;
                }
            } else if (data.startsWith("b_vector")) {
                for (i = 0; i < 3; ++i) {
                    this.bvec[i] = vals[i];
                    ++this.cellCount;
                }
            } else if (data.startsWith("c_vector")) {
                for (i = 0; i < 3; ++i) {
                    this.cvec[i] = vals[i];
                    ++this.cellCount;
                }
            }
            if (this.cellCount == 3) {
                this.cell = new Cell(this.avec, this.bvec, this.cvec);
                this.coords.setCell(this.cell);
            }
            return true;
        }
        if (data.startsWith("ntyp")) {
            String[] ntyp = data.split("=");
            if (ntyp.length <= 2) {
                logger.warn((Object)"invalid specification for ntyp and/or natm");
                return false;
            }
            String nty = ntyp[1].trim();
            String[] nt = nty.split("[\\s]+");
            if (nt.length <= 1) {
                logger.warn((Object)"invalid specification for ntyp and/or natm");
                return false;
            }
            try {
                this.NTyp = Integer.parseInt(nt[0].trim());
                this.NAtom = Integer.parseInt(ntyp[2].trim());
            }
            catch (NumberFormatException nfe) {
                logger.warn((Object)"either ntyp or natm was not a number");
                return false;
            }
            logger.debug((Object)("ntyp: " + this.NTyp + " natm: " + this.NAtom));
            return true;
        }
        if (data.startsWith("(natm->type)")) {
            int i;
            String[] species = data.split("[\\s]+");
            if (species.length <= 1) {
                logger.warn((Object)"no specification for atom species");
                return false;
            }
            for (i = 1; i < species.length; ++i) {
                this.atomSpecies.addElement(species[i]);
            }
            for (i = 0; i < this.atomSpecies.size(); ++i) {
                logger.debug((Object)("species for atom " + i + " is " + this.atomSpecies.get(i)));
            }
            return true;
        }
        if (data.startsWith("(speciesname)")) {
            String[] names = data.split("[\\s]+");
            if (names.length <= 3) {
                logger.warn((Object)"invalid specification for species name");
                return false;
            }
            String tag = names[1];
            String value = names[3];
            logger.debug((Object)("tag & value for species: " + tag + " " + value));
            TaggedString ts = new TaggedString(tag, value);
            this.speciesName.addElement(ts);
            return true;
        }
        return true;
    }

    private boolean parseData(String str) {
        ++this.NAtomNow;
        String[] data = str.split("[\\s]+");
        if (data.length <= 4) {
            logger.warn((Object)"invalid data");
            return false;
        }
        String[] xyz = new String[3];
        String type = new String();
        try {
            int index = Integer.parseInt(data[0].trim()) - 1;
            type = (String)this.atomSpecies.get(index);
        }
        catch (NumberFormatException nfe) {
            logger.warn((Object)"found a non-numeric index");
            return false;
        }
        String elementName = this.getElementName(type);
        if (elementName == null) {
            logger.warn((Object)"inconsistentcy found among species name and data");
            return false;
        }
        try {
            for (int i = 1; i < 4; ++i) {
                Double.parseDouble(data[i].trim());
            }
        }
        catch (NumberFormatException nfe) {
            logger.warn((Object)"xyz-data is not a number");
            return false;
        }
        xyz[0] = data[1].trim();
        xyz[1] = data[2].trim();
        xyz[2] = data[3].trim();
        String[] force = new String[3];
        if (data.length >= 7) {
            force[0] = data[4].trim();
            force[1] = data[5].trim();
            force[2] = data[6].trim();
        }
        logger.debug((Object)("got data for atom no. " + this.NAtomNow + " : " + elementName + " " + xyz[0] + " " + xyz[1] + " " + xyz[2]));
        Atom atom = new Atom(elementName, xyz, force);
        this.coords.getAtomList().addAtom(atom);
        if (this.NAtomNow == this.NAtom) {
            this.NAtomNow = 0;
            this.coords.convert(6, 8);
            this.frames.addElement(this.coords);
            this.coords = new AtomCoords();
            this.coords.setUnit(1);
            this.coords.isCart(true);
            this.coords.setCell(this.cell);
        }
        return true;
    }

    private String getElementName(String type) {
        int numSpecies = this.speciesName.size();
        for (int i = 0; i < numSpecies; ++i) {
            TaggedString ts = (TaggedString)this.speciesName.get(i);
            if (!ts.getTag().trim().equals(type.trim())) continue;
            return ts.getValue();
        }
        return null;
    }

    public Vector getFrameAt(int i) {
        if (this.frames == null || this.frames.size() == 0) {
            this.parse();
        }
        int framenum = i;
        if (this.frames.size() <= i) {
            framenum = this.frames.size() - 1;
        }
        Vector ret = new Vector();
        ret.addElement(this.frames.elementAt(framenum));
        return ret;
    }

    public Vector getFrames() {
        if (this.frames == null || this.frames.size() == 0) {
            this.parse();
        }
        return this.frames;
    }

    public int getNumFrames() {
        if (this.frames == null || this.frames.size() == 0) {
            this.parse();
        }
        return this.frames.size();
    }
}

