/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.atomcoord;

import org.apache.log4j.Logger;

public class ChargeDensity {
    private Logger logger = Logger.getLogger((String)ChargeDensity.class.getName());
    private float[] density;
    private int[] ndiv;
    private float[][] delta;
    private float[] origin;
    private int Ntot;

    public ChargeDensity(float[] density, int[] ndiv, float[][] delta, float[] origin) {
        this.density = density;
        this.ndiv = ndiv;
        this.delta = delta;
        this.origin = origin;
        this.Ntot = ndiv[0] * ndiv[1] * ndiv[2];
    }

    public int[] getNumDiv() {
        return this.ndiv;
    }

    public float[] getDensity() {
        return this.density;
    }

    public float getDensityAt(int i) {
        return this.density[i];
    }

    public float[][] getCoordinates() {
        float[][] ret = new float[3][this.Ntot];
        for (int i = 0; i < this.ndiv[2]; ++i) {
            for (int j = 0; j < this.ndiv[1]; ++j) {
                for (int k = 0; k < this.ndiv[0]; ++k) {
                    int n = i + j * this.ndiv[2] + k * this.ndiv[2] * this.ndiv[1];
                    ret[0][n] = (float)k * this.delta[0][0] + (float)j * this.delta[1][0] + (float)i * this.delta[2][0];
                    ret[1][n] = (float)k * this.delta[0][1] + (float)j * this.delta[1][1] + (float)i * this.delta[2][1];
                    ret[2][n] = (float)k * this.delta[0][2] + (float)j * this.delta[1][2] + (float)i * this.delta[2][2];
                }
            }
        }
        return ret;
    }

    private int[] get3DIndexFrom1DIndex(int index1d) {
        int nz = index1d % this.ndiv[2];
        int ny = (index1d - nz) / this.ndiv[2] % this.ndiv[1];
        int nx = ((index1d - nz) / this.ndiv[2] - ny) / this.ndiv[1];
        return new int[]{nx, ny, nz};
    }

    private float[] getCoordinatesFrom(int[] index) {
        float[] ret = new float[3];
        for (int i = 0; i < 3; ++i) {
            ret[i] = 0.0f;
            for (int j = 0; j < 3; ++j) {
                int n = i;
                ret[n] = ret[n] + (float)index[j] * this.delta[j][i];
            }
            int n = i;
            ret[n] = ret[n] + this.origin[i];
        }
        return ret;
    }

    private float[] getCoordinatesFrom(int index) {
        return this.getCoordinatesFrom(this.get3DIndexFrom1DIndex(index));
    }
}

