/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer.scenegraphelements;

import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3f;
import jp.advancesoft.chase.common.Utils;

class Arc
extends Shape3D {
    protected Arc(double[] a, double[] b, double[] center) {
        this.createArc(a, b, center);
    }

    private void createArc(double[] a, double[] b, double[] center) {
        float resolution = 100.0f;
        float invresolution = 1.0f / resolution;
        int length = (int)resolution;
        double[] bma = new double[]{b[0] - a[0], b[1] - a[1], b[2] - a[2]};
        double[] amc = new double[]{a[0] - center[0], a[1] - center[1], a[2] - center[2]};
        double radius = Utils.getNorm(amc);
        double[] oap = new double[3];
        double[][] point = new double[length][3];
        for (int i = 0; i < length; ++i) {
            int j;
            for (j = 0; j < 3; ++j) {
                double tmp = bma[j] * (double)invresolution * (double)i + a[j];
                oap[j] = tmp - center[j];
            }
            Utils.normalize(oap);
            for (j = 0; j < 3; ++j) {
                point[i][j] = oap[j] * radius + center[j];
            }
        }
        Appearance appearance = new Appearance();
        appearance.setColoringAttributes(new ColoringAttributes(0.9f, 0.9f, 0.5f, 1));
        LineAttributes lineAttrib = new LineAttributes();
        lineAttrib.setLineWidth(5.0f);
        lineAttrib.setLinePattern(1);
        appearance.setLineAttributes(lineAttrib);
        LineStripArray lsa = new LineStripArray(length, 1, new int[]{length});
        Point3f pt = new Point3f();
        for (int i = 0; i < length; ++i) {
            pt.x = (float)point[i][0];
            pt.y = (float)point[i][1];
            pt.z = (float)point[i][2];
            lsa.setCoordinate(i, pt);
        }
        this.setAppearance(appearance);
        this.setGeometry((Geometry)lsa);
    }
}

