/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.macosx.cgl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import jogamp.opengl.macosx.cgl.CGL;
import jogamp.opengl.macosx.cgl.MacOSXCGLContext;
import jogamp.opengl.macosx.cgl.MacOSXCGLDrawableFactory;

public class MacOSXCGLGraphicsConfiguration
extends MutableGraphicsConfiguration
implements Cloneable {
    static final IntBuffer cglInternalAttributeToken = Buffers.newDirectIntBuffer(new int[]{99, 73, 72, 58, 90, 5, 6, 8, 11, 12, 14, 13, 55, 56});

    MacOSXCGLGraphicsConfiguration(AbstractGraphicsScreen abstractGraphicsScreen, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2) {
        super(abstractGraphicsScreen, gLCapabilitiesImmutable, gLCapabilitiesImmutable2);
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    protected static List<GLCapabilitiesImmutable> getAvailableCapabilities(MacOSXCGLDrawableFactory macOSXCGLDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice) {
        MacOSXCGLDrawableFactory.SharedResource sharedResource = macOSXCGLDrawableFactory.getOrCreateSharedResourceImpl(abstractGraphicsDevice);
        if (null == sharedResource) {
            throw new GLException("Shared resource for device n/a: " + abstractGraphicsDevice);
        }
        return new ArrayList<GLCapabilitiesImmutable>(0);
    }

    static IntBuffer GLCapabilities2NSAttribList(AbstractGraphicsDevice abstractGraphicsDevice, IntBuffer intBuffer, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n, int n2, int n3) {
        int n4 = intBuffer.remaining();
        int n5 = intBuffer.position();
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(n4);
        block15: for (int i = 0; i < n4; ++i) {
            int n6 = intBuffer.get(i + n5);
            switch (n6) {
                case 99: {
                    intBuffer2.put(i, MacOSXCGLContext.GLProfile2CGLOGLProfileValue(abstractGraphicsDevice, n, n2, n3));
                    continue block15;
                }
                case 72: {
                    intBuffer2.put(i, gLCapabilitiesImmutable.getHardwareAccelerated() ? 1 : 0);
                    continue block15;
                }
                case 58: {
                    intBuffer2.put(i, 0);
                    continue block15;
                }
                case 90: {
                    intBuffer2.put(i, !gLCapabilitiesImmutable.isOnscreen() && gLCapabilitiesImmutable.isPBuffer() ? 1 : 0);
                    continue block15;
                }
                case 5: {
                    intBuffer2.put(i, gLCapabilitiesImmutable.getDoubleBuffered() ? 1 : 0);
                    continue block15;
                }
                case 6: {
                    intBuffer2.put(i, gLCapabilitiesImmutable.getStereo() ? 1 : 0);
                    continue block15;
                }
                case 8: {
                    intBuffer2.put(i, gLCapabilitiesImmutable.getRedBits() + gLCapabilitiesImmutable.getGreenBits() + gLCapabilitiesImmutable.getBlueBits());
                    continue block15;
                }
                case 11: {
                    intBuffer2.put(i, gLCapabilitiesImmutable.getAlphaBits());
                    continue block15;
                }
                case 12: {
                    intBuffer2.put(i, gLCapabilitiesImmutable.getDepthBits());
                    continue block15;
                }
                case 14: {
                    intBuffer2.put(i, gLCapabilitiesImmutable.getAccumRedBits() + gLCapabilitiesImmutable.getAccumGreenBits() + gLCapabilitiesImmutable.getAccumBlueBits() + gLCapabilitiesImmutable.getAccumAlphaBits());
                    continue block15;
                }
                case 13: {
                    intBuffer2.put(i, gLCapabilitiesImmutable.getStencilBits());
                    continue block15;
                }
                case 55: {
                    intBuffer2.put(i, gLCapabilitiesImmutable.getSampleBuffers() ? 1 : 0);
                    continue block15;
                }
                case 56: {
                    intBuffer2.put(i, gLCapabilitiesImmutable.getNumSamples());
                    continue block15;
                }
            }
        }
        return intBuffer2;
    }

    static long GLCapabilities2NSPixelFormat(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n, int n2, int n3) {
        IntBuffer intBuffer = cglInternalAttributeToken.duplicate();
        if (!MacOSXCGLContext.isLionOrLater) {
            intBuffer.position(1);
        }
        IntBuffer intBuffer2 = MacOSXCGLGraphicsConfiguration.GLCapabilities2NSAttribList(abstractGraphicsDevice, intBuffer, gLCapabilitiesImmutable, n, n2, n3);
        return CGL.createPixelFormat(intBuffer, intBuffer.remaining(), intBuffer2);
    }

    static GLCapabilities NSPixelFormat2GLCapabilities(GLProfile gLProfile, long l) {
        return MacOSXCGLGraphicsConfiguration.PixelFormat2GLCapabilities(gLProfile, l, true);
    }

    static long GLCapabilities2CGLPixelFormat(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, int n, int n2, int n3) {
        IntBuffer intBuffer;
        PointerBuffer pointerBuffer;
        int n4;
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(256);
        int n5 = 0;
        if (MacOSXCGLContext.isLionOrLater) {
            intBuffer2.put(n5++, 99);
            intBuffer2.put(n5++, MacOSXCGLContext.GLProfile2CGLOGLProfileValue(abstractGraphicsDevice, n, n2, n3));
        }
        if (gLCapabilitiesImmutable.getDoubleBuffered()) {
            intBuffer2.put(n5++, 5);
        }
        if (gLCapabilitiesImmutable.getStereo()) {
            intBuffer2.put(n5++, 6);
        }
        intBuffer2.put(n5++, 8);
        intBuffer2.put(n5++, gLCapabilitiesImmutable.getRedBits() + gLCapabilitiesImmutable.getGreenBits() + gLCapabilitiesImmutable.getBlueBits());
        intBuffer2.put(n5++, 11);
        intBuffer2.put(n5++, gLCapabilitiesImmutable.getAlphaBits());
        intBuffer2.put(n5++, 12);
        intBuffer2.put(n5++, gLCapabilitiesImmutable.getDepthBits());
        intBuffer2.put(n5++, 13);
        intBuffer2.put(n5++, gLCapabilitiesImmutable.getStencilBits());
        intBuffer2.put(n5++, 14);
        intBuffer2.put(n5++, gLCapabilitiesImmutable.getAccumRedBits() + gLCapabilitiesImmutable.getAccumGreenBits() + gLCapabilitiesImmutable.getAccumBlueBits() + gLCapabilitiesImmutable.getAccumAlphaBits());
        if (gLCapabilitiesImmutable.getSampleBuffers()) {
            intBuffer2.put(n5++, 55);
            intBuffer2.put(n5++, 1);
            intBuffer2.put(n5++, 56);
            intBuffer2.put(n5++, gLCapabilitiesImmutable.getNumSamples());
        }
        if ((n4 = CGL.CGLChoosePixelFormat(intBuffer2, pointerBuffer = PointerBuffer.allocateDirect(1), intBuffer = Buffers.newDirectIntBuffer(1))) != 0) {
            throw new GLException("Error code " + n4 + " while choosing pixel format");
        }
        return pointerBuffer.get(0);
    }

    static GLCapabilities CGLPixelFormat2GLCapabilities(long l) {
        return MacOSXCGLGraphicsConfiguration.PixelFormat2GLCapabilities(null, l, false);
    }

    private static GLCapabilities PixelFormat2GLCapabilities(GLProfile gLProfile, long l, boolean bl) {
        int n;
        IntBuffer intBuffer = cglInternalAttributeToken.duplicate();
        int n2 = !MacOSXCGLContext.isLionOrLater ? 1 : 0;
        intBuffer.position(n2);
        int n3 = intBuffer.remaining();
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(n3);
        if (bl) {
            CGL.queryPixelFormat(l, intBuffer, n3, intBuffer2);
        } else {
            CGL.CGLQueryPixelFormat(l, intBuffer, n3, intBuffer2);
        }
        if (null == gLProfile && MacOSXCGLContext.isLionOrLater) {
            block19: for (int i = 0; i < n3; ++i) {
                n = intBuffer2.get(i);
                if (99 != intBuffer.get(i + n2)) continue;
                switch (n) {
                    case 16640: {
                        gLProfile = GLProfile.get("GL4");
                        continue block19;
                    }
                    case 12800: {
                        gLProfile = GLProfile.get("GL3");
                        continue block19;
                    }
                    case 4096: {
                        gLProfile = GLProfile.get("GL2");
                        continue block19;
                    }
                    default: {
                        throw new RuntimeException("Unhandled OSX OpenGL Profile: 0x" + Integer.toHexString(n));
                    }
                }
            }
        }
        if (null == gLProfile) {
            gLProfile = GLProfile.get("GL2");
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        n = 0;
        block20: for (int i = 0; i < n3; ++i) {
            int n4 = intBuffer.get(i + n2);
            int n5 = intBuffer2.get(i);
            switch (n4) {
                case 73: {
                    gLCapabilities.setHardwareAccelerated(n5 != 0);
                    continue block20;
                }
                case 58: {
                    continue block20;
                }
                case 90: {
                    gLCapabilities.setPBuffer(n5 != 0);
                    continue block20;
                }
                case 5: {
                    gLCapabilities.setDoubleBuffered(n5 != 0);
                    continue block20;
                }
                case 6: {
                    gLCapabilities.setStereo(n5 != 0);
                    continue block20;
                }
                case 8: {
                    int n6 = (32 == n5 ? 24 : n5) / 3;
                    gLCapabilities.setRedBits(n6);
                    gLCapabilities.setGreenBits(n6);
                    gLCapabilities.setBlueBits(n6);
                    continue block20;
                }
                case 11: {
                    n = n5;
                    continue block20;
                }
                case 12: {
                    gLCapabilities.setDepthBits(n5);
                    continue block20;
                }
                case 14: {
                    int n6 = n5 / 4;
                    gLCapabilities.setAccumRedBits(n6);
                    gLCapabilities.setAccumGreenBits(n6);
                    gLCapabilities.setAccumBlueBits(n6);
                    gLCapabilities.setAccumAlphaBits(n6);
                    continue block20;
                }
                case 13: {
                    gLCapabilities.setStencilBits(n5);
                    continue block20;
                }
                case 55: {
                    gLCapabilities.setSampleBuffers(n5 != 0);
                    continue block20;
                }
                case 56: {
                    gLCapabilities.setNumSamples(n5);
                    continue block20;
                }
            }
        }
        gLCapabilities.setAlphaBits(n);
        return gLCapabilities;
    }
}

