/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.oculusvr;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.oculusvr.ovrDistortionVertex;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class ovrDistortionMesh {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] ovrDistortionMesh_size = new int[]{16, 16, 16, 16, 16, 16, 24, 24};
    private static final int[] pVertexData_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] VertexCount_offset = new int[]{8, 8, 8, 8, 8, 8, 16, 16};
    private static final int[] IndexCount_offset = new int[]{12, 12, 12, 12, 12, 12, 20, 20};

    public static int size() {
        return ovrDistortionMesh_size[mdIdx];
    }

    public static ovrDistortionMesh create() {
        return ovrDistortionMesh.create(Buffers.newDirectByteBuffer(ovrDistortionMesh.size()));
    }

    public static ovrDistortionMesh create(ByteBuffer byteBuffer) {
        return new ovrDistortionMesh(byteBuffer);
    }

    ovrDistortionMesh(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[ovrDistortionMesh.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    private native ByteBuffer getPVertexData0(ByteBuffer var1, int var2);

    public ovrDistortionVertex[] getPVertexData(int n, ovrDistortionVertex[] ovrDistortionVertexArray) {
        int n2 = this.getVertexCount();
        if (n + ovrDistortionVertexArray.length > n2) {
            throw new IndexOutOfBoundsException("offset " + n + " + result.length " + ovrDistortionVertexArray.length + " > array-length " + n2);
        }
        ByteBuffer byteBuffer = this.getBuffer();
        for (int i = 0; i < ovrDistortionVertexArray.length; ++i) {
            ByteBuffer byteBuffer2 = this.getPVertexData0(byteBuffer, n + i);
            if (byteBuffer2 == null) {
                return null;
            }
            ovrDistortionVertexArray[i] = ovrDistortionVertex.create(byteBuffer2);
        }
        return ovrDistortionVertexArray;
    }

    private native ByteBuffer getPIndexData0(ByteBuffer var1, int var2);

    public ShortBuffer getPIndexData() {
        int n = this.getIndexCount();
        ByteBuffer byteBuffer = this.getPIndexData0(this.getBuffer(), n);
        if (byteBuffer == null) {
            return null;
        }
        return Buffers.nativeOrder(byteBuffer).asShortBuffer();
    }

    public ovrDistortionMesh setVertexCount(int n) {
        this.accessor.setIntAt(VertexCount_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getVertexCount() {
        return this.accessor.getIntAt(VertexCount_offset[mdIdx], this.md.intSizeInBytes());
    }

    public ovrDistortionMesh setIndexCount(int n) {
        this.accessor.setIntAt(IndexCount_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getIndexCount() {
        return this.accessor.getIntAt(IndexCount_offset[mdIdx], this.md.intSizeInBytes());
    }
}

