/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DefaultFitterFactory;
import jas.hist.Fitter;
import jas.hist.FitterFactory;
import jas.hist.FitterFactoryError;
import jas.util.NestedRuntimeException;
import java.util.Enumeration;
import java.util.Vector;

public class FitterRegistry {
    private Vector m_fitters = new Vector();
    private static FitterRegistry theFitterRegistry = new FitterRegistry();
    private FitterFactory defaultFitterFactory;

    private FitterRegistry() {
    }

    public static FitterRegistry instance() {
        return theFitterRegistry;
    }

    public void registerFitter(Class clazz, String string) {
        this.registerFitter(this.createFitterFactory(clazz, string));
    }

    public FitterFactory createFitterFactory(Class clazz, String string) {
        try {
            return new DefaultFitterFactory(clazz, string);
        }
        catch (FitterFactoryError fitterFactoryError) {
            throw new NestedRuntimeException(fitterFactoryError);
        }
    }

    public void registerFitter(FitterFactory fitterFactory) {
        this.m_fitters.addElement(fitterFactory);
        if (this.defaultFitterFactory == null) {
            this.defaultFitterFactory = fitterFactory;
        }
    }

    public void removeFitterFactory(FitterFactory fitterFactory) {
        this.m_fitters.removeElement(fitterFactory);
    }

    public void removeAllFitters() {
        this.m_fitters.removeAllElements();
    }

    public Enumeration elements() {
        return this.m_fitters.elements();
    }

    public int size() {
        return this.m_fitters.size();
    }

    public FitterFactory getDefaultFitterFactory() {
        return this.defaultFitterFactory;
    }

    public void setDefaultFitterFactory(FitterFactory fitterFactory) {
        this.defaultFitterFactory = fitterFactory;
    }

    public Fitter getDefaultFitter() {
        return this.defaultFitterFactory == null ? null : this.defaultFitterFactory.createFitter();
    }

    public void setContents(Vector vector) {
        this.m_fitters = vector;
    }
}

