/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.tuple;

import gnu.jel.DVMap;
import hep.aida.ITuple;

public class JELTupleProvider
extends DVMap {
    private ITuple tuple;

    public JELTupleProvider(ITuple tuple) {
        this.tuple = tuple;
    }

    public ITuple getTuple() {
        return this.tuple;
    }

    public String getTypeName(String name) {
        int index = -1;
        try {
            index = this.tuple.findColumn(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        Class colType = this.tuple.columnType(index);
        if (colType == Integer.TYPE) {
            return "Int";
        }
        if (colType == Short.TYPE) {
            return "Short";
        }
        if (colType == Long.TYPE) {
            return "Long";
        }
        if (colType == Float.TYPE) {
            return "Float";
        }
        if (colType == Double.TYPE) {
            return "Double";
        }
        if (colType == Boolean.TYPE) {
            return "Boolean";
        }
        if (colType == Byte.TYPE) {
            return "Byte";
        }
        if (colType == Character.TYPE) {
            return "Char";
        }
        if (colType == String.class) {
            return "String";
        }
        if (colType == Object.class) {
            return "Double.NaN";
        }
        return "Double.NaN";
    }

    public Object translate(String name) {
        int index = -1;
        try {
            index = this.tuple.findColumn(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        return new Integer(index);
    }

    public int getIntProperty(int i) {
        return this.tuple.getInt(i);
    }

    public short getShortProperty(int i) {
        return this.tuple.getShort(i);
    }

    public long getLongProperty(int i) {
        return this.tuple.getLong(i);
    }

    public float getFloatProperty(int i) {
        return this.tuple.getFloat(i);
    }

    public double getDoubleProperty(int i) {
        return this.tuple.getDouble(i);
    }

    public boolean getBooleanProperty(int i) {
        return this.tuple.getBoolean(i);
    }

    public byte getByteProperty(int i) {
        return this.tuple.getByte(i);
    }

    public char getCharProperty(int i) {
        return this.tuple.getChar(i);
    }

    public String getStringProperty(int i) {
        return this.tuple.getString(i);
    }
}

