/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompilationException;
import gnu.jel.DVMap;
import gnu.jel.Library;
import gnu.jel.OP;
import gnu.jel.OPbinary;
import gnu.jel.OPcall;
import gnu.jel.OPcondtnl;
import gnu.jel.OPload;
import gnu.jel.OPunary;
import java.lang.reflect.Member;
import java.util.Stack;

public class Parser {
    Stack paramOPs;
    Stack xchgOP;
    int err_col = -1;
    Library lib;
    StringBuffer accDV = null;
    StringBuffer typeAccum = new StringBuffer();
    private String in;
    private int pos = 0;
    protected int c;
    private boolean prevCR = false;
    private boolean prevLF = false;
    private int column = 0;
    private int line = 1;
    public int ct_column;
    public int ct_line;
    public Object val;
    public int type;
    private StringBuffer buf = new StringBuffer();

    public Parser(String string, Library library) {
        this.in = string;
        this.read();
        this.lib = library;
        this.paramOPs = new Stack();
        this.xchgOP = new Stack();
        if (library.resolver != null) {
            this.accDV = new StringBuffer();
        }
    }

    protected int read() {
        try {
            this.c = this.in.charAt(this.pos++);
        }
        catch (Exception exception) {
            this.c = -1;
        }
        ++this.column;
        if (this.prevLF) {
            this.prevLF = false;
            this.column = 1;
            ++this.line;
        } else if (this.prevCR) {
            this.prevCR = false;
            if (this.c == 10) {
                this.prevLF = true;
            } else {
                this.column = 1;
                ++this.line;
            }
        }
        switch (this.c) {
            case 13: {
                this.prevCR = true;
                break;
            }
            case 10: {
                this.prevLF = true;
                break;
            }
            case 9: {
                --this.column;
                this.column += 8 - (this.column & 7);
                break;
            }
        }
        return this.c;
    }

    protected void consume(int n) throws CompilationException {
        if (n < 0 || this.c != n) {
            CompilationException compilationException = new CompilationException(this.c == -1 ? 1 : 3, new Character((char)this.c));
            compilationException.col = this.column;
            if (this.c == -1) {
                --compilationException.col;
            }
            throw compilationException;
        }
        this.read();
    }

    public void nextToken() throws CompilationException {
        this.ct_column = this.column;
        this.ct_line = this.line;
        block48: while (true) {
            switch (this.c) {
                case -1: {
                    this.type = -1;
                    return;
                }
                case 10: 
                case 13: 
                case 32: {
                    this.read();
                    this.ct_column = this.column;
                    this.ct_line = this.line;
                    continue block48;
                }
                case 43: {
                    this.read();
                    this.type = 0;
                    return;
                }
                case 45: {
                    this.read();
                    this.type = 1;
                    return;
                }
                case 42: {
                    this.read();
                    this.type = 2;
                    return;
                }
                case 47: {
                    this.read();
                    this.type = 3;
                    return;
                }
                case 37: {
                    this.read();
                    this.type = 4;
                    return;
                }
                case 38: {
                    switch (this.read()) {
                        case 38: {
                            this.read();
                            this.type = 17;
                            return;
                        }
                    }
                    this.type = 5;
                    return;
                }
                case 124: {
                    switch (this.read()) {
                        case 124: {
                            this.read();
                            this.type = 18;
                            return;
                        }
                    }
                    this.type = 6;
                    return;
                }
                case 94: {
                    this.read();
                    this.type = 7;
                    return;
                }
                case 61: {
                    this.read();
                    this.consume(61);
                    this.type = 8;
                    return;
                }
                case 33: {
                    switch (this.read()) {
                        case 61: {
                            this.read();
                            this.type = 9;
                            return;
                        }
                    }
                    this.type = 31;
                    return;
                }
                case 60: {
                    switch (this.read()) {
                        case 61: {
                            this.read();
                            this.type = 13;
                            return;
                        }
                        case 60: {
                            this.read();
                            this.type = 14;
                            return;
                        }
                    }
                    this.type = 10;
                    return;
                }
                case 62: {
                    switch (this.read()) {
                        case 61: {
                            this.read();
                            this.type = 11;
                            return;
                        }
                        case 62: {
                            switch (this.read()) {
                                case 62: {
                                    this.read();
                                    this.type = 16;
                                    return;
                                }
                            }
                            this.type = 15;
                            return;
                        }
                    }
                    this.type = 12;
                    return;
                }
                case 126: {
                    this.read();
                    this.type = 30;
                    return;
                }
                case 91: {
                    this.read();
                    this.type = 19;
                    return;
                }
                case 93: {
                    this.read();
                    this.type = 20;
                    return;
                }
                case 63: {
                    this.read();
                    this.type = 35;
                    return;
                }
                case 58: {
                    this.read();
                    this.type = 36;
                    return;
                }
                case 46: {
                    int n = this.read();
                    if (n >= 48 && n <= 57) {
                        this.parseReal();
                    } else {
                        this.type = 40;
                    }
                    return;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.parseNumber();
                    return;
                }
                case 40: {
                    this.read();
                    this.type = 41;
                    return;
                }
                case 41: {
                    this.read();
                    this.type = 42;
                    return;
                }
                case 44: {
                    this.read();
                    this.type = 43;
                    return;
                }
                case 34: {
                    this.read();
                    this.parseString();
                    return;
                }
                case 39: {
                    this.parseChar();
                    return;
                }
            }
            if (Character.isJavaIdentifierStart((char)this.c)) {
                this.parseID();
                return;
            }
            this.consume(-1);
        }
    }

    private int parseEscape() throws CompilationException {
        switch (this.read()) {
            case 114: {
                this.read();
                return 13;
            }
            case 110: {
                this.read();
                return 10;
            }
            case 102: {
                this.read();
                return 12;
            }
            case 98: {
                this.read();
                return 8;
            }
            case 116: {
                this.read();
                return 9;
            }
            case 34: 
            case 39: 
            case 92: {
                return this.c + (this.read() - this.c);
            }
        }
        if (this.c >= 48 && this.c <= 55) {
            int n = this.c - 48;
            int n2 = 0;
            while (n2 < 2) {
                this.read();
                if (this.c < 48 || this.c > 55) {
                    if (n > 255) {
                        this.consume(-1);
                    }
                    return n;
                }
                n = (n << 3) + this.c - 48;
                ++n2;
            }
            this.read();
            if (n > 255) {
                this.consume(-1);
            }
            return n;
        }
        this.consume(-1);
        return -1;
    }

    private void parseChar() throws CompilationException {
        char c = '\u0000';
        switch (this.read()) {
            case 92: {
                c = (char)this.parseEscape();
                break;
            }
            case -1: 
            case 10: 
            case 13: 
            case 39: {
                this.consume(-1);
                break;
            }
            default: {
                c = (char)this.c;
                this.read();
            }
        }
        this.consume(39);
        this.type = 60;
        this.val = new Character(c);
    }

    private void parseString() throws CompilationException {
        block5: while (true) {
            switch (this.c) {
                case -1: 
                case 10: 
                case 13: 
                case 39: {
                    this.consume(-1);
                    continue block5;
                }
                case 92: {
                    this.buf.append((char)this.parseEscape());
                    continue block5;
                }
                case 34: {
                    this.read();
                    this.type = 60;
                    this.val = this.buf.toString();
                    this.buf.setLength(0);
                    return;
                }
            }
            this.buf.append((char)this.c);
            this.read();
        }
    }

    private void parseID() throws CompilationException {
        do {
            this.buf.append((char)this.c);
            this.read();
        } while (this.c > 0 && Character.isJavaIdentifierPart((char)this.c));
        this.type = 50;
        this.val = this.buf.toString();
        this.buf.setLength(0);
        if (this.val.equals("true")) {
            this.type = 60;
            this.val = Boolean.TRUE;
        } else if (this.val.equals("false")) {
            this.type = 60;
            this.val = Boolean.FALSE;
        }
    }

    private void parseNumber() throws CompilationException {
        boolean bl = false;
        boolean bl2 = false;
        int n = this.c == 48 ? 8 : 10;
        long l = this.c - 48;
        this.buf.append((char)this.c);
        block9: while (true) {
            switch (this.read()) {
                case 56: 
                case 57: {
                    bl2 = true;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    bl = true;
                    this.buf.append((char)this.c);
                    if (n == 10) {
                        if (l * 10L / 10L != l) {
                            this.consume(-1);
                        }
                        l = l * 10L + (long)(this.c - 48);
                        continue block9;
                    }
                    if (n == 8) {
                        if (l >>> 61 > 0L) {
                            this.consume(-1);
                        }
                        l = (l << 3) + (long)(this.c - 48);
                        continue block9;
                    }
                    if (l >>> 60 > 0L) {
                        this.consume(-1);
                    }
                    l = (l << 4) + (long)(this.c - 48);
                    continue block9;
                }
                case 68: 
                case 69: 
                case 70: 
                case 100: 
                case 101: 
                case 102: {
                    if (n != 16) {
                        this.parseReal();
                        return;
                    }
                }
                case 65: 
                case 66: 
                case 67: 
                case 97: 
                case 98: 
                case 99: {
                    if (n != 16) break block9;
                    bl = true;
                    if (l >>> 60 > 0L) {
                        this.consume(-1);
                    }
                    l = (l << 4) + (long)(10 + Character.toLowerCase((char)this.c) - 97);
                    continue block9;
                }
                case 46: {
                    if (n == 16) break block9;
                    this.parseReal();
                    return;
                }
                case 76: 
                case 108: {
                    this.read();
                    this.buf.setLength(0);
                    this.type = 60;
                    this.val = new Long(l);
                    break block9;
                }
                case 88: 
                case 120: {
                    if (this.buf.length() != 1 || n != 8) break block9;
                    n = 16;
                    bl = false;
                    continue block9;
                }
                default: {
                    this.buf.setLength(0);
                    this.type = 60;
                    if (l <= 127L) {
                        this.val = new Byte((byte)l);
                        break block9;
                    }
                    if (l <= 32767L) {
                        this.val = new Short((short)l);
                        break block9;
                    }
                    if (l <= Integer.MAX_VALUE) {
                        this.val = new Integer((int)l);
                        break block9;
                    }
                    this.consume(-1);
                    break block9;
                }
            }
            break;
        }
        if (this.c == 46 || Character.isJavaIdentifierPart((char)this.c)) {
            this.consume(-1);
        } else if (n == 8 && bl2) {
            this.consume(-1);
        } else if (n == 16 && !bl) {
            this.consume(-1);
        }
    }

    private void parseReal() throws CompilationException {
        char c;
        boolean bl = false;
        boolean bl2 = false;
        if (this.c == 46) {
            this.read();
        }
        this.buf.append('.');
        block7: while (true) {
            switch (this.c) {
                case 69: 
                case 101: {
                    if (bl) break block7;
                    bl = true;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.buf.append((char)this.c);
                    break;
                }
                case 43: 
                case 45: {
                    c = this.buf.charAt(this.buf.length() - 1);
                    if (c != 'e' && c != 'E') break block7;
                    this.buf.append((char)this.c);
                    break;
                }
                case 70: 
                case 102: {
                    this.read();
                    bl2 = true;
                    break block7;
                }
                case 68: 
                case 100: {
                    this.read();
                }
                default: {
                    break block7;
                }
            }
            this.read();
        }
        if (this.c == 46 || Character.isJavaIdentifierPart((char)this.c)) {
            this.consume(-1);
        } else {
            c = this.buf.charAt(this.buf.length() - 1);
            if (c == 'E' || c == 'e' || c == '+' || c == '-') {
                this.consume(-1);
            } else {
                this.type = 60;
                if (bl2) {
                    this.val = Float.valueOf(this.buf.toString());
                    if (Float.isInfinite(((Float)this.val).floatValue())) {
                        this.consume(-1);
                    }
                } else {
                    this.val = Double.valueOf(this.buf.toString());
                    if (Double.isInfinite((Double)this.val)) {
                        this.consume(-1);
                    }
                }
                this.buf.setLength(0);
            }
        }
    }

    public boolean isCast() {
        if (this.type != 41) {
            return false;
        }
        boolean bl = this.prevCR;
        boolean bl2 = this.prevLF;
        int n = this.column;
        int n2 = this.line;
        int n3 = this.pos;
        int n4 = this.c;
        boolean bl3 = false;
        boolean bl4 = false;
        block19: while (true) {
            switch (this.c) {
                case -1: {
                    break block19;
                }
                case 10: 
                case 13: 
                case 32: {
                    this.read();
                    continue block19;
                }
                default: {
                    if (!Character.isJavaIdentifierStart((char)this.c)) break block19;
                    this.read();
                    while (Character.isJavaIdentifierPart((char)this.c)) {
                        this.read();
                    }
                    block21: while (true) {
                        switch (this.c) {
                            case -1: {
                                break block19;
                            }
                            case 10: 
                            case 13: 
                            case 32: {
                                this.read();
                                continue block21;
                            }
                        }
                        break;
                    }
                    switch (this.c) {
                        case 46: {
                            this.read();
                            continue block19;
                        }
                        case 41: {
                            break;
                        }
                        case 91: {
                            bl4 = true;
                            break;
                        }
                        default: {
                            break block19;
                        }
                    }
                    this.read();
                    block22: while (true) {
                        switch (this.c) {
                            case 10: 
                            case 13: 
                            case 32: {
                                this.read();
                                continue block22;
                            }
                            case 93: {
                                bl3 = true;
                            }
                            case 34: 
                            case 39: 
                            case 40: 
                            case 46: {
                                if (bl4) break block19;
                                bl3 = true;
                            }
                            case -1: {
                                break block19;
                            }
                            default: {
                                bl3 = !bl4 && (this.c >= 48 && this.c <= 57 || Character.isJavaIdentifierStart((char)this.c));
                                break block19;
                            }
                        }
                        break;
                    }
                }
            }
            break;
        }
        this.prevCR = bl;
        this.prevLF = bl2;
        this.c = n4;
        this.column = n;
        this.line = n2;
        this.pos = n3;
        return bl3;
    }

    public OP parse(Class clazz) throws CompilationException {
        try {
            this.expression();
            this.err_col = this.ct_column - 1;
            if (((OP)this.paramOPs.peek()).resID == 10) {
                this.paramOPs.push(new OPunary(this.paramOPs, 11, null, false));
            }
            if (clazz != null) {
                this.paramOPs.push(new OPunary(this.paramOPs, OP.typeID(clazz), clazz, false));
            }
            this.paramOPs.push(new OPunary(this.paramOPs, 3));
        }
        catch (CompilationException compilationException) {
            if (compilationException.col < 0) {
                compilationException.col = this.err_col;
            }
            throw compilationException;
        }
        return (OP)this.paramOPs.pop();
    }

    private void consumeT(int n) throws CompilationException {
        if (this.type != n) {
            this.consume(-1);
        }
        this.nextToken();
    }

    private void expression() throws CompilationException {
        this.nextToken();
        this.conditional();
        this.consumeT(-1);
    }

    private void conditional() throws CompilationException {
        this.binOP(0);
        if (this.type == 35) {
            int n = this.ct_column;
            this.nextToken();
            int n2 = this.paramOPs.size();
            this.conditional();
            this.consumeT(36);
            int n3 = this.paramOPs.size();
            this.conditional();
            this.err_col = n;
            this.paramOPs.push(new OPcondtnl(this.paramOPs));
        }
    }

    private void binOP(int n) throws CompilationException {
        int n2;
        if (n == 9) {
            this.unary();
        } else {
            this.binOP(n + 1);
        }
        int n3 = n < 5 ? (int)(181667661137490L >>> n * 10) : (int)(142971423336744L >>> (n - 5) * 10);
        while ((n2 = this.type) >= (n3 & 0x1F) && n2 <= (n3 >>> 5 & 0x1F)) {
            int n4 = this.ct_column;
            this.nextToken();
            if (n == 9) {
                this.unary();
            } else {
                this.binOP(n + 1);
            }
            this.err_col = n4;
            this.paramOPs.push(new OPbinary(this.paramOPs, n2));
        }
    }

    private void unary() throws CompilationException {
        int n = this.type;
        if (n == 1 || n == 30 || n == 31) {
            int n2 = this.ct_column;
            this.nextToken();
            this.unary();
            if (n >= 30) {
                n -= 28;
            }
            this.err_col = n2;
            this.paramOPs.push(new OPunary(this.paramOPs, n - 1));
        } else if (this.isCast()) {
            this.consumeT(41);
            int n3 = this.ct_column;
            int n4 = this.typeAccum.length();
            this.typeAccum.append(this.val);
            this.consumeT(50);
            while (this.type == 40) {
                this.typeAccum.append('.');
                this.nextToken();
                this.typeAccum.append(this.val);
                this.consumeT(50);
            }
            this.consumeT(42);
            this.element();
            this.err_col = n3;
            int n5 = 0;
            Class clazz = null;
            while (n5 < 8 && !this.typeAccum.substring(n4).equals(OP.specialTypes[n5].toString())) {
                ++n5;
            }
            if (n5 == 8 && (clazz = this.lib.cnmap == null ? null : (Class)this.lib.cnmap.get(this.typeAccum.substring(n4))) == null) {
                n5 = -1;
            }
            if (n5 == 8) {
                n5 = OP.typeID(clazz);
            }
            this.typeAccum.setLength(n4);
            if (n5 < 0) {
                throw new CompilationException(4, this.typeAccum.toString());
            }
            this.paramOPs.push(new OPunary(this.paramOPs, n5, clazz, true));
        } else {
            n = this.type;
            if (n == 60 || n == 50 || n == 41) {
                this.element();
            } else {
                this.consume(-1);
            }
        }
    }

    private void element() throws CompilationException {
        switch (this.type) {
            case 60: {
                this.paramOPs.push(new OPload(this.val));
                this.nextToken();
                break;
            }
            case 41: {
                this.nextToken();
                this.conditional();
                this.consumeT(42);
                break;
            }
            case 50: {
                this.invocation(false);
                break;
            }
            default: {
                this.consume(-1);
                break;
            }
        }
        while (this.type == 40) {
            this.nextToken();
            this.invocation(true);
        }
        this.genDVCall();
    }

    private void invocation(boolean bl) throws CompilationException {
        int n;
        int n2;
        int n3 = 0;
        Class clazz = null;
        boolean bl2 = false;
        int n4 = n2 = this.ct_column;
        Object object = this.val;
        this.consumeT(50);
        if (this.accDV != null) {
            n = this.accDV.length();
            if (bl) {
                this.accDV.append('.');
            }
            this.accDV.append(object);
            bl2 = this.isDV();
            if (!bl2) {
                this.accDV.setLength(n);
                this.err_col = n2;
                this.genDVCall();
            }
        }
        if (!bl2) {
            if (bl) {
                clazz = ((OP)this.paramOPs.peek()).resType;
            }
            n3 = this.paramOPs.size();
        }
        if (this.type == 41) {
            n2 = this.ct_column;
            if (bl2) {
                this.err_col = n2;
                throw new CompilationException(26, null);
            }
            this.nextToken();
            n = this.type;
            if (n == 1 || n == 30 || n == 31 || n == 41 || n == 60 || n == 50) {
                this.conditional();
                while (this.type == 43) {
                    this.nextToken();
                    this.conditional();
                }
            }
            this.consumeT(42);
        }
        if (!bl2) {
            this.err_col = n4;
            this.functionCall(clazz, (String)object, n3);
        }
        while (this.type == 19) {
            n2 = this.ct_column;
            this.nextToken();
            this.genDVCall();
            this.conditional();
            this.consumeT(20);
            this.err_col = n2;
            this.paramOPs.push(new OPbinary(this.paramOPs, 19));
        }
    }

    private final boolean isDV() {
        return this.lib.resolver.getTypeName(this.accDV.toString()) != null;
    }

    private final void genDVCall() throws CompilationException {
        if (this.accDV == null || this.accDV.length() == 0) {
            return;
        }
        String string = this.accDV.toString();
        String string2 = this.lib.resolver.getTypeName(string);
        int n = this.paramOPs.size();
        Object object = this.lib.resolver instanceof DVMap ? ((DVMap)this.lib.resolver).translate(string) : string;
        this.paramOPs.push(new OPload(object));
        this.functionCall(null, "get" + string2 + "Property", n);
        this.accDV.setLength(0);
    }

    private final void functionCall(Class clazz, String string, int n) throws CompilationException {
        int n2;
        Object object;
        int n3 = this.paramOPs.size() - n;
        Class[] classArray = new Class[n3];
        int n4 = n3 - 1;
        while (n4 >= 0) {
            object = (OP)this.paramOPs.pop();
            this.xchgOP.push(object);
            classArray[n4] = ((OP)object).resType;
            --n4;
        }
        object = this.lib.getMember(clazz, string, classArray);
        if (clazz == null && (object.getModifiers() & 8) == 0) {
            this.paramOPs.push(new OPcall(1, new Object[0].getClass()));
            n2 = this.lib.getDynamicMethodClassID((Member)object);
            this.paramOPs.push(new OPload(new Integer(n2)));
            this.paramOPs.push(new OPbinary(this.paramOPs, 19));
        }
        n2 = 0;
        while (n2 < n3) {
            this.paramOPs.push(this.xchgOP.pop());
            ++n2;
        }
        this.paramOPs.push(new OPcall(this.paramOPs, (Member)object, this.lib.isStateless((Member)object)));
    }
}

