/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Tool.GridBagLayoutPanel;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyComboBox;
import AbinitMp.Tool.MyLabel;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.Text3DData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.media.j3d.TransformGroup;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JColorChooser;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TextAssignPanel
extends GridBagLayoutPanel {
    private AbinitMpViewer viewer;
    private JTextField textText;
    private JTextField sizeText;
    private JTextField xText;
    private JTextField yText;
    private MyComboBox fontComboBox;
    private MyComboBox styleComboBox;
    private JList textList;
    private DefaultListModel listModel;
    private MyButton colorButton;
    private Color color = Color.red;
    private final String[] styleList = new String[]{"Plain", "Bold", "Italic", "Bold Italic"};
    private final int[] styleId = new int[]{0, 1, 2, 3};
    private String[] fontList;
    public Vector text3DDataVector = new Vector();
    private DecimalFormat fmt = new DecimalFormat("##0.00");

    public TextAssignPanel(AbinitMpViewer abinitMpViewer) {
        this.viewer = abinitMpViewer;
        this.fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        FlowLayout flowLayout = new FlowLayout(0);
        this.textText = new JTextField();
        this.textText.setPreferredSize(new Dimension(200, 28));
        this.sizeText = new JTextField("100");
        this.sizeText.setPreferredSize(new Dimension(70, 28));
        this.xText = new JTextField("40.00");
        this.xText.setPreferredSize(new Dimension(50, 28));
        this.yText = new JTextField("95.00");
        this.yText.setPreferredSize(new Dimension(50, 28));
        this.fontComboBox = new MyComboBox(this.fontList);
        this.styleComboBox = new MyComboBox(this.styleList);
        this.colorButton = new MyButton();
        this.colorButton.setPreferredSize(new Dimension(50, 28));
        this.colorButton.setBackground(this.color);
        MyButton myButton = new MyButton(MyResourceBundle.getResourceString("TextAssignPanel.add"));
        MyButton myButton2 = new MyButton(MyResourceBundle.getResourceString("TextAssignPanel.modify"));
        MyButton myButton3 = new MyButton(MyResourceBundle.getResourceString("TextAssignPanel.delete"));
        this.colorButton.addActionListener(new colorListener());
        myButton.addActionListener(new addListener());
        myButton2.addActionListener(new modifyListener());
        myButton3.addActionListener(new deleteListener());
        this.listModel = new DefaultListModel();
        this.textList = new JList(this.listModel);
        this.textList.setVisibleRowCount(5);
        JScrollPane jScrollPane = new JScrollPane(this.textList);
        this.textList.addListSelectionListener(new listListener());
        int n = 0;
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("TextAssignPanel.text")), 0, n, 5, 1, 1.0, 0.0);
        this.layoutObject(this.textText, 5, 0, 10, 1, 1.0, 0.0);
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("TextAssignPanel.font")), 0, ++n, 5, 1, 1.0, 0.0);
        this.layoutObject(this.fontComboBox, 5, 1, 10, 1, 1.0, 0.0);
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("TextAssignPanel.style")), 0, ++n, 5, 1, 1.0, 0.0);
        this.layoutObject(this.styleComboBox, 5, 2, 10, 1, 1.0, 0.0);
        MyPanel myPanel = new MyPanel(flowLayout);
        myPanel.add(this.sizeText);
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("TextAssignPanel.size")), 0, ++n, 5, 1, 1.0, 0.0);
        this.layoutObject(myPanel, 5, 3, 10, 1, 1.0, 0.0);
        myPanel = new MyPanel(flowLayout);
        myPanel.add(this.colorButton);
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("TextAssignPanel.color")), 0, ++n, 5, 1, 1.0, 0.0);
        this.layoutObject(myPanel, 5, 4, 10, 1, 1.0, 0.0);
        ++n;
        myPanel = new MyPanel(flowLayout);
        myPanel.add(new MyLabel(MyResourceBundle.getResourceString("TextAssignPanel.x")));
        myPanel.add(this.xText);
        myPanel.add(new MyLabel(MyResourceBundle.getResourceString("TextAssignPanel.y")));
        myPanel.add(this.yText);
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("TextAssignPanel.position")), 0, n, 5, 1, 1.0, 0.0);
        this.layoutObject(myPanel, 5, 5, 10, 1, 1.0, 0.0);
        ++n;
        myPanel = new MyPanel();
        myPanel.add(myButton);
        myPanel.add(myButton2);
        this.layoutObject(myPanel, 0, n, 0, 1, 1.0, 0.0);
        this.layoutObject(jScrollPane, 0, ++n, 0, 5, 1.0, 0.0);
        myPanel = new MyPanel();
        myPanel.add(myButton3);
        this.layoutObject(myPanel, 0, n += 5, 0, 1, 1.0, 0.0);
    }

    public void setNewTextPosition(float f, float f2, TransformGroup transformGroup) {
        for (int i = 0; i < this.text3DDataVector.size(); ++i) {
            Text3DData text3DData = (Text3DData)this.text3DDataVector.get(i);
            if (text3DData.transformGroup != transformGroup) continue;
            text3DData.x = f * 100.0f;
            text3DData.y = f2 * 100.0f;
            this.textList.setSelectedIndex(i);
            this.setGUI(text3DData);
            break;
        }
    }

    public void setGUI(Text3DData text3DData) {
        int n;
        this.textText.setText(text3DData.text);
        this.sizeText.setText(Integer.toString(text3DData.size));
        this.xText.setText(this.fmt.format(text3DData.x));
        this.yText.setText(this.fmt.format(text3DData.y));
        for (n = 0; n < this.fontList.length; ++n) {
            if (!this.fontList[n].equals(text3DData.font)) continue;
            this.fontComboBox.setSelectedIndex(n);
            break;
        }
        for (n = 0; n < this.styleId.length; ++n) {
            if (this.styleId[n] != text3DData.style) continue;
            this.styleComboBox.setSelectedIndex(n);
            break;
        }
        this.color = text3DData.color;
        this.colorButton.setBackground(this.color);
    }

    public void setText(Vector vector) {
        Text3DData text3DData;
        int n;
        for (n = this.text3DDataVector.size(); n > 0; --n) {
            text3DData = (Text3DData)this.text3DDataVector.get(n - 1);
            this.viewer.delete3DText(text3DData);
        }
        this.text3DDataVector.removeAllElements();
        this.listModel.removeAllElements();
        this.text3DDataVector = vector;
        for (n = 0; n < this.text3DDataVector.size(); ++n) {
            text3DData = (Text3DData)this.text3DDataVector.get(n);
            this.listModel.addElement(text3DData);
            this.viewer.add3DText(text3DData);
        }
        this.textList.setSelectedIndex(0);
        this.setGUI((Text3DData)this.text3DDataVector.get(0));
    }

    class listListener
    implements ListSelectionListener {
        listListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = TextAssignPanel.this.textList.getSelectedIndex();
            if (n != -1) {
                Text3DData text3DData = (Text3DData)TextAssignPanel.this.text3DDataVector.get(n);
                TextAssignPanel.this.setGUI(text3DData);
            }
        }
    }

    class colorListener
    extends AbstractAction {
        colorListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MyButton myButton = (MyButton)actionEvent.getSource();
            if ((TextAssignPanel.this.color = JColorChooser.showDialog(myButton, "Color", TextAssignPanel.this.color)) != null) {
                myButton.setBackground(TextAssignPanel.this.color);
            }
        }
    }

    class deleteListener
    extends AbstractAction {
        deleteListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TextAssignPanel.this.textList.getSelectedIndices();
            if (nArray.length != 0) {
                for (int i = nArray.length - 1; i >= 0; --i) {
                    TextAssignPanel.this.listModel.removeElementAt(nArray[i]);
                    Text3DData text3DData = (Text3DData)TextAssignPanel.this.text3DDataVector.get(nArray[i]);
                    TextAssignPanel.this.text3DDataVector.removeElementAt(nArray[i]);
                    TextAssignPanel.this.viewer.delete3DText(text3DData);
                }
            }
        }
    }

    class modifyListener
    extends AbstractAction {
        modifyListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = TextAssignPanel.this.textList.getSelectedIndex();
            if (n != -1) {
                Text3DData text3DData = (Text3DData)TextAssignPanel.this.text3DDataVector.get(n);
                text3DData.text = TextAssignPanel.this.textText.getText();
                text3DData.font = (String)TextAssignPanel.this.fontComboBox.getSelectedItem();
                text3DData.style = TextAssignPanel.this.styleId[TextAssignPanel.this.styleComboBox.getSelectedIndex()];
                text3DData.size = Integer.parseInt(TextAssignPanel.this.sizeText.getText());
                text3DData.color = new Color(TextAssignPanel.this.color.getRGB());
                text3DData.x = Float.parseFloat(TextAssignPanel.this.xText.getText());
                text3DData.y = Float.parseFloat(TextAssignPanel.this.yText.getText());
                TextAssignPanel.this.viewer.modify3DText(text3DData);
                TextAssignPanel.this.textList.clearSelection();
                TextAssignPanel.this.textList.setSelectedIndex(n);
            }
        }
    }

    class addListener
    extends AbstractAction {
        addListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Text3DData text3DData = new Text3DData(TextAssignPanel.this.textText.getText(), (String)TextAssignPanel.this.fontComboBox.getSelectedItem(), TextAssignPanel.this.styleId[TextAssignPanel.this.styleComboBox.getSelectedIndex()], Integer.parseInt(TextAssignPanel.this.sizeText.getText()), TextAssignPanel.this.color, Float.parseFloat(TextAssignPanel.this.xText.getText()), Float.parseFloat(TextAssignPanel.this.yText.getText()));
            TextAssignPanel.this.text3DDataVector.add(text3DData);
            TextAssignPanel.this.listModel.addElement(text3DData);
            TextAssignPanel.this.viewer.add3DText(text3DData);
            TextAssignPanel.this.textList.setSelectedIndex(TextAssignPanel.this.text3DDataVector.size() - 1);
        }
    }
}

