/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.AbinitMpFile.AjfFile;
import AbinitMp.Common.AtomData;
import AbinitMp.Common.BaseWindow;
import AbinitMp.Tool.ExampleFileFilter;
import AbinitMp.Tool.GridBagLayoutPanel;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyCheckBox;
import AbinitMp.Tool.MyComboBox;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyRadioButton;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.FragmentAssignWindow;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class AjfFileWindow
extends BaseWindow {
    private JTextField readGeomText;
    private JTextField writeGeomText;
    private JTextField titleText;
    private JTextField maxIterationText;
    private JTextField maxGradientText;
    private JTextField peptideText;
    private JTextField maxSccCycleText;
    private JTextField maxSccEnergyText;
    private JTextField espaocText;
    private JTextField espptcText;
    private JTextField dimerText;
    private JTextField nprocText;
    private JTextField ghostText;
    private JTextField chargeText;
    private JTextField ligandChargeText;
    private JTextField maxScfCycleText;
    private JTextField maxScfDensityText;
    private JTextField maxScfEnergyText;
    private JTextField vShiftText;
    private JTextField kShiftText;
    private JTextField lShiftText;
    private JTextField mo1Text;
    private JTextField mo2Text;
    private MyRadioButton optimizeOnRadioButton;
    private MyRadioButton optimizeOffRadioButton;
    private MyRadioButton fmoOnRadioButton;
    private MyRadioButton fmoOffRadioButton;
    private MyRadioButton autoOnRadioButton;
    private MyRadioButton autoOffRadioButton;
    private MyCheckBox peptideCheckBox;
    private MyCheckBox nucleotideCheckBox;
    private MyComboBox methodComboBox;
    private MyComboBox basisSetComboBox;
    private MyComboBox electronicStateComboBox;
    private MyComboBox outputLevelComboBox;
    private MyComboBox optMethodComboBox;
    private MyComboBox optLevelComboBox;
    private MyComboBox nucleotideComboBox;
    private MyComboBox appLevelComboBox;
    private MyComboBox directScfComboBox;
    private GridBagLayoutPanel optimizePanel = new GridBagLayoutPanel();
    private GridBagLayoutPanel fmoPanel = new GridBagLayoutPanel();
    private GridBagLayoutPanel autoPanel = new GridBagLayoutPanel();
    private JLabel optimizePanelLabel;
    private JLabel fmoPanelLabel;
    private JFileChooser openFileChooser;
    private JFileChooser saveFileChooser;
    private JFileChooser pdbOpenFileChooser;
    private JFileChooser pdbSaveFileChooser;
    private FragmentAssignWindow fragmentAssignWindow = null;
    private AbinitMpViewer viewer;

    public AjfFileWindow(AbinitMpViewer abinitMpViewer) {
        super(MyResourceBundle.getResourceString("AjfFileWindow.Title"));
        this.viewer = abinitMpViewer;
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter("ajf", "ABINIT-MP input file");
        this.openFileChooser = new JFileChooser(".");
        FileFilter fileFilter = this.openFileChooser.getFileFilter();
        this.openFileChooser.addChoosableFileFilter(exampleFileFilter);
        this.openFileChooser.setFileFilter(fileFilter);
        this.openFileChooser.setPreferredSize(new Dimension(500, 500));
        this.saveFileChooser = new JFileChooser(".");
        fileFilter = this.saveFileChooser.getFileFilter();
        this.saveFileChooser.addChoosableFileFilter(exampleFileFilter);
        this.saveFileChooser.setFileFilter(fileFilter);
        this.saveFileChooser.setPreferredSize(new Dimension(500, 500));
        ExampleFileFilter exampleFileFilter2 = new ExampleFileFilter(new String[]{"pdb", "ent"}, "PDB file");
        this.pdbOpenFileChooser = new JFileChooser(".");
        fileFilter = this.pdbOpenFileChooser.getFileFilter();
        this.pdbOpenFileChooser.addChoosableFileFilter(exampleFileFilter2);
        this.pdbOpenFileChooser.setFileFilter(fileFilter);
        this.pdbOpenFileChooser.setPreferredSize(new Dimension(500, 500));
        this.pdbSaveFileChooser = new JFileChooser(".");
        fileFilter = this.pdbSaveFileChooser.getFileFilter();
        this.pdbSaveFileChooser.addChoosableFileFilter(exampleFileFilter2);
        this.pdbSaveFileChooser.setFileFilter(fileFilter);
        this.pdbSaveFileChooser.setPreferredSize(new Dimension(500, 500));
        Container container = this.getContentPane();
        container.remove(this.messagePanel);
        this.getJMenuBar().add(this.addMenuItem("AjfFileWindow.fileMenuTitle", "AjfFileWindow.fileMenu", (Action)new fileListener()));
        AjfFile ajfFile = new AjfFile();
        GridLayout gridLayout = new GridLayout(1, 2);
        gridLayout.setHgap(10);
        MyPanel myPanel = new MyPanel(gridLayout);
        myPanel.setBorder(new TitledBorder(MyResourceBundle.getResourceString("AjfFileWindow.file.title")));
        GridBagLayoutPanel gridBagLayoutPanel = new GridBagLayoutPanel();
        GridBagLayoutPanel gridBagLayoutPanel2 = new GridBagLayoutPanel();
        MyButton myButton = new MyButton(MyResourceBundle.getResourceString("file"));
        MyButton myButton2 = new MyButton(MyResourceBundle.getResourceString("file"));
        myButton.addActionListener(new pdbOpenListener());
        myButton2.addActionListener(new pdbSaveListener());
        this.readGeomText = new JTextField(33);
        this.writeGeomText = new JTextField(33);
        gridBagLayoutPanel.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.file.inputFile")), 0, 0, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(this.readGeomText, 5, 0, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(myButton, 10, 0, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel2.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.file.outputFile")), 0, 0, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel2.layoutObject(this.writeGeomText, 5, 0, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel2.layoutObject(myButton2, 10, 0, 5, 1, 1.0, 0.0);
        myPanel.add(gridBagLayoutPanel);
        myPanel.add(gridBagLayoutPanel2);
        this.directScfComboBox = new MyComboBox(MyResourceBundle.getResourceStrings("AjfFileWindow.general.scf.directScf.options"));
        GridBagLayoutPanel gridBagLayoutPanel3 = new GridBagLayoutPanel();
        GridBagLayoutPanel gridBagLayoutPanel4 = new GridBagLayoutPanel();
        this.titleText = new JTextField(25);
        this.ghostText = new JTextField(ajfFile.ghost, 10);
        this.chargeText = new JTextField(Float.toString(ajfFile.charge), 10);
        this.ligandChargeText = new JTextField(ajfFile.ligandCharge, 10);
        this.methodComboBox = new MyComboBox(MyResourceBundle.getResourceStrings("AjfFileWindow.general.method.options"));
        this.basisSetComboBox = new MyComboBox(MyResourceBundle.getResourceStrings("AjfFileWindow.general.basisSet.options"));
        this.electronicStateComboBox = new MyComboBox(MyResourceBundle.getResourceStrings("AjfFileWindow.general.electronicState.options"));
        this.electronicStateComboBox.setMaximumRowCount(10);
        this.outputLevelComboBox = new MyComboBox(MyResourceBundle.getResourceStrings("AjfFileWindow.general.outputLevel.options"));
        int n = 0;
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(1);
        gridBagLayoutPanel3.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.Title")), 0, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel3.layoutObject(this.titleText, 5, 0, 0, 1, 1.0, 0.0);
        gridBagLayoutPanel3.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.method")), 0, ++n, 5, 1, 1.0, 0.0);
        MyPanel myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.methodComboBox);
        gridBagLayoutPanel3.layoutObject(myPanel2, 5, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel3.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.basisSet")), 0, ++n, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.basisSetComboBox);
        gridBagLayoutPanel3.layoutObject(myPanel2, 5, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel3.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.electronicState")), 0, ++n, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.electronicStateComboBox);
        gridBagLayoutPanel3.layoutObject(myPanel2, 5, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel3.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.charge")), 0, ++n, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.chargeText);
        gridBagLayoutPanel3.layoutObject(myPanel2, 5, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel3.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.outputLevel")), 0, ++n, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.outputLevelComboBox);
        gridBagLayoutPanel3.layoutObject(myPanel2, 5, n, 5, 1, 1.0, 0.0);
        this.outputLevelComboBox.setSelectedIndex(ajfFile.nprint);
        gridBagLayoutPanel3.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.ghost")), 0, ++n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel3.layoutObject(this.ghostText, 5, n, 5, 1, 1.0, 0.0);
        this.maxScfEnergyText = new JTextField(Float.toString(ajfFile.maxScfEnergy), 10);
        this.maxScfDensityText = new JTextField(Float.toString(ajfFile.maxScfDensity), 10);
        this.maxScfCycleText = new JTextField(Integer.toString(ajfFile.maxScfCycle), 10);
        this.vShiftText = new JTextField(Float.toString(ajfFile.vshift), 10);
        this.kShiftText = new JTextField(Float.toString(ajfFile.kshift), 10);
        this.lShiftText = new JTextField(Float.toString(ajfFile.lshift), 10);
        this.mo1Text = new JTextField(Integer.toString(ajfFile.mo1), 5);
        this.mo2Text = new JTextField(Integer.toString(ajfFile.mo2), 5);
        GridBagLayoutPanel gridBagLayoutPanel5 = new GridBagLayoutPanel();
        gridBagLayoutPanel3.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.scf")), 0, ++n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel5.setBorder(new TitledBorder(""));
        gridBagLayoutPanel3.layoutObject(gridBagLayoutPanel5, 5, n, 5, 4, 1.0, 0.0);
        int n2 = 0;
        gridBagLayoutPanel5.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.scf.directScf")), 0, n2, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.directScfComboBox);
        gridBagLayoutPanel5.layoutObject(myPanel2, 5, n2, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel5.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.scf.energy")), 0, ++n2, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.maxScfEnergyText);
        gridBagLayoutPanel5.layoutObject(myPanel2, 5, n2, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel5.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.scf.density")), 0, ++n2, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.maxScfDensityText);
        gridBagLayoutPanel5.layoutObject(myPanel2, 5, n2, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel5.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.scf.cycle")), 0, ++n2, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.maxScfCycleText);
        gridBagLayoutPanel5.layoutObject(myPanel2, 5, n2, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel5.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.scf.vshift")), 0, ++n2, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.vShiftText);
        gridBagLayoutPanel5.layoutObject(myPanel2, 5, n2, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel5.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.scf.kshift")), 0, ++n2, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.kShiftText);
        gridBagLayoutPanel5.layoutObject(myPanel2, 5, n2, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel5.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.scf.lshift")), 0, ++n2, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.lShiftText);
        gridBagLayoutPanel5.layoutObject(myPanel2, 5, n2, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel5.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.scf.alterMo")), 0, ++n2, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.mo1Text);
        myPanel2.add(this.mo2Text);
        gridBagLayoutPanel5.layoutObject(myPanel2, 5, n2, 5, 1, 1.0, 0.0);
        this.optimizeOnRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("on"));
        this.optimizeOffRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("off"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.optimizeOnRadioButton);
        buttonGroup.add(this.optimizeOffRadioButton);
        MyPanel myPanel3 = new MyPanel(flowLayout);
        myPanel3.add(this.optimizeOnRadioButton);
        myPanel3.add(this.optimizeOffRadioButton);
        this.optimizeOnRadioButton.addActionListener(new optimizeListener(true));
        this.optimizeOffRadioButton.addActionListener(new optimizeListener(false));
        n = 0;
        gridBagLayoutPanel4.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.optimize")), 0, n, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(myPanel3, 5, n, 5, 1, 1.0, 0.0);
        this.optimizePanel.setBorder(new TitledBorder(""));
        this.optimizePanelLabel = new JLabel(" ");
        gridBagLayoutPanel4.layoutObject(this.optimizePanelLabel, 0, ++n, 5, 4, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(this.optimizePanel, 5, n, 5, 4, 1.0, 0.0);
        this.maxIterationText = new JTextField(Integer.toString(ajfFile.maxCycle), 10);
        this.maxGradientText = new JTextField(Float.toString(ajfFile.maxGrad), 10);
        this.optMethodComboBox = new MyComboBox(MyResourceBundle.getResourceStrings("AjfFileWindow.general.optimize.method.options"));
        this.optLevelComboBox = new MyComboBox(MyResourceBundle.getResourceStrings("AjfFileWindow.general.optimize.level.options"));
        int n3 = 0;
        this.optimizePanel.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.optimize.iteration")), 0, n3, 5, 1, 1.0, 0.0);
        this.optimizePanel.layoutObject(this.maxIterationText, 5, n3, 5, 1, 1.0, 0.0);
        this.optimizePanel.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.optimize.gradient")), 0, ++n3, 5, 1, 1.0, 0.0);
        this.optimizePanel.layoutObject(this.maxGradientText, 5, n3, 5, 1, 1.0, 0.0);
        this.optimizePanel.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.optimize.method")), 0, ++n3, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.optMethodComboBox);
        this.optimizePanel.layoutObject(myPanel2, 5, n3, 5, 1, 1.0, 0.0);
        this.optimizePanel.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.optimize.level")), 0, ++n3, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.optLevelComboBox);
        this.optimizePanel.layoutObject(myPanel2, 5, n3, 5, 1, 1.0, 0.0);
        if (ajfFile.optimize) {
            this.optimizeOnRadioButton.setSelected(true);
        } else {
            this.optimizeOffRadioButton.setSelected(true);
            this.optimizePanel.setVisible(false);
            this.optimizePanelLabel.setVisible(false);
        }
        n = n + 1 + n3;
        gridBagLayoutPanel4.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.fmo")), 0, n, 5, 1, 1.0, 0.0);
        this.fmoOnRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("on"));
        this.fmoOffRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("off"));
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.fmoOnRadioButton);
        buttonGroup.add(this.fmoOffRadioButton);
        MyPanel myPanel4 = new MyPanel(flowLayout);
        myPanel4.add(this.fmoOnRadioButton);
        myPanel4.add(this.fmoOffRadioButton);
        this.fmoOnRadioButton.addActionListener(new fmoListener(true));
        this.fmoOffRadioButton.addActionListener(new fmoListener(false));
        gridBagLayoutPanel4.layoutObject(myPanel4, 5, n, 5, 1, 1.0, 0.0);
        this.fmoPanel.setBorder(new TitledBorder(""));
        this.fmoPanelLabel = new JLabel(" ");
        gridBagLayoutPanel4.layoutObject(this.fmoPanelLabel, 0, ++n, 5, 4, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(this.fmoPanel, 5, n, 5, 4, 1.0, 0.0);
        gridBagLayoutPanel4.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.fragment")), 0, n += 8, 5, 1, 1.0, 0.0);
        MyButton myButton3 = new MyButton(MyResourceBundle.getResourceString("AjfFileWindow.general.fragment"));
        myButton3.addActionListener(new fragmentListener());
        MyPanel myPanel5 = new MyPanel(flowLayout);
        myPanel5.add(myButton3);
        gridBagLayoutPanel4.layoutObject(myPanel5, 5, n, 5, 1, 1.0, 0.0);
        if (ajfFile.fmo) {
            this.fmoOnRadioButton.setSelected(true);
        } else {
            this.fmoOffRadioButton.setSelected(true);
            this.fmoPanel.setVisible(false);
            this.fmoPanelLabel.setVisible(false);
        }
        this.peptideText = new JTextField(Integer.toString(ajfFile.fragSizeResidue), 10);
        this.maxSccCycleText = new JTextField(Integer.toString(ajfFile.maxSccCycle), 10);
        this.maxSccEnergyText = new JTextField(Float.toString(ajfFile.maxSccEnergy), 10);
        this.espaocText = new JTextField(Float.toString(ajfFile.laoc), 10);
        this.espptcText = new JTextField(Float.toString(ajfFile.lptc), 10);
        this.dimerText = new JTextField(Float.toString(ajfFile.ldimer), 10);
        this.nprocText = new JTextField(Integer.toString(ajfFile.np), 10);
        this.nucleotideComboBox = new MyComboBox(MyResourceBundle.getResourceStrings("AjfFileWindow.general.fmo.fragmentSize.nucleotide.options"));
        this.appLevelComboBox = new MyComboBox(MyResourceBundle.getResourceStrings("AjfFileWindow.general.fmo.appLevel.options"));
        this.autoOnRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("on"));
        this.autoOffRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("off"));
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.autoOnRadioButton);
        buttonGroup.add(this.autoOffRadioButton);
        MyPanel myPanel6 = new MyPanel(flowLayout);
        myPanel6.add(this.autoOnRadioButton);
        myPanel6.add(this.autoOffRadioButton);
        this.autoOnRadioButton.addActionListener(new autoListener(true));
        this.autoOffRadioButton.addActionListener(new autoListener(false));
        if (ajfFile.autoFrag) {
            this.autoOnRadioButton.setSelected(true);
        } else {
            this.autoOffRadioButton.setSelected(true);
        }
        n = 0;
        this.fmoPanel.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.fmo.autoFrag")), 0, n, 5, 1, 1.0, 0.0);
        this.fmoPanel.layoutObject(myPanel6, 5, n, 10, 1, 1.0, 0.0);
        this.autoPanel.setBorder(new TitledBorder(""));
        this.fmoPanel.layoutObject(this.autoPanel, 0, ++n, 0, 1, 1.0, 0.0);
        this.autoPanel.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.fmo.fragmentSize")), 0, 0, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        JLabel jLabel = new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.fmo.fragmentSize.peptide"));
        myPanel2.add(jLabel);
        myPanel2.add(this.peptideText);
        this.autoPanel.layoutObject(myPanel2, 5, 0, 5, 1, 1.0, 0.0);
        if (ajfFile.fragSizeResidueFrag) {
            this.peptideCheckBox.setSelected(true);
        }
        myPanel2 = new MyPanel(flowLayout);
        jLabel = new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.fmo.fragmentSize.nucleotide"));
        myPanel2.add(jLabel);
        myPanel2.add(this.nucleotideComboBox);
        this.autoPanel.layoutObject(myPanel2, 5, 1, 5, 1, 1.0, 0.0);
        if (ajfFile.fragSizeNucleotideFrag) {
            this.nucleotideCheckBox.setSelected(true);
        }
        this.autoPanel.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.fmo.charge")), 0, 6, 5, 1, 1.0, 0.0);
        this.autoPanel.layoutObject(this.ligandChargeText, 5, 6, 5, 1, 1.0, 0.0);
        this.autoPanel.setVisible(false);
        this.fmoPanel.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.fmo.maxSccCycle")), 0, ++n, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.maxSccCycleText);
        this.fmoPanel.layoutObject(myPanel2, 5, n, 5, 1, 1.0, 0.0);
        this.fmoPanel.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.fmo.maxSccEnergy")), 0, ++n, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.maxSccEnergyText);
        this.fmoPanel.layoutObject(myPanel2, 5, n, 5, 1, 1.0, 0.0);
        this.fmoPanel.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.fmo.appLevel")), 0, ++n, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.appLevelComboBox);
        this.fmoPanel.layoutObject(myPanel2, 5, n, 5, 1, 1.0, 0.0);
        this.appLevelComboBox.setSelectedIndex(ajfFile.approximationLevel);
        this.fmoPanel.layoutObject(new JLabel("     " + MyResourceBundle.getResourceString("AjfFileWindow.general.fmo.EspAoc")), 0, ++n, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.espaocText);
        this.fmoPanel.layoutObject(myPanel2, 5, n, 5, 1, 1.0, 0.0);
        this.fmoPanel.layoutObject(new JLabel("     " + MyResourceBundle.getResourceString("AjfFileWindow.general.fmo.EspPtc")), 0, ++n, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.espptcText);
        this.fmoPanel.layoutObject(myPanel2, 5, n, 5, 1, 1.0, 0.0);
        this.fmoPanel.layoutObject(new JLabel("     " + MyResourceBundle.getResourceString("AjfFileWindow.general.fmo.dimer-es")), 0, ++n, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.dimerText);
        this.fmoPanel.layoutObject(myPanel2, 5, n, 5, 1, 1.0, 0.0);
        this.fmoPanel.layoutObject(new JLabel(MyResourceBundle.getResourceString("AjfFileWindow.general.fmo.monomerNproc")), 0, ++n, 5, 1, 1.0, 0.0);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(this.nprocText);
        this.fmoPanel.layoutObject(myPanel2, 5, n, 5, 1, 1.0, 0.0);
        MyPanel myPanel7 = new MyPanel(gridLayout);
        myPanel7.setBorder(new TitledBorder(MyResourceBundle.getResourceString("AjfFileWindow.general.title")));
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(gridBagLayoutPanel3);
        myPanel7.add(myPanel2);
        myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(gridBagLayoutPanel4);
        myPanel7.add(myPanel2);
        GridBagLayoutPanel gridBagLayoutPanel6 = new GridBagLayoutPanel();
        gridBagLayoutPanel6.layoutObject(myPanel, 0, 0, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel6.layoutObject(myPanel7, 0, 1, 5, 1, 1.0, 0.0);
        this.mainPanel.add(gridBagLayoutPanel6);
        this.pack();
        this.fragmentAssignWindow = new FragmentAssignWindow(abinitMpViewer);
    }

    private void setParameter(AjfFile ajfFile) {
        this.readGeomText.setText(ajfFile.readGeom);
        this.writeGeomText.setText(ajfFile.writeGeom);
        this.titleText.setText(ajfFile.title);
        this.methodComboBox.setSelectedIndex(ajfFile.method);
        this.basisSetComboBox.setSelectedIndex(ajfFile.basisSet);
        this.electronicStateComboBox.setSelectedIndex(ajfFile.electronicState);
        this.outputLevelComboBox.setSelectedIndex(ajfFile.nprint);
        this.directScfComboBox.setSelectedIndex(ajfFile.directScf);
        this.maxScfEnergyText.setText(Float.toString(ajfFile.maxScfEnergy));
        this.maxScfDensityText.setText(Float.toString(ajfFile.maxScfDensity));
        this.maxScfCycleText.setText(Integer.toString(ajfFile.maxScfCycle));
        this.vShiftText.setText(Float.toString(ajfFile.vshift));
        this.kShiftText.setText(Float.toString(ajfFile.kshift));
        this.lShiftText.setText(Float.toString(ajfFile.lshift));
        this.mo1Text.setText(Integer.toString(ajfFile.mo1));
        this.mo2Text.setText(Integer.toString(ajfFile.mo2));
        this.ghostText.setText(ajfFile.ghost);
        this.chargeText.setText(Float.toString(ajfFile.charge));
        this.ligandChargeText.setText(ajfFile.ligandCharge);
        if (ajfFile.optimize) {
            this.optimizeOnRadioButton.setSelected(true);
            this.optimizePanel.setVisible(true);
            this.optimizePanelLabel.setVisible(true);
        } else {
            this.optimizeOffRadioButton.setSelected(true);
            this.optimizePanel.setVisible(false);
            this.optimizePanelLabel.setVisible(false);
        }
        this.maxIterationText.setText(Integer.toString(ajfFile.maxCycle));
        this.maxGradientText.setText(Float.toString(ajfFile.maxGrad));
        this.optMethodComboBox.setSelectedIndex(ajfFile.optimizeMethod);
        this.optLevelComboBox.setSelectedIndex(ajfFile.hopt);
        if (ajfFile.fmo) {
            this.fmoOnRadioButton.setSelected(true);
            this.fmoPanel.setVisible(true);
            this.fmoPanelLabel.setVisible(true);
        } else {
            this.fmoOffRadioButton.setSelected(true);
            this.fmoPanel.setVisible(false);
            this.fmoPanelLabel.setVisible(false);
        }
        if (ajfFile.autoFrag) {
            this.autoOnRadioButton.setSelected(true);
            this.autoPanel.setVisible(true);
        } else {
            this.autoOffRadioButton.setSelected(true);
            this.autoPanel.setVisible(false);
        }
        this.nucleotideComboBox.setSelectedIndex(ajfFile.fragSizeNucleotide);
        this.maxSccCycleText.setText(Integer.toString(ajfFile.maxSccCycle));
        this.maxSccEnergyText.setText(Float.toString(ajfFile.maxSccEnergy));
        this.appLevelComboBox.setSelectedIndex(ajfFile.approximationLevel);
        this.espaocText.setText(Float.toString(ajfFile.laoc));
        this.espptcText.setText(Float.toString(ajfFile.lptc));
        this.dimerText.setText(Float.toString(ajfFile.ldimer));
        this.nprocText.setText(Integer.toString(ajfFile.np));
        this.pack();
        if (!this.fragmentAssignWindow.setParameter(ajfFile)) {
            JOptionPane.showMessageDialog(this.readGeomText, "Can not set fragment boundary data. Becauase read geomfile error.", "Error message", 0);
        }
    }

    private void openFile(String string) {
        AjfFile ajfFile = new AjfFile(string);
        this.setParameter(ajfFile);
    }

    private void saveFile(String string) {
        AjfFile ajfFile = new AjfFile();
        ajfFile.readGeom = this.readGeomText.getText();
        ajfFile.writeGeom = this.writeGeomText.getText();
        ajfFile.title = this.titleText.getText();
        ajfFile.method = this.methodComboBox.getSelectedIndex();
        ajfFile.basisSet = this.basisSetComboBox.getSelectedIndex();
        ajfFile.electronicState = this.electronicStateComboBox.getSelectedIndex();
        ajfFile.nprint = this.outputLevelComboBox.getSelectedIndex();
        ajfFile.directScf = this.directScfComboBox.getSelectedIndex();
        ajfFile.maxScfEnergy = Float.parseFloat(this.maxScfEnergyText.getText());
        ajfFile.maxScfDensity = Float.parseFloat(this.maxScfDensityText.getText());
        ajfFile.maxScfCycle = Integer.parseInt(this.maxScfCycleText.getText());
        ajfFile.vshift = Float.parseFloat(this.vShiftText.getText());
        ajfFile.kshift = Float.parseFloat(this.kShiftText.getText());
        ajfFile.lshift = Float.parseFloat(this.lShiftText.getText());
        ajfFile.mo1 = Integer.parseInt(this.mo1Text.getText());
        ajfFile.mo2 = Integer.parseInt(this.mo2Text.getText());
        ajfFile.ghost = this.ghostText.getText();
        ajfFile.charge = Float.parseFloat(this.chargeText.getText());
        ajfFile.ligandCharge = this.ligandChargeText.getText();
        if (this.optimizeOnRadioButton.isSelected()) {
            ajfFile.optimize = true;
            ajfFile.maxCycle = Integer.parseInt(this.maxIterationText.getText());
            ajfFile.maxGrad = Float.parseFloat(this.maxGradientText.getText());
            ajfFile.optimizeMethod = this.optMethodComboBox.getSelectedIndex();
            ajfFile.hopt = this.optLevelComboBox.getSelectedIndex();
        }
        if (this.fmoOnRadioButton.isSelected()) {
            ajfFile.fmo = true;
            ajfFile.autoFrag = this.autoOnRadioButton.isSelected();
            if (ajfFile.autoFrag) {
                ajfFile.fragSizeNucleotideFrag = true;
                ajfFile.fragSizeResidueFrag = true;
                ajfFile.fragSizeResidue = Integer.parseInt(this.peptideText.getText());
                ajfFile.fragSizeNucleotide = this.nucleotideComboBox.getSelectedIndex();
            }
            ajfFile.approximationLevel = this.appLevelComboBox.getSelectedIndex();
            ajfFile.laoc = Float.parseFloat(this.espaocText.getText());
            ajfFile.lptc = Float.parseFloat(this.espptcText.getText());
            ajfFile.ldimer = Float.parseFloat(this.dimerText.getText());
            ajfFile.np = Integer.parseInt(this.nprocText.getText());
        }
        this.fragmentAssignWindow.getParameter(ajfFile);
        ajfFile.saveFile(string);
    }

    public void setAtom(AtomData atomData) {
        if (this.fragmentAssignWindow != null) {
            this.fragmentAssignWindow.setAtom(atomData);
        }
    }

    public void highlightBounbary(AtomData atomData) {
        this.fragmentAssignWindow.highlightBounbary(atomData);
    }

    public void setReadGeomFilename(String string) {
        this.readGeomText.setText(string);
    }

    class fragmentListener
    extends AbstractAction {
        fragmentListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AjfFileWindow.this.viewer.getCurrentFileItem() != null) {
                AjfFileWindow.this.fragmentAssignWindow.setVisible(true);
            } else {
                JOptionPane.showMessageDialog((MyButton)actionEvent.getSource(), "Please display pdb file.", "Error message", 0);
            }
        }
    }

    class autoListener
    extends AbstractAction {
        boolean tf;

        public autoListener(boolean bl) {
            this.tf = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.tf) {
                AjfFileWindow.this.autoPanel.setVisible(true);
            } else {
                AjfFileWindow.this.autoPanel.setVisible(false);
            }
            AjfFileWindow.this.pack();
        }
    }

    class fmoListener
    extends AbstractAction {
        boolean tf;

        public fmoListener(boolean bl) {
            this.tf = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.tf) {
                AjfFileWindow.this.fmoPanel.setVisible(true);
                AjfFileWindow.this.fmoPanelLabel.setVisible(true);
            } else {
                AjfFileWindow.this.fmoPanel.setVisible(false);
                AjfFileWindow.this.fmoPanelLabel.setVisible(false);
            }
            AjfFileWindow.this.pack();
        }
    }

    class optimizeListener
    extends AbstractAction {
        boolean tf;

        public optimizeListener(boolean bl) {
            this.tf = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.tf) {
                AjfFileWindow.this.optimizePanel.setVisible(true);
                AjfFileWindow.this.optimizePanelLabel.setVisible(true);
            } else {
                AjfFileWindow.this.optimizePanel.setVisible(false);
                AjfFileWindow.this.optimizePanelLabel.setVisible(false);
            }
            AjfFileWindow.this.pack();
        }
    }

    class pdbSaveListener
    extends AbstractAction {
        pdbSaveListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AjfFileWindow.this.pdbSaveFileChooser.showSaveDialog(null) == 0) {
                String string = AjfFileWindow.this.pdbSaveFileChooser.getSelectedFile().getPath();
                AjfFileWindow.this.writeGeomText.setText(string);
            }
        }
    }

    class pdbOpenListener
    extends AbstractAction {
        pdbOpenListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AjfFileWindow.this.pdbOpenFileChooser.showOpenDialog(null) == 0) {
                String string = AjfFileWindow.this.pdbOpenFileChooser.getSelectedFile().getPath();
                AjfFileWindow.this.readGeomText.setText(string);
            }
        }
    }

    class fileListener
    extends AbstractAction {
        fileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("AjfFileWindow.fileMenu");
            char c = string.charAt(0);
            if (AjfFileWindow.this.getNemonic(stringArray[0]) == c) {
                if (AjfFileWindow.this.openFileChooser.showOpenDialog(null) == 0) {
                    String string2 = AjfFileWindow.this.openFileChooser.getSelectedFile().getPath();
                    AjfFileWindow.this.openFile(string2);
                }
            } else if (AjfFileWindow.this.getNemonic(stringArray[1]) == c) {
                if (AjfFileWindow.this.saveFileChooser.showSaveDialog(null) == 0) {
                    String string3 = AjfFileWindow.this.saveFileChooser.getSelectedFile().getPath();
                    int n = string3.lastIndexOf(".");
                    if (n == -1) {
                        string3 = string3 + ".ajf";
                    }
                    AjfFileWindow.this.saveFile(string3);
                }
            } else if (AjfFileWindow.this.getNemonic(stringArray[2]) == c) {
                AjfFile ajfFile = new AjfFile();
                AjfFileWindow.this.setParameter(ajfFile);
            } else if (AjfFileWindow.this.getNemonic(stringArray[3]) == c) {
                AjfFileWindow.this.setVisible(false);
            }
        }
    }
}

