/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Common;

import AbinitMp.Tool.ExecCommand;
import AbinitMp.Tool.MyCheckBoxMenuItem;
import AbinitMp.Tool.MyColor;
import AbinitMp.Tool.MyFrame;
import AbinitMp.Tool.MyMenu;
import AbinitMp.Tool.MyMenuBar;
import AbinitMp.Tool.MyMenuItem;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyRadioButtonMenuItem;
import AbinitMp.Tool.MyResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class BaseWindow
extends MyFrame {
    protected MyMenuBar menuBar;
    protected MyPanel mainPanel;
    protected MyPanel messagePanel;
    protected JTextArea messageArea;
    protected MyMenu helpMenu;
    private String helpUrl = "index.html";
    protected int mainFlag = 0;

    public BaseWindow(String string) {
        super(string);
        this.setSize(500, 500);
        this.setBackground(MyColor.getColor(MyResourceBundle.getResourceString("Frame.background")));
        this.setIconImage(new ImageIcon(this.getClass().getResource("/AbinitMp/images/title-small.gif")).getImage());
        this.menuBar = new MyMenuBar();
        this.setJMenuBar(this.menuBar);
        Container container = this.getContentPane();
        this.mainPanel = new MyPanel();
        container.add((Component)this.mainPanel, "Center");
        this.messagePanel = new MyPanel();
        this.messagePanel.setLayout(new BorderLayout());
        this.messageArea = new JTextArea();
        this.messageArea.setRows(4);
        this.messageArea.setLineWrap(true);
        this.messageArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.messageArea, 22, 31);
        this.messagePanel.add((Component)jScrollPane, "Center");
        Border border = BorderFactory.createRaisedBevelBorder();
        Border border2 = BorderFactory.createLoweredBevelBorder();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, border2);
        this.messagePanel.setBorder(compoundBorder);
        container.add((Component)this.messagePanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BaseWindow.this.closeProcess();
                if (BaseWindow.this.mainFlag == 1) {
                    System.exit(0);
                } else {
                    BaseWindow.this.setVisible(false);
                }
            }
        });
    }

    public void setMain() {
        this.mainFlag = 1;
    }

    protected JMenu addHelpMenu() {
        this.helpMenu = new MyMenu(MyResourceBundle.getResourceString("Main.HelpButton"));
        this.helpMenu.setMnemonic('H');
        this.menuBar.add(Box.createHorizontalGlue());
        this.menuBar.add(this.helpMenu);
        MyMenuItem myMenuItem = new MyMenuItem("View Help");
        myMenuItem.addActionListener(new helpCommand());
        this.helpMenu.add(myMenuItem);
        return this.helpMenu;
    }

    protected void setHelpUrl(String string) {
        this.helpUrl = string;
    }

    public char getNemonic(String string) {
        char c;
        int n = string.indexOf(40);
        if (n == -1) {
            c = 'X';
            System.out.println("can't find nemonic in (" + string + ")");
        } else {
            c = string.charAt(n + 1);
        }
        return c;
    }

    protected MyMenu addMenuItem(String string, String string2, Action action) {
        String string3 = MyResourceBundle.getResourceString(string);
        String[] stringArray = MyResourceBundle.getResourceStrings(string2);
        MyMenu myMenu = new MyMenu(string3);
        myMenu.setMnemonic(this.getNemonic(string3));
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-")) {
                myMenu.addSeparator();
                continue;
            }
            MyMenuItem myMenuItem = new MyMenuItem(stringArray[i]);
            char c = this.getNemonic(stringArray[i]);
            myMenuItem.setMnemonic(c);
            myMenuItem.setActionCommand(new Character(c).toString());
            myMenu.add(myMenuItem);
            myMenuItem.addActionListener(action);
        }
        return myMenu;
    }

    protected MyMenu addMenuItem(MyMenu myMenu, String string, Action action) {
        String[] stringArray = MyResourceBundle.getResourceStrings(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-")) {
                myMenu.addSeparator();
                continue;
            }
            MyMenuItem myMenuItem = new MyMenuItem(stringArray[i]);
            char c = this.getNemonic(stringArray[i]);
            myMenuItem.setMnemonic(c);
            myMenuItem.setActionCommand(new Character(c).toString());
            myMenu.add(myMenuItem);
            myMenuItem.addActionListener(action);
        }
        return myMenu;
    }

    protected MyMenu addCheckBoxMenuItem(String string, String string2, Action action) {
        ButtonGroup buttonGroup = new ButtonGroup();
        String string3 = MyResourceBundle.getResourceString(string);
        String[] stringArray = MyResourceBundle.getResourceStrings(string2);
        MyMenu myMenu = new MyMenu(string3);
        myMenu.setMnemonic(this.getNemonic(string3));
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-")) {
                myMenu.addSeparator();
                continue;
            }
            MyCheckBoxMenuItem myCheckBoxMenuItem = new MyCheckBoxMenuItem(stringArray[i]);
            char c = this.getNemonic(stringArray[i]);
            myCheckBoxMenuItem.setMnemonic(c);
            myCheckBoxMenuItem.setActionCommand(new Character(c).toString());
            myMenu.add(myCheckBoxMenuItem);
            myCheckBoxMenuItem.addActionListener(action);
        }
        return myMenu;
    }

    protected MyMenu addRadioButtonMenuItem(String string, String string2, Action action, int n) {
        ButtonGroup buttonGroup = new ButtonGroup();
        String string3 = MyResourceBundle.getResourceString(string);
        String[] stringArray = MyResourceBundle.getResourceStrings(string2);
        MyMenu myMenu = new MyMenu(string3);
        myMenu.setMnemonic(this.getNemonic(string3));
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-")) {
                myMenu.addSeparator();
                continue;
            }
            MyRadioButtonMenuItem myRadioButtonMenuItem = new MyRadioButtonMenuItem(stringArray[i]);
            char c = this.getNemonic(stringArray[i]);
            myRadioButtonMenuItem.setMnemonic(c);
            myRadioButtonMenuItem.setActionCommand(new Character(c).toString());
            myMenu.add(myRadioButtonMenuItem);
            myRadioButtonMenuItem.addActionListener(action);
            buttonGroup.add(myRadioButtonMenuItem);
            if (i != n) continue;
            myRadioButtonMenuItem.setSelected(true);
        }
        return myMenu;
    }

    protected MyMenu addRadioButtonMenuItem(MyMenu myMenu, String string, Action action, int n) {
        ButtonGroup buttonGroup = new ButtonGroup();
        String[] stringArray = MyResourceBundle.getResourceStrings(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-")) {
                myMenu.addSeparator();
                continue;
            }
            MyRadioButtonMenuItem myRadioButtonMenuItem = new MyRadioButtonMenuItem(stringArray[i]);
            char c = this.getNemonic(stringArray[i]);
            myRadioButtonMenuItem.setMnemonic(c);
            myRadioButtonMenuItem.setActionCommand(new Character(c).toString());
            myMenu.add(myRadioButtonMenuItem);
            myRadioButtonMenuItem.addActionListener(action);
            buttonGroup.add(myRadioButtonMenuItem);
            if (i != n) continue;
            myRadioButtonMenuItem.setSelected(true);
        }
        return myMenu;
    }

    public void addMessage(String string) {
        this.messageArea.append(string);
        this.messageArea.setCaretPosition(this.messageArea.getText().length());
    }

    public void addMessageln(String string) {
        this.messageArea.append(string);
        this.messageArea.append("\n");
        this.messageArea.setCaretPosition(this.messageArea.getText().length());
    }

    public void closeProcess() {
    }

    public void setDefaultCursor() {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void setWaitCursor() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setCrossCursor() {
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    protected Color getLabelColor(Color color) {
        int n = (color.getRed() + color.getGreen() + color.getBlue()) / 3;
        if (n < 128) {
            return Color.white;
        }
        return Color.black;
    }

    public static void main(String[] stringArray) {
        BaseWindow baseWindow = new BaseWindow("base Window");
        baseWindow.setMain();
        MyMenu myMenu = new MyMenu("File(F)");
        myMenu.setMnemonic('F');
        MyMenuItem myMenuItem = new MyMenuItem("Close(C)");
        myMenuItem.setMnemonic('C');
        myMenu.add(myMenuItem);
        baseWindow.getJMenuBar().add(myMenu);
        baseWindow.addHelpMenu();
        baseWindow.setVisible(true);
    }

    public class helpCommand
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = System.getProperty("os.name");
            String string2 = string.indexOf("Windows") != -1 ? "IEXPLORE " : "netscape ";
            ExecCommand.exec(string2 + BaseWindow.this.helpUrl, false);
        }
    }
}

