/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.AbinitMpFile;

import AbinitMp.AbinitMpFile.CpfAtomData;
import AbinitMp.Common.PdbFile;
import AbinitMp.Display.ColorMap;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.JOptionPane;

public class CheckPointFile {
    public String filename = null;
    public String comment = null;
    public int numberOfAtom;
    public int numberOfFragment;
    public Vector cpfAtomDatas;
    public int[] numberOfElectronInFragment;
    public int[] numberOfFragmentConnection;
    public int[][] infoFragmentConnection;
    private int[][] infoFragmentNoConnection;
    public String elecState = new String(" ");
    public PdbFile pdbFile;
    public float mullikenMinValue = 1.0E11f;
    public float mullikenMaxValue = -1.0E11f;
    public float displayMullikenMinValue = 0.0f;
    public float displayMullikenMaxValue = 0.0f;
    public ColorMap colorMap = null;
    public double[][] interactionEnergy;
    public double interactionEnergyMinValue = 9.9999997952E10;
    public double interactionEnergyMaxValue = -9.9999997952E10;
    public double displayInteractionEnergyMinValue = 0.0;
    public double displayInteractionEnergyMaxValue = 0.0;
    public double displayInteractionEnergyThreshold = 0.0;
    public ColorMap interactionEnergyColorMap = null;
    public double displayInteractionEnergyManyMinValue = -10.0;
    public double displayInteractionEnergyManyMaxValue = 10.0;
    public double displayInteractionEnergyManyThreshold = 0.0;

    public CheckPointFile(String string) {
        this.readFile(string);
        if (this.filename != null) {
            this.pdbFile = new PdbFile(this);
        }
    }

    public void readFile(String string) {
        this.initTable();
        try {
            int n;
            int n2;
            int n3;
            int n4;
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string2 = null;
            String string3 = "CPF";
            String string4 = bufferedReader.readLine();
            this.comment = string4.trim();
            string4 = bufferedReader.readLine();
            this.numberOfAtom = Integer.parseInt(string4.substring(0, 5).trim());
            this.numberOfFragment = Integer.parseInt(string4.substring(5, 10).trim());
            for (n4 = 0; n4 < this.numberOfAtom; ++n4) {
                String string5;
                string4 = bufferedReader.readLine();
                int n5 = Integer.parseInt(string4.substring(0, 5).trim());
                String string6 = string4.substring(6, 8).trim();
                String string7 = string4.substring(9, 13).trim();
                if (string7.length() == 0) {
                    string7 = string6;
                }
                if ((string5 = string4.substring(14, 17).trim()).length() == 0) {
                    string5 = "UKN";
                }
                int n6 = Integer.parseInt(string4.substring(18, 22).trim());
                int n7 = Integer.parseInt(string4.substring(23, 27).trim());
                float f = Float.parseFloat(string4.substring(28, 40));
                float f2 = Float.parseFloat(string4.substring(40, 52));
                float f3 = Float.parseFloat(string4.substring(52, 64));
                float f4 = Float.parseFloat(string4.substring(64, 76));
                this.mullikenMinValue = Math.min(f4, this.mullikenMinValue);
                this.mullikenMaxValue = Math.max(f4, this.mullikenMaxValue);
                float f5 = Float.parseFloat(string4.substring(76, 88));
                float f6 = Float.parseFloat(string4.substring(88, 100));
                float f7 = Float.parseFloat(string4.substring(100, 112));
                if (string4.length() > 112) {
                    string3 = string4.substring(113, 114);
                    string2 = string4.substring(115, 116);
                }
                CpfAtomData cpfAtomData = new CpfAtomData(n5, string6, string7, string5, n6, n7, f, f2, f3, f4, f5, f6, f7, string3, string2);
                this.cpfAtomDatas.add(cpfAtomData);
            }
            this.numberOfElectronInFragment = new int[this.numberOfFragment];
            this.numberOfFragmentConnection = new int[this.numberOfFragment];
            n4 = 0;
            block3: for (n3 = 0; n3 < (this.numberOfFragment - 1) / 16 + 1; ++n3) {
                string4 = bufferedReader.readLine();
                for (n2 = 0; n2 < 16; ++n2) {
                    this.numberOfElectronInFragment[n4] = Integer.parseInt(string4.substring(n2 * 5, (n2 + 1) * 5).trim());
                    if (++n4 == this.numberOfFragment) continue block3;
                }
            }
            n4 = 0;
            n3 = 0;
            block5: for (n2 = 0; n2 < (this.numberOfFragment - 1) / 16 + 1; ++n2) {
                string4 = bufferedReader.readLine();
                for (n = 0; n < 16; ++n) {
                    this.numberOfFragmentConnection[n4] = Integer.parseInt(string4.substring(n * 5, (n + 1) * 5).trim());
                    n3 += this.numberOfFragmentConnection[n4];
                    if (++n4 == this.numberOfFragment) continue block5;
                }
            }
            this.infoFragmentConnection = new int[n3][2];
            this.infoFragmentNoConnection = new int[n3][2];
            for (n2 = 0; n2 < n3; ++n2) {
                string4 = bufferedReader.readLine();
                this.infoFragmentConnection[n2][0] = Integer.parseInt(string4.substring(0, 5).trim());
                this.infoFragmentConnection[n2][1] = Integer.parseInt(string4.substring(5, 10).trim());
                this.infoFragmentNoConnection[n2][0] = ((CpfAtomData)this.cpfAtomDatas.get((int)(this.infoFragmentConnection[n2][0] - 1))).fragmentNo;
                this.infoFragmentNoConnection[n2][1] = ((CpfAtomData)this.cpfAtomDatas.get((int)(this.infoFragmentConnection[n2][1] - 1))).fragmentNo;
            }
            string4 = bufferedReader.readLine();
            if (!"END".equals(string4.trim())) {
                string4 = bufferedReader.readLine();
                this.elecState = string4.trim();
                if (!" ".equals(string4.substring(0, 1))) {
                    bufferedReader.readLine();
                    bufferedReader.readLine();
                    bufferedReader.readLine();
                    bufferedReader.readLine();
                    bufferedReader.readLine();
                    for (n2 = 0; n2 < this.numberOfFragment; ++n2) {
                        bufferedReader.readLine();
                    }
                    this.interactionEnergy = new double[this.numberOfFragment][this.numberOfFragment];
                    for (n2 = 1; n2 < this.numberOfFragment; ++n2) {
                        for (n = 0; n < n2; ++n) {
                            string4 = bufferedReader.readLine();
                            if (this.isConnectFragment(n2 + 1, n + 1)) continue;
                            int n8 = string4.indexOf(32, 10);
                            double d = (Double.parseDouble(string4.substring(1, n8).trim().replace('D', 'E')) + Double.parseDouble(string4.substring(n8).trim().replace('D', 'E'))) * (double)627.51f;
                            this.interactionEnergy[n][n2] = d;
                            this.interactionEnergy[n2][n] = d;
                            this.interactionEnergyMinValue = Math.min(this.interactionEnergy[n2][n], this.interactionEnergyMinValue);
                            this.interactionEnergyMaxValue = Math.max(this.interactionEnergy[n2][n], this.interactionEnergyMaxValue);
                        }
                    }
                }
            }
            this.filename = string;
            bufferedReader.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(new Frame(), "Check Point File read error (" + string + ").\n" + exception.getMessage(), "Error message", 0);
        }
        if (this.mullikenMinValue != 1.0E11f && this.mullikenMaxValue != -1.0E11f) {
            this.colorMap = new ColorMap(this.mullikenMinValue, this.mullikenMaxValue, 0);
        }
        if (this.interactionEnergyMinValue != 9.9999997952E10 && this.interactionEnergyMaxValue != -9.9999997952E10) {
            double d = this.interactionEnergyMinValue < 0.0 && Math.abs(this.interactionEnergyMinValue) < this.interactionEnergyMaxValue ? -this.interactionEnergyMaxValue : this.interactionEnergyMinValue;
            double d2 = this.interactionEnergyMaxValue > 0.0 && Math.abs(this.interactionEnergyMinValue) > this.interactionEnergyMaxValue ? -this.interactionEnergyMinValue : this.interactionEnergyMaxValue;
            this.interactionEnergyColorMap = new ColorMap((float)d, (float)d2, 0);
        }
    }

    private void initTable() {
        this.filename = null;
        this.cpfAtomDatas = new Vector();
    }

    public boolean isConnectFragment(int n, int n2) {
        boolean bl = false;
        for (int i = 0; i < this.infoFragmentNoConnection.length; ++i) {
            if ((this.infoFragmentNoConnection[i][0] != n || this.infoFragmentNoConnection[i][1] != n2) && (this.infoFragmentNoConnection[i][0] != n2 || this.infoFragmentNoConnection[i][1] != n)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void debugPrint(PrintStream printStream) {
        int n;
        printStream.println("Check point File (" + this.filename + ")");
        printStream.println("Comment : " + this.comment);
        printStream.println("atom " + this.numberOfAtom + " fragment " + this.numberOfFragment);
        for (n = 0; n < this.cpfAtomDatas.size(); ++n) {
            ((CpfAtomData)this.cpfAtomDatas.get(n)).debugPrint(printStream);
        }
        for (n = 0; n < this.numberOfFragment; ++n) {
            if ((n + 1) % 16 == 0) {
                printStream.println("");
            }
            printStream.print(this.numberOfElectronInFragment[n] + " ");
        }
        printStream.println("");
        for (n = 0; n < this.numberOfFragment; ++n) {
            if ((n + 1) % 16 == 0) {
                printStream.println("");
            }
            printStream.print(this.numberOfFragmentConnection[n] + " ");
        }
        printStream.println("");
        for (n = 0; n < this.infoFragmentConnection.length; ++n) {
            printStream.println(this.infoFragmentConnection[n][0] + " " + this.infoFragmentConnection[n][1]);
        }
        printStream.println("");
        for (n = 0; n < this.numberOfFragment; ++n) {
            for (int i = 0; i < this.numberOfFragment; ++i) {
                printStream.println(this.interactionEnergy[n][i]);
            }
            printStream.println("");
        }
        this.pdbFile.debugPrint(printStream);
    }

    public static void main(String[] stringArray) {
        CheckPointFile checkPointFile = new CheckPointFile(stringArray[0]);
        checkPointFile.debugPrint(System.out);
    }
}

