/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.Statistics;
import jas.util.xml.XMLNodeTraverser;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class StatisticsTraverser
extends XMLNodeTraverser
implements Statistics {
    private String[] names;
    private double[] values;
    private int cn = 0;
    private int cv = 0;

    StatisticsTraverser(Node node) throws XMLNodeTraverser.BadXMLException {
        Object[] objectArray;
        int n = node.getChildNodes().getLength();
        this.names = new String[n];
        this.values = new double[n];
        this.traverse(node);
        if (this.cn < n) {
            objectArray = new String[this.cn];
            System.arraycopy(this.names, 0, objectArray, 0, this.cn);
            this.names = objectArray;
        }
        if (this.cv < n) {
            objectArray = new double[this.cn];
            System.arraycopy(this.values, 0, objectArray, 0, this.cv);
            this.values = (double[])objectArray;
        }
    }

    protected void handleElement(Element element, String string) throws XMLNodeTraverser.BadXMLException {
        if (string.equals("statistic")) {
            this.traverse(element);
        } else {
            super.handleElement(element, string);
        }
    }

    protected void handleAttributeNode(Attr attr, String string, String string2) throws XMLNodeTraverser.BadXMLException {
        if (string.equals("value")) {
            this.values[this.cv++] = this.toDouble(string2);
        } else if (string.equals("name")) {
            this.names[this.cn++] = string2;
        } else {
            super.handleAttributeNode(attr, string, string2);
        }
    }

    public String[] getStatisticNames() {
        return this.names;
    }

    public double getStatistic(String string) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!string.equals(this.names[i])) continue;
            return this.values[i];
        }
        return 0.0;
    }
}

