/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.Basic1DFunction;
import jas.hist.DataSource;
import jas.hist.FunctionFactory;
import jas.hist.FunctionFactoryError;
import jas.hist.FunctionParamNodeTraverser;
import jas.hist.FunctionRegistry;
import jas.hist.FunctionStyle1DNodeTraverser;
import jas.hist.InvalidFunctionParameter;
import jas.hist.JASHist;
import jas.hist.JASHist1DFunctionStyle;
import jas.hist.JASHistStyle;
import jas.util.xml.XMLNodeTraverser;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class Function1DTraverser
extends XMLNodeTraverser {
    private String fitRef;
    private String refName;
    private boolean isVisible = true;
    private static FunctionRegistry theRegistry = FunctionRegistry.instance();
    private JASHist plot;
    private int yAxis;
    private JASHist1DFunctionStyle style;
    private String className;
    private Basic1DFunction function;
    private FunctionParamNodeTraverser fp = new FunctionParamNodeTraverser();
    private FunctionStyle1DNodeTraverser st = new FunctionStyle1DNodeTraverser();

    Function1DTraverser(Node node, JASHist jASHist) throws XMLNodeTraverser.BadXMLException {
        this.plot = jASHist;
        this.traverse(node);
    }

    protected void handleElement(Element element, String string) throws XMLNodeTraverser.BadXMLException {
        if (string.equals("functionStyle1d")) {
            this.style = new JASHist1DFunctionStyle();
            this.st.traverse(element, this.style);
        } else if (string.equals("fit")) {
            this.traverse(element);
        } else if (string.equals("functionParam")) {
            if (this.function != null) {
                try {
                    this.fp.traverse(element);
                    String string2 = this.fp.getName();
                    String[] stringArray = this.function.getParameterNames();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!stringArray[i].equals(string2)) continue;
                        this.function.setParameter(i, this.fp.getValue());
                        return;
                    }
                    throw new XMLNodeTraverser.BadXMLException("Unknown parameter " + string + " for function " + this.className);
                }
                catch (InvalidFunctionParameter invalidFunctionParameter) {
                    throw new XMLNodeTraverser.BadXMLException("Invalid value for parameter " + string + " for function " + this.className);
                }
            }
        } else {
            super.handleElement(element, string);
        }
    }

    protected void handleAttributeNode(Attr attr, String string, String string2) throws XMLNodeTraverser.BadXMLException {
        if (string.equals("axis")) {
            this.yAxis = this.toInt(string2.substring(1));
        } else if (string.equals("name")) {
            this.refName = string2;
        } else if (string.equals("isVisible")) {
            this.isVisible = this.toBoolean(string2);
        } else if (string.equals("ref")) {
            this.fitRef = string2;
        } else if (string.equals("type")) {
            this.className = string2;
            FunctionFactory functionFactory = theRegistry.find(string2);
            if (functionFactory == null) {
                System.err.println("Could not find function " + string2 + " in function registry -- ignored");
            } else {
                try {
                    this.function = functionFactory.createFunction(this.plot);
                }
                catch (FunctionFactoryError functionFactoryError) {
                    throw new XMLNodeTraverser.BadXMLException("Unable to create function " + string2);
                }
            }
        } else {
            super.handleAttributeNode(attr, string, string2);
        }
    }

    DataSource getDataSource() {
        return this.function;
    }

    int getYAxis() {
        return this.yAxis;
    }

    JASHistStyle getStyle() {
        return this.style;
    }

    boolean isVisible() {
        return this.isVisible;
    }

    String getRefName() {
        return this.refName;
    }

    String getFitRef() {
        return this.fitRef;
    }
}

