/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfResources;
import java.util.HashMap;
import java.util.Iterator;

class PageResources {
    protected PdfDictionary fontDictionary = new PdfDictionary();
    protected PdfDictionary xObjectDictionary = new PdfDictionary();
    protected PdfDictionary colorDictionary = new PdfDictionary();
    protected PdfDictionary patternDictionary = new PdfDictionary();
    protected PdfDictionary shadingDictionary = new PdfDictionary();
    protected PdfDictionary extGStateDictionary = new PdfDictionary();
    protected PdfDictionary LayerDictionary = new PdfDictionary();
    protected HashMap forbiddenNames;
    protected PdfDictionary originalResources;
    protected int[] namePtr = new int[]{0};
    protected HashMap usedNames;

    PageResources() {
    }

    void setOriginalResources(PdfDictionary pdfDictionary, int[] nArray) {
        if (nArray != null) {
            this.namePtr = nArray;
        }
        this.originalResources = pdfDictionary;
        this.forbiddenNames = new HashMap();
        this.usedNames = new HashMap();
        if (pdfDictionary == null) {
            return;
        }
        Iterator iterator = pdfDictionary.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get((PdfName)iterator.next()));
            if (!pdfObject.isDictionary()) continue;
            PdfDictionary pdfDictionary2 = (PdfDictionary)pdfObject;
            Iterator iterator2 = pdfDictionary2.getKeys().iterator();
            while (iterator2.hasNext()) {
                this.forbiddenNames.put(iterator2.next(), null);
            }
        }
    }

    PdfName translateName(PdfName pdfName) {
        PdfName pdfName2 = pdfName;
        if (this.forbiddenNames != null && (pdfName2 = (PdfName)this.usedNames.get(pdfName)) == null) {
            int n;
            do {
                n = this.namePtr[0];
                this.namePtr[0] = n + 1;
            } while (this.forbiddenNames.containsKey(pdfName2 = new PdfName("Xi" + n)));
            this.usedNames.put(pdfName, pdfName2);
        }
        return pdfName2;
    }

    PdfName addFont(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        pdfName = this.translateName(pdfName);
        this.fontDictionary.put(pdfName, pdfIndirectReference);
        return pdfName;
    }

    PdfName addXObject(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        pdfName = this.translateName(pdfName);
        this.xObjectDictionary.put(pdfName, pdfIndirectReference);
        return pdfName;
    }

    PdfName addColor(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        pdfName = this.translateName(pdfName);
        this.colorDictionary.put(pdfName, pdfIndirectReference);
        return pdfName;
    }

    void addDefaultColor(PdfName pdfName, PdfObject pdfObject) {
        if (pdfObject == null || pdfObject.isNull()) {
            this.colorDictionary.remove(pdfName);
        } else {
            this.colorDictionary.put(pdfName, pdfObject);
        }
    }

    void addDefaultColor(PdfDictionary pdfDictionary) {
        this.colorDictionary.merge(pdfDictionary);
    }

    void addDefaultColorDiff(PdfDictionary pdfDictionary) {
        this.colorDictionary.mergeDifferent(pdfDictionary);
    }

    PdfName addShading(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        pdfName = this.translateName(pdfName);
        this.shadingDictionary.put(pdfName, pdfIndirectReference);
        return pdfName;
    }

    PdfName addPattern(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        pdfName = this.translateName(pdfName);
        this.patternDictionary.put(pdfName, pdfIndirectReference);
        return pdfName;
    }

    PdfName addExtGState(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        pdfName = this.translateName(pdfName);
        this.extGStateDictionary.put(pdfName, pdfIndirectReference);
        return pdfName;
    }

    PdfName addLayer(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        pdfName = this.translateName(pdfName);
        this.LayerDictionary.put(pdfName, pdfIndirectReference);
        return pdfName;
    }

    PdfDictionary getResources() {
        PdfResources pdfResources = new PdfResources();
        if (this.originalResources != null) {
            pdfResources.putAll(this.originalResources);
        }
        pdfResources.put(PdfName.PROCSET, new PdfLiteral("[/PDF /Text /ImageB /ImageC /ImageI]"));
        pdfResources.add(PdfName.FONT, this.fontDictionary);
        pdfResources.add(PdfName.XOBJECT, this.xObjectDictionary);
        pdfResources.add(PdfName.COLORSPACE, this.colorDictionary);
        pdfResources.add(PdfName.PATTERN, this.patternDictionary);
        pdfResources.add(PdfName.SHADING, this.shadingDictionary);
        pdfResources.add(PdfName.EXTGSTATE, this.extGStateDictionary);
        pdfResources.add(PdfName.PROPERTIES, this.LayerDictionary);
        return pdfResources;
    }
}

