/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.oculusvr;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.DynamicLibraryBundle;
import com.jogamp.oculusvr.OVRDynamicLibraryBundleInfo;
import com.jogamp.oculusvr.OVRException;
import com.jogamp.oculusvr.ovrDistortionMesh;
import com.jogamp.oculusvr.ovrEyeRenderDesc;
import com.jogamp.oculusvr.ovrFovPort;
import com.jogamp.oculusvr.ovrFrameTiming;
import com.jogamp.oculusvr.ovrHmdDesc;
import com.jogamp.oculusvr.ovrInitParams;
import com.jogamp.oculusvr.ovrMatrix4f;
import com.jogamp.oculusvr.ovrPosef;
import com.jogamp.oculusvr.ovrQuatf;
import com.jogamp.oculusvr.ovrRecti;
import com.jogamp.oculusvr.ovrSizei;
import com.jogamp.oculusvr.ovrTrackingState;
import com.jogamp.oculusvr.ovrVector2f;
import com.jogamp.oculusvr.ovrVector3f;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class OVR {
    public static final int ovrHmd_None = 0;
    public static final int ovrHmd_DK1 = 3;
    public static final int ovrHmd_DKHD = 4;
    public static final int ovrHmd_DK2 = 6;
    public static final int ovrHmd_BlackStar = 7;
    public static final int ovrHmd_CB = 8;
    public static final int ovrHmd_Other = 9;
    public static final int ovrHmd_EnumSize = Integer.MAX_VALUE;
    public static final int ovrDistortionCap_TimeWarp = 2;
    public static final int ovrDistortionCap_Vignette = 8;
    public static final int ovrDistortionCap_NoRestore = 16;
    public static final int ovrDistortionCap_FlipInput = 32;
    public static final int ovrDistortionCap_SRGB = 64;
    public static final int ovrDistortionCap_Overdrive = 128;
    public static final int ovrDistortionCap_HqDistortion = 256;
    public static final int ovrDistortionCap_LinuxDevFullscreen = 512;
    public static final int ovrDistortionCap_ComputeShader = 1024;
    public static final int ovrDistortionCap_TimewarpJitDelay = 4096;
    public static final int ovrDistortionCap_ProfileNoSpinWaits = 65536;
    public static final int ovrDistortionCap_EnumSize = Integer.MAX_VALUE;
    public static final int ovrHmdCap_Present = 1;
    public static final int ovrHmdCap_Available = 2;
    public static final int ovrHmdCap_Captured = 4;
    public static final int ovrHmdCap_ExtendDesktop = 8;
    public static final int ovrHmdCap_DebugDevice = 16;
    public static final int ovrHmdCap_NoMirrorToWindow = 8192;
    public static final int ovrHmdCap_DisplayOff = 64;
    public static final int ovrHmdCap_LowPersistence = 128;
    public static final int ovrHmdCap_DynamicPrediction = 512;
    public static final int ovrHmdCap_NoVSync = 4096;
    public static final int ovrHmdCap_Writable_Mask = 12992;
    public static final int ovrHmdCap_Service_Mask = 8896;
    public static final int ovrHmdCap_EnumSize = Integer.MAX_VALUE;
    public static final int ovrInit_Debug = 1;
    public static final int ovrInit_ServerOptional = 2;
    public static final int ovrInit_RequestVersion = 4;
    public static final int ovrInit_ForceNoDebug = 8;
    public static final int ovrStatus_OrientationTracked = 1;
    public static final int ovrStatus_PositionTracked = 2;
    public static final int ovrStatus_CameraPoseTracked = 4;
    public static final int ovrStatus_PositionConnected = 32;
    public static final int ovrStatus_HmdConnected = 128;
    public static final int ovrStatus_EnumSize = Integer.MAX_VALUE;
    public static final int ovrTrackingCap_Orientation = 16;
    public static final int ovrTrackingCap_MagYawCorrection = 32;
    public static final int ovrTrackingCap_Position = 64;
    public static final int ovrTrackingCap_Idle = 256;
    public static final int ovrTrackingCap_EnumSize = Integer.MAX_VALUE;
    public static final int ovrEye_Left = 0;
    public static final int ovrEye_Right = 1;
    public static final int ovrEye_Count = 2;
    public static final int ovrEye_EnumSize = Integer.MAX_VALUE;
    public static final int ovrProjection_None = 0;
    public static final int ovrProjection_RightHanded = 1;
    public static final int ovrProjection_FarLessThanNear = 2;
    public static final int ovrProjection_FarClipAtInfinity = 4;
    public static final int ovrProjection_ClipRangeOpenGL = 8;
    public static final int ovrLogLevel_Debug = 0;
    public static final int ovrLogLevel_Info = 1;
    public static final int ovrLogLevel_Error = 2;
    public static final long ovrRenderAPI_None = 0L;
    public static final long ovrRenderAPI_Count = 1L;
    public static final int ovrRenderAPI_EnumSize = Integer.MAX_VALUE;
    public static final int ovrTrue = 1;
    public static final int HEADLESS_APP = 1;
    public static final int OVR_PRODUCT_VERSION = 0;
    public static final int OVR_DK2_LATEST_FIRMWARE_MINOR_VERSION = 12;
    public static final int OVR_MAJOR_VERSION = 5;
    public static final float OVR_DEFAULT_IPD = 0.064f;
    public static final float OVR_DEFAULT_NECK_TO_EYE_HORIZONTAL = 0.0805f;
    public static final int ovrFalse = 0;
    public static final int OVR_MINOR_VERSION = 0;
    public static final int ovrDistortionCap_Chromatic = 1;
    public static final int OVR_BUILD_NUMBER = 0;
    public static final float OVR_DEFAULT_NECK_TO_EYE_VERTICAL = 0.075f;
    public static final int OVR_PATCH_VERSION = 1;
    public static final float OVR_DEFAULT_PLAYER_HEIGHT = 1.778f;
    public static final float OVR_DEFAULT_EYE_HEIGHT = 1.675f;
    public static final int OVR_DK2_LATEST_FIRMWARE_MAJOR_VERSION = 2;
    public static final int OVR_DEFAULT_EYE_RELIEF_DIAL = 3;
    static final DynamicLibraryBundle dynamicLookupHelper = AccessController.doPrivileged(new PrivilegedAction<DynamicLibraryBundle>(){

        @Override
        public DynamicLibraryBundle run() {
            DynamicLibraryBundle dynamicLibraryBundle = new DynamicLibraryBundle(new OVRDynamicLibraryBundleInfo());
            if (null == dynamicLibraryBundle) {
                throw new RuntimeException("Null DynamicLibraryBundle");
            }
            if (!dynamicLibraryBundle.isLibComplete()) {
                System.err.println("Couldn't load native OVR/JNI glue library");
                return null;
            }
            if (!OVR.initializeImpl()) {
                System.err.println("Native initialization failure of OVR/JNI glue library");
                return null;
            }
            return dynamicLibraryBundle;
        }
    });

    public static boolean ovr_Initialize(ovrInitParams ovrInitParams2) {
        if (!OVR.isAvailable()) {
            return false;
        }
        return OVR.ovr_Initialize1(ovrInitParams2 == null ? null : ovrInitParams2.getBuffer());
    }

    private static native boolean ovr_Initialize1(ByteBuffer var0);

    public static native void ovr_Shutdown();

    public static ByteBuffer ovr_GetVersionString() {
        ByteBuffer byteBuffer = OVR.ovr_GetVersionString1();
        if (byteBuffer == null) {
            return null;
        }
        Buffers.nativeOrder(byteBuffer);
        return byteBuffer;
    }

    private static native ByteBuffer ovr_GetVersionString1();

    public static native int ovrHmd_Detect();

    public static ovrHmdDesc ovrHmd_Create(int n) {
        if (!OVR.isAvailable()) {
            return null;
        }
        ByteBuffer byteBuffer = OVR.ovrHmd_Create1(n);
        if (byteBuffer == null) {
            return null;
        }
        return ovrHmdDesc.create(Buffers.nativeOrder(byteBuffer));
    }

    private static native ByteBuffer ovrHmd_Create1(int var0);

    public static void ovrHmd_Destroy(ovrHmdDesc ovrHmdDesc2) {
        OVR.ovrHmd_Destroy1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer());
    }

    private static native void ovrHmd_Destroy1(ByteBuffer var0);

    public static ovrHmdDesc ovrHmd_CreateDebug(int n) {
        if (!OVR.isAvailable()) {
            return null;
        }
        ByteBuffer byteBuffer = OVR.ovrHmd_CreateDebug1(n);
        if (byteBuffer == null) {
            return null;
        }
        return ovrHmdDesc.create(Buffers.nativeOrder(byteBuffer));
    }

    private static native ByteBuffer ovrHmd_CreateDebug1(int var0);

    public static String ovrHmd_GetLastError(ovrHmdDesc ovrHmdDesc2) {
        return OVR.ovrHmd_GetLastError1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer());
    }

    private static native String ovrHmd_GetLastError1(ByteBuffer var0);

    public static int ovrHmd_GetEnabledCaps(ovrHmdDesc ovrHmdDesc2) {
        return OVR.ovrHmd_GetEnabledCaps1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer());
    }

    private static native int ovrHmd_GetEnabledCaps1(ByteBuffer var0);

    public static void ovrHmd_SetEnabledCaps(ovrHmdDesc ovrHmdDesc2, int n) {
        OVR.ovrHmd_SetEnabledCaps1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), n);
    }

    private static native void ovrHmd_SetEnabledCaps1(ByteBuffer var0, int var1);

    public static boolean ovrHmd_ConfigureTracking(ovrHmdDesc ovrHmdDesc2, int n, int n2) {
        return OVR.ovrHmd_ConfigureTracking1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), n, n2);
    }

    private static native boolean ovrHmd_ConfigureTracking1(ByteBuffer var0, int var1, int var2);

    public static void ovrHmd_RecenterPose(ovrHmdDesc ovrHmdDesc2) {
        OVR.ovrHmd_RecenterPose1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer());
    }

    private static native void ovrHmd_RecenterPose1(ByteBuffer var0);

    public static ovrTrackingState ovrHmd_GetTrackingState(ovrHmdDesc ovrHmdDesc2, double d) {
        ByteBuffer byteBuffer = OVR.ovrHmd_GetTrackingState1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), d);
        if (byteBuffer == null) {
            return null;
        }
        return ovrTrackingState.create(Buffers.nativeOrder(byteBuffer));
    }

    private static native ByteBuffer ovrHmd_GetTrackingState1(ByteBuffer var0, double var1);

    public static ovrSizei ovrHmd_GetFovTextureSize(ovrHmdDesc ovrHmdDesc2, int n, ovrFovPort ovrFovPort2, float f) {
        ByteBuffer byteBuffer = OVR.ovrHmd_GetFovTextureSize1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), n, ovrFovPort2 == null ? null : ovrFovPort2.getBuffer(), f);
        if (byteBuffer == null) {
            return null;
        }
        return ovrSizei.create(Buffers.nativeOrder(byteBuffer));
    }

    private static native ByteBuffer ovrHmd_GetFovTextureSize1(ByteBuffer var0, int var1, ByteBuffer var2, float var3);

    public static void ovrHmd_GetEyePoses(ovrHmdDesc ovrHmdDesc2, int n, ovrVector3f[] ovrVector3fArray, ovrPosef[] ovrPosefArray, ovrTrackingState ovrTrackingState2) {
        int n2;
        if (ovrVector3fArray.length < 2) {
            throw new OVRException("Array \"hmdToEyeViewOffset\" length (" + ovrVector3fArray.length + ") was less than the required (2)");
        }
        if (ovrPosefArray.length < 2) {
            throw new OVRException("Array \"outEyePoses\" length (" + ovrPosefArray.length + ") was less than the required (2)");
        }
        ByteBuffer[] byteBufferArray = new ByteBuffer[ovrVector3fArray.length];
        for (int i = 0; i < ovrVector3fArray.length; ++i) {
            ovrVector3f ovrVector3f2 = ovrVector3fArray[i];
            byteBufferArray[i] = ovrVector3f2 == null ? null : ovrVector3f2.getBuffer();
        }
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[ovrPosefArray.length];
        for (n2 = 0; n2 < ovrPosefArray.length; ++n2) {
            ovrPosef ovrPosef2 = ovrPosefArray[n2];
            byteBufferArray2[n2] = ovrPosef2 == null ? null : ovrPosef2.getBuffer();
        }
        OVR.ovrHmd_GetEyePoses1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), n, byteBufferArray, byteBufferArray2, ovrTrackingState2 == null ? null : ovrTrackingState2.getBuffer());
        for (n2 = 0; n2 < ovrPosefArray.length; ++n2) {
            if (ovrPosefArray[n2] == null && byteBufferArray2[n2] == null || ovrPosefArray[n2] != null && ovrPosefArray[n2].getBuffer() == byteBufferArray2[n2]) continue;
            ovrPosefArray[n2] = byteBufferArray2[n2] == null ? null : ovrPosef.create(byteBufferArray2[n2]);
        }
    }

    private static native void ovrHmd_GetEyePoses1(ByteBuffer var0, int var1, ByteBuffer[] var2, ByteBuffer[] var3, ByteBuffer var4);

    public static ovrPosef ovrHmd_GetHmdPosePerEye(ovrHmdDesc ovrHmdDesc2, int n) {
        ByteBuffer byteBuffer = OVR.ovrHmd_GetHmdPosePerEye1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), n);
        if (byteBuffer == null) {
            return null;
        }
        return ovrPosef.create(Buffers.nativeOrder(byteBuffer));
    }

    private static native ByteBuffer ovrHmd_GetHmdPosePerEye1(ByteBuffer var0, int var1);

    public static ovrEyeRenderDesc ovrHmd_GetRenderDesc(ovrHmdDesc ovrHmdDesc2, int n, ovrFovPort ovrFovPort2) {
        ByteBuffer byteBuffer = OVR.ovrHmd_GetRenderDesc1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), n, ovrFovPort2 == null ? null : ovrFovPort2.getBuffer());
        if (byteBuffer == null) {
            return null;
        }
        return ovrEyeRenderDesc.create(Buffers.nativeOrder(byteBuffer));
    }

    private static native ByteBuffer ovrHmd_GetRenderDesc1(ByteBuffer var0, int var1, ByteBuffer var2);

    public static boolean ovrHmd_CreateDistortionMesh(ovrHmdDesc ovrHmdDesc2, int n, ovrFovPort ovrFovPort2, int n2, ovrDistortionMesh ovrDistortionMesh2) {
        return OVR.ovrHmd_CreateDistortionMesh1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), n, ovrFovPort2 == null ? null : ovrFovPort2.getBuffer(), n2, ovrDistortionMesh2 == null ? null : ovrDistortionMesh2.getBuffer());
    }

    private static native boolean ovrHmd_CreateDistortionMesh1(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4);

    public static boolean ovrHmd_CreateDistortionMeshDebug(ovrHmdDesc ovrHmdDesc2, int n, ovrFovPort ovrFovPort2, int n2, ovrDistortionMesh ovrDistortionMesh2, float f) {
        return OVR.ovrHmd_CreateDistortionMeshDebug1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), n, ovrFovPort2 == null ? null : ovrFovPort2.getBuffer(), n2, ovrDistortionMesh2 == null ? null : ovrDistortionMesh2.getBuffer(), f);
    }

    private static native boolean ovrHmd_CreateDistortionMeshDebug1(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, float var5);

    public static void ovrHmd_DestroyDistortionMesh(ovrDistortionMesh ovrDistortionMesh2) {
        OVR.ovrHmd_DestroyDistortionMesh1(ovrDistortionMesh2 == null ? null : ovrDistortionMesh2.getBuffer());
    }

    private static native void ovrHmd_DestroyDistortionMesh1(ByteBuffer var0);

    public static void ovrHmd_GetRenderScaleAndOffset(ovrFovPort ovrFovPort2, ovrSizei ovrSizei2, ovrRecti ovrRecti2, ovrVector2f[] ovrVector2fArray) {
        int n;
        if (ovrVector2fArray.length < 2) {
            throw new OVRException("Array \"uvScaleOffsetOut\" length (" + ovrVector2fArray.length + ") was less than the required (2)");
        }
        ByteBuffer[] byteBufferArray = new ByteBuffer[ovrVector2fArray.length];
        for (n = 0; n < ovrVector2fArray.length; ++n) {
            ovrVector2f ovrVector2f2 = ovrVector2fArray[n];
            byteBufferArray[n] = ovrVector2f2 == null ? null : ovrVector2f2.getBuffer();
        }
        OVR.ovrHmd_GetRenderScaleAndOffset1(ovrFovPort2 == null ? null : ovrFovPort2.getBuffer(), ovrSizei2 == null ? null : ovrSizei2.getBuffer(), ovrRecti2 == null ? null : ovrRecti2.getBuffer(), byteBufferArray);
        for (n = 0; n < ovrVector2fArray.length; ++n) {
            if (ovrVector2fArray[n] == null && byteBufferArray[n] == null || ovrVector2fArray[n] != null && ovrVector2fArray[n].getBuffer() == byteBufferArray[n]) continue;
            ovrVector2fArray[n] = byteBufferArray[n] == null ? null : ovrVector2f.create(byteBufferArray[n]);
        }
    }

    private static native void ovrHmd_GetRenderScaleAndOffset1(ByteBuffer var0, ByteBuffer var1, ByteBuffer var2, ByteBuffer[] var3);

    public static ovrFrameTiming ovrHmd_GetFrameTiming(ovrHmdDesc ovrHmdDesc2, int n) {
        ByteBuffer byteBuffer = OVR.ovrHmd_GetFrameTiming1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), n);
        if (byteBuffer == null) {
            return null;
        }
        return ovrFrameTiming.create(Buffers.nativeOrder(byteBuffer));
    }

    private static native ByteBuffer ovrHmd_GetFrameTiming1(ByteBuffer var0, int var1);

    public static ovrFrameTiming ovrHmd_BeginFrameTiming(ovrHmdDesc ovrHmdDesc2, int n) {
        ByteBuffer byteBuffer = OVR.ovrHmd_BeginFrameTiming1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), n);
        if (byteBuffer == null) {
            return null;
        }
        return ovrFrameTiming.create(Buffers.nativeOrder(byteBuffer));
    }

    private static native ByteBuffer ovrHmd_BeginFrameTiming1(ByteBuffer var0, int var1);

    public static void ovrHmd_EndFrameTiming(ovrHmdDesc ovrHmdDesc2) {
        OVR.ovrHmd_EndFrameTiming1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer());
    }

    private static native void ovrHmd_EndFrameTiming1(ByteBuffer var0);

    public static void ovrHmd_ResetFrameTiming(ovrHmdDesc ovrHmdDesc2, int n) {
        OVR.ovrHmd_ResetFrameTiming1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), n);
    }

    private static native void ovrHmd_ResetFrameTiming1(ByteBuffer var0, int var1);

    public static void ovrHmd_GetEyeTimewarpMatrices(ovrHmdDesc ovrHmdDesc2, int n, ovrPosef ovrPosef2, ovrMatrix4f[] ovrMatrix4fArray) {
        int n2;
        if (ovrMatrix4fArray.length < 2) {
            throw new OVRException("Array \"twmOut\" length (" + ovrMatrix4fArray.length + ") was less than the required (2)");
        }
        ByteBuffer[] byteBufferArray = new ByteBuffer[ovrMatrix4fArray.length];
        for (n2 = 0; n2 < ovrMatrix4fArray.length; ++n2) {
            ovrMatrix4f ovrMatrix4f2 = ovrMatrix4fArray[n2];
            byteBufferArray[n2] = ovrMatrix4f2 == null ? null : ovrMatrix4f2.getBuffer();
        }
        OVR.ovrHmd_GetEyeTimewarpMatrices1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), n, ovrPosef2 == null ? null : ovrPosef2.getBuffer(), byteBufferArray);
        for (n2 = 0; n2 < ovrMatrix4fArray.length; ++n2) {
            if (ovrMatrix4fArray[n2] == null && byteBufferArray[n2] == null || ovrMatrix4fArray[n2] != null && ovrMatrix4fArray[n2].getBuffer() == byteBufferArray[n2]) continue;
            ovrMatrix4fArray[n2] = byteBufferArray[n2] == null ? null : ovrMatrix4f.create(byteBufferArray[n2]);
        }
    }

    private static native void ovrHmd_GetEyeTimewarpMatrices1(ByteBuffer var0, int var1, ByteBuffer var2, ByteBuffer[] var3);

    public static void ovrHmd_GetEyeTimewarpMatricesDebug(ovrHmdDesc ovrHmdDesc2, int n, ovrPosef ovrPosef2, ovrQuatf ovrQuatf2, ovrMatrix4f[] ovrMatrix4fArray, double d) {
        int n2;
        if (ovrMatrix4fArray.length < 2) {
            throw new OVRException("Array \"twmOut\" length (" + ovrMatrix4fArray.length + ") was less than the required (2)");
        }
        ByteBuffer[] byteBufferArray = new ByteBuffer[ovrMatrix4fArray.length];
        for (n2 = 0; n2 < ovrMatrix4fArray.length; ++n2) {
            ovrMatrix4f ovrMatrix4f2 = ovrMatrix4fArray[n2];
            byteBufferArray[n2] = ovrMatrix4f2 == null ? null : ovrMatrix4f2.getBuffer();
        }
        OVR.ovrHmd_GetEyeTimewarpMatricesDebug1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), n, ovrPosef2 == null ? null : ovrPosef2.getBuffer(), ovrQuatf2 == null ? null : ovrQuatf2.getBuffer(), byteBufferArray, d);
        for (n2 = 0; n2 < ovrMatrix4fArray.length; ++n2) {
            if (ovrMatrix4fArray[n2] == null && byteBufferArray[n2] == null || ovrMatrix4fArray[n2] != null && ovrMatrix4fArray[n2].getBuffer() == byteBufferArray[n2]) continue;
            ovrMatrix4fArray[n2] = byteBufferArray[n2] == null ? null : ovrMatrix4f.create(byteBufferArray[n2]);
        }
    }

    private static native void ovrHmd_GetEyeTimewarpMatricesDebug1(ByteBuffer var0, int var1, ByteBuffer var2, ByteBuffer var3, ByteBuffer[] var4, double var5);

    public static native double ovr_GetTimeInSeconds();

    public static boolean ovrHmd_ProcessLatencyTest(ovrHmdDesc ovrHmdDesc2, ByteBuffer byteBuffer) {
        if (Buffers.remainingElem(byteBuffer) < 3) {
            throw new OVRException("Array \"rgbColorOut\" length (" + Buffers.remainingElem(byteBuffer) + ") was less than the required (3)");
        }
        boolean bl = Buffers.isDirect(byteBuffer);
        return OVR.ovrHmd_ProcessLatencyTest1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), bl ? byteBuffer : Buffers.getArray(byteBuffer), bl ? Buffers.getDirectBufferByteOffset(byteBuffer) : Buffers.getIndirectBufferByteOffset(byteBuffer), bl);
    }

    private static native boolean ovrHmd_ProcessLatencyTest1(ByteBuffer var0, Object var1, int var2, boolean var3);

    public static boolean ovrHmd_ProcessLatencyTest(ovrHmdDesc ovrHmdDesc2, byte[] byArray, int n) {
        if (byArray.length < 3) {
            throw new OVRException("Array \"rgbColorOut\" length (" + byArray.length + ") was less than the required (3)");
        }
        if (byArray != null && byArray.length <= n) {
            throw new OVRException("array offset argument \"rgbColorOut_offset\" (" + n + ") equals or exceeds array length (" + byArray.length + ")");
        }
        return OVR.ovrHmd_ProcessLatencyTest1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), byArray, n, false);
    }

    public static String ovrHmd_GetLatencyTestResult(ovrHmdDesc ovrHmdDesc2) {
        return OVR.ovrHmd_GetLatencyTestResult1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer());
    }

    private static native String ovrHmd_GetLatencyTestResult1(ByteBuffer var0);

    public static boolean ovrHmd_GetLatencyTest2DrawColor(ovrHmdDesc ovrHmdDesc2, ByteBuffer byteBuffer) {
        if (Buffers.remainingElem(byteBuffer) < 3) {
            throw new OVRException("Array \"rgbColorOut\" length (" + Buffers.remainingElem(byteBuffer) + ") was less than the required (3)");
        }
        boolean bl = Buffers.isDirect(byteBuffer);
        return OVR.ovrHmd_GetLatencyTest2DrawColor1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), bl ? byteBuffer : Buffers.getArray(byteBuffer), bl ? Buffers.getDirectBufferByteOffset(byteBuffer) : Buffers.getIndirectBufferByteOffset(byteBuffer), bl);
    }

    private static native boolean ovrHmd_GetLatencyTest2DrawColor1(ByteBuffer var0, Object var1, int var2, boolean var3);

    public static boolean ovrHmd_GetLatencyTest2DrawColor(ovrHmdDesc ovrHmdDesc2, byte[] byArray, int n) {
        if (byArray.length < 3) {
            throw new OVRException("Array \"rgbColorOut\" length (" + byArray.length + ") was less than the required (3)");
        }
        if (byArray != null && byArray.length <= n) {
            throw new OVRException("array offset argument \"rgbColorOut_offset\" (" + n + ") equals or exceeds array length (" + byArray.length + ")");
        }
        return OVR.ovrHmd_GetLatencyTest2DrawColor1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), byArray, n, false);
    }

    public static boolean ovrHmd_GetBool(ovrHmdDesc ovrHmdDesc2, ByteBuffer byteBuffer, boolean bl) {
        boolean bl2 = Buffers.isDirect(byteBuffer);
        return OVR.ovrHmd_GetBool1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), bl2 ? byteBuffer : Buffers.getArray(byteBuffer), bl2 ? Buffers.getDirectBufferByteOffset(byteBuffer) : Buffers.getIndirectBufferByteOffset(byteBuffer), bl2, bl);
    }

    private static native boolean ovrHmd_GetBool1(ByteBuffer var0, Object var1, int var2, boolean var3, boolean var4);

    public static boolean ovrHmd_GetBool(ovrHmdDesc ovrHmdDesc2, byte[] byArray, int n, boolean bl) {
        if (byArray != null && byArray.length <= n) {
            throw new OVRException("array offset argument \"propertyName_offset\" (" + n + ") equals or exceeds array length (" + byArray.length + ")");
        }
        return OVR.ovrHmd_GetBool1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), byArray, n, false, bl);
    }

    public static boolean ovrHmd_SetBool(ovrHmdDesc ovrHmdDesc2, ByteBuffer byteBuffer, boolean bl) {
        boolean bl2 = Buffers.isDirect(byteBuffer);
        return OVR.ovrHmd_SetBool1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), bl2 ? byteBuffer : Buffers.getArray(byteBuffer), bl2 ? Buffers.getDirectBufferByteOffset(byteBuffer) : Buffers.getIndirectBufferByteOffset(byteBuffer), bl2, bl);
    }

    private static native boolean ovrHmd_SetBool1(ByteBuffer var0, Object var1, int var2, boolean var3, boolean var4);

    public static boolean ovrHmd_SetBool(ovrHmdDesc ovrHmdDesc2, byte[] byArray, int n, boolean bl) {
        if (byArray != null && byArray.length <= n) {
            throw new OVRException("array offset argument \"propertyName_offset\" (" + n + ") equals or exceeds array length (" + byArray.length + ")");
        }
        return OVR.ovrHmd_SetBool1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), byArray, n, false, bl);
    }

    public static int ovrHmd_GetInt(ovrHmdDesc ovrHmdDesc2, ByteBuffer byteBuffer, int n) {
        boolean bl = Buffers.isDirect(byteBuffer);
        return OVR.ovrHmd_GetInt1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), bl ? byteBuffer : Buffers.getArray(byteBuffer), bl ? Buffers.getDirectBufferByteOffset(byteBuffer) : Buffers.getIndirectBufferByteOffset(byteBuffer), bl, n);
    }

    private static native int ovrHmd_GetInt1(ByteBuffer var0, Object var1, int var2, boolean var3, int var4);

    public static int ovrHmd_GetInt(ovrHmdDesc ovrHmdDesc2, byte[] byArray, int n, int n2) {
        if (byArray != null && byArray.length <= n) {
            throw new OVRException("array offset argument \"propertyName_offset\" (" + n + ") equals or exceeds array length (" + byArray.length + ")");
        }
        return OVR.ovrHmd_GetInt1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), byArray, n, false, n2);
    }

    public static boolean ovrHmd_SetInt(ovrHmdDesc ovrHmdDesc2, ByteBuffer byteBuffer, int n) {
        boolean bl = Buffers.isDirect(byteBuffer);
        return OVR.ovrHmd_SetInt1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), bl ? byteBuffer : Buffers.getArray(byteBuffer), bl ? Buffers.getDirectBufferByteOffset(byteBuffer) : Buffers.getIndirectBufferByteOffset(byteBuffer), bl, n);
    }

    private static native boolean ovrHmd_SetInt1(ByteBuffer var0, Object var1, int var2, boolean var3, int var4);

    public static boolean ovrHmd_SetInt(ovrHmdDesc ovrHmdDesc2, byte[] byArray, int n, int n2) {
        if (byArray != null && byArray.length <= n) {
            throw new OVRException("array offset argument \"propertyName_offset\" (" + n + ") equals or exceeds array length (" + byArray.length + ")");
        }
        return OVR.ovrHmd_SetInt1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), byArray, n, false, n2);
    }

    public static float ovrHmd_GetFloat(ovrHmdDesc ovrHmdDesc2, String string, float f) {
        return OVR.ovrHmd_GetFloat1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), string, f);
    }

    private static native float ovrHmd_GetFloat1(ByteBuffer var0, String var1, float var2);

    public static boolean ovrHmd_SetFloat(ovrHmdDesc ovrHmdDesc2, String string, float f) {
        return OVR.ovrHmd_SetFloat1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), string, f);
    }

    private static native boolean ovrHmd_SetFloat1(ByteBuffer var0, String var1, float var2);

    public static int ovrHmd_GetFloatArray(ovrHmdDesc ovrHmdDesc2, String string, FloatBuffer floatBuffer, int n) {
        boolean bl = Buffers.isDirect(floatBuffer);
        return OVR.ovrHmd_GetFloatArray1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), string, bl ? floatBuffer : Buffers.getArray(floatBuffer), bl ? Buffers.getDirectBufferByteOffset(floatBuffer) : Buffers.getIndirectBufferByteOffset(floatBuffer), bl, n);
    }

    private static native int ovrHmd_GetFloatArray1(ByteBuffer var0, String var1, Object var2, int var3, boolean var4, int var5);

    public static int ovrHmd_GetFloatArray(ovrHmdDesc ovrHmdDesc2, String string, float[] fArray, int n, int n2) {
        if (fArray != null && fArray.length <= n) {
            throw new OVRException("array offset argument \"values_offset\" (" + n + ") equals or exceeds array length (" + fArray.length + ")");
        }
        return OVR.ovrHmd_GetFloatArray1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), string, fArray, 4 * n, false, n2);
    }

    public static boolean ovrHmd_SetFloatArray(ovrHmdDesc ovrHmdDesc2, String string, FloatBuffer floatBuffer, int n) {
        boolean bl = Buffers.isDirect(floatBuffer);
        return OVR.ovrHmd_SetFloatArray1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), string, bl ? floatBuffer : Buffers.getArray(floatBuffer), bl ? Buffers.getDirectBufferByteOffset(floatBuffer) : Buffers.getIndirectBufferByteOffset(floatBuffer), bl, n);
    }

    private static native boolean ovrHmd_SetFloatArray1(ByteBuffer var0, String var1, Object var2, int var3, boolean var4, int var5);

    public static boolean ovrHmd_SetFloatArray(ovrHmdDesc ovrHmdDesc2, String string, float[] fArray, int n, int n2) {
        if (fArray != null && fArray.length <= n) {
            throw new OVRException("array offset argument \"values_offset\" (" + n + ") equals or exceeds array length (" + fArray.length + ")");
        }
        return OVR.ovrHmd_SetFloatArray1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), string, fArray, 4 * n, false, n2);
    }

    public static String ovrHmd_GetString(ovrHmdDesc ovrHmdDesc2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        boolean bl = Buffers.isDirect(byteBuffer);
        boolean bl2 = Buffers.isDirect(byteBuffer2);
        return OVR.ovrHmd_GetString1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), bl ? byteBuffer : Buffers.getArray(byteBuffer), bl ? Buffers.getDirectBufferByteOffset(byteBuffer) : Buffers.getIndirectBufferByteOffset(byteBuffer), bl, bl2 ? byteBuffer2 : Buffers.getArray(byteBuffer2), bl2 ? Buffers.getDirectBufferByteOffset(byteBuffer2) : Buffers.getIndirectBufferByteOffset(byteBuffer2), bl2);
    }

    private static native String ovrHmd_GetString1(ByteBuffer var0, Object var1, int var2, boolean var3, Object var4, int var5, boolean var6);

    public static String ovrHmd_GetString(ovrHmdDesc ovrHmdDesc2, byte[] byArray, int n, byte[] byArray2, int n2) {
        if (byArray != null && byArray.length <= n) {
            throw new OVRException("array offset argument \"propertyName_offset\" (" + n + ") equals or exceeds array length (" + byArray.length + ")");
        }
        if (byArray2 != null && byArray2.length <= n2) {
            throw new OVRException("array offset argument \"defaultVal_offset\" (" + n2 + ") equals or exceeds array length (" + byArray2.length + ")");
        }
        return OVR.ovrHmd_GetString1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), byArray, n, false, byArray2, n2, false);
    }

    public static boolean ovrHmd_SetString(ovrHmdDesc ovrHmdDesc2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        boolean bl = Buffers.isDirect(byteBuffer);
        boolean bl2 = Buffers.isDirect(byteBuffer2);
        return OVR.ovrHmd_SetString1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), bl ? byteBuffer : Buffers.getArray(byteBuffer), bl ? Buffers.getDirectBufferByteOffset(byteBuffer) : Buffers.getIndirectBufferByteOffset(byteBuffer), bl, bl2 ? byteBuffer2 : Buffers.getArray(byteBuffer2), bl2 ? Buffers.getDirectBufferByteOffset(byteBuffer2) : Buffers.getIndirectBufferByteOffset(byteBuffer2), bl2);
    }

    private static native boolean ovrHmd_SetString1(ByteBuffer var0, Object var1, int var2, boolean var3, Object var4, int var5, boolean var6);

    public static boolean ovrHmd_SetString(ovrHmdDesc ovrHmdDesc2, byte[] byArray, int n, byte[] byArray2, int n2) {
        if (byArray != null && byArray.length <= n) {
            throw new OVRException("array offset argument \"propertyName_offset\" (" + n + ") equals or exceeds array length (" + byArray.length + ")");
        }
        if (byArray2 != null && byArray2.length <= n2) {
            throw new OVRException("array offset argument \"value_offset\" (" + n2 + ") equals or exceeds array length (" + byArray2.length + ")");
        }
        return OVR.ovrHmd_SetString1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), byArray, n, false, byArray2, n2, false);
    }

    public static int ovr_TraceMessage(int n, ByteBuffer byteBuffer) {
        boolean bl = Buffers.isDirect(byteBuffer);
        return OVR.ovr_TraceMessage1(n, bl ? byteBuffer : Buffers.getArray(byteBuffer), bl ? Buffers.getDirectBufferByteOffset(byteBuffer) : Buffers.getIndirectBufferByteOffset(byteBuffer), bl);
    }

    private static native int ovr_TraceMessage1(int var0, Object var1, int var2, boolean var3);

    public static int ovr_TraceMessage(int n, byte[] byArray, int n2) {
        if (byArray != null && byArray.length <= n2) {
            throw new OVRException("array offset argument \"message_offset\" (" + n2 + ") equals or exceeds array length (" + byArray.length + ")");
        }
        return OVR.ovr_TraceMessage1(n, byArray, n2, false);
    }

    public static boolean ovrHmd_StartPerfLog(ovrHmdDesc ovrHmdDesc2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        boolean bl = Buffers.isDirect(byteBuffer);
        boolean bl2 = Buffers.isDirect(byteBuffer2);
        return OVR.ovrHmd_StartPerfLog1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), bl ? byteBuffer : Buffers.getArray(byteBuffer), bl ? Buffers.getDirectBufferByteOffset(byteBuffer) : Buffers.getIndirectBufferByteOffset(byteBuffer), bl, bl2 ? byteBuffer2 : Buffers.getArray(byteBuffer2), bl2 ? Buffers.getDirectBufferByteOffset(byteBuffer2) : Buffers.getIndirectBufferByteOffset(byteBuffer2), bl2);
    }

    private static native boolean ovrHmd_StartPerfLog1(ByteBuffer var0, Object var1, int var2, boolean var3, Object var4, int var5, boolean var6);

    public static boolean ovrHmd_StartPerfLog(ovrHmdDesc ovrHmdDesc2, byte[] byArray, int n, byte[] byArray2, int n2) {
        if (byArray != null && byArray.length <= n) {
            throw new OVRException("array offset argument \"fileName_offset\" (" + n + ") equals or exceeds array length (" + byArray.length + ")");
        }
        if (byArray2 != null && byArray2.length <= n2) {
            throw new OVRException("array offset argument \"userData1_offset\" (" + n2 + ") equals or exceeds array length (" + byArray2.length + ")");
        }
        return OVR.ovrHmd_StartPerfLog1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer(), byArray, n, false, byArray2, n2, false);
    }

    public static boolean ovrHmd_StopPerfLog(ovrHmdDesc ovrHmdDesc2) {
        return OVR.ovrHmd_StopPerfLog1(ovrHmdDesc2 == null ? null : ovrHmdDesc2.getBuffer());
    }

    private static native boolean ovrHmd_StopPerfLog1(ByteBuffer var0);

    public static ovrMatrix4f ovrMatrix4f_Projection(ovrFovPort ovrFovPort2, float f, float f2, int n) {
        ByteBuffer byteBuffer = OVR.ovrMatrix4f_Projection1(ovrFovPort2 == null ? null : ovrFovPort2.getBuffer(), f, f2, n);
        if (byteBuffer == null) {
            return null;
        }
        return ovrMatrix4f.create(Buffers.nativeOrder(byteBuffer));
    }

    private static native ByteBuffer ovrMatrix4f_Projection1(ByteBuffer var0, float var1, float var2, int var3);

    public static ovrMatrix4f ovrMatrix4f_OrthoSubProjection(ovrMatrix4f ovrMatrix4f2, ovrVector2f ovrVector2f2, float f, float f2) {
        ByteBuffer byteBuffer = OVR.ovrMatrix4f_OrthoSubProjection1(ovrMatrix4f2 == null ? null : ovrMatrix4f2.getBuffer(), ovrVector2f2 == null ? null : ovrVector2f2.getBuffer(), f, f2);
        if (byteBuffer == null) {
            return null;
        }
        return ovrMatrix4f.create(Buffers.nativeOrder(byteBuffer));
    }

    private static native ByteBuffer ovrMatrix4f_OrthoSubProjection1(ByteBuffer var0, ByteBuffer var1, float var2, float var3);

    public static native double ovr_WaitTillTime(double var0);

    public static boolean isAvailable() {
        return dynamicLookupHelper != null;
    }

    private static native boolean initializeImpl();

    private static native int getCStringLengthImpl(long var0);
}

