/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.AbinitMpFile.CheckPointFile;
import AbinitMp.Common.PdbFile;
import AbinitMp.Tool.MyLabel;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyRadioButton;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.FileItem;
import AbinitMp.Viewer.RangeFieldPanelKit;
import AbinitMp.Viewer.StartEnd;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JTextField;

public class InteractionEnergyManyToManyPanel
extends RangeFieldPanelKit {
    private JTextField range1Text;
    private JTextField range2Text;
    private MyRadioButton range1RadioButton;
    private MyRadioButton range2RadioButton;
    public Vector residueAssign1 = new Vector();
    public Vector residueAssign2 = new Vector();

    public InteractionEnergyManyToManyPanel(AbinitMpViewer abinitMpViewer) {
        this.viewer = abinitMpViewer;
        int n = 0;
        this.range1Text = new JTextField();
        this.range1RadioButton = new MyRadioButton();
        MyPanel myPanel = new MyPanel(new FlowLayout(0));
        myPanel.add(this.range1RadioButton);
        myPanel.add(this.range1Text);
        this.range1Text.setPreferredSize(new Dimension(200, 28));
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("InteractionEnergyManyToManyPanel.select1")), 0, n, 5, 1, 1.0, 0.0);
        this.layoutObject(myPanel, 5, n, 10, 1, 1.0, 0.0);
        ++n;
        this.range2Text = new JTextField();
        this.range2RadioButton = new MyRadioButton();
        myPanel = new MyPanel(new FlowLayout(0));
        myPanel.add(this.range2RadioButton);
        myPanel.add(this.range2Text);
        this.range2Text.setPreferredSize(new Dimension(200, 28));
        this.layoutObject(new MyLabel(MyResourceBundle.getResourceString("InteractionEnergyManyToManyPanel.select2")), 0, n, 10, 1, 1.0, 0.0);
        this.layoutObject(myPanel, 5, n, 10, 1, 1.0, 0.0);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.range1RadioButton);
        buttonGroup.add(this.range2RadioButton);
        this.range1RadioButton.setSelected(true);
    }

    public void setFragmentInfo(int n) {
        Vector vector;
        JTextField jTextField;
        if (this.range1RadioButton.isSelected()) {
            jTextField = this.range1Text;
            vector = this.residueAssign1;
        } else {
            jTextField = this.range2Text;
            vector = this.residueAssign2;
        }
        this.parseText(vector, jTextField);
        this.setResidueNo(vector, jTextField, n);
    }

    public boolean conform() {
        this.parseText(this.residueAssign1, this.range1Text);
        this.parseText(this.residueAssign2, this.range2Text);
        FileItem fileItem = this.viewer.getSelectedFileItem();
        CheckPointFile checkPointFile = (CheckPointFile)fileItem.file;
        PdbFile pdbFile = fileItem.getPdbFile();
        double d = 0.0;
        for (int i = 0; i < this.residueAssign1.size(); ++i) {
            int n = ((StartEnd)this.residueAssign1.get((int)i)).start;
            int n2 = ((StartEnd)this.residueAssign1.get((int)i)).end;
            for (int j = n; j <= n2; ++j) {
                for (int k = 0; k < this.residueAssign2.size(); ++k) {
                    int n3 = ((StartEnd)this.residueAssign2.get((int)k)).start;
                    int n4 = ((StartEnd)this.residueAssign2.get((int)k)).end;
                    for (int i2 = n3; i2 <= n4; ++i2) {
                        d += checkPointFile.interactionEnergy[j - 1][i2 - 1];
                    }
                }
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        this.viewer.addMessageln("Energy  " + decimalFormat.format(d) + " [kcal/mol] between " + this.range1Text.getText() + " and " + this.range2Text.getText());
        return true;
    }

    public void close() {
    }
}

