/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Display;

import AbinitMp.AbinitMpFile.ElectricFieldFile;
import AbinitMp.Display.ColorMap;
import AbinitMp.Display.ElectricFieldAssignValue;
import AbinitMp.Display.MarchingCube;
import AbinitMp.Display.StickNode;
import AbinitMp.Structure.CoordInfo;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.DisplayPreference;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class ElectricFieldNode
extends TransformGroup {
    private TransparencyAttributes tattr = new TransparencyAttributes();
    private PolygonAttributes pattr;
    private ColoringAttributes cattr;
    private ElectricFieldFile electricFieldFile;
    private int shading = 0;
    Vector streamPointVector;

    public ElectricFieldNode() {
        this.tattr.setCapability(3);
        if (MyResourceBundle.getResourceString("Transparency").equals("Nice")) {
            this.tattr.setTransparencyMode(1);
        } else {
            this.tattr.setTransparencyMode(3);
        }
        this.pattr = new PolygonAttributes();
        String string = MyResourceBundle.getResourceString("Cull");
        if (string.equals("None")) {
            this.pattr.setCullFace(0);
        } else if (string.equals("Front")) {
            this.pattr.setCullFace(2);
        } else {
            this.pattr.setCullFace(1);
        }
        if (DisplayPreference.isPoligonLine) {
            this.pattr.setPolygonMode(1);
        } else {
            this.pattr.setPolygonMode(2);
        }
        this.pattr.setBackFaceNormalFlip(true);
        this.cattr = new ColoringAttributes();
        this.cattr.setShadeModel(3);
    }

    public TransformGroup createNode(ElectricFieldFile electricFieldFile, ElectricFieldAssignValue electricFieldAssignValue, CoordInfo coordInfo) {
        Shape3D shape3D;
        int n;
        this.tattr.setTransparency((float)electricFieldAssignValue.transparency / 100.0f);
        float f = electricFieldAssignValue.value;
        Color3f color3f = electricFieldAssignValue.colorMinus;
        float[] fArray = electricFieldFile.x;
        float[] fArray2 = electricFieldFile.y;
        float[] fArray3 = electricFieldFile.z;
        int n2 = electricFieldFile.nx;
        int n3 = electricFieldFile.ny;
        int n4 = electricFieldFile.nz;
        float[] fArray4 = electricFieldFile.densityValue;
        Point3f point3f = new Point3f(coordInfo.xcenter, coordInfo.ycenter, coordInfo.zcenter);
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        MarchingCube marchingCube = new MarchingCube();
        marchingCube.create_isosurf(fArray, fArray2, fArray3, n2, n3, n4, fArray4, f, vector, vector2, 0);
        if (vector.size() == 0) {
            return null;
        }
        Point3f[] point3fArray = new Point3f[vector.size()];
        Vector3f[] vector3fArray = new Vector3f[vector2.size()];
        for (int i = 0; i < vector.size(); ++i) {
            point3fArray[i] = (Point3f)vector.get(i);
            point3fArray[i].sub((Tuple3f)point3f);
            vector3fArray[i] = (Vector3f)vector2.get(i);
        }
        Appearance appearance = new Appearance();
        appearance.setCapability(11);
        appearance.setTransparencyAttributes(this.tattr);
        appearance.setPolygonAttributes(this.pattr);
        appearance.setColoringAttributes(this.cattr);
        TriangleArray triangleArray = null;
        Material material = new Material();
        material.setShininess(128.0f);
        material.setAmbientColor(new Color3f(0.2f, 0.2f, 0.2f));
        material.setSpecularColor(new Color3f(0.0f, 0.0f, 0.0f));
        appearance.setMaterial(material);
        triangleArray = new TriangleArray(point3fArray.length, 7);
        ColorMap colorMap = new ColorMap(electricFieldAssignValue.minValue, electricFieldAssignValue.maxValue, electricFieldAssignValue.potentialColor);
        this.streamPointVector = new Vector();
        float f2 = electricFieldAssignValue.getThresholdMinValue();
        float f3 = electricFieldAssignValue.getThresholdMaxValue();
        for (int i = 0; i < point3fArray.length; ++i) {
            int n5;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            n = 0;
            for (n5 = 0; n5 < electricFieldFile.nx; ++n5) {
                if (!(point3fArray[i].x <= electricFieldFile.xx[n5] - coordInfo.xcenter)) continue;
                n6 = n5;
                if (!(Math.abs(point3fArray[i].x - (electricFieldFile.xx[n5] - coordInfo.xcenter)) > 1.0E-7f)) break;
                n = 0;
                break;
            }
            for (n5 = 0; n5 < electricFieldFile.ny; ++n5) {
                if (!(point3fArray[i].y <= electricFieldFile.yy[n5] - coordInfo.ycenter)) continue;
                n7 = n5;
                if (!(Math.abs(point3fArray[i].y - (electricFieldFile.yy[n5] - coordInfo.ycenter)) > 1.0E-7f)) break;
                n = 1;
                break;
            }
            for (n5 = 0; n5 < electricFieldFile.nz; ++n5) {
                if (!(point3fArray[i].z <= electricFieldFile.zz[n5] - coordInfo.zcenter)) continue;
                n8 = n5;
                if (!(Math.abs(point3fArray[i].z - (electricFieldFile.zz[n5] - coordInfo.zcenter)) > 1.0E-7f)) break;
                n = 2;
                break;
            }
            float f4 = 0.0f;
            f4 = n == 0 ? (electricFieldFile.potentialValue[n6 + n7 * n2 + n8 * n2 * n3] - electricFieldFile.potentialValue[n6 - 1 + n7 * n2 + n8 * n2 * n3]) * (point3fArray[i].x - (electricFieldFile.xx[n6 - 1] - coordInfo.xcenter)) / (electricFieldFile.xx[n6] - electricFieldFile.xx[n6 - 1]) + electricFieldFile.potentialValue[n6 - 1 + n7 * n2 + n8 * n2 * n3] : (n == 1 ? (electricFieldFile.potentialValue[n6 + n7 * n2 + n8 * n2 * n3] - electricFieldFile.potentialValue[n6 + (n7 - 1) * n2 + n8 * n2 * n3]) * (point3fArray[i].y - (electricFieldFile.yy[n7 - 1] - coordInfo.ycenter)) / (electricFieldFile.yy[n7] - electricFieldFile.yy[n7 - 1]) + electricFieldFile.potentialValue[n6 + (n7 - 1) * n2 + n8 * n2 * n3] : (electricFieldFile.potentialValue[n6 + n7 * n2 + n8 * n2 * n3] - electricFieldFile.potentialValue[n6 + n7 * n2 + (n8 - 1) * n2 * n3]) * (point3fArray[i].z - (electricFieldFile.zz[n8 - 1] - coordInfo.zcenter)) / (electricFieldFile.zz[n8] - electricFieldFile.zz[n8 - 1]) + electricFieldFile.potentialValue[n6 + n7 * n2 + (n8 - 1) * n2 * n3]);
            float[] fArray5 = colorMap.getRgb(f4);
            triangleArray.setColors(i, fArray5);
            if (!(f2 < f4 && f4 < f3) && (!(-f3 < f4) || !(f4 < -f2)) || this.streamPointVector.contains(point3fArray[i])) continue;
            this.streamPointVector.add(point3fArray[i]);
        }
        if (this.shading == 0) {
            triangleArray.setCoordinates(0, point3fArray);
            triangleArray.setNormals(0, vector3fArray);
            shape3D = new Shape3D((Geometry)triangleArray, appearance);
        } else {
            GeometryInfo geometryInfo = new GeometryInfo(1);
            geometryInfo.setCoordinates(point3fArray);
            NormalGenerator normalGenerator = new NormalGenerator();
            normalGenerator.generateNormals(geometryInfo);
            shape3D = new Shape3D((Geometry)geometryInfo.getGeometryArray(), appearance);
        }
        shape3D.setPickable(false);
        this.addChild((Node)shape3D);
        if (electricFieldAssignValue.boundingBox) {
            int n9;
            Color3f color3f2 = electricFieldAssignValue.bboxColor;
            LineArray lineArray = new LineArray(24, 5);
            Point3f[] point3fArray2 = new Point3f[8];
            n = electricFieldFile.nx - 1;
            int n10 = electricFieldFile.ny - 1;
            int n11 = electricFieldFile.nz - 1;
            point3fArray2[0] = new Point3f(electricFieldFile.xx[0], electricFieldFile.yy[0], electricFieldFile.zz[0]);
            point3fArray2[1] = new Point3f(electricFieldFile.xx[n], electricFieldFile.yy[0], electricFieldFile.zz[0]);
            point3fArray2[2] = new Point3f(electricFieldFile.xx[n], electricFieldFile.yy[n10], electricFieldFile.zz[0]);
            point3fArray2[3] = new Point3f(electricFieldFile.xx[0], electricFieldFile.yy[n10], electricFieldFile.zz[0]);
            point3fArray2[4] = new Point3f(electricFieldFile.xx[0], electricFieldFile.yy[0], electricFieldFile.zz[n11]);
            point3fArray2[5] = new Point3f(electricFieldFile.xx[n], electricFieldFile.yy[0], electricFieldFile.zz[n11]);
            point3fArray2[6] = new Point3f(electricFieldFile.xx[n], electricFieldFile.yy[n10], electricFieldFile.zz[n11]);
            point3fArray2[7] = new Point3f(electricFieldFile.xx[0], electricFieldFile.yy[n10], electricFieldFile.zz[n11]);
            for (n9 = 0; n9 < 8; ++n9) {
                point3fArray2[n9].sub((Tuple3f)point3f);
            }
            lineArray.setCoordinate(0, point3fArray2[0]);
            lineArray.setCoordinate(1, point3fArray2[1]);
            lineArray.setCoordinate(2, point3fArray2[1]);
            lineArray.setCoordinate(3, point3fArray2[2]);
            lineArray.setCoordinate(4, point3fArray2[2]);
            lineArray.setCoordinate(5, point3fArray2[3]);
            lineArray.setCoordinate(6, point3fArray2[3]);
            lineArray.setCoordinate(7, point3fArray2[0]);
            lineArray.setCoordinate(8, point3fArray2[4]);
            lineArray.setCoordinate(9, point3fArray2[5]);
            lineArray.setCoordinate(10, point3fArray2[5]);
            lineArray.setCoordinate(11, point3fArray2[6]);
            lineArray.setCoordinate(12, point3fArray2[6]);
            lineArray.setCoordinate(13, point3fArray2[7]);
            lineArray.setCoordinate(14, point3fArray2[7]);
            lineArray.setCoordinate(15, point3fArray2[4]);
            lineArray.setCoordinate(16, point3fArray2[2]);
            lineArray.setCoordinate(17, point3fArray2[6]);
            lineArray.setCoordinate(18, point3fArray2[1]);
            lineArray.setCoordinate(19, point3fArray2[5]);
            lineArray.setCoordinate(20, point3fArray2[3]);
            lineArray.setCoordinate(21, point3fArray2[7]);
            lineArray.setCoordinate(22, point3fArray2[0]);
            lineArray.setCoordinate(23, point3fArray2[4]);
            for (n9 = 0; n9 < 24; ++n9) {
                lineArray.setColor(n9, color3f2);
            }
            Appearance appearance2 = new Appearance();
            LineAttributes lineAttributes = new LineAttributes(2.0f, 0, true);
            appearance2.setLineAttributes(lineAttributes);
            Shape3D shape3D2 = new Shape3D((Geometry)lineArray, appearance2);
            shape3D2.setPickable(false);
            this.addChild((Node)shape3D2);
        }
        for (int i = 0; i < 2; ++i) {
            Point3f point3f2;
            boolean bl = false;
            if (i == 1) {
                bl = true;
            }
            Vector vector3 = new Vector();
            Vector vector4 = new Vector();
            Vector<Integer> vector5 = new Vector<Integer>();
            int n12 = 0;
            float f5 = 0.0f;
            float f6 = 1.0f / electricFieldAssignValue.getThinned();
            int n13 = 0;
            while (n13 < this.streamPointVector.size()) {
                point3f2 = (Point3f)this.streamPointVector.get(n13);
                this.getStreamLine(electricFieldFile, point3f2, electricFieldAssignValue, colorMap, coordInfo, vector3, vector4, bl);
                int n14 = vector3.size() - n12;
                if (n14 != 0) {
                    vector5.add(new Integer(n14));
                    n12 = vector3.size();
                }
                n13 = (int)(f5 += f6);
            }
            if (vector3.size() != 0) {
                Object object;
                Point3f[] point3fArray3;
                for (n13 = 0; n13 < vector3.size(); n13 += 2) {
                    point3f2 = (Point3f)vector3.get(n13);
                    point3f2.sub((Tuple3f)point3f);
                    Point3f point3f3 = (Point3f)vector3.get(n13 + 1);
                    point3f3.sub((Tuple3f)point3f);
                }
                if (electricFieldAssignValue.getModel() == 0.0f) {
                    LineArray lineArray = new LineArray(vector3.size(), 5);
                    int n15 = 0;
                    for (int j = 0; j < vector3.size(); j += 2) {
                        point3fArray3 = (Point3f[])vector3.get(j);
                        object = (Point3f)vector3.get(j + 1);
                        lineArray.setCoordinate(n15, (Point3f)point3fArray3);
                        lineArray.setColor(n15, (float[])vector4.get(j));
                        lineArray.setCoordinate(++n15, (Point3f)object);
                        lineArray.setColor(n15, (float[])vector4.get(j + 1));
                        ++n15;
                    }
                    Shape3D shape3D3 = new Shape3D((Geometry)lineArray);
                    shape3D3.setPickable(false);
                    this.addChild((Node)shape3D3);
                    continue;
                }
                n13 = 0;
                for (int j = 0; j < vector5.size(); ++j) {
                    int n16 = (Integer)vector5.get(j) / 2;
                    if (n16 > 1) {
                        point3fArray3 = new Point3f[n16 + 1];
                        object = new Vector();
                        for (int k = 0; k < n16; ++k) {
                            point3fArray3[k] = (Point3f)vector3.get(k * 2 + n13);
                            ((Vector)object).add(vector4.get(k * 2 + n13));
                        }
                        point3fArray3[n16] = (Point3f)vector3.get((n16 - 1) * 2 + n13 + 1);
                        ((Vector)object).add(vector4.get((n16 - 1) * 2 + n13 + 1));
                        StickNode stickNode = new StickNode(point3fArray3, (Vector)object, electricFieldAssignValue.getStickWidth());
                        this.addChild((Node)stickNode);
                        if (i == 1) {
                            this.addChild((Node)this.createCone(point3fArray3[n16], point3fArray3[n16 - 1], (float[])vector4.get((n16 - 1) * 2 + n13 + 1), electricFieldAssignValue.getStickWidth()));
                        }
                    }
                    n13 += n16 * 2;
                }
                continue;
            }
            System.out.println("linePoints is zero");
        }
        this.setPickable(false);
        return this;
    }

    private void getStreamLine(ElectricFieldFile electricFieldFile, Point3f point3f, ElectricFieldAssignValue electricFieldAssignValue, ColorMap colorMap, CoordInfo coordInfo, Vector vector, Vector vector2, boolean bl) {
        Point3f point3f2 = new Point3f(point3f);
        point3f2.x += coordInfo.xcenter;
        point3f2.y += coordInfo.ycenter;
        point3f2.z += coordInfo.zcenter;
        float[] fArray = colorMap.getRgb(this.getPotentialValue(electricFieldFile, point3f2));
        for (int i = 0; i < electricFieldAssignValue.getStepNum(); ++i) {
            Vector3f vector3f = this.getVector(electricFieldFile, point3f2);
            if (vector3f == null) {
                vector.remove(vector.size() - 1);
                vector.remove(vector.size() - 1);
                vector2.remove(vector2.size() - 1);
                vector2.remove(vector2.size() - 1);
                break;
            }
            if (bl) {
                vector3f.negate();
            }
            Point3f point3f3 = new Point3f();
            point3f3.scale(electricFieldAssignValue.getLength(), (Tuple3f)vector3f);
            point3f3.add((Tuple3f)point3f2);
            if (point3f3.toString().indexOf("NaN") != -1) {
                return;
            }
            float[] fArray2 = colorMap.getRgb(this.getPotentialValue(electricFieldFile, point3f3));
            Point3f point3f4 = new Point3f(point3f2);
            float[] fArray3 = new float[3];
            for (int j = 0; j < 3; ++j) {
                fArray3[j] = fArray[j];
            }
            vector.add(point3f4);
            vector.add(point3f3);
            vector2.add(fArray);
            vector2.add(fArray2);
            point3f2 = point3f3;
            fArray = fArray2;
        }
    }

    private Vector3f getVector(ElectricFieldFile electricFieldFile, Point3f point3f) {
        int n;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (n = 0; n < electricFieldFile.xx.length; ++n) {
            if (!(point3f.x < electricFieldFile.xx[n])) continue;
            n2 = n - 1;
            break;
        }
        for (n = 0; n < electricFieldFile.yy.length; ++n) {
            if (!(point3f.y < electricFieldFile.yy[n])) continue;
            n3 = n - 1;
            break;
        }
        for (n = 0; n < electricFieldFile.zz.length; ++n) {
            if (!(point3f.z < electricFieldFile.zz[n])) continue;
            n4 = n - 1;
            break;
        }
        if (n2 < 0 || n3 < 0 || n4 < 0) {
            return null;
        }
        float f = this.getInterpolateValue(n2, n3, n4, point3f, electricFieldFile.electricFieldX, electricFieldFile);
        float f2 = this.getInterpolateValue(n2, n3, n4, point3f, electricFieldFile.electricFieldY, electricFieldFile);
        float f3 = this.getInterpolateValue(n2, n3, n4, point3f, electricFieldFile.electricFieldZ, electricFieldFile);
        Vector3f vector3f = new Vector3f(f, f2, f3);
        vector3f.normalize();
        return vector3f;
    }

    private float getPotentialValue(ElectricFieldFile electricFieldFile, Point3f point3f) {
        int n;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (n = 0; n < electricFieldFile.xx.length; ++n) {
            if (!(point3f.x < electricFieldFile.xx[n])) continue;
            n2 = n - 1;
            break;
        }
        for (n = 0; n < electricFieldFile.yy.length; ++n) {
            if (!(point3f.y < electricFieldFile.yy[n])) continue;
            n3 = n - 1;
            break;
        }
        for (n = 0; n < electricFieldFile.zz.length; ++n) {
            if (!(point3f.z < electricFieldFile.zz[n])) continue;
            n4 = n - 1;
            break;
        }
        if (n2 < 0 || n3 < 0 || n4 < 0) {
            return 0.0f;
        }
        return this.getInterpolateValue(n2, n3, n4, point3f, electricFieldFile.potentialValue, electricFieldFile);
    }

    private float getInterpolateValue(int n, int n2, int n3, Point3f point3f, float[] fArray, ElectricFieldFile electricFieldFile) {
        float[] fArray2 = new float[8];
        float[] fArray3 = new float[8];
        float f = electricFieldFile.xx[n];
        float f2 = electricFieldFile.xx[n + 1];
        float f3 = electricFieldFile.yy[n2];
        float f4 = electricFieldFile.yy[n2 + 1];
        float f5 = electricFieldFile.zz[n3];
        float f6 = electricFieldFile.zz[n3 + 1];
        fArray2[0] = (point3f.x - f) * (point3f.y - f3) * (point3f.z - f5);
        fArray2[1] = (f2 - point3f.x) * (point3f.y - f3) * (point3f.z - f5);
        fArray2[2] = (point3f.x - f) * (point3f.y - f3) * (f6 - point3f.z);
        fArray2[3] = (f2 - point3f.x) * (point3f.y - f3) * (f6 - point3f.z);
        fArray2[4] = (point3f.x - f) * (f4 - point3f.y) * (point3f.z - f5);
        fArray2[5] = (f2 - point3f.x) * (f4 - point3f.y) * (point3f.z - f5);
        fArray2[6] = (point3f.x - f) * (f4 - point3f.y) * (f6 - point3f.z);
        fArray2[7] = (f2 - point3f.x) * (f4 - point3f.y) * (f6 - point3f.z);
        int n4 = electricFieldFile.nx;
        int n5 = electricFieldFile.ny;
        int n6 = electricFieldFile.nz;
        fArray3[0] = fArray[n + n2 * n4 + n3 * n4 * n5];
        fArray3[1] = fArray[n + 1 + n2 * n4 + n3 * n4 * n5];
        fArray3[2] = fArray[n + n2 * n4 + (n3 + 1) * n4 * n5];
        fArray3[3] = fArray[n + 1 + n2 * n4 + (n3 + 1) * n4 * n5];
        fArray3[4] = fArray[n + (n2 + 1) * n4 + n3 * n4 * n5];
        fArray3[5] = fArray[n + 1 + (n2 + 1) * n4 + n3 * n4 * n5];
        fArray3[6] = fArray[n + (n2 + 1) * n4 + (n3 + 1) * n4 * n5];
        fArray3[7] = fArray[n + 1 + (n2 + 1) * n4 + (n3 + 1) * n4 * n5];
        float f7 = (f2 - f) * (f4 - f3) * (f6 - f5);
        float f8 = 0.0f;
        for (int i = 0; i < 8; ++i) {
            f8 += fArray3[7 - i] * fArray2[i];
        }
        return f8 /= f7;
    }

    public void setTransparency(float f) {
        this.tattr.setTransparency(f);
    }

    public void setShading(int n) {
        this.shading = n;
    }

    private TransformGroup createCone(Point3f point3f, Point3f point3f2, float[] fArray, float f) {
        float f2;
        float f3;
        float f4;
        float f5;
        float f6 = point3f.x - point3f2.x;
        float f7 = point3f.y - point3f2.y;
        float f8 = point3f.z - point3f2.z;
        float f9 = (float)Math.sqrt(f6 * f6 + f7 * f7 + f8 * f8);
        float f10 = (float)Math.sqrt(f7 * f7 + f6 * f6);
        float f11 = (float)Math.sqrt(f10 * f10 + f8 * f8);
        if ((double)f10 != 0.0) {
            f5 = f7 / f10;
            f4 = -f6 / f10;
        } else {
            f5 = 1.0f;
            f4 = 0.0f;
        }
        if ((double)f11 != 0.0) {
            f3 = f10 / f11;
            f2 = f8 / f11;
        } else {
            f3 = 1.0f;
            f2 = 0.0f;
        }
        Matrix4d matrix4d = new Matrix4d((double)f5, (double)f4, 0.0, 0.0, (double)(-f4) * (double)f3, (double)f5 * (double)f3, (double)f2, 0.0, (double)f4 * (double)f2, (double)(-f5) * (double)f2, (double)f3, 0.0, 0.0, 0.0, 0.0, 1.0);
        Transform3D transform3D = new Transform3D(matrix4d);
        transform3D.invert();
        Vector3f vector3f = new Vector3f(f6, f7, f8);
        vector3f.normalize();
        vector3f.scale(f * 1.5f);
        transform3D.setTranslation(new Vector3d((double)(point3f.x + vector3f.x), (double)(point3f.y + vector3f.y), (double)(point3f.z + vector3f.z)));
        TransformGroup transformGroup = new TransformGroup(transform3D);
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setPolygonMode(2);
        Material material = new Material();
        material.setDiffuseColor(fArray[0], fArray[1], fArray[2]);
        Appearance appearance = new Appearance();
        appearance.setPolygonAttributes(polygonAttributes);
        appearance.setMaterial(material);
        Cone cone = new Cone(f * 1.5f, f * 3.0f, appearance);
        cone.setPickable(false);
        transformGroup.addChild((Node)cone);
        return transformGroup;
    }
}

