/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : MyUserInfo.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.ssh.hosts;

import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

import ciss.phase_viewer.mainpanel.Desk;

import com.jcraft.jsch.UserInfo;

public class MyUserInfo implements UserInfo {
    private static org.apache.log4j.Logger logger = org.apache.log4j.Logger
            .getLogger(MyUserInfo.class.getName());
    private String passwd;
    private JTextField passwordField = (JTextField) new JPasswordField(20);

    private HostInfo host;
    private int retry = 0;
    private int max_retry = 3;

    public MyUserInfo(HostInfo host) {
        this.host = host;
    }

    public String getPassword() {
        return passwd;
    }

    public boolean promptYesNo(String str) {
        Object[] options = { "yes", "no" };
        int foo = JOptionPane.showOptionDialog(Desk.getDesktop(), str,
                "Warning", JOptionPane.YES_NO_OPTION,
                JOptionPane.WARNING_MESSAGE, null, options, options[0]);
        boolean ret = (foo == JOptionPane.YES_OPTION);
        logger.debug("you have chosen... " + ret);
        return ret;
    }

    public String getPassphrase() {
        return getPassword();
    }

    public boolean promptPassphrase(String message) {
        return promptPassword(message);
    }

    public boolean promptPassword(String message) {
        retry++;
        passwd = host.getPasswordString();
        if (passwd == null || passwd.trim().length() == 0) {
            Object[] ob = { passwordField };
            passwordField.requestFocus();
            // int result =
            // JOptionPane.showInternalConfirmDialog(Desktop.getDesktop(), ob,
            // message, JOptionPane.OK_CANCEL_OPTION);
            int result = JOptionPane.showConfirmDialog(Desk.getDesktop(), ob,
                    message, JOptionPane.OK_CANCEL_OPTION);
            if (result == JOptionPane.OK_OPTION) {
                passwd = passwordField.getText();
                retry = 0;
                return true;
            } else {
                return false;
            }
        }
        return true;
    }

    public void showMessage(String message) {
        logger.info(message);
    }
}
