/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/08/30, 16:20
!  AUTHOR(S): KOGA, Junichiro
!  File : PropConfigTextField.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.settings;

import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

import org.apache.log4j.Logger;

/**
 * vpeB[ҏWpJTextField
 * 
 * @author
 */
public class PropConfigTextField extends JTextField implements PropConfigGUI {
    private Logger logger = Logger.getLogger(PropConfigTextField.class
            .getName());

    public static int FLOAT = 0;
    public static int INT = 1;
    public static int STR = 2;

    private int valtype = FLOAT;
    private String key;
    private GlobalProperties properties;

    /** Creates a new instance of PropConfigTextField */
    public PropConfigTextField(int col, int valtype, String key,
            GlobalProperties properties) {
        super(col);
        this.valtype = valtype;
        this.key = key;
        this.properties = properties;
        init();
    }

    public PropConfigTextField(String initText, int valtype, String key,
            GlobalProperties properties) {
        super(initText);
        this.valtype = valtype;
        this.key = key;
        this.properties = properties;
        init();
    }

    private void init() {
        load();
        addCaretListener(new CaretListener() {
            public void caretUpdate(CaretEvent e) {
                save();
            }
        });
    }

    public void save() {
        String str = getText();
        if (str == null || str.trim().length() == 0)
            return;
        str = str.trim();
        if (valtype == FLOAT) {
            try {
                Float.parseFloat(str);
                properties.setProperty(key, str);
            } catch (Exception exc) {
            }
        } else if (valtype == INT) {
            try {
                Integer.parseInt(str);
                properties.setProperty(key, str);
            } catch (Exception exc) {
            }
        } else {
            properties.setProperty(key, str);
        }
    }

    public void load() {
        String str = properties.getProperty(key);
        if (str == null || str.trim().length() == 0)
            return;
        str = str.trim();

        if (valtype == FLOAT) {
            try {
                Float.parseFloat(str);
                setText(str);
            } catch (Exception exc) {
            }
        } else if (valtype == INT) {
            try {
                Integer.parseInt(str);
                setText(str);
            } catch (Exception exc) {
            }
        } else {
            setText(str);
        }
    }

}
