/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/09/27, 18:34
!  AUTHOR(S): KOGA, Junichiro
!  File : PosConfigGUI.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.settings;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

import org.apache.log4j.Logger;

/**
 * "ꏊ"ݒ肷邽߂GUI
 * 
 * @author
 */
public class PosConfigGUI extends JPanel implements PropConfigGUI {
    private Logger logger = Logger.getLogger(PosConfigGUI.class.getName());
    private GlobalProperties properties;
    private String key;
    private JTextField x;
    private JTextField y;
    private JTextField z;

    /** Creates a new instance of PosConfigGUI */
    public PosConfigGUI(String text, String key, GlobalProperties properties) {
        this.key = key;
        this.properties = properties;
        setBorder(new TitledBorder(text));
        init();
    }

    private void init() {
        JPanel px = new JPanel();
        px.setBorder(new TitledBorder("x"));
        JPanel py = new JPanel();
        py.setBorder(new TitledBorder("y"));
        JPanel pz = new JPanel();
        pz.setBorder(new TitledBorder("z"));
        x = new JTextField(5);
        y = new JTextField(5);
        z = new JTextField(5);
        px.add(x);
        py.add(y);
        pz.add(z);
        setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        add(px);
        add(py);
        add(pz);
        load();

        x.addCaretListener(new CaretListener() {
            public void caretUpdate(CaretEvent e) {
                save();
            }
        });

        y.addCaretListener(new CaretListener() {
            public void caretUpdate(CaretEvent e) {
                save();
            }
        });

        z.addCaretListener(new CaretListener() {
            public void caretUpdate(CaretEvent e) {
                save();
            }
        });
    }

    public void save() {
        try {
            String sx = x.getText().trim();
            String sy = y.getText().trim();
            String sz = z.getText().trim();
            Double.parseDouble(sx);
            Double.parseDouble(sy);
            Double.parseDouble(sz);
            String res = sx + "," + sy + "," + sz;
            properties.setProperty(key, res);
        } catch (Exception exc) {
        }
    }

    public void load() {
        try {
            String[] spos = properties.getProperty(key).split(",");
            Float.parseFloat(spos[0]);
            Float.parseFloat(spos[1]);
            Float.parseFloat(spos[2]);
            x.setText(spos[0]);
            y.setText(spos[1]);
            z.setText(spos[2]);
        } catch (Exception exc) {
        }
    }

}
