/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/01/24, 17:38
!  AUTHOR(S): KOGA, Junichiro
!  File : ScriptBrowser.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.scripting.scriptmanipulator;

import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.filebrowser.DefaultFileBrowserPanel;
import ciss.phase_viewer.filebrowser.FileBrowserEvent;
import ciss.phase_viewer.filebrowser.FileBrowserTree;
import ciss.phase_viewer.filebrowser.FileBrowserTreeListener;
import ciss.phase_viewer.scripting.ScriptDescriptionPanel;

/**
 * XNvgt@CI肷邽߂̃NX.
 * 
 * @author
 */
public class ScriptBrowser extends JPanel implements FileBrowserTreeListener,
        MouseListener {
    private Logger logger = Logger.getLogger(ScriptBrowser.class.getName());
    private FileBrowserTree tree;
    private String dotchase = System.getProperty("user.home")
            + System.getProperty("file.separator") + ".phase-viewer";
    private String scriptDir = dotchase + System.getProperty("file.separator")
            + "scripts";
    private String scriptDirOrig = System.getProperty("pviewer.home")
            + System.getProperty("file.separator") + "scripts";
    DefaultFileBrowserPanel browser;

    private ScriptList scriptList;
    private FileBrowserTree fbtree;

    private ScriptDescriptionPanel descriptionPanel;

    /** Creates a new instance of ScriptBrowser */
    public ScriptBrowser(String inidir, ScriptList scriptList) {
        if (!new File(scriptDir).exists()) {
            ciss.phase_viewer.common.Utils.copyDir(new File(scriptDirOrig),
                    new File(dotchase));
        }
        this.scriptList = scriptList;
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
        browser = new DefaultFileBrowserPanel(scriptDir
                + System.getProperty("file.separator") + inidir,
                "ciss.phase_viewer.scripting.scriptmanipulator.ScriptBrowserNode");
        browser.addFileBrowserTreeListener(this);

        p.add(browser);
        p.setBorder(new TitledBorder("script files"));
        fbtree = browser.getFileBrowserTree();
        JTree tree = fbtree.getTree();
        tree.addMouseListener(this);
        // setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
        setLayout(new GridLayout());
        descriptionPanel = new ScriptDescriptionPanel();
        split = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, true, p,
                descriptionPanel);
        split.setResizeWeight(0.5);
        add(split);
        setBorder(new TitledBorder("select script"));
        // add(p);
        // add(descriptionPanel);
        mousePressed(null);
    }

    public void adjust() {
        split.setDividerLocation(0.5);
    }

    public void directoryHasChanged(FileBrowserEvent e) {
        adjust();
        String[] paths = fbtree.getSelectedPaths();
        descriptionPanel.setScriptFile(paths[0]);
    }

    public String[] getSelectedPaths() {
        return browser.getSelectedPaths();
    }

    public void mouseReleased(MouseEvent e) {
    }

    private JSplitPane split;

    public void mousePressed(MouseEvent e) {
        adjust();
        String[] paths = fbtree.getSelectedPaths();
        // if ( paths != null && paths.length != 0 ) {
        // scriptList.setDescription(paths[0]);
        // }
        descriptionPanel.setScriptFile(paths[0]);
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

}
