/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/07/13, 15:30
!  AUTHOR(S): KOGA, Junichiro
!  File : ProjectDirBrowserNode.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.projectbrowser.projectdirbrowser;

import java.io.Serializable;
import java.util.Vector;

import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

import org.apache.log4j.Logger;
import org.jdom.Element;

import ciss.phase_viewer.projectbrowser.ProjectBrowser;
import ciss.phase_viewer.projectbrowser.ProjectInfo;

/**
 * vWFNguEU[pTreeNode
 * 
 * @author KOGA, Junichiro
 */
public class ProjectDirBrowserNode extends DefaultMutableTreeNode implements
        Serializable, TreeSelectionListener {
    private static Logger logger = Logger.getLogger(ProjectDirBrowserNode.class
            .getName());
    private ProjectInfo info;
    private Vector listeners = new Vector();
    private Element proj;
    private ProjectDirBrowser parent;
    private ProjectBrowser panel;

    private boolean bselected = false;
    private boolean bexpanded = false;
    private boolean readProjectPropertyDoc = false;

    /**
     * Creates a new instance of ProjectDirBrowserNode
     * 
     * @param proj
     *            myproject.xmlɋLqĂvWFNg
     * @param parent
     *            ̃m[h̑ݐ
     * @param readProjectPropertyDoc
     *            vWFNgfBNg[phase-viewer.xmlt@Cǂݍނۂw.
     */
    public ProjectDirBrowserNode(Element proj, ProjectDirBrowser parent,
            boolean readProjectPropertyDoc) {
        super();
        this.proj = proj;
        this.parent = parent;
        this.readProjectPropertyDoc = readProjectPropertyDoc;
        String hasSub = proj.getAttributeValue("hassub");
        boolean bhasSub = false;
        if (hasSub != null) {
            bhasSub = new Boolean(hasSub).booleanValue();
        }

        info = new ProjectInfo(proj, readProjectPropertyDoc);
        ProjectDirBrowserObject o = new ProjectDirBrowserObject(info);
        super.setUserObject(o);

        String isExpanded = proj.getAttributeValue("shouldbevisible");
        bexpanded = false;
        if (isExpanded != null) {
            bexpanded = new Boolean(isExpanded).booleanValue();
        }

        String isSelected = proj.getAttributeValue("selected");
        bselected = false;
        if (isSelected != null) {
            bselected = new Boolean(isSelected).booleanValue();
        }
        // JTree tree = parent.getTree();
        // if ( tree != null ) {
        // tree.addTreeSelectionListener(this);
        // }
    }

    public Object clone() {
        ProjectDirBrowserNode nd = new ProjectDirBrowserNode(
                (Element) proj.clone(), parent, readProjectPropertyDoc);
        nd.addProjectDirBrowserNodeChangeListener(parent);
        int child = this.getChildCount();
        // Element parentElement = nd.getProjectElement();
        // if ( child > 0 ) {
        // for ( int i=0 ; i<child ; i++ ) {
        // ProjectDirBrowserNode node = (ProjectDirBrowserNode) getChildAt(i);
        // ProjectDirBrowserNode ch = (ProjectDirBrowserNode) node.clone();
        // Element childElement = ch.getProjectElement();
        // childElement.detach();
        // parentElement.addContent(childElement);
        // nd.add(ch);
        // }
        // }
        return nd;
    }

    public boolean isSelected() {
        return bselected;
    }

    public boolean isExpanded() {
        return bexpanded;
    }

    public ProjectInfo getProjectInfo() {
        return this.info;
    }

    public Element getProjectElement() {
        return this.proj;
    }

    public void addProjectDirBrowserNodeChangeListener(
            ProjectDirBrowserNodeChangeListener listener) {
        listeners.addElement(listener);
    }

    public void selectMe() {
        try {
            bselected = true;
            for (int i = 0; i < listeners.size(); i++) {
                ProjectDirBrowserNodeChangeListener listener = (ProjectDirBrowserNodeChangeListener) listeners
                        .elementAt(i);
                listener.nodeSelected(new ProjectDirBrowserNodeChangeEvent(this));
            }
            if (panel != null)
                panel.setSelected(true);
        } catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public ProjectBrowser getProjectBrowser() {
        return this.panel;
    }

    public void setProjectBrowser(ProjectBrowser panel) {
        this.panel = panel;
    }

    public ProjectDirBrowser getDirBrowser() {
        return this.parent;
    }

    public void valueChanged(javax.swing.event.TreeSelectionEvent e) {
        logger.debug("button 1 pressed.");
        logger.debug(info);
        for (int i = 0; i < listeners.size(); i++) {
            ProjectDirBrowserNodeChangeListener listener = (ProjectDirBrowserNodeChangeListener) listeners
                    .elementAt(i);
            listener.nodeSelected(new ProjectDirBrowserNodeChangeEvent(this));
        }
    }

    public String toString() {
        String ret = "";
        ret += "name: " + getProjectInfo().getProjectName()
                + System.getProperty("line.separator");
        ret += "date: " + getProjectInfo().getDate()
                + System.getProperty("line.separator");
        ret += "dir: " + getProjectInfo().getProjectDirectory();
        String comment = getProjectInfo().getComment();
        if (comment != null) {
            ret += System.getProperty("line.separator") + "comment: " + comment;
        }
        return ret;
    }

}
