/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : ChoicePanelPhaseUnit.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.primitiveguis;

import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.border.TitledBorder;
import javax.swing.event.PopupMenuListener;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;

public class ChoicePanelPhaseUnit extends PrimitiveInputComponents implements
        PhaseInputPanelInterface {
    private ComboBoxPhaseUnit combobox;

    private static Logger logger = Logger.getLogger(ChoicePanelPhaseUnit.class
            .getName());

    private String[] choices;
    private String title;
    private Vector dupli = null;

    /**
     * ̃NXS̓t@C̏ȂǂɎRXgN^[.
     * 
     * @param title
     *            GUIɂBorderedTitle. nullnĂ悢. ̏ꍇBorderedTitle͕tȂ.
     * @param choices
     *            GUĨR{{bNXɗpI̔z.
     * @param parent
     *            ̃NX̌Ăяo. EventListener̃TuNXCvgĂKv.
     */
    public ChoicePanelPhaseUnit(String[] inputSpecifications,
            InputInterface inputinterface, String title, String[] choices,
            EventListener parent) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.choices = choices;
        this.createGUI();
        this.addListeners(parent);
    }

    public ChoicePanelPhaseUnit(String[] inputSpecifications,
            InputInterface inputinterface, String title, String[] choices,
            Vector dupli, EventListener parent) {
        super(inputSpecifications, inputinterface);

        this.title = title;
        this.choices = choices;
        this.dupli = dupli;

        this.createGUI();
        this.addListeners(parent);
    }

    public ChoicePanelPhaseUnit(String[] inputSpecifications,
            InputInterface inputinterface, String title, String[] choices) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.choices = choices;
        this.createGUI();
    }

    public ChoicePanelPhaseUnit(String[] inputSpecifications,
            InputInterface inputinterface, String title, String[] choices,
            Vector dupli) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.choices = choices;
        this.dupli = dupli;
        this.createGUI();
    }

    private void createGUI() {
        super.setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        this.createComboBox();
        super.add(combobox);
        if (title != null) {
            super.setBorder(new TitledBorder(title));
        }
    }

    private void createComboBox() {
        combobox = new ComboBoxPhaseUnit(choices, inputSpecifications,
                inputInterface, ComboBoxPhaseUnit.ENERGY);
        String[] value = units.getUnits();
        if (value != null) {
            for (int j = 0; j < choices.length; j++) {
                for (int i = 0; i < value.length; i++) {
                    String val = value[i].trim();
                    if (choices[j].equalsIgnoreCase(val)) {
                        combobox.setSelectedIndex(j);
                        break;
                    }
                }
            }
        }
    }

    /**
     * ̃NXێR{{bNX, ANVXi[t郁\bh.
     */
    public void addListeners(EventListener listener) {
        combobox.addActionListener((ActionListener) listener);
        combobox.addPopupMenuListener((PopupMenuListener) listener);
    }

    public void setEnabled(boolean enabled) {
        combobox.setEnabled(enabled);
    }

    public String getValue() {
        return (String) combobox.getSelectedItem();
    }

    public String getUnit() {
        return new String();
    }

    public JComboBox getComboBox() {
        return this.combobox;
    }

}
